/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class LRS
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int NP = 1;
    public static final int BW = 32;

    public static class CORE
    extends Core {
        int gain;
        float fscl;
        int lrsx;
        int lrsy;
        CoreCommon.CxFloat[] vi;
        CoreCommon.CxFloat[] vo;
        boolean neg;

        public void setGain(int n) {
            this.gain = n;
            this.fscl = CORE.d2f(CORE.pow(2.0, (double)this.gain / 6.0));
            this.putVars("fscl");
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (!this.isMatch(string, "L:GAIN")) {
                return super.set(string, value);
            }
            this.setGain(value.toL());
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (!this.isMatch(string, "L:GAIN")) {
                return super.get(string, value);
            }
            value.fromL(this.gain);
            return 0;
        }

        public int fLRS(int n) {
            return n << 1 | CORE.getBits(n, 0, 0) ^ CORE.getBits(n, 1, 1) ^ CORE.getBits(n, 5, 5) ^ CORE.getBits(n, 25, 25);
        }

        @Override
        public int init() {
            this.gain = -70;
            this.lrsx = -123457;
            this.lrsy = -654322;
            this.neg = false;
            return 0;
        }

        @Override
        public int open() {
            int n;
            this.vi = new CoreCommon.CxFloat[1];
            for (n = 0; n < 1; ++n) {
                this.vi[n] = new CoreCommon.CxFloat();
            }
            this.vo = new CoreCommon.CxFloat[1];
            for (n = 0; n < 1; ++n) {
                this.vo[n] = new CoreCommon.CxFloat();
            }
            this.setGain(this.gain);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            while (stream.rok && stream2.wok) {
                stream.rdCIFA(this.vi, 1);
                int n = CORE.iLRS(this.lrsx);
                int n2 = CORE.iLRS(this.lrsy);
                for (int i = 0; i < 1; ++i) {
                    CoreCommon.CxFloat cxFloat = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat cxFloat2 = CoreCommon.CxFloat.stk();
                    cxFloat.x = CORE.L2F(i > 0 ? ~n : (this.neg ? ~this.lrsx : this.lrsx));
                    cxFloat.y = CORE.L2F(i > 0 ? ~n2 : (this.neg ? ~this.lrsy : this.lrsy));
                    cxFloat2.x = cxFloat.x * this.fscl;
                    cxFloat2.y = cxFloat.y * this.fscl;
                    CORE.addcc(this.vi[i], cxFloat2, this.vo[i]);
                }
                this.lrsx = n;
                this.lrsy = n2;
                this.neg = !this.neg;
                stream2.wrCFIA(this.vo, 1);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

