/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreLibrary;

public class Filters
extends CoreLibrary {
    public static final int FIRKAIS_LOW = 1;
    public static final int FIRKAIS_HIGH = 2;
    public static final int FIRKAIS_BAND = 3;

    public static double sinx(double d) {
        double d2 = Filters.sin(d);
        if (Filters.fabs(d) < 1.0E-20 && Filters.fabs(d2) < 1.0E-20) {
            return 1.0;
        }
        return d2 / d;
    }

    public static double besselIO(double d) {
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 1.0;
        while (!((d2 = d2 * d * d / ((d3 += 2.0) * d3)) - (d4 += d2) * 2.0E-9 < 0.0)) {
        }
        return d4;
    }

    public static int genFirKais(int n, double d, double d2, double d3, double d4, float[] fArray, int n2) {
        double d5 = d;
        double d6 = n == 3 ? d2 * 0.5 : d;
        double d7 = d3;
        double d8 = 2.0;
        double d9 = (d4 - 8.0) / (14.357078426905355 * d7 / d8);
        if (n2 <= 0) {
            n2 = (int)(d9 + 1.5);
        }
        if (n2 <= 0) {
            return 0;
        }
        double d10 = d4 > 50.0 ? 0.1102 * (d4 - 8.7) : (d4 >= 21.0 ? 0.5842 * Filters.pow(d4 - 21.0, 0.4) + 0.07886 * (d4 - 21.0) : 0.0);
        double d11 = 0.5 * (double)(n2 - 1);
        double d12 = n == 2 ? d6 - 0.5 * d7 : d6 + 0.5 * d7;
        double d13 = Math.PI * 2 * (d12 /= d8);
        double d14 = Filters.besselIO(d10);
        if (n != 3) {
            d5 = 0.0;
        }
        double d15 = -0.5 * (double)(n2 - 1);
        double d16 = Math.PI * 2 * d5 / d8;
        for (int i = 0; i < n2; ++i) {
            double d17 = Filters.cos((d15 + (double)i) * d16);
            double d18 = Filters.sin((d15 + (double)i) * d16);
            double d19 = 2.0 * d12 * Filters.sinx(d13 * ((double)i - d11));
            if (n == 2) {
                d19 = Filters.sinx(Math.PI * ((double)i - d11)) - d19;
            }
            double d20 = Filters.sqrt(1.0 - Filters.pow((1.0 * (double)i - d11) / d11, 2.0));
            double d21 = Filters.besselIO(d10 * d20) / d14;
            fArray[i + i + 0] = (float)(d21 * d19 * d17);
            fArray[i + i + 1] = (float)(d21 * d19 * d18);
        }
        return n2;
    }

    public static double sincfunc(double d) {
        double d2 = Filters.sin(d);
        double d3 = 1.0;
        if (Filters.fabs(d2) > 1.0E-20 && Filters.fabs(d) > 1.0E-20) {
            d3 = d2 / d;
        }
        return d3;
    }

    public static float[] genWindowFilter(int n, int n2, int n3, double d, double d2, double d3) {
        float[] fArray = new float[n];
        d /= d3;
        d2 /= d3;
        double d4 = 0.5 * (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double d5 = 1.0;
            if (n2 == 1) {
                d5 = 0.5 - 0.5 * Filters.cos((double)i * Math.PI / d4);
            }
            if (n2 == 2) {
                d5 = 0.54 - 0.46 * Filters.cos((double)i * Math.PI / d4);
            }
            double d6 = 2.0 * d * Filters.sincfunc(Math.PI * 2 * d * ((double)i - d4));
            if (n3 == 2) {
                d6 = Filters.sincfunc(Math.PI * ((double)i - d4)) - d6;
            }
            fArray[i] = (float)(d5 * d6);
        }
        return fArray;
    }

    public static int applyCompensation(float f, float[] fArray, int n) {
        float f2;
        float f3 = -f / 2.0f;
        float f4 = 1.0f + f;
        float f5 = -f / 2.0f;
        float f6 = fArray[n - 1];
        float f7 = f2 = fArray[0];
        for (int i = 0; i < n; ++i) {
            float f8 = f6;
            f6 = f2;
            f2 = i == n - 1 ? f7 : fArray[i + 1];
            fArray[i] = f8 * f3 + f6 * f4 + f2 * f5;
        }
        return n;
    }

    public static int genLinearSlope(double d, float[] fArray, int n) {
        int n2 = n;
        return n2;
    }

    public static class CxPhasePLL
    extends CoreComponent {
        int BNSHF = 20;
        float B0;
        float B1;
        float adl;
        double nco;
        double uF;
        public static final String handleAuto = "sets,process=ix4";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:fptx:process_ret";

        public void setup(double d, double d2, double d3, double d4) {
            double d5 = d2 * Math.PI / d3;
            double d6 = d / (d5 * d5);
            double d7 = 2.0 * d3 / d5;
            this.B0 = CxPhasePLL.mulfp2((float)(1.0 / (2.0 * d6 * d4 * d4) * (1.0 + 1.0 / CxPhasePLL.tan(1.0 / (2.0 * d7 * d4)))), this.BNSHF);
            this.B1 = CxPhasePLL.mulfp2((float)(1.0 / (2.0 * d6 * d4 * d4) * (1.0 - 1.0 / CxPhasePLL.tan(1.0 / (2.0 * d7 * d4)))), this.BNSHF);
            this.adl = 0.0f;
            this.uF = 0.0;
        }

        public float process(CoreCommon.CxFloat cxFloat) {
            float f = CxPhasePLL.atan2cf(cxFloat.y, cxFloat.x);
            float f2 = CxPhasePLL.wrapf(f - CxPhasePLL.d2f(this.nco));
            this.nco = CxPhasePLL.frac(this.nco + CxPhasePLL.divp2(this.uF, this.BNSHF));
            this.uF += CxPhasePLL.f2d(this.B0 * f2 + this.B1 * this.adl);
            this.adl = f2;
            return CxPhasePLL.d2f(this.nco);
        }
    }

    public static class CxIIR
    extends CoreComponent {
        int ORD;
        int STR;
        int LEN;
        int LENM1;
        CxIIRStageO1 s1;
        CxIIRStageO1 s2;
        CxIIRStageO1 s3;
        CoreCommon.CxFloat c1;
        CoreCommon.CxFloat c2;
        int iN;
        int iM;
        int i2M;
        float[] ax1;
        float[] ax2;
        float[] ax3;
        float[] ax4;
        float[] ay1;
        float[] ay2;
        float[] ay3;
        float[] ay4;
        public static final String handleAuto = "sets,process=iox10";
        public static final String handleMethod_process = "$process_ena=T,$ci=%1,x=10,%2=$co,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:ci,o:CxFptx:co,o:process_ret";

        public CxIIR(int n, int n2) {
            this.ORD = n;
            this.STR = n2;
            this.LEN = this.STR * 2;
            this.LENM1 = this.LEN - 1;
            this.s1 = new CxIIRStageO1();
            this.s2 = new CxIIRStageO1();
            this.s3 = new CxIIRStageO1();
            this.c1 = new CoreCommon.CxFloat();
            this.c2 = new CoreCommon.CxFloat();
            this.ax1 = new float[this.LEN];
            this.ay1 = new float[this.LEN];
            this.ax2 = new float[this.LEN];
            this.ay2 = new float[this.LEN];
            this.ax3 = new float[this.LEN];
            this.ay3 = new float[this.LEN];
            this.ax4 = new float[this.LEN];
            this.ay4 = new float[this.LEN];
        }

        public void open(int n, float f, float[] fArray, float[] fArray2) {
            int n2 = 3;
            float f2 = CxIIR.powf(f * 8.0f, 1.0f / (float)n2);
            if (n == 3) {
                this.s3.open(1, f2, fArray[4], fArray2[4], 0.0f, 0.0f);
                this.s2.open(1, f2, fArray[2], fArray2[2], fArray[3], fArray2[3]);
                this.s1.open(1, f2, fArray[0], fArray2[0], fArray[1], fArray2[1]);
            } else if (n == 5) {
                this.s3.open(1, f2, fArray[8], fArray2[8], 0.0f, 0.0f);
                this.s2.open(2, f2, fArray[4], fArray2[4], fArray[5], fArray2[5]);
                this.s1.open(2, f2, fArray[0], fArray2[0], fArray[1], fArray2[1]);
            } else {
                System.out.printf("Unsupported IIR filter order=%d\n", n);
            }
            this.iN = 0;
            this.iM = this.LEN - this.STR;
            this.i2M = 0;
        }

        public int process(CoreCommon.CxFloat cxFloat, CoreCommon.CxFloat cxFloat2) {
            this.ax1[this.iN] = cxFloat.x;
            this.ay1[this.iN] = cxFloat.y;
            this.s1.process(cxFloat, this.c1, this.ax1[this.iM], this.ay1[this.iM], this.ax2[this.iM], this.ay2[this.iM]);
            this.ax2[this.iN] = this.c1.x;
            this.ay2[this.iN] = this.c1.y;
            this.s2.process(this.c1, this.c2, this.ax2[this.iM], this.ay2[this.iM], this.ax3[this.iM], this.ay3[this.iM]);
            this.ax3[this.iN] = this.c2.x;
            this.ay3[this.iN] = this.c2.y;
            this.s3.process(this.c2, cxFloat2, this.ax3[this.iM], this.ay3[this.iM], this.ax4[this.iM], this.ay4[this.iM]);
            this.ax4[this.iN] = cxFloat2.x;
            this.ay4[this.iN] = cxFloat2.y;
            this.iN = this.iN == this.LENM1 ? 0 : this.iN + 1;
            this.iM = this.iM == this.LENM1 ? 0 : this.iM + 1;
            this.i2M = this.i2M == this.LENM1 ? 0 : this.i2M + 1;
            return 1;
        }
    }

    public static class CxIIRStageO2
    extends CoreComponent {
        float b0;
        float b1;
        float b2;
        float a1;
        float a2;
        public static final String handleAuto = "sets,process=iOiiiiiiiix3";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,$axM=%3,$ayM=%4,$naxM=%5,$nayM=%6,$ax2M=%7,$ay2M=%8,$nax2M=%9,$nay2M=%10,x=3,%2==$fo,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,i:fptx:axM,i:fptx:ayM,i:fptx:naxM,i:fptx:nayM,i:fptx:ax2M,i:fptx:ay2M,i:fptx:nax2M,i:fptx:nay2M,o:process_ret";

        public void open(int n, float f, float f2, float f3, float f4, float f5) {
            int n2 = n;
            this.b0 = f;
            this.b1 = (float)(-n2) * f3;
            this.b2 = f3 * f3 + f5 * f5;
            this.a1 = (float)(-n2) * f2;
            this.a2 = f2 * f2 + f4 * f4;
        }

        public int process(CoreCommon.CxFloat cxFloat, CoreCommon.CxFloat cxFloat2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float f9 = f3 * this.a1 + f7 * this.a2;
            float f10 = f4 * this.a1 + f8 * this.a2;
            float f11 = f * this.b1 + f5 * this.b2 + cxFloat.x;
            float f12 = f2 * this.b1 + f6 * this.b2 + cxFloat.y;
            cxFloat2.x = f11 * this.b0 - f9;
            cxFloat2.y = f12 * this.b0 - f10;
            return 1;
        }
    }

    public static class CxIIRStageO1
    extends CoreComponent {
        float b0;
        float b1;
        float b2;
        float a1;
        float a2;
        public static final String handleAuto = "sets,process=iOiiiix2";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,$axM=%3,$ayM=%4,$naxM=%5,$nayM=%6,x=2,%2==$fo,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,i:fptx:axM,i:fptx:ayM,i:fptx:naxM,i:fptx:nayM,o:process_ret";

        public void open(int n, float f, float f2, float f3, float f4, float f5) {
            int n2 = n;
            this.b0 = f;
            this.b1 = (float)(-n2) * f3;
            this.b2 = (float)(-n2) * f5;
            this.a1 = (float)(-n2) * f2;
            this.a2 = (float)(-n2) * f4;
        }

        public int process(CoreCommon.CxFloat cxFloat, CoreCommon.CxFloat cxFloat2, float f, float f2, float f3, float f4) {
            float f5 = f3 * this.a1 - f4 * this.a2;
            float f6 = f4 * this.a1 + f3 * this.a2;
            float f7 = f * this.b1 - f2 * this.b2 + cxFloat.x;
            float f8 = f2 * this.b1 + f * this.b2 + cxFloat.y;
            cxFloat2.x = f7 * this.b0 - f5;
            cxFloat2.y = f8 * this.b0 - f6;
            return 1;
        }
    }

    public static class CxComb
    extends CoreComponent {
        int off;
        int lenm1;
        float fx;
        float fy;
        float scale;
        float[] ax;
        float[] ay;
        boolean full;
        public static final String handleAuto = "sets,process=iox4";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%2=$fo,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,o:process_ret";

        public void setLength(int n) {
            this.lenm1 = n - 1;
            this.scale = 1.0f / (float)n;
        }

        public CxComb(int n) {
            int n2 = 1 << n;
            this.ax = new float[1 << n];
            this.ay = new float[1 << n];
            this.full = false;
            this.lenm1 = n2 - 1;
            this.scale = 1.0f / (float)n2;
            this.off = 0;
        }

        public boolean process(CoreCommon.CxFloat cxFloat, CoreCommon.CxFloat cxFloat2) {
            float f = !this.full ? 0.0f : this.ax[this.off];
            float f2 = !this.full ? 0.0f : this.ay[this.off];
            float f3 = cxFloat.x;
            float f4 = cxFloat.y;
            this.ax[this.off] = cxFloat.x;
            this.ay[this.off] = cxFloat.y;
            this.fx = this.fx + f3 - f;
            this.fy = this.fy + f4 - f2;
            cxFloat2.x = this.fx * this.scale;
            cxFloat2.y = this.fy * this.scale;
            this.full = this.full || this.off == this.lenm1;
            this.off = this.off < this.lenm1 ? this.off + 1 : 0;
            return this.full;
        }
    }

    public static class CxCIC
    extends CoreComponent {
        int O_CIC;
        int O_DEC;
        int count;
        int decm;
        int coarse;
        int fine;
        long[] pix;
        long[] piy;
        int[] pox;
        int[] poy;
        int[] pdx;
        int[] pdy;
        public static final String handleAuto = "sets,process=iox4";
        public static final String handleMethod_process = "$process_ena=T,$fi=%1,x=4,%2=$fo,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:CxFptx:fi,o:CxFptx:fo,o:process_ret";

        public void setGain(int n) {
            int n2 = this.decm + 1;
            int n3 = (int)(5.0 * CxCIC.log2((double)n2 / 4.0) + 9.0) - CxCIC.d2i((double)n / 6.0);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 >= 32) {
                this.coarse = 31;
                this.fine = n3 - 31;
            } else {
                this.coarse = n3;
                this.fine = 0;
            }
        }

        public void setDecimation(int n) {
            this.count = this.decm = n - 1;
            this.setGain(0);
        }

        public CxCIC(int n, int n2) {
            this.O_CIC = n;
            this.O_DEC = n2;
            this.pix = new long[this.O_CIC + 1];
            this.piy = new long[this.O_CIC + 1];
            this.pox = new int[this.O_CIC + 1];
            this.poy = new int[this.O_CIC + 1];
            this.pdx = new int[this.O_CIC + 1];
            this.pdy = new int[this.O_CIC + 1];
            this.setDecimation(1 << n2);
        }

        public boolean process(CoreCommon.CxFloat cxFloat, CoreCommon.CxFloat cxFloat2) {
            for (int i = this.O_CIC; i >= 0; --i) {
                this.pix[i] = i == 0 ? CxCIC.s2l(CxCIC.F2I(cxFloat.x)) : this.pix[i] + this.pix[i - 1];
                this.piy[i] = i == 0 ? CxCIC.s2l(CxCIC.F2I(cxFloat.y)) : this.piy[i] + this.piy[i - 1];
            }
            boolean bl = this.count == 0;
            int n = this.count = this.count == 0 ? this.decm : this.count - 1;
            if (bl) {
                long l = this.pix[this.O_CIC] >> this.coarse;
                long l2 = this.piy[this.O_CIC] >> this.coarse;
                for (int i = this.O_CIC; i >= 0; --i) {
                    this.pdx[i] = this.pox[i];
                    this.pox[i] = i == 0 ? CxCIC.l2i(l) : this.pox[i - 1] - this.pdx[i - 1];
                    this.pdy[i] = this.poy[i];
                    this.poy[i] = i == 0 ? CxCIC.l2i(l2) : this.poy[i - 1] - this.pdy[i - 1];
                }
                cxFloat2.x = CxCIC.K2F(this.pox[this.O_CIC] >> this.fine);
                cxFloat2.y = CxCIC.K2F(this.poy[this.O_CIC] >> this.fine);
            }
            return bl;
        }
    }

    public static class SmoothP2X
    extends CoreComponent {
        int shift;
        int mshft;
        float val = 0.0f;
        float scale;
        public static final String handleAuto = "sets,process=iix1";
        public static final String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=1,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";

        public SmoothP2X(int n) {
            this.shift = n;
            this.scale = 1.0f - 1.0f / (float)(1 << this.shift);
        }

        public void reset() {
            this.val = 0.0f;
        }

        public float process(float f, boolean bl) {
            if (bl) {
                this.val = this.val * this.scale + SmoothP2X.divfp2(SmoothP2X.mulfp2(f, 8), this.shift);
            }
            return SmoothP2X.divfp2(this.val, 8);
        }
    }

    public static class SmoothP2
    extends CoreComponent {
        int mlen;
        int mask;
        int offa;
        int offb;
        int olen;
        int lx;
        int[] ax;
        boolean full;
        public static final String handleAuto = "sets,process=iix3";
        public static final String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=3,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";

        public void reset() {
            int n = 1 << this.olen;
            this.offa = 0;
            this.offb = this.offa - n + 1 & this.mask;
            this.full = false;
            this.lx = 0;
        }

        public void setLength(int n) {
            int n2;
            this.olen = 0;
            for (n2 = 1; n2 < n; n2 *= 2) {
                ++this.olen;
            }
            if (n2 != n) {
                System.out.printf("Smoother length modified from desired len=%d to power2 len=%d\n", n, n2);
            }
            this.reset();
        }

        public SmoothP2(int n) {
            this.mlen = 1 << n;
            this.mask = this.mlen - 1;
            this.ax = new int[this.mlen];
            this.olen = n;
            this.reset();
        }

        public float process(float f, boolean bl) {
            int n;
            int n2 = n = SmoothP2.F2K(f);
            this.ax[this.offa] = n;
            int n3 = this.full ? this.ax[this.offb] : 0;
            boolean bl2 = this.full = this.full || this.offb == this.mask;
            if (bl) {
                this.offa = this.offa + 1 & this.mask;
                this.offb = this.offb + 1 & this.mask;
                this.lx += n2 - n3;
            }
            return SmoothP2.K2F(this.lx >> this.olen);
        }
    }

    public static class Smooth
    extends CoreComponent {
        int mlen;
        int mask;
        int offa;
        int offb;
        float scale;
        double fx;
        float[] ax;
        boolean full;
        float ival;
        public static final String handleAuto = "sets,process=iix3";
        public static final String handleMethod_process = "$process_ena=T,$fin=%1,$valid=%2,x=3,%0=$process_ret";
        public static final String handleArgs = "sets,i:process_ena,i:fptx:fin,i:valid,o:fptx:process_ret";

        public void setLength(int n) {
            int n2 = n;
            if (n2 > this.mask) {
                System.out.printf("Smoother length reduced from desired len=%d to max len=%d\n", n2, this.mask);
                n2 = this.mask;
            }
            this.scale = 1.0f / (float)n2;
            this.offa = 0;
            this.offb = this.offa - n2 & this.mask;
            this.full = false;
            this.fx = 0.0;
            this.ival = 0.0f;
        }

        public void setInitial(float f) {
            this.ival = f;
            this.fx = this.ival / this.scale;
        }

        public Smooth(int n) {
            this.mlen = 1 << n;
            this.mask = this.mlen - 1;
            this.ax = new float[this.mlen];
            this.setLength(this.mlen - 1);
            this.setInitial(0.0f);
        }

        public float process(float f, boolean bl) {
            float f2 = f;
            this.ax[this.offa] = f;
            float f3 = this.full ? this.ax[this.offb] : this.ival;
            boolean bl2 = this.full = this.full || this.offb == this.mask;
            if (bl) {
                this.offa = this.offa + 1 & this.mask;
                this.offb = this.offb + 1 & this.mask;
                this.fx += Smooth.f2d(f2 - f3);
            }
            return Smooth.d2f(this.fx * (double)this.scale);
        }
    }
}

