/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Filters;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class DDC
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int NP = 1;
    public static final int SIBW = 32;
    public static final int SOBW = 32;
    public static final int OCIC = 5;
    public static final int ODEC = 10;
    public static final int OTAP = 8;
    public static final int RTAP = 256;
    public static final int PTAP = 8;
    public static final int OAGC = 12;
    public static final int FPS = 31;
    public static final int MAXCR = 250000000;

    public static class CORE
    extends Core {
        public double fs;
        public double fbwf;
        public double dbwf;
        public float alpha;
        public int gain;
        double p;
        double dp;
        float fscl;
        int ntap;
        int cdec;
        int ndec;
        int ups;
        int mdec;
        int idec;
        int oagc;
        int pass;
        int maxpass;
        int count;
        int maxcount;
        float blkSum;
        float AMDes;
        boolean cntovr;
        Filters.CxCIC cic;
        CoreComponent.CxTapBuf vd;
        CoreComponent.RomF rft;

        public void setFreq(double d) {
            this.dp = -d / this.fs;
            this.putVars("dp");
        }

        public void setFcny(double d) {
            this.dp = -d;
            this.putVars("dp");
        }

        public void setBW(double d) {
            this.ups = 1;
            this.cdec = 1;
            this.ndec = CORE.d2i(this.fs / (d * this.dbwf));
            if (this.ndec < 1) {
                this.ups = 2;
                this.ndec = 1;
            }
            if (this.ndec > 3) {
                this.cdec = this.ndec >> 1;
                this.ndec = 2;
            }
            this.fbwf = d / ((double)this.ups * this.fs / (double)this.cdec);
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("DDC.setBW fs=%f bw=%f bwf=%f ups=%d cdec=%d ndec=%d\n", this.fs, d, this.dbwf, this.ups, this.cdec, this.ndec);
            }
        }

        public double getRatio() {
            return 1.0 * (double)this.ups / (double)(this.cdec * this.ndec);
        }

        public double getDelay() {
            double d = this.oagc * this.maxcount * this.cdec * this.ndec;
            d = this.cdec == 1 ? (d -= 2.5 * (double)this.cdec * (double)this.ndec) : (d -= 3.5 + 2.5 * (double)this.cdec * (double)this.ndec);
            return (d -= (double)(this.ntap / 2 * this.cdec)) / this.fs;
        }

        public void setDec(int n) {
            this.ups = 1;
            this.cdec = 1;
            this.ndec = n;
            if (this.ndec > 3) {
                this.cdec = this.ndec >> 1;
                this.ndec = 2;
            }
            this.fbwf = 0.8;
        }

        public void setGain(double d) {
            int n = CORE.d2i(d / 6.0) * 6;
            this.cic.setGain(n);
            this.fscl = CORE.d2f(CORE.pow(2.0, (d -= (double)n) / 6.0)) / CORE.i2f(31);
            this.putVars("fscl");
        }

        public void genFilt() {
            int n;
            int n2 = this.ntap;
            double d = this.fbwf;
            float f = CORE.i2f(31);
            float f2 = this.alpha > 0.0f ? this.alpha : (this.cdec == 2 ? 0.2f : (this.cdec == 3 ? 0.3f : 0.4f));
            float[] fArray = new float[n2 * 2];
            Filters.genFirKais(1, d, 0.0, 0.01, 70.0, fArray, n2);
            for (n = 0; n < n2; ++n) {
                fArray[n] = fArray[n + n];
            }
            if (this.cdec > 1) {
                Filters.applyCompensation(f2, fArray, n2);
            }
            for (n = 0; n < n2; ++n) {
                this.rft.set(n, fArray[n] * f);
            }
        }

        @Override
        public int init() {
            this.fs = -1.0;
            this.dbwf = 1.5;
            this.dp = 0.0;
            this.ntap = 128;
            this.gain = 0;
            this.alpha = -1.0f;
            this.AMDes = 0.7071f;
            this.setDec(1);
            this.maxcount = 4096;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "D:FS")) {
                this.fs = value.toD();
            } else if (this.isMatch(string, "D:FREQ")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(string, "D:FCNY")) {
                this.setFcny(value.toD());
            } else if (this.isMatch(string, "D:BW")) {
                this.setBW(value.toD());
            } else if (this.isMatch(string, "L:DEC")) {
                this.setDec(value.toL());
            } else if (this.isMatch(string, "D:FBWF")) {
                this.fbwf = value.toD();
            } else if (this.isMatch(string, "D:DBWF")) {
                this.dbwf = value.toD();
            } else if (this.isMatch(string, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(string, "L:GAIN")) {
                this.gain = value.toL();
            } else if (this.isMatch(string, "L:AGC")) {
                this.oagc = value.toL();
            } else if (this.isMatch(string, "F:AMDES")) {
                this.AMDes = value.toF();
            } else if (this.isMatch(string, "F:ALPHA")) {
                this.alpha = value.toF();
            } else if (this.isMatch(string, "L:MAXPASS")) {
                this.maxpass = value.toL();
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "D:FS")) {
                value.fromD(this.fs);
            } else if (this.isMatch(string, "D:FREQ")) {
                value.fromD(this.dp * this.fs);
            } else if (this.isMatch(string, "D:RATIO")) {
                value.fromD(this.getRatio());
            } else if (this.isMatch(string, "D:XDIO")) {
                value.fromD(1.0 / this.getRatio());
            } else if (this.isMatch(string, "D:XSIO")) {
                value.fromD(this.getDelay());
            } else if (this.isMatch(string, "L:NTAP")) {
                value.fromL(this.ntap);
            } else if (this.isMatch(string, "L:GAIN")) {
                value.fromL(this.gain);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.cic = new Filters.CxCIC(5, 10);
            this.cic.setDecimation(this.cdec);
            this.vd = new CoreComponent.CxTapBuf(8, 1, 8, 0);
            this.vd.setLength(this.ntap);
            this.rft = new CoreComponent.RomF(8, 8);
            this.genFilt();
            this.setGain(this.gain);
            if (this.oagc > 0) {
                this.AMDes *= CORE.d2f(CORE.pow(2.0, this.gain / 6));
            }
            this.p = 0.0;
            this.idec = this.mdec = this.ndec - 1;
            System.out.printf("DDC Fs=%f Fc=%f cdec=%d ndec=%d fbwf=%f ntap=%d mc=%d NP=%d\n", this.fs, -this.fs * this.dp, this.cdec, this.ndec, this.fbwf, this.ntap, this.maxcount, 1);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            boolean bl;
            CoreCommon.CxFloat cxFloat = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat2 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat3 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat4 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat5 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat6 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat7 = CoreCommon.CxFloat.stk();
            if (this.cntovr) {
                int n = this.pass = this.pass >= 4096 ? 4096 : this.pass + 1;
                if (this.pass <= this.oagc) {
                    float f = CORE.divfp2(this.blkSum, 12);
                    float f2 = CORE.invf(f);
                    this.fscl = this.fscl * this.AMDes * f2;
                    this.blkSum = 0.0f;
                }
                this.count = 0;
                this.cntovr = false;
            }
            boolean bl2 = bl = this.pass >= this.oagc;
            while (stream.rok && stream2.wok && !this.cntovr) {
                if (this.ups == 2 && CORE.getBit(this.count, 0)) {
                    cxFloat2.x = 0.0f;
                    cxFloat2.y = 0.0f;
                } else {
                    stream.rdCIF(cxFloat2);
                }
                float f = CORE.d2f(this.p);
                this.p = CORE.frac(this.p + this.dp);
                CORE.sincoscf(f, cxFloat);
                CORE.mulcc(cxFloat2, cxFloat, cxFloat3);
                boolean bl3 = this.cic.process(cxFloat3, cxFloat4);
                if (!bl3) continue;
                this.vd.load(cxFloat4);
                boolean bl4 = this.idec == 0;
                int n = this.idec = this.idec == 0 ? this.mdec : this.idec - 1;
                if (!bl4) continue;
                cxFloat5.x = 0.0f;
                cxFloat5.y = 0.0f;
                for (int i = 0; i < this.ntap; ++i) {
                    CoreCommon.CxFloat cxFloat8 = CoreCommon.CxFloat.stk();
                    float f3 = this.rft.get(i);
                    this.vd.get(i, cxFloat8);
                    cxFloat5.x += f3 * cxFloat8.x;
                    cxFloat5.y += f3 * cxFloat8.y;
                }
                CORE.mulcf(cxFloat5, this.fscl, cxFloat6);
                if (bl) {
                    stream2.wrCFI(cxFloat6);
                }
                if (this.pass < this.oagc) {
                    cxFloat7.x = cxFloat6.x * cxFloat6.x;
                    cxFloat7.y = cxFloat6.y * cxFloat6.y;
                    float f4 = cxFloat7.x + cxFloat7.y;
                    float f5 = CORE.sqrtf(f4);
                    this.blkSum += f5;
                }
                ++this.count;
                this.cntovr = this.count >= this.maxcount;
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

