/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.dsp.prim.firkais;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class CFIR
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int ONP = 1;
    public static final int NP = 2;
    public static final int BW = 64;
    public static final int RTAP = 32;
    public static final int NCTAP = 22;
    public static final int NCTAPX = 24;
    public static final int CSCL = 16;
    public static final double[] EQFILT_6DB = new double[]{0.0013318773, -0.0, -0.002600332, 6.3422725E-5, 0.0048201275, -1.2684545E-4, -0.008562068, 3.1711368E-4, 0.014714073, -6.3422736E-4, -0.024481175, 0.0012050319, 0.039639205, -0.0022197957, -0.06393011, 0.0042493227, 0.10585253, -0.008752337, -0.19686416, 0.02295903, 0.6135515, -0.16718231, 0.648878, 0.12361091, -0.20047925, -0.005898314, 0.106994145, -5.073818E-4, -0.06437407, 0.0013953, 0.039829474, -0.0012684547, -0.024544597, 9.5134095E-4, 0.0147774955, -6.9765E-4, -0.0086254915, 4.4395908E-4, 0.0048201275, -2.536909E-4, -0.002600332, 1.2684545E-4, 0.0013318773, -6.3422725E-5};
    public static final double[] EQFILT_12DB = new double[]{0.0013437333, -3.7325924E-5, -0.0025754888, 1.1197778E-4, 0.0048150443, -2.2395556E-4, -0.008584962, 4.8523702E-4, 0.014706414, -9.331481E-4, -0.02444848, 0.0017543184, 0.039602805, -0.0032846814, -0.06382733, 0.006308081, 0.10570701, -0.013176052, -0.19644634, 0.035496954, 0.6100549, -0.27303913, 0.6520839, 0.22746417, -0.20077613, -0.015378281, 0.10705075, 0.0021275778, -0.06434989, 3.7325924E-4, 0.039864086, -8.584963E-4, -0.024523133, 8.2117034E-4, 0.014781066, -5.972148E-4, -0.008584962, 4.1058517E-4, 0.0048150443, -2.6128147E-4, -0.0025754888, 1.493037E-4, 0.0013437333, -7.465185E-5};
    public static final double[] EQFILT_15DB = new double[]{0.0013215624, -5.7459238E-5, -0.0025856656, 1.436481E-4, 0.004826576, -2.872962E-4, -0.008590156, 5.745924E-4, 0.014709565, -0.0010917255, -0.024420176, 0.0020685326, 0.039618142, -0.0038784987, -0.063808486, 0.0074409717, 0.10563881, -0.015600183, -0.1962233, 0.042376187, 0.60820603, -0.33125252, 0.6539436, 0.2845956, -0.20093496, -0.020570407, 0.10710402, 0.0035912024, -0.064383075, -1.436481E-4, 0.03984798, -6.607812E-4, -0.024535095, 7.1824045E-4, 0.014767024, -5.745924E-4, -0.008590156, 4.0221465E-4, 0.004826576, -2.5856658E-4, -0.0025856656, 1.436481E-4, 0.0013215624, -8.618886E-5};

    public static class CORE
    extends Core {
        public int eq;
        public int ntap;
        public int nrpt;
        public int gain;
        public double fwf;
        boolean bypass;
        CoreCommon.CxFloat[] vi;
        CoreCommon.CxFloat[] vo;
        float[] cftx;
        float[] cfty;
        CoreCommon.CxFloat[] cdt;
        float cscl;

        public void setEq(int n) {
            int n2;
            int n3;
            int n4 = 0;
            int n5 = n3 = n < 0 ? -n : n;
            if (this.cftx == null) {
                this.eq = n;
                return;
            }
            double[] dArray = null;
            for (n2 = 0; n2 < 22; ++n2) {
                this.cftx[n2] = 0.0f;
                this.cfty[n2] = 0.0f;
            }
            if (n3 == 0) {
                n4 = 1;
                this.cftx[0] = 16.0f;
            } else if (n3 == 6) {
                n4 = 22;
                dArray = EQFILT_6DB;
            } else if (n3 == 12) {
                n4 = 22;
                dArray = EQFILT_12DB;
            } else if (n3 == 15) {
                n4 = 22;
                dArray = EQFILT_15DB;
            } else {
                System.out.printf("Unsupported EQ rollOff=%d dB\n", this.eq);
                return;
            }
            if (n4 > 1 && dArray != null) {
                for (n2 = 0; n2 < n4; ++n2) {
                    this.cftx[n2] = CORE.d2f(16.0 * dArray[n2 + n2 + 0]);
                    this.cfty[n2] = CORE.d2f(16.0 * dArray[n2 + n2 + 1]);
                }
                if (n < 0) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.cfty[n2] = -this.cfty[n2];
                    }
                }
            }
            this.eq = n;
        }

        @Override
        public int init() {
            this.ntap = 32;
            this.bypass = false;
            this.fwf = 1.0;
            this.cscl = 0.0625f;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:GAIN")) {
                this.gain = value.toL();
            } else if (this.isMatch(string, "L:EQ")) {
                this.setEq(value.toL());
            } else if (this.isMatch(string, "L:NTAP")) {
                this.ntap = value.toL();
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:GAIN")) {
                value.fromL(this.gain);
            } else if (this.isMatch(string, "L:NTAP")) {
                value.fromL(this.ntap);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        public void genFilt() {
            int n = this.nrpt * this.ntap;
            int n2 = 32 - this.ntap;
            double d = this.fwf;
            float[] fArray = new float[n * 2];
            firkais.generate((int)1, (double)(d / (double)this.nrpt), (double)0.0, (double)(0.05 / (double)this.nrpt), (double)80.0, (float[])fArray, (int)n, (boolean)false);
        }

        @Override
        public int open() {
            int n;
            this.cftx = new float[22];
            this.cfty = new float[22];
            this.cdt = new CoreCommon.CxFloat[24];
            for (n = 0; n < 24; ++n) {
                this.cdt[n] = new CoreCommon.CxFloat();
            }
            this.vi = new CoreCommon.CxFloat[2];
            for (n = 0; n < 2; ++n) {
                this.vi[n] = new CoreCommon.CxFloat();
            }
            this.vo = new CoreCommon.CxFloat[2];
            for (n = 0; n < 2; ++n) {
                this.vo[n] = new CoreCommon.CxFloat();
            }
            this.setEq(this.eq);
            System.out.printf("CFIR ntap=%d NP=%d eq=%d byp=%d\n", this.ntap, 2, this.eq, this.bypass ? 1 : 0);
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            while (stream.rok && stream2.wok) {
                stream.rdCIFA(this.vi, 2);
                for (int i = 21; i >= 0; --i) {
                    CORE.dupcc(i < 2 ? this.vi[1 - i] : this.cdt[i - 2], this.cdt[i]);
                }
                for (int i = 0; i < 2; ++i) {
                    CoreCommon.CxFloat cxFloat = CoreCommon.CxFloat.stk();
                    cxFloat.x = 0.0f;
                    cxFloat.y = 0.0f;
                    for (int j = 0; j < 22; ++j) {
                        CoreCommon.CxFloat cxFloat2 = CoreCommon.CxFloat.stk();
                        CoreCommon.CxFloat cxFloat3 = CoreCommon.CxFloat.stk();
                        CoreCommon.CxFloat cxFloat4 = CoreCommon.CxFloat.stk();
                        CoreCommon.CxFloat cxFloat5 = CoreCommon.CxFloat.stk();
                        cxFloat2.x = this.cftx[j];
                        cxFloat2.y = this.cfty[j];
                        cxFloat3 = this.cdt[1 - i + j];
                        cxFloat4.x = cxFloat2.x * cxFloat3.x;
                        cxFloat4.y = cxFloat2.y * cxFloat3.y;
                        cxFloat5.x = cxFloat2.x * cxFloat3.y;
                        cxFloat5.y = cxFloat2.y * cxFloat3.x;
                        cxFloat.x += cxFloat4.x - cxFloat4.y;
                        cxFloat.y += cxFloat5.x + cxFloat5.y;
                    }
                    CORE.mulcf(cxFloat, this.cscl, this.vo[i]);
                }
                stream2.wrCFIA(this.vo, 2);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

