#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/ethernet.h>
#include <arpa/inet.h>

#define RXBUFSIZE 0x1000000

int pkt_dump (char *host, int timer, char *fn) {
  int status=0;
  FILE *fp=NULL;

  int sock_r;
  sock_r = socket(AF_PACKET,SOCK_RAW,htons(ETH_P_ALL));
  if(sock_r<0) { perror("error in socket\n"); return -1; }

  int unblock=1;
  int stat = ioctl (sock_r, FIONBIO, &unblock);
  if (stat<0) { perror("Err unblocking socket\n"); return -2; }

  int bufsize=RXBUFSIZE;
  stat = setsockopt (sock_r, SOL_SOCKET, SO_RCVBUF, &bufsize, sizeof(bufsize));
  if (stat<0) { perror("Err sizing receive socket buffer\n"); return -3; }

  unsigned char *buffer,*bufstr; //to receive data

  struct sockaddr saddr;
  int saddr_len = sizeof (saddr);

  int i=0,j,n;
  int ipaddr,ipmask,ipgate;
  unsigned char *ipn;
  int lastProto=0, lastLen=0, lastCnt=0;

  if (timer<0) {
    n = -timer;
    fp = fopen(fn,"w");
    buffer = (unsigned char *) malloc(n+65536); //to receive data
  } else {
    n = timer*100;
    buffer = (unsigned char *) malloc(65536); //to receive data
    memset(buffer,0,65536);
  }
  bufstr = buffer;
 
  for (i=0; i<n; i++) {
    //Receive a network packet and copy in to buffer
    int buflen=recvfrom(sock_r,buffer,65536,0,&saddr,(socklen_t *)&saddr_len);
    if (buflen<0 && errno==EAGAIN) continue;
    if (buflen<0 && errno==EAGAIN) { usleep(10000); printf("Waiting\n"); continue; }
    if (buflen<0) { printf("Error in reading recvfrom function\n"); return -1; }

    struct ethhdr *eth = (struct ethhdr *)(buffer);

    if ((buflen!=lastLen || eth->h_proto!=lastProto)) {
      printf("Got packet proto=%d len=%d cnt=%d\n",lastProto,lastLen,lastCnt);
      lastCnt = 0;
    }
    else lastCnt++;

    if (buflen!=lastLen && lastCnt==0) {
      printf("packet size=%d data=",buflen);
      for (j=0; j<buflen; j++) printf(" %02x",buffer[j]);
      printf(" end\n");
    }

    if (fp!=NULL) { buffer+=buflen; i+=buflen-1; }

    lastProto = eth->h_proto;
    lastLen = buflen;
  }
  printf("Got packet proto=%d len=%d cnt=%d\n",lastProto,lastLen,lastCnt);

  DONE:
  close(sock_r);
  if (fp!=NULL) { printf("Writing %d bytes to %s\n",i,fn); fwrite(bufstr,1,i,fp); fclose(fp); }
  free(bufstr);
  return status;
}

int main (int argc, char *argv[]) {
  int status = 0;
  char *host = argv[1];
  int timer = atoi(argv[2]);
  char *fn = argv[3];
  if (argc==4) status = pkt_dump (host,timer,fn);
  else printf("Usage: icenetdump <host> <timer> <filename>\n");
  exit (status);
}
