#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/ethernet.h>
#include <arpa/inet.h>

int pkt_sniff (int mode, int timer, char *fn) {
  int status=0;

  int sock_r;
  sock_r=socket(AF_PACKET,SOCK_RAW,htons(ETH_P_ALL));
  if(sock_r<0) { printf("error in socket\n"); return -1; }

  int unblock=1;
  int stat = ioctl (sock_r, FIONBIO, &unblock);
  if (stat<0) { printf("Err unblocking socket\n"); return -2; }

  unsigned char *buffer = (unsigned char *) malloc(65536); //to receive data
  memset(buffer,0,65536);

  struct sockaddr saddr;
  int saddr_len = sizeof (saddr);

  int i=0,j,n=30;
  int ipaddr,ipmask,ipgate;
  unsigned char *ipn;
 
  for (i=0; i<timer*100; i++) {
    //Receive a network packet and copy in to buffer
    int buflen=recvfrom(sock_r,buffer,65536,0,&saddr,(socklen_t *)&saddr_len);
    if (buflen<0 && errno==EAGAIN) { usleep(10000); continue; }
    if (buflen<0) { printf("Error in reading recvfrom function\n"); return -1; }

    struct ethhdr *eth = (struct ethhdr *)(buffer);

    if (eth->h_proto==8) {	// ping
      for (j=0; j<buflen; j++) { 
	if (strncmp(buffer+j,"ICE=",4)==0) {
	  memcpy(&ipaddr,buffer+j+4,4);
	  memcpy(&ipmask,buffer+j+8,4);
	  memcpy(&ipgate,buffer+j+12,4);
	  printf("Got ICE reconfig ping IPADDR=0x%08x IPMASK=0x%08x IPGATE=%08x\n",ipaddr,ipmask,ipgate);
	  FILE *f = fopen(fn,"w");
	  if (f!=NULL) {
	    fprintf(f,"hostname=%s\n","devIce");
	    ipn=(unsigned char*)(&ipaddr);
	    fprintf(f,"hostaddr=%d.%d.%d.%d\n",ipn[0],ipn[1],ipn[2],ipn[3]);
	    ipn=(unsigned char*)(&ipmask);
	    fprintf(f,"hostmask=%d.%d.%d.%d\n",ipn[0],ipn[1],ipn[2],ipn[3]);
	    ipn=(unsigned char*)(&ipgate);
	    fprintf(f,"hostgate=%d.%d.%d.%d\n",ipn[0],ipn[1],ipn[2],ipn[3]);
	    fclose(f);
	  } else {
	    printf("Error opening %s\n",fn);
	  }
	  status=1;
	  goto DONE;
	}
      }
    }
    else if (mode==0) {
      printf("Ethernet Header pktlen=%d\n",buflen);
      printf("t|-Source Address : %.2X-%.2X-%.2X-%.2X-%.2X-%.2X\n",eth->h_source[0],eth->h_source[1],eth->h_source[2],eth->h_source[3],eth->h_source[4],eth->h_source[5]);
      printf("t|-Destination Address : %.2X-%.2X-%.2X-%.2X-%.2X-%.2X\n",eth->h_dest[0],eth->h_dest[1],eth->h_dest[2],eth->h_dest[3],eth->h_dest[4],eth->h_dest[5]);
      printf("t|-Protocol : %d\n",eth->h_proto);
    }
  }
  DONE:
  close(sock_r);
  return status;
}

int main (int argc, char *argv[]) {
  int status = 0;
  int mode = atoi(argv[1]);
  int timer = atoi(argv[2]);
  char *fn = argv[3];
  status = pkt_sniff (mode,timer,fn);
  exit (status);
}
