package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;
import nxm.ice.lib.NetIO;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.MDevIce;
import nxm.ice.lib.DevIce.DmaMap;
import nxm.ice.lib.VRTPacket;
import nxm.ice.lib.SDDSPacket;
import nxm.ice.lib.ArchSFN;

/**
  Manage playback of a Midas file/pipe to a devICE or other network packet stream

  @author Jeff Schoen
  @version $Id: sinkice.java,v 1.8 2009/05/26 13:07:53 jgs Exp $
*/
public class sinkice extends Primitive {

  private Data data;
  private DataFile hi,ho;
  private PacketHandler pkh;
  private ICEPacket opkh,ipkh;
  private VRTPacket vpkh;
  private SDDSPacket spkh;
  private NetIO nio = new NetIO(true);
  private ArchSFN asfn;
  private DmaMap map;
  private MDevIce pic;
  private boolean rt,wrap,skip,net,ram,inputIsICE,fromHdr,swap2,swap4,needContext;
  private double tdelta,tstart,dout,osize,maxout,outRTF,timeRTF,tcur,flush,tflush;
  private int sock=0,sink,bxfer,hxfer,cxfer,pt,sid,archsf,preoff,tc,ctx;
  private long pdata=0,offset=0;
  private Time time;
  private String drep;
  private byte[] prenet;

  /** List of packet types */
  public static String ptList = "NONE,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
  private static int ICE=1, SDDS=2, VRT=3, VRTL=4, VRTW=5, VRTX=6, VRTD=7;

  /** List of packet modes */
  public static String pkthdrList = "Strip,Copy,Attach,Detach";
  private static int STRIP=1,COPY=2,ATTACH=3,DETACH=4;

  /** List of output stream types */
  public static String sinkList = "Net,File,RtFile,DevIce,PktFile,UdpFile,EthFile";
  private static int NET=1,FILE=2,RTFILE=3,DEVICE=4,PKTF=5,UDPF=6,ETHF=7;

  /** List of TimeCode modes */
  public static String tcList = "Off,CPU";
  private static int TC_OFF=1,TC_CPU=2;

  private int lossy,loss,lcnt;

  @Override
  public int open() {

    // get switches
    sid  = MA.getL("/SID",0);
    lossy= MA.getL("/LOSSY");
    wrap = MA.getState("/WRAP");
    rt   = MA.getState("/RT");
    archsf = MA.getL("/ARCHSF",0);
    maxout = MA.getD("/MAXOUT");
    flush  = MA.getD("/FLUSH");

    // exceptions for input type
    boolean isPipe = MA.getS("IN").startsWith("_");
    if (isPipe) { wrap=false; archsf=0; }

    // get input file
    if (archsf!=0) {
      if (archsf==1) archsf=-1;      // default to automatic
      String fn = MA.getCS ("IN");
      asfn = new ArchSFN(this,fn,archsf);
      asfn.setTL(MA.getL("/ARCHTL",B1M/4));
      asfn.setTop(MA.getD("/ARCHTOP"));
      asfn.setDur(MA.getD("/ARCHDUR"));
      openNextFile(true);
      osize = MA.getD("/ARCHDUR") / hi.getXDelta();
      if (osize<=0) osize = hi.getSize();
    } else {
      hi = MA.getDataFile ("IN","1000,2000","S#,C#",0);
      hi.open();
      osize = hi.getSize();
    }
    opkh = (ICEPacket) hi.getPacketHandler();
    inputIsICE = (opkh!=null);
    fromHdr = inputIsICE;
    time    = hi.getTime();
    if (time.getWSec()==0) time.fromCurrent();
    double wsec=time.getWSec(), fsec=time.getFSec();

    pt   = MA.getState("/SDDS")? SDDS : ICE;
    pt   = MA.getChoice("/PT",ptList,pt+1)-1;
//    tc   = MA.getChoice("/TC",tcList,0);
    drep = MA.getS("/REP",hi.getDataRep());

    ho = MA.getDataFile ("OUT",hi,0);
    ho.setDataRep(drep);
    ram = ho.getURL().startsWith("ramd:");

    net = ho.getURL().startsWith("udp:");
    sink = MA.getSelectionIndex("/SINK",sinkList,net?NET:FILE);

    bxfer= MA.getL("/PKTLEN",1024);
    if (net) bxfer = Math.min(bxfer,8192);
    xfer = MA.getL("/TL",(int)(bxfer/hi.dbpe));
    bxfer = (int)(xfer*hi.dbpe);
    ctx = MA.getL("CTX",1);

    if (pt==ICE) {
      pkh = ipkh = new ICEPacket();
      ipkh.setFormat(hi.getFormat());
      ipkh.setSize(xfer);
      ipkh.setTC(1,1,0.0,wsec,fsec);
      hxfer = 64;
    }
    else if (pt==SDDS) {
      pkh = spkh = new SDDSPacket();
      spkh.setFormat(hi.getFormat());
      spkh.setTC(1,0.0,wsec,fsec);
      swap2 = (hi.bps==2);
      hxfer = 56;
      bxfer = 1024;
    }
    else if (pt>=VRT && pt<=VRTD) {
      pkh = vpkh = new VRTPacket(hi.getFormat(), MA.getS("/PT") );
      vpkh.setSID(sid);
      vpkh.setBytes(bxfer);
      vpkh.setTC(wsec,fsec);
      hxfer = vpkh.getHeaderLength();
      int rate = (int)(1/hi.getDelta());
      int freq = MA.getL("/FREQ",0);
      int gain = MA.getL("/GAIN",0);
      vpkh.createContextFor(ctx,rate,freq,gain);
      needContext = (ctx>0);
    }

    cxfer = bxfer;	// no 12b
    int bits = MA.getL("/BITS",0);
    if (vpkh!=null && bits>0) {
      vpkh.setBits(bits);
      cxfer = (bxfer/hi.bps)*bits/8;
      vpkh.setBytes(cxfer);
    }

    if (sink==NET) {
      sock = nio.nioOpen(ho.getURL(),0,nio.OUTPUT|nio.UDP);
      if (sock<=0) M.error("Could not open ICE formatted network stream URL="+ho.getURL());
      pdata = nio.nioAlloc(bxfer+64);
      //fromHdr = false;
    }
    else if (sink>=PKTF) {
      genprenet();
      pdata = nio.nioAlloc(bxfer+64);
      ho.setSize(osize);
      ho.open();
    } 
    else if (sink==RTFILE && ram) {
      ho.open(ho.INOUT);
      osize = ho.getSize();
      ho.setOutput(false);
      pic = new MDevIce(MA,"ICEPIC,DEVNO=0,IOM=NONE,PM=NONE");
      if (pic.open()<=0) M.error("Problem opening PIC device");
      map = pic.mapFile(ho);
      if (map==null) M.error("Problem mapping DMA memory");
    } 
    else {
      ho.setSize(osize);				// set for FTPd output size
      if (pt==ICE && inputIsICE) pkh=ipkh=opkh;		// use output packet handler
      else if (pt>0) ho.setPacketHandler(pkh);		// add output packet handler
      ho.open();
    }

    data   = hi.getDataBuffer(xfer);
    tdelta = hi.getDelta();
    tstart = dout = 0;
    if (rt && tdelta>=0.1) M.warning("Realtime with dt>0.1 ?");
    tcur = Time.current();
    if (sink==RTFILE) updateRTF(0);	// initialize

    return (NORMAL);
  }

  @Override
  public int process() {
    if (rt || flush>0) tcur = Time.current();
    if (rt) {
      if (tstart==0 && hi.avail()<xfer) return (NOOP);
      if (tstart==0) tstart = tcur;
      if (tcur<tstart+dout*tdelta) return (NOOP);
    }
    if (needContext) {
      int npkt = vpkh.ctx2pkt(pdata);
      if (sink==NET) nio.nioSend (sock,0, pdata,npkt, 0);
      if (sink==PKTF) ho.write (pdata,0,npkt);
      needContext=false;
    }
    int n = hi.read(data);
    int bytes = (int)(n*ho.dbpe);
    if (n==xfer) {  
      if (pt==ICE &&  fromHdr) ipkh.setTC (opkh);
      if (pt==ICE && !fromHdr) ipkh.setTC (0,0,0.0,time.getWSec(),time.getFSec());
      if (pt>=VRT && pt<=VRTD) vpkh.setTC (time.getWSec(),time.getFSec());
      if (swap2) Convert.swap2(data.buf,0,bytes>>1);
      if (lossy>0 && simdrop()) {
        // drop this on the floor
      }
      else if (sink==NET) for (int i=0; i<bytes; i+=bxfer) {
        if      (pt==ICE)  { 
          Native.ja2p (ipkh.buf,0, pdata,0, hxfer);
          Native.ja2p (data.buf,i, pdata,hxfer, bxfer);
          nio.nioSend (sock,0, pdata,hxfer+bxfer, 0);
          ipkh.upCount(); 
        }
        else if (pt==SDDS) {
          Native.ja2p (spkh.buf,8, pdata,0, hxfer);
          Native.ja2p (data.buf,i, pdata,hxfer, bxfer);
          nio.nioSend (sock,0, pdata,hxfer+bxfer, 0);
          spkh.upCount(); 
        }
        else if (pt>=VRT && pt<=VRTD)  {
	  int npkt = vpkh.buf2pkt(data.buf,i,pdata,bxfer);
          nio.nioSend (sock,0, pdata,npkt, 0);
          vpkh.upCount(); 
        }
      }
      else if (sink>=PKTF) for (int i=0; i<bytes; i+=bxfer) {
        ho.write (prenet,preoff, 48-preoff);
        if (pt==ICE)  { 
          ho.write (ipkh.buf,0, hxfer);
          ho.write (data.buf,i, bxfer);
          ipkh.upCount(); 
        }
        else if (pt==SDDS) {
          ho.write (spkh.buf,8, hxfer);
          ho.write (data.buf,i, bxfer);
          spkh.upCount(); 
        }
        else if (pt>=VRT && pt<=VRTD)  {
	  int npkt = vpkh.buf2pkt(data.buf,i,pdata,bxfer);
          ho.write (pdata,0,npkt);
          vpkh.upCount(); 
        }
      }
      else if (sink==RTFILE && ram) {
	long vaddr = map.getVirtualAddress(offset,bytes); 
        Native.ja2p (data.buf,0, vaddr,0, bytes);
	offset += bytes;
	if (offset>=map.bytes) offset=0;
      }
      else {
        ho.write(data); 
        if (sink==RTFILE) updateRTF(bxfer);
      }
      if (sink!=NET && sink<PKTF) {
        if (pt==ICE && !fromHdr) ipkh.upCount(); 
        if (pt==SDDS) spkh.upCount();
        if (pt==VRT) vpkh.upCount();
      }
      if (maxout>0 && ho.seek()>=maxout) {
	if (sink==RTFILE) ho.seek(0.0);
	else return FINISH;
      }
      time.addSec(xfer*tdelta);
      dout += n;
    }
    else if (n>0) M.warning("Partial packet of "+n+" elements not output");
    else if (n==0) return (NOOP);
    else if (archsf!=0 && openNextFile(false));                 // found next file - continue
    else if (wrap && hi.isFile()) hi.seek(0.0);
    else return (FINISH);

    if (flush>0 && tcur-tflush>flush) { ho.flush(); tflush=tcur; }
    return (NORMAL);
  }

  @Override
  public int close() {
    if (net) nio.nioClose(sock);
    if (pdata!=0) nio.nioFree(pdata);
    if (map!=null) map.close();
    if (pic!=null) pic.close();
    hi.close();
    ho.close();
    return (NORMAL);
  }

  private boolean simdrop() {
    if (lossy<=0) return false;
    if (++lcnt>100) {
      if (++loss>lossy) loss=1;
      lcnt = 1;
    }
    return (lcnt<=loss);
  }

  public void setArchTop (double top) { if (archsf!=0 && top>=0) { asfn.setTop(top); openNextFile(true); } }
  public void setArchDur (double dur) { if (archsf!=0 && dur>=0) asfn.setDur(dur); }

  private boolean openNextFile (boolean reload) {
    if (hi!=null && hi.isOpen()) hi.close();
    int index = reload? asfn.getIndex() : asfn.nextIndex();
    String sfn = asfn.getSFN(index);
    hi = new DataFile (this,sfn,"","",0);
    hi.open(hi.NATIVE);
    if (!hi.isOpen) return false;   // problem finding file
    if (asfn.isTop()) return false;       // back to top
    return true;
  }

  private void updateRTF (int bytes) {
    boolean init = (bytes==0);
    if (init) timeRTF = tcur;
    else if (tcur-timeRTF<0.05) return;
    timeRTF = tcur;
    outRTF += bytes;
    ho.setInByte(outRTF);
    if (init) ho.setSize(maxout); 
    ho.update();
    //ho.ioh.write(ho.hb,80,8,80L);       // direct access to in_byte
  }

  private void genprenet() {
    prenet = new byte[48];
    int srcport = MA.getL("/SRCPORT",7000);
    int dstport = MA.getL("/DSTPORT",7000);
    int srcaddr = MA.getL("/SRCADDR",0xC0A80001);
    int dstaddr = MA.getL("/DSTADDR",0xE0000001);
    int udplen  = 8 + hxfer + cxfer;
    int udpchk  = 0;
    int iplen   = 20 + udplen;
    int ipchk   = 0;
    long srcaddreth = (0x1CE000L<<24) | (srcaddr&0xFFFFFFFFL);
    long dstaddreth = (0x01005EL<<24) | (dstaddr&0x007FFFFFL);

    Convert.packX(prenet, 0,0xD55555555555L);		// eth preamble
    Convert.packX(prenet, 6,dstaddreth<<16,IEEE);	// eth dest address
    Convert.packX(prenet,12,srcaddreth<<16,IEEE);	// eth source address
    Convert.packI(prenet,18,(short)0x0008);		// eth type=IP

    Convert.packL(prenet,20,0x45000000|iplen,IEEE);	// ip version length
    Convert.packL(prenet,24,0x00008000,IEEE);		// ip ident fragment
    Convert.packL(prenet,28,0x20110000|ipchk,IEEE);	// ip ttl=32 protocol=UDP chksum
    Convert.packL(prenet,32,srcaddr,IEEE);		// ip source address
    Convert.packL(prenet,36,dstaddr,IEEE);		// ip dest address

    Convert.packL(prenet,40,(dstport<<16)|srcport,IEEE);// udp ports
    Convert.packL(prenet,44,(udplen<<16)|udpchk,IEEE);	// udp len
     
    preoff = (sink==ETHF)? 0 : (sink==UDPF)? 40 : 48;
  }

}
