package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;
import nxm.ice.lib.RamDiskResource;
import nxm.ice.lib.DevIce.DmaMap;

/**
  Implements an RealTime RamBuffer File to GPU Memory Circular Buffer transfer 

  @author Jeff Schoen
  @version $Id: bf2gm.java,v 1.9 2011/05/24 13:21:12 jgs Exp $
*/
public class icertmon extends Primitive {

  private DataFile hr;
  private DmaMap map;
  private long iPtr,oPtr;
  private long vaddr,vsize;	// virtual addr/size of RAM buffer
  private int xfer=0x00100000;

  public int open() {

    // open input stream
    hr = MA.getDataFile ("IN","1000,2000","S#,C#",0);
    hr.open();

    if (hr.io instanceof RamDiskResource) map = ((RamDiskResource)hr.io).map;
    else M.error("Input file must exist on an ICE RamDisk mount point");
    map.setPaged(false);

    vsize = map.bytes;
    vaddr = map.getVirtualAddress(0L,(int)vsize);	// map this space

    xfer = MA.getL("/TL",xfer);
    if (vsize%xfer != 0) M.error("Input file length must be a multiple of the transfer length");

    updateRTF();
    oPtr=iPtr;

    return (NORMAL);
  }

  public int process() {
    int status;
    if (iPtr-oPtr<xfer) {
      updateRTF(); // check for new data avail
      if (iPtr-oPtr<xfer) return (NOOP);
    }

    long voff = oPtr % vsize;
    System.out.printf("Processing data at voff=%x optr=%x iptr=%x off=%x\n",voff,oPtr,iPtr);

    oPtr += xfer;
    return (NORMAL);
  }

  public int close() {
    hr.close();
    return (NORMAL);
  }

  private void updateRTF() {
    hr.ioh.read(hr.hb,0,512,0L);	// update inByte field
    iPtr = (long)hr.getInByte();	// detached header so inByte points to data buffer
  }

}
