package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;

/**
  ICE Protocol analyzer.

  @author Jeff Schoen
  @version $Id: icepa.java,v 1.20 2014/08/04 18:14:33 ntn Exp $
*/
public class icepa extends Primitive {

  private DataFile hi,ho;
  private Data dati,dato;
  private int mode=1, spb,hspb,spms, bufSize=0x10000;
  private double xs,xd;
  private long offset;
  private byte[][] cmda = new byte[32][8];

  public static String protocolList = "USB2LS,USB2FS,USB2HS,USB3,DP,PCIe,AUX,TGbE";
  public static String usb2cmdList = "OUT,ACK,DATA0,PING,SOF,NYET,DATA2,SPLIT,IN,NAK,DATA1,PRE,SETUP,STALL,MDATA,SE0,RESET";
  public static String usb2smBits = "rsv,rx_recv,rx_dm,rx_dp,intr,tx_se0,tx_data,tx_en";
  public static int U2_IDLE=0, U2_SE0=16, U2_RESET=17, U2_LAST=18;

  public int open() {

    hi = MA.getDataFile ("IN");
    hi.open();

    ho = MA.getDataFile("OUT", "3000", "NH", 0);
    ho.setSubRecords("TIME|SD,RPT|SL,LEN|SL,TYPE|1A,DATA|1A");
    ho.open(ho.OUTPUT);

    mode = MA.getSelectionIndex("MODE",protocolList,mode);
    spb = (mode==2)? 5 : 40; hspb = spb/2;
    spms = 60000; // samples per millisecond at 60MHz;

    setProgressFeed(hi,"IcePA "+hi.getURL()+" to "+ho.getURL());

    xfer = Math.max(1,(int)(bufSize/hi.dbpe));
    xfer = MA.getL("/TL",xfer);
    dati = hi.getDataBuffer(xfer);
    dato = ho.getDataBuffer(1);

    xs = 0.0;
    xd = hi.getXDelta();
    offset = 0;

    Parser p = new Parser(usb2cmdList);
    for (int i=0; i<U2_LAST; i++) {
      String cmd = (i==0)? "IDLE" : p.get(i);
      while (cmd.length()<8) cmd += " ";
      cmda[i] = cmd.getBytes();
    }

    return (NORMAL);
  }

  public int process() {

    int n = hi.read(dati);
    if (n<=0) return (FINISH);

    processUSB(dati.buf,n);
    offset += n;

    return (NORMAL);
  }

  public int close() {
    hi.close();
    ho.close();
    return (NORMAL);
  }

  void writeOut (long start, int rpt, int len, int cmd, byte[] data, int dlen) {
    Convert.packD(dato.buf,0,xs+xd*start);
    Convert.packL(dato.buf,8,rpt);
    Convert.packL(dato.buf,12,len);
    Convert.packA(dato.buf,16,8,cmda[cmd]);
    Convert.packA(dato.buf,24,dlen,data);
    ho.write(dato,1);
  }

  int lbdr=0x20;
  int state=0;
  long start=0;
  int length=0;
  int lcmd;
  byte[] bcmd = new byte[4096];
  byte[] bdata = new byte[256];

  void processUSBcmd () {
    int cmd=0,rpt,dlen=0;
    boolean nbit;
    int k=1; for (int i=1,s=0; i<lcmd; i++,k++) {
      nbit = (bcmd[i]==0) ^ (bcmd[i-1]==0);
      if (nbit) s=0; else if (++s==6) { i++; s=0; nbit = (bcmd[i]==0) ^ (bcmd[i-1]==0); }
      int j = k&0x7;
      if (j==0) bdata[dlen]=0;
      if (!nbit) bdata[dlen] |= (1<<j);
      if (j==7) dlen++;
      if (k==15) { cmd = bdata[1] & 0xF; dlen=0; }
    }
    if (dlen>4) dlen=4;
    String sdata = Convert.bb2hex(bdata,0,dlen).substring(2);
    while (sdata.length()<8) sdata += " ";
    byte[] edata = sdata.getBytes();
    rpt=1;
    writeOut(start,rpt,k,cmd,edata,8); 
  }

  void processUSB (byte[] buf, int len) {
    for (int i=0; i<len; i++) {
      int bus = buf[i];
      int bdr = bus & 0x30;			// recieve lines
      if (bus < 0) continue;			// illegal bus - startup to serial mode
      if (bdr != lbdr) {
	if (bdr==0) {				// start of sync
	  if (state>0 && lcmd>0) processUSBcmd(); 
	  state=-1; start=offset+i; length=0;
	}
	else if (state<0 && bdr!=0) { 		// end of sync
	  int reset = length/spms;
	  if (reset>0) writeOut(start,1,reset,U2_RESET,buf,0); state=0;
	}
	else if (state==0 && bdr==0x10) {	// start of command
	  state=1; start=offset+i; length=0; lcmd=0; 
	}
      }
      if (state>0 && (length%spb)==hspb && lcmd<4096) {	// add bit to next command
	if (bdr==0x30) { bdr=lbdr; System.out.println("Bad BDR at "+offset+" "+i); }
	bcmd[lcmd++] = (bdr==0x10)? (byte)1:0;
      }
      length++;
      lbdr=bdr;
    }
  }

}
