package nxm.ice.prim;

import nxm.sys.inc.*;
import nxm.sys.lib.*;
import nxm.ice.lib.NetIO;
import nxm.ice.lib.MDevIce;

/**
  Wrapper to Ice NIO library functions

  @author Jeff Schoen
  @version $Id: icenet.java,v 1.9 2011/05/24 13:21:12 jgs Exp $
*/
public class icenet extends Primitive {

  private int tl=4096;
  private DataFile hi,ho;
  private Data dbi,dbo;
  private Table keys;
  private String func,fname,aname;
  private NetIO nio = new NetIO(true);
  private boolean isSet,isGet,isAcq,isPly,isMsg,isMsgR,isFile,isImport,isExport,needHeader;
  private double size;

  public int open() {

    String func = MA.getS("FUNC");
    String addr = MA.getCS("ADDR");
    String label = MA.getU("/LABEL");
    String table = MA.getU("/TABLE");
    String result= MA.getU("/RESULT");

    size = MA.getD("SIZE");

    isSet = func.equals("SET");
    isGet = func.equals("GET");
    isAcq = func.equals("ACQ");
    isPly = func.equals("PLY");
    isMsg = func.equals("MSG");
    isMsgR = func.equals("MSGR");

    isFile   = func.equals("FILE");
    isImport = func.equals("IMPORT");
    isExport = func.equals("EXPORT");

    tl = isAcq? 8192 : 4096;
    tl = MA.getL("/TL", tl);
    
    if (func.length()==0 || addr.length()==0) M.error("Need to specify all arguments");

    // resolve address
    if (addr.indexOf(':')<0 && addr.indexOf('/')<0) {
      String config = MDevIce.getConfig(MA,addr.toUpperCase());
      if (config==null) M.error("Alias "+addr+" not found in HW config file");
      addr = MDevIce.getConfigEntry(config,"IPADDR");
      if (addr==null) M.error("No IPADDR field in HW config "+config);
    }

    if (isSet || isGet || isMsg || isMsgR) {
      int type = isMsgR? NetIO.MSGR : isMsg? NetIO.MSG : isSet? NetIO.SET : NetIO.GET;
      int flags = MA.getOptionMask("FLAGS",NetIO.flagsList,0);
      if ((flags&NetIO.RMIF)==0) flags |= NetIO.HTTP;
      Table t = MA.getTable("FILE",null,MA.NO_ERROR);
      byte[] fb = (t!=null)? t.toBytes() : MA.getCS("FILE").getBytes();
      int len = fb.length;
      if (flags==0) flags=NetIO.RMIF;
      byte[] buf = new byte[tl];
      System.arraycopy(fb,0,buf,0,len);
      int stat = nio.open(addr,0,flags);
      if (stat<0) M.error("Opening socket");
      len = nio.msg(0,type,buf,len,flags);
      String str = (len>0)? new String(buf,0,len) : "NULL";
      int iq = str.indexOf('{');
      int ie = str.indexOf('=');
      if (label.length()>0) MR.put(label,str);
      if (table.length()>0) MR.put(table,new Table(str.substring(iq)));
      if (result.length()>0) MR.put(result,str.substring(ie+1,str.length()-1));
      if (verbose && label.length()<=0 && table.length()<=0 && result.length()<=0) MT.writeln(str);
      return (FINISH);
    }
    else if (isAcq) {
      ho = MA.getDataFile ("FILE","1000","SB",0,size,null);
      ho.open();
      xfer = tl+64;
      dbo = ho.getDataBuffer(xfer);     
      nio.open(addr,0,NetIO.INPUT);
      needHeader=true;
    }
    else if (isPly) {
      hi = MA.getDataFile ("FILE","1000,2000","S#,C#",0);
      hi.open(hi.OPTIONAL);
      dbi = hi.getDataBuffer(tl); 
      M.error("Function "+func+" not coded yet");
    }
    else if (isFile || isImport || isExport) {
      int stat = nio.open(addr,0,NetIO.HTTP);
      if (stat<0) M.error("Opening socket");
      BaseFile bf = MA.getFile("FILE"); bf.find(bf.OUTPUT);
      fname = bf.getURL().substring(5);
      aname = MA.getCS("FLAGS");
    }
    else M.error("Function "+func+" not supported");

    return (NORMAL);
  }

  public int process() {
    if (isAcq) {
      int n = nio.recv (0, dbo.buf,0, xfer, 0);
      if (n>0) ho.write(dbo,n);
      if (ho.seek()>size) return FINISH;
    }
    else if (isPly) {
    }
    else if (isFile || isImport || isExport) {
      nio.file(fname,aname,isImport?1:isExport?-1:0);
      return FINISH;
    }
    else {
      return FINISH;
    }
    return (NORMAL);
  }

  public int close() {
    if (nio!=null) nio.close();
    if (hi!=null) hi.close();
    if (ho!=null) {
      ho.keywords.putMain("PACKET","ICE/FS="+dbo.unpackL(8));
      ho.setFormatMode(dbo.buf[20]);
      ho.setFormatType(dbo.buf[21]);
      ho.close(); 
    }
    return (NORMAL);
  }

}
