!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This is a simple macro to use a SRVICE interface. 
!
!  DEVICE is a devICE alias in the HW file or the devICE string itself
!  CFG is the configuration table in in NeXtMidas|JSON format
!
!  Author: Jeff Schoen
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro s:device t:cfg fn:filename

! create default table if none specified
if cfg eqs NULL then
  set t:cfg {}
endif
if cfg.stream nrexists
  set t:cfg.stream {PORT=MODULE1,FORMAT=CI,RATE=25e6}
endif
if cfg.display nrexists
  set t:cfg.display {PLOT=LINE,NFFT=4K,PSDR=5,PSDA=5,EXPA=1}
endif
if /verbose then
  res/all cfg
endif

pipe on

  ! graphical container window
  panel/controls=gc/setup/logger

  ! graphical top-pane controls
  gcontrol button "DO"   "" "Act,Msg,Cfg" /toff
  gcontrol button "MODE" "" ">|,||,>" "||" /toff
  gcontrol tval   "TIME" "Time" 0 1 -1 1  
  gcontrol lval   "ADLM" "" -48 -48 10 1 /vumeter

  ! graphical left-pane controls
  gcontrol label  "DISP" "Displays"
  gcontrol choice "PLOT" "Plot Type " "Line,Raster,Multi" ^cfg.display.plot
  gcontrol choice "NFFT" "Fft/Frame " "1K,2K,4K,8K,16K" ^cfg.display.nfft /input
  gcontrol choice "PSDR" "Disp Rate " "1,5,10" ^cfg.display.psdr /units="Hz" /input
  gcontrol choice "PSDA" "Disp Avg  " "1,5,10" ^cfg.display.psda /units="Frames" /input
  gcontrol lval   "EXPA" "Expn Avg  "  ^cfg.display.expa 1 100 1 /units="Frames"

  ! allocate timers
  set this.timers 2
  set this.timer(0) 1
  set this.timer(1) 10

pipe off

endmacro

procedure startIce
  if reg.sp rexists return

  set nfft gc.NFFT.v
  set psdr gc.PSDR.v
  set psda gc.PSDA.v
  set expa gc.EXPA.v

  pipe init

  ! perform acquisition or playback
  if /play or /ply then
    sinkice/id=sp/cfg=cfg/replay=0 filename device /frame=nfft /mon=_cb /monrate=psdr*psda
  else
    sourceice/id=sp/cfg=cfg/replay=0 device filename /frame=nfft /mon=_cb /monrate=psdr*psda /native
  endif

  ! provide graphical monitor
  if /mcp then

  elseif /tdp then
    
  else
    fft/id=fft _cb _cbf nfft HANN 0 psda /psd /log /nexp=expa 
  endif

  if gc.PLOT.v eqs "RASTER" then
    plot/id=plot _cbf axis=frame type=raster
  else
    plot/id=plot _cbf axis=frame type=line options=+bstore
  endif
  

  pipe run

return

procedure stopIce
if reg.sp rexists then set reg.sp.replay ABORT
if reg.fft rexists then reg FINISH fft
if reg.plot rexists then reg FINISH plot
return

procedure restartIce
call stopIce
call startIce
if gc.MODE.v eqs ">" then sendto "SP" "SET" {REPLAY=CONT}
return

procedure processMessage

if msg.name eqs "TIMER" then

elseif msg.name eqs "MODE" then
  call startIce 
  if msg.data eqs ">" then
    sendto "SP" "SET" {REPLAY=CONT}
  elseif msg.data eqs ">|" then
    sendto "SP" "SET" {REPLAY=ONESHOT}
  elseif msg.data eqs "||" then
    sendto "SP" "SET" {REPLAY=STOPNOW}
  endif

elseif msg.name eqs "DO" then
  if msg.data eqs "ACT" then
    gc/temp menu "ACTION" "Action" "Status,Exit"
  elseif msg.data eqs "MSG" then
    set reg.panel.toggleborders 0x8
  elseif msg.data eqs "CFG" then
    set reg.panel.toggleborders 0x1
  endif

elseif msg.name eqs "NFFT" or msg.name eqs "PSDR" or msg.name eqs "PSDA" or msg.name eqs "PLOT" then
  call restartIce

elseif msg.name eqs "EXPA" then
  if reg.fft rexists set reg.fft.nexp gc.expa.v

elseif msg.name eqs "ACTION" then
  if msg.data eqs "EXIT" then
    pipe stop
  elseif msg.data eqs "Status" then

  endif
endif
return

