!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Arbitrary Waveform Generator 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/msgid=main/mlog/ps=1m/gc=siggenset s:file s:flags o:config

global hwalias

set cfgfn "siggen_cfg"
set l:live 0
set plen 0
set selectedrow 0
set l:mcf 256
set sbwfactor 1.5
set archvalid 0
set nrpt "NOTPRESENT"
set amp 32k 

switch "SERVICE" server get 0
switch "SERVER" server get server
switch "AUTO" autoprev get "ON"
switch "BPW"  l:bpw get 16
switch "PLEN" l:plen get 256K
switch "AFLAGS" aflags get "PM1=NONE|PM2=NONE" 
switch "XCVR" s:xcvr get ,, "at" /cs
switch "XCF"  xcf get 1 1
switch "RTM"  rtm get 1
switch "PSDA" psda get 10
switch "PSDE" psde get 1
switch "NFFT" nfft get 4k
switch "RFFREQ" rffreq get 1000
switch "DEFPORT" port get "Module1"
switch "SOURCE" source get "Core-AWG"
switch "CMAP" cmap get "BRGC"

if /batch then
  call load_cfg config
  calc length gcfg.LENGTH gcfg.RATE*1e6 * 1m / round 1m *
  switch "LENGTH" length get length
  timer set
  file open/w cfg cfgfn
  call siggen file length
  file close cfg
  timer elapse
  call cleanup
  pipe stop
  stop
endif

if file eqss "PIC" set l:live 1
if port eqss "MCore" then sedit port port "SUBS" "MCORE" "CORE"		! backwards compat
switch "LIVE" l:live get live

if config isnull then				! from command line
  global siggenset
  if siggenset nrexists then set t:siggenset {CONFIG=siggen_cfg}
  call load_cfg siggenset.config
  table siggenset MERGE gcfg siggenset 
  set gcfg siggenset
  set siggenset.card file
elseif config typeof "nxm.sys.lib.Table" then	! from SNAPAPP
  set siggenset config
  if siggenset.config nrexists set siggenset.config "siggen_cfg"
  set siggenset.FORM siggenset.FORMAT		! fixup
  call load_cfg siggenset.config
  if /useglobal then table siggenset MERGE siggenset gcfg
  set gcfg siggenset
else						! all from config file
  call load_cfg config
  set siggenset gcfg
endif

file open/w cfg cfgfn

if live gt 0 or /gen eq 2
  invoke shapes=nxm.ice.core.Modefs.modList
  invoke fecs=nxm.ice.core.Modefs.fecList
else
  invoke shapes=nxm.ice.prim.icewave.shapeList
  set fecs "None"
endif

if /lrsps pexists then
  switch "LRSPS" l:lrsps get 
  switch "REPEAT" d:lrsr get -1
  info "LRS Polys=^/lrsps Repeat=^lrsr"
endif

set tdwlen 4k
if /nio then
  set ports "Core1,Core2,Core3,Core4"
else
  set ports "Module1,Module2,Module1&2,Core1,Core2,Core3,Core4,Core1&2,Core3&4"
endif

pipe on

panel/setup/controls=gc/logger

if server gt 0 then icermif/id=rmif/http server 

view/id=list cfgfn nxm.ice.cfg.genlist.tbl hilite=fore 
plot/id=tdp type=line axis=def y1=-amp y2=amp
plot/id=wbp type=line axis=def /db /xmult=6

feature ,, ff {NAME=FF,TYPE=VLINE|DATA,COLOR=#0080A0} wbp

gcontrol label  "FUNC"    "Files" 
if live gt 0 then
gcontrol choice "MODE"   "Action" "Preview,PostView,Archive,Config,Idle,Run,Rates,Save,Exit" "Preview" /cs
gcontrol file   "FILE"   "File  " archive
gcontrol prompt "CARD"   "Card  " file
gcontrol choice "SOURCE" "Source" "Core-AWG,TBank-FSR,TBank-MCS,TBank-MSP" "Core-AWG"
else
gcontrol choice "MODE"   "Action" "Preview,Archive,Config,Save,Exit" "Preview"
gcontrol file   "FILE"   "File  " file
gcontrol choice "SOURCE" "Source" "Host" "Host"
endif
gcontrol prompt "CONFIG" "Config" 

gcontrol label  "CFG"   "Port Config" 
gcontrol choice "PORT"   "Port  " ports port /input
gcontrol choice "FORM"   "Format" "CF,CI,CJ,CB" "CI"
gcontrol choice "CLOCK"  "Clock " "P,PX" "P"
gcontrol dval   "LENGTH" "Length" 1 1 -1 1  /units="sec"
gcontrol dval   "RATE"   "SRate " 100 1 -1 10 /fmt="#0.000" /units="MHz"
gcontrol dval   "RFFREQ" "RFFreq" rffreq 1 -1 1 /fmt="#0.000" /units="MHz"
gcontrol dval   "RFGAIN" "RFGain" 12 -20 42 1 /units="dB"
gcontrol lval   "NFGAIN" "NFGain" -100 -100 0 10 /units="dB"
gcontrol lval   "GAIN"   "MxGain" 0 1 -1 1 /units="dB"

if /nio then
gcontrol label  "PKT"   "Packet Config" 
gcontrol choice "TPKT"  "PktTyp" "ICE,SDDS,VRT,VRTL,VRTW,VRTX" "ICE" /input
gcontrol choice "LPKT"  "PktLen" "1K,1432,2K,4K,8K" "1K" /units="by" /input
gcontrol prompt "APKT"  "PktAdr" "225.0.0.1"
gcontrol choice "PPKT"  "PktPrt" "7000,29452" "7000" /input
endif

gcontrol label  "SYS"    "System" 0
gcontrol prompt "FLAGS"  "Flags " flags
gcontrol choice "ACTION" "Action" "Monitor,Process,Rec/PB,Stop,Config,Exit,ExitNow"

pipe run
set this.timers 1
if /nolist then set reg.panel.borders "-Right"

sedit gc.PORT.v port upcase
sedit gc.CARD.v card upcase
sedit gc.SOURCE.v source upcase
sendto "MAIN" "MODE" "PREVIEW"
switch "ACTION" lmode get "IDLE"
set gc.MODE.action lmode
if xcvr nisnull call doxcvrinit
call setShows

pipe off

foreach item intable gc
  if item eqs "FLAGS" or item eqs "MODE" or item eqs "ACTION" continue
  set siggenset.^item gc.^{item}.value
endfor
table siggenset SAVE "^env.home/siggenset.tbl"

file close cfg 

call cleanup
if xcvr nisnull call doxcvr "XFREQ" 0

endmacro

procedure cleanup
erase/warn=off awg_psd awg_tdp awg_tmp
if live then 
!  erase/warn=off gc.FILE.v
  files/e ^{gc.CARD.v}_* ,, ^env.ramaux
endif
if rtmfile fexists erase rtmfile
if ramfile fexists erase ramfile
return

procedure load_cfg s:cfname
if ^{cfname}.txt fexists then
  if cfname eqs cfgfn
    info "Loading default working config file: ^cfgfn"
  else
    info "Copying ^cfname to default working config file: ^cfgfn"
    file copy/f ^{cfname}.txt ^{cfgfn}.txt{aux=^aux.write}
  endif
else
  warn "Could not open config file: ^cfname, creating default for ^cfgfn"
  file copy/f nxm.ice.cfg.siggen_cfg.txt ^{cfgfn}.txt{aux=^aux.write}
endif
file open/t scf ^{cfgfn}.txt
file read scf globals
file close scf
sedit globals globals "TRIM" "GLOBAL="
table gcfg create ^globals
if gcfg.LENGTH nrexists then
  set gcfg.LENGTH 1.0
  if gc.LENGTH rexists set gcfg.LEN gc.LENGTH.v
  if gcfg.LEN rexists set gcfg.LENGTH gcfg.LEN
endif
remove gcfg.len
if config instanceof "nxm.sys.lib.Table" and config.RATE rexists then
  set gcfg.RATE config.RATE
endif
if siggenset.NFGAIN rexists set gcfg.NFGAIN siggenset.NFGAIN
convert/parse cfgfn T2B cfgfn "A8|A8|L4|F8|F8|L8|F8|F8|A8" 2
header cfgfn sr(1)="(MODE,)" sr(2)="(SHP,)" sr(3)="(GAIN,)" sr(4)="(FREQ,)" sr(5)="(BAUD,)" sr(6)="(TAPS,)" sr(7)="(FBWF,)" sr(8)="(SPEC,)" sr(9)="(FEC,)"
foreach key intable gcfg
  keyword cfgfn "ADD" "^key" gcfg.^key
endfor
set l:fsz file(cfgfn).size
switch "NTC" l:ntc get fsz
if fsz neq ntc then header cfgfn size=ntc	! trimming file for now
if ntc gt 9 then set nrpt 4k	! reduce taps for large number of channels
return

procedure save_cfg s:cfname
file open/t/n scf ^{cfname}.txt
file write scf "GLOBAL={FORM=^gc.FORM.v,LENGTH=^gc.LENGTH.v,RATE=^gc.RATE.v,GAIN=^gc.GAIN.v,RFFREQ=^gc.RFFREQ.v,RFGAIN=^gc.RFGAIN.v,NFGAIN=^gc.NFGAIN.v,}"
file write scf "MODE	SHAPE	GAIN	FREQ	BAUD	TAPS	FBWF	SPEC	FEC"
do nn 0 ntc-1
  file write scf "^cfg.data(nn,"MODE")	^cfg.data(nn,"SHP")	^cfg.data(nn,"GAIN")	^cfg.data(nn,"FREQ")	^cfg.data(nn,"BAUD")	^cfg.data(nn,"TAPS")	^cfg.data(nn,"FBWF")	^cfg.data(nn,"SPEC")	^cfg.data(nn,"FEC")"
enddo
file close scf
info "Saved configuration to ^cfname"
return

procedure siggen s:fname d:len
info "Processing Signals"
set port "MODULE"
if gcfg.FORM nrexists set gcfg.FORM "CI"
if gcfg.RATE nrexists set gcfg.RATE 10
if gcfg.GAIN nrexists set gcfg.GAIN -100
if gcfg.NFGAIN nrexists set gcfg.NFGAIN -100
if live and len neq 0 then sedit gc.PORT.v port upcase
if len eq 0 then set len plen
if port eqss "CORE" and source ends "AWG" then set len plen
calc amp 128 32k test(gcfg.FORM,eqs,"CB") ?:
calc f:scale 2 gcfg.GAIN/6 ** amp/32k *
set rate gcfg.RATE
if source ends "FSR" then call getsbwmax
set t:arates {}
if port eqss "CORE" and source ends "MSP" then
  picd/exact create fname ^gcfg.FORM rate*1e6 len
else
  pipe init
  set shape "ZERO"
  if gcfg.NFGAIN gt -100 then set shape "NFLOOR"
  icewave/tl=2k/amp=32k _cb0 shape=^shape form=ci gain=^gcfg.NFGAIN rate=rate*1e6 elem=len 
  res fcargs "_cb{form=^gcfg.FORM} _cb0 "
endif
do nn 1 ntc 
  set imode cfg.data(nn-1,"MODE")
  if imode neqs "ON" and port eqss "MOD" continue
  if /maxchn gt 0 and nn gt /maxchn then continue
  set ishp  cfg.data(nn-1,"SHP")
  set ifreq cfg.data(nn-1,"FREQ")
  set igain cfg.data(nn-1,"GAIN")
  set ibw   cfg.data(nn-1,"BAUD")
  set taps  cfg.data(nn-1,"TAPS")
  set fbwf  cfg.data(nn-1,"FBWF")
  set spec  cfg.data(nn-1,"SPEC")
  set fec   cfg.data(nn-1,"FEC")
  if imode neqs "ON" set igain -200
  if port eqss "CORE" and source ends "FSR" then 
    calc ilen sbw*fbwf*1e6*sbwfactor*gcfg.LENGTH 
    calc ilen ilen 256 / round 256 *			! enforce even number of packets
    calc arates.^nn ilen/gcfg.LENGTH			! exact rate
    if taps le 0 set taps "NOTPRESENT"
    icewave/id=wave^nn/tl=2k/wrap/ntap=^taps/fwidth=^fbwf/midx=^spec/nrpt=^nrpt/amp=32k &
	_cb^nn shape=^ishp freq=0 gain=0 baud=^ibw*1e6 form=ci rate=arates.^nn elem=ilen
  elseif port eqss "CORE" and source ends "MSP" then 
    call getsbw nn
    calc ilen sbw*fbwf*1e6*sbwfactor*gcfg.LENGTH 
    calc ilen ilen 256 / round 256 *			! enforce even number of packets
    calc arates.^nn ilen/gcfg.LENGTH			! exact rate
    if taps le 0 set taps "NOTPRESENT"
    sedit "^{card}_^{port}_^nn" ramfilei "LOCASE"
    info "Creating index=^nn fn=^ramfilei"
    icewave/id=wave^nn/tl=8k/wrap/ntap=^taps/fwidth=^fbwf/midx=^spec/nrpt=^nrpt/amp=32k &
	ramfilei{DET=1,AUX=^env.ramaux} shape=^ishp freq=0 gain=0 baud=^ibw*1e6 form=ci rate=arates.^nn elem=ilen
  elseif /gen eq 1 then
    switch "CORE^nn" ct get "j"
    icecore/id=wave^nn/oxd=(1e-6/rate)/ofmt=ci/otl=8k/core=^ct ,, _cb^nn &
	"AWG" SHAPE=^ishp MIDX=^spec NTAP=^taps FS=^rate*1e6 FSYM=^ibw*1e6 FBWF=^fbwf COFF=^ifreq*1e6 GAIN=^igain FEC=^fec BPW=0
    sedit fcargs fcargs "APPEND" "_cb^nn + "
  else
    if taps le 0 set taps "NOTPRESENT"
    icewave/id=wave^nn/tl=2k/wrap/ntap=^taps/fwidth=^fbwf/midx=^spec/nrpt=^nrpt/seed=nn*100/amp=32k &
	_cb^nn shape=^ishp freq=^ifreq*1e6 gain=^igain baud=^ibw*1e6 form=cf rate=rate*1e6 elem=len
    sedit fcargs fcargs "APPEND" "_cb^nn + "
  endif
enddo
if port eqss "CORE" and source ends "MSP" then 
  return
elseif port eqss "CORE" and source ends "FSR" then
  icemux _cb _cb ntc
else
  sedit fcargs fcargs "APPEND" "scale *"
  run "fcalc/id=fcalc/tl=8k/type=f ^fcargs"
endif
header _cb size=len
if len gt plen then
  noop/id=noop/tl=8k/gpw _cb fname{^gcfg.FORM,det=1}
  fft/id=spectra/psd _cb awg_psd nfft=8k over=0 navg=32
else
  noop/id=noop/tl=8k _cb fname{form^=gcfg.FORM,det=1}
  spectra/id=spectra _cb awg_psd nfft=8k over=0
endif
pipe run
while reg.noop rexists then
  pause 0.1
endwhile
foreach key intable REG
  if key eqss "WAVE" and "REG.^key" "REXISTS" then reg "WAIT" "^key" 5
endfor
if len neq plen info "Done Processing"
return

procedure reread
sendto/sync list "FILES" "REREAD"
sendto/sync list "SELECTROW" x:selectedrow
return

procedure selectrow l:nn
set ff.x 0 
set ff.dx 0 
sendto list "SELECTROW" x:row
set selectedrow nn
if nn le 0 return
call getsbw nn
calc ff.x  ^cfg.data(nn-1,"FREQ") 1e6 *
calc ff.dx sbw 1e6 *
return

procedure getsbw l:nn
set s:modt ^cfg.data(nn-1,"SHP")
set sbw ^cfg.data(nn-1,"BAUD")
if modt eqs "FSK" then
  calc sbw ^cfg.data(nn-1,"SPEC") 1 * 2 + sbw *
elseif modt eqs "4FSK" then
  calc sbw ^cfg.data(nn-1,"SPEC") 3 * 2 + sbw *
endif
return
    
procedure getsbwmax l:nn
set sbwmax 0
do nn 1 ntc 
  call getsbw nn
  calc sbwmax sbwmax sbw MAX
enddo
set sbw sbwmax
return

procedure processClose
call picstop
return


procedure processMessage m:msg
!say "Got message ^msg.name = ^msg.data from ^msg.fid  lmode=^lmode"
if msg.name eqs "TIMER" then
  if gc.MODE.v eqs "EXIT" return
  if reg.SPM nrexists then
    call siggen awg_tdp 0
    sendto "TDP" "OPENFILE" "awg_tdp" info=-1
    sendto "WBP" "OPENFILE" "awg_psd" info=-1
  endif
  if selectedrow gt 0 then call selectrow selectedrow

elseif msg.name eqs "ACTION"		! snapapp IF
  if msg.data eqss "MON" or msg.data eqss "REC" then
    if msg.info ge 0 set gc.MODE.action "RUN"
  elseif msg.data eqss "START" then
    set gc.MODE.action "RUN"
  elseif msg.data eqss "STOP" then
    set gc.MODE.action "IDLE"
  elseif msg.data eqss "EXIT" then
    set gc.MODE.action "EXIT"
  endif

elseif msg.fid eqs "RMIF" then          ! handled server/client messaging

elseif msg.name eqs "SET" then          ! server side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.action "^sets.^key"
  endfor
  message send "REPLY" msg "ACK" ,, sets

elseif msg.name eqs "GET" then          ! server side
  set t:sets msg.data
  foreach key intable sets
    set sets.^key gc.^{key}.value
  endfor
  message send "REPLY" msg "RET" ,, sets

elseif msg.name eqs "MODE"
  if lmode eqs "EXIT" then
    pipe stop
    return
  endif
  if msg.data eqs "PREVIEW" then
    call siggen awg_tdp 0
    sendto "TDP" "OPENFILE" "awg_tdp" info=-1
    sendto "WBP" "OPENFILE" "awg_psd" info=-1
  elseif msg.data eqs "POSTVIEW" then
    thin ramfile(0:16m) awg_tdp
    spectra awg_tdp awg_psd nfft=8K
    sendto "TDP" "OPENFILE" "awg_tdp" info=-1
    sendto "WBP" "OPENFILE" "awg_psd" info=-1
  elseif msg.data eqs "ARCHIVE" then
    calc length gc.LENGTH.v gc.RATE.v*1e6 * 1m / round 1m *
    switch "LENGTH" length get length
    if port eqss "MOD" then
      call siggen gc.FILE.v length
      sendto "TDP" "OPENFILE" "^gc.FILE.v" info=-1
      sendto "WBP" "OPENFILE" "awg_psd" info=-1
    else
      calc length gc.LENGTH.v gc.RATE.v*1e6 * 1m / round 1m *
      call siggen gc.FILE.v length
    endif
  elseif msg.data eqs "CONFIG" then
    gc/temp button "CONF" "Config" "Load,AddRow,AutoPreview,ResetCfg,Save,DelRow,ManPreview,Other" /nc=2
  elseif msg.data eqs "EXIT" then
    call picstop
    pipe stop
  elseif msg.data eqs "IDLE" or msg.data eqs "STOP" then
    call picstop
!    pause 1
!    sendto "MAIN" "MODE" "PREVIEW" 
  elseif msg.data eqss "MON" then
    set gc.MODE.action "RUN"
  elseif msg.data eqs "RUN" then
    call picstop
    pause 1
    call picsetup
    call picstart
  elseif msg.data eqs "SAVE" then
    call save_cfg cfgfn
  elseif msg.data eqs "RATES"
    picd get ^card "SPEEDS"
    set gc.MODE.v lmode
  else
    warn "Set mode to ^msg.data"
  endif
  set lmode gc.MODE.v

elseif msg.name eqs "CARD"
  sedit gc.CARD.v card upcase
elseif msg.name eqs "SOURCE"
  call picstop
  sedit gc.SOURCE.v source upcase
  if gc.MODE.v eqs "RUN" then sendto "MAIN" "MODE" "RUN"
elseif msg.name eqs "PORT"
  sedit gc.PORT.v port upcase
  call setShows
  if gc.MODE.v eqs "RUN" then sendto "MAIN" "MODE" "RUN"

elseif msg.name eqs "CONF"
  if msg.data eqs "LOAD"
    sendto "MAIN" "CFG_LOAD"
  elseif msg.data eqs "SAVE"
    sendto "MAIN" "CFG_SAVE"
  elseif msg.data eqs "AUTOPREVIEW"
    set autoprev "ON"
  elseif msg.data eqs "MANPREVIEW"
    set autoprev "OFF"
  elseif msg.data eqs "RESETCFG"
    erase ^{cfgfn}.txt
    sendto "MAIN" "CFG_LOAD"
  elseif msg.data eqs "OTHER"
    say "No OTHER menu yet"
    set autoprev "OFF"
  elseif selectedrow le 0 then
    gc/temp alert "ALERT" "Row Warning" "Must select ROW to add/delete"
  elseif msg.data eqs "ADDROW"
    file close cfg
    mergefile cfgfn(selectedrow-1:selectedrow) cfgfn
    set l:ntc file(cfgfn).size
    file open/w cfg cfgfn
    call reread
  elseif msg.data eqs "DELROW"
    file close cfg
    noop cfgfn awg_tmp
    noop awg_tmp(0:selectedrow-1) cfgfn
    mergefile awg_tmp(selectedrow:) cfgfn
    set l:ntc file(cfgfn).size
    file open/w cfg cfgfn
    call reread
  endif

elseif msg.name eqs "MARK" then	
  if msg.fid neqs "WBP" then
  elseif msg.info eq 101 then		! shift click
    call clickTune msg.data.x*1e-6
  else
    call clickSelect msg.data.x*1e-6
  endif

elseif msg.fid eqs "LIST" then
  !say "Got a LIST message ^msg.name = ^msg.data"
  if msg.name eqs "SELECT" then
    set col msg.data.name
    if msg.data.TYPE eqss "COL" then 
      set row 0
      set value ^cfg.data(0,"^col") 
    else
      set row msg.data.ROW
      if row gt 0 then set value ^cfg.data(row-1,"^col") 
    endif
    if msg.data.TYPE eqs "ROW" then
      if selectedrow gt 0 and row eq selectedrow then set row 0
      call selectrow row
    elseif col eqs "MODE" then
      if row eq 0 then
        gc/temp menu CFG_MODE-^row "Signal On/Off " "On,Off,Toggle"
      else
        sendto "MAIN" "CFG_MODE-^row" "TOGGLE"
      endif
    elseif col eqs "GAIN" then
      gc/temp lval CFG_GAIN-^row "Signal Gain (dB) : " ^value -100 100 3
    elseif col eqs "TAPS" then
      gc/temp lval CFG_TAPS-^row "Filter Taps : " ^value 0 100 1
    elseif col eqs "FREQ" then
      gc/temp fval CFG_FREQ-^row "Center Freq (MHz): " ^value -rate rate 1
    elseif col eqs "BAUD" then
      gc/temp fval CFG_BAUD-^row "Signal BandWidth (MHz): " ^value -rate rate 1
    elseif col eqs "FBWF" then
      gc/temp fval CFG_FBWF-^row "Filter BandWidth Factor: " ^value 0.2 10 0.1
    elseif col eqs "SPEC" then
      gc/temp fval CFG_SPEC-^row "Signal Specific: " ^value -5 5 .5
    elseif col eqs "SHP" then
      gc/temp menu CFG_SHP-^row "Signal Shape " shapes 
    elseif col eqs "FEC" then
      gc/temp menu CFG_FEC-^row "FEC Mode " fecs 
    elseif row eq 0
      warn "Configuration of ^col not editable by column"
    else
      warn "Configuration of ^col not editable by cell"
    endif

  elseif msg.name eqs "DESELECT" then
    if msg.data.TYPE eqs "ROW" then
      call selectrow 0
    endif
  else
  endif

elseif msg.name eqs "RFFREQ" then
  if xcvr nisnull then
    call doxcvr "XFREQ" ^gc.RFFREQ.v
  else
    if reg.sp rexists set reg.sp.RFFREQ ^gc.RFFREQ.v
    if reg.sq rexists set reg.sq.RFFREQ ^gc.RFFREQ.v
  endif
  set gcfg.RFFREQ gc.RFFREQ.v

elseif msg.name eqs "RFGAIN" then
  if reg.sp rexists set reg.sp.RFGAIN ^gc.RFGAIN.v
  if reg.sq rexists set reg.sq.RFGAIN ^gc.RFGAIN.v
  set gcfg.RFGAIN gc.RFGAIN.v

elseif msg.name eqs "GAIN" then
  if reg.sp rexists set reg.sp.GAIN ^gc.GAIN.v
  if reg.sq rexists set reg.sq.GAIN ^gc.GAIN.v
  set gcfg.GAIN gc.GAIN.v

elseif msg.name eqs "CFG_SAVE" then
  call save_cfg gc.CONFIG.v

elseif msg.name eqs "CFG_LOAD" then
  file close cfg
  call load_cfg gc.CONFIG.v
  file open/w cfg cfgfn
  call reread

elseif msg.name eqss "CFG_" then
  sedit msg.name col "TRIM" "_" "-"
  sedit msg.name l:row "TRIM" "-"
  set value msg.data
!  say "Got a msg ^col ^row sel ^selectedrow from ^msg.fid"
  if row le 0 then
    set row1 1 
    set row2 ntc
  else
    set row1 row
    set row2 row
  endif
  do nn row1 row2
    if msg.data eqs "TOGGLE" then
      if ^cfg.data(nn-1,"^col") eqs "ON" then
	set value "OFF"
      else
	set value "ON"
      endif
    endif
    if col subs "SHP,MODE" then
      set cfg.data(nn-1,"^col") "^value"
    else
      set cfg.data(nn-1,"^col") ^value
    endif
    if reg.ic^nn rexists then
      if col eqs "MODE" then
        set imute test(value,eqs,OFF)
	set reg.ic^{nn}.MUTE ^imute
      elseif col eqs "SHP" then
	set reg.ic^{nn}.SHAPE ^value
      elseif col eqs "GAIN" then
	set reg.ic^{nn}.GAIN ^value
      elseif col eqs "FREQ" then
	set reg.ic^{nn}.FREQ ^value*1e6
      elseif col eqs "BAUD" then
	set reg.ic^{nn}.FSYM ^value*1e6
      elseif col eqs "FBWF" then
	set reg.ic^{nn}.FBWF ^value
      elseif col eqs "SPEC" then
	set reg.ic^{nn}.SPEC ^value
      elseif col eqs "TAPS" then
	set reg.ic^{nn}.NTAP ^value
      endif
    elseif reg.sp rexists then
      if reg.sp rexists set reg.sp.CHAN nn
      if reg.sq rexists set reg.sq.CHAN nn
      if col eqs "MODE" then
        set imute test(value,eqs,OFF)
	if reg.sp rexists set reg.sp.MUTE ^imute
	if reg.sq rexists set reg.sq.MUTE ^imute
      elseif col eqs "GAIN" then
	if reg.sp rexists set reg.sp.GAIN ^value
	if reg.sq rexists set reg.sq.GAIN ^value
      elseif col eqs "FREQ" then
	if reg.sp rexists set reg.sp.FREQ ^value*1e6
	if reg.sq rexists set reg.sq.FREQ ^value*1e6
      endif
      if reg.sp rexists set reg.sp.CHAN 0
      if reg.sq rexists set reg.sq.CHAN 0
    endif
  enddo
  call reread

elseif msg.name eqs "NFGAIN" then
  set gcfg.NFGAIN gc.NFGAIN.v
  if reg.sp rexists set reg.sp.NFGAIN gc.NFGAIN.v
  if reg.sq rexists set reg.sq.NFGAIN gc.NFGAIN.v

elseif msg.name eqs "RATE" then
  set gcfg.RATE gc.RATE.v
  if gc.MODE.v eqs "RUN" then sendto "MAIN" "MODE" "RUN"

elseif msg.name eqs "LENGTH" then
  set gcfg.LENGTH gc.LENGTH.v
  if gc.MODE.v eqs "RUN" then sendto "MAIN" "MODE" "RUN"

elseif msg.name eqs "FORM" then
  set gcfg.FORM gc.FORM.v
  if gc.MODE.v eqs "RUN" then sendto "MAIN" "MODE" "RUN"

elseif msg.name eqs "EXIT"
  call picstop
  pipe stop

else
  ! the rest need no other action
  !say "Unhandled message ^msg.name"
endif

if autoprev eqs "ON" then
  if msg.name eqs "FORM" or msg.name eqs "GAIN" or msg.name eqs "NFGAIN" or &
     msg.name eqs "RATE" or msg.name eqss "CFG_" then
    set this.timer(0) -1
  endif
endif

return

procedure clickSelect d:freq
set row 0
set fmin rate
do nn 1 ntc
  set fcur cfg.data(nn-1,"FREQ")
  set fbw cfg.data(nn-1,"BAUD")/2
  calc diff freq fcur - abs
  if freq gt fcur-fbw and freq lt fcur+fbw and diff lt fmin then 
    set row nn
    set fmin fcur
  endif
enddo
call selectrow row
return

procedure clickTune d:freq
if selectedrow le 0 then
  info "Need to select a row first"
else
  sendto "MAIN" "CFG_FREQ-^selectedrow" ^freq
endif
return

procedure picsetup 
sedit "^{card}_^port{DET=1,AUX=^env.ramaux}" ramfile "LOCASE"
calc length gc.LENGTH.v gc.RATE.v*1e6 * 1m / round 1m *
call siggen ^gc.FILE.v length
return

procedure picstart 
!report on
set l:side 1
if "2" subs port or "4" subs port then set l:side 2
if "&" subs port set l:side 1
sedit "^{card}_^port" ramfile "LOCASE"
sedit "^{card}_module^side" rtmfile "LOCASE"
set flags gc.FLAGS.v
set clk gc.CLOCK.v
if /testmode then
  set flgs "^flags|^aflags|IOC=IIW|MUXCLK=P|MBITS=-16|PM1FPGA=MX|TPOE=5"
elseif /nio then
  set flgs "^flags|^aflags|IOC=IIW|MUXCLK=^clk|MBITS=-16"
  calc l:skip rate*1e6/nfft/32 1 max 
  pic/round=nfft create ramfile ^gc.FORM.v rate*1e6/skip rate*1e6
else
  set flgs "^flags|^aflags|MUXCLK=^clk|MBITS=-16|PM1=NONE|PM2=NONE"
  if gcfg.rate ge 200 then sedit flgs flgs "APPEND" "|VHS"
  if gcfg.rate ge 240 then sedit flgs flgs "APPEND" "|QDRX"
  icecopy ^gc.FILE.v ^ramfile{DET=1,AUX=^env.ramaux}
endif
if rtm and port neqss "MOD" then
  calc l:skip rate*1e6/nfft/(psda*5) 1 max 
  pic/round=nfft create rtmfile ^gc.FORM.v rate*1e6/skip rate*1e6
endif
if /noreset isfalse then
  picd reset card /flags=^flgs
endif
if xcvr nisnull then
  set aflgs "^flgs|XCF=^xcf|RFFREQ=^{xcf}000|RFGAIN=^gc.RFGAIN.v"
else
  set aflgs "^flgs|RFFREQ=^gc.RFFREQ.v|RFGAIN=^gc.RFGAIN.v"
endif
if /tc eqss "CPU" then
  set aflgs "MTGO|MUXCLK=PX|^aflgs"
endif
info "Starting output on port=^port"
pipe init
if "&" subs port then
  set l:dual 1 ssp "SQ"
  sedit port i1 "TRIM" "CORE" "&" "TRIM" "MODULE" "&"
  sedit port i2 "TRIM" "&"
else
  set l:dual 0 ssp "NOTPRESENT"
  sedit port i1 "TRIM" "CORE" "" "TRIM" "MODULE" ""
endif
set amode "CONT"
if port eqss "MOD" then
  set aflgs "BLOCK=128K|^aflgs"
  if dual then &
  sinkpic/id=sq/port=MODULE2/replax="CONT" ramfile ramfile card /flags=^aflgs /slave=NS
  sinkpic/id=sp/port=MODULE1/replay="CONT" ramfile ramfile card /flags=^aflgs /master=^ssp
else
  picd get card "CNAME" tsig /port=core^i1
  switch "TSIG" tsig get tsig
  set aflgs "^aflgs|TSIG=^tsig|NFGAIN=^gc.NFGAIN.v"
  sedit ramfile ramfile "APPEND" "{fs=^mcf}" 
  if source ends "FSR" then
    if dual then &
    sinkpic/id=sq/port=TBANK^i2/replax="CONT"/tl=1/nchn=^ntc ramfile ramfile card ,,, gc.GAIN.v /srate=rate*1e6 /flags=^aflgs /slave=NS
    sinkpic/id=sp/port=TBANK^i1/replay="CONT"/tl=1/nchn=^ntc ramfile ramfile card ,,, gc.GAIN.v /srate=rate*1e6 /flags=^aflgs /master=^ssp
  elseif source ends "MSP" then
    if dual then &
    sinkpic/id=sq/port=CORE^i2/replay="STOPPED"/tl=1 ramfile ramfile card ,,, gc.GAIN.v /srate=rate*1e6 /flags=^aflgs|MCS=^ntc|MCI=0|ICSEL /slave=NS
    sinkpic/id=sp/port=CORE^i1/replay="STOPPED"/tl=1 ramfile ramfile card ,,, gc.GAIN.v /srate=rate*1e6 /flags=^aflgs|MCS=^ntc|MCI=0|ICSEL /master=^ssp
    set amode "SPIN"
  elseif /nio then
    sedit aflgs aflgs "APPEND" "|IPORT=NONE|NIO=^gc.TPKT.v|NIOA=^gc.APKT.v|PKTLEN=^gc.LPKT.v"
    sourcepic/id=sp/port=^port/replay="STOPPED"/tl=1 ramfile{fs=2k} ramfile card ,,, gc.GAIN.v /srate=rate*1e6 /flags=^aflgs|MCS=^ntc /skiponcard /skip=skip /stats
  else 
    if dual then &
    sinkpic/id=sq/port=CORE^i2/replay="STOPPED"/tl=1 ramfile ramfile card ,,, gc.GAIN.v /srate=rate*1e6 /flags=^aflgs|MCS=^ntc|NODMA /slave=NS
    sinkpic/id=sp/port=CORE^i1/replay="STOPPED"/tl=1 ramfile ramfile card ,,, gc.GAIN.v /srate=rate*1e6 /flags=^aflgs|MCS=^ntc|NODMA /master=^ssp
  endif
  set icport1 "^card:^i1"
  set icport2 "^card:^i2"
 do nn 1 ntc 
  sedit "^{card}_^{port}_^nn" ramfilei "LOCASE"
  calc l:ii (nn-1)*2 side +
  calc l:jj ii+1 
  set imode cfg.data(nn-1,"MODE")
  set imute test(imode,eqs,"OFF")
  set ifreq cfg.data(nn-1,"FREQ")
  set igain cfg.data(nn-1,"GAIN")
  if source ends "FSR" then
    if reg.sq rexists set reg.sq.chan nn reg.sq.gain igain reg.sq.freq ifreq*1e6 reg.sq.mute imute reg.sq.chan 0
    if reg.sp rexists set reg.sp.chan nn reg.sp.gain igain reg.sp.freq ifreq*1e6 reg.sp.mute imute reg.sp.chan 0
    continue
  endif
  set ishp cfg.data(nn-1,"SHP")
  set ibw  cfg.data(nn-1,"BAUD")
  set taps cfg.data(nn-1,"TAPS")
  set fbwf cfg.data(nn-1,"FBWF")
  set spec cfg.data(nn-1,"SPEC")
  set fec  cfg.data(nn-1,"FEC")
  if fec eqs "" then set fec "None"
  if source ends "AWG" and lrsps rexists
    set l:ispec ^spec-.5
    set l:lrsp lrsps(ispec)
    res/hex/res=lrspx lrsp
    icecore/id=ic^nn/mcid=nn/core=icex/coredev=^icport1|mcs=^ntc|mci=^nn|xverbose ,,, "MOD" &
      SHAPE=^ishp NTAP=^taps FS=^rate*1e6 FSYM=^ibw*1e6 FBWF=^fbwf LRSP=^lrsp LRSR=^lrsr COFF=^ifreq*1e6 GAIN=^igain MUTE=^imute BPW=0  /ifmt=ci /ofmt=ci
    res/res=afreq reg.ic^{nn}.d:freq
    calc afreq afreq/1e6 gc.RFFREQ.v +
    sedit afreq sfreq "NFORM" (f18.12)
    info "Setup chan=^nn LRSP=^lrspx LRSR=^lrsr IF=^ifreq actualRF=^sfreq MHz"
  elseif source ends "MSP" then
    calc l:irepl 0 2 test(imode,eqs,"OFF") ?:
    if reg.sp rexists sinkpic/id=ic^nn/port=TUNER^ii/replay=^irepl/tl=1 ramfilei ramfilei card -1 ^ifreq*1e6 ^igain /srate=rate*1e6 /flags=^aflgs|RGO
    if reg.sq rexists sinkpic/id=jc^nn/port=TUNER^jj/replay=^irepl/tl=1 ramfilei ramfilei card -1 ^ifreq*1e6 ^igain /srate=rate*1e6 /flags=^aflgs|RGO
  else
    if reg.sp rexists icecore/id=ic^nn/mcid=nn/core=icex/coredev=^icport1|mcs=^ntc|mci=^nn|xverbose ,,, "MOD" &
      SHAPE=^ishp NTAP=^taps FS=^rate*1e6 FSYM=^ibw*1e6 FBWF=^fbwf MIDX=^spec COFF=^ifreq*1e6 GAIN=^igain MUTE=^imute FEC=^fec MAP=^cmap BPW=0  /ifmt=ci /ofmt=ci
    if reg.sq rexists icecore/id=jc^nn/mcid=nn/core=icex/coredev=^icport2|mcs=^ntc|mci=^nn|xverbose ,,, "MOD" &
      SHAPE=^ishp NTAP=^taps FS=^rate*1e6 FSYM=^ibw*1e6 FBWF=^fbwf MIDX=^spec COFF=^ifreq*1e6 GAIN=^igain MUTE=^imute FEC=^fec MAP=^cmap BPW=0  /ifmt=ci /ofmt=ci
  endif
 enddo
  if rtm then
    sourcepic/id=spm/port=module^side/replay="CONT" rtmfile{fs=nfft} _cb card /skiponcard /skip=skip /flags=muxclk=n|hxfd
    fft/id=fft/psd _cb _psd nfft HANN 0 psda /nexp=psde
    thin/id=nop _cb _tdp ,,, psda
    sendto "TDP" "OPENFILE" "_tdp" info=-1
    sendto "WBP" "OPENFILE" "_psd" info=-1
  endif
  set reg.sp.replay amode
endif
pipe run
return

procedure picstop
do nn 1 ntc 
  if reg.ic^nn rexists reg "FINISH" ic^nn 2
  if reg.jc^nn rexists reg "FINISH" jc^nn 2
enddo
if reg.sp rexists set reg.sp.replay "ABORT"
if reg.sq rexists set reg.sq.replay "ABORT"
if reg.spm rexists set reg.spm.replay "ABORT"
if rtmfile fexists erase rtmfile
if ramfile fexists erase ramfile
call cleanup
!report off
return

procedure doxcvrinit
fname ipmice "bin" "ipmice" ,, ice
call doxcvr "XFREQ" gc.RFFREQ.v
call doxcvr "status"
return

procedure doxcvr s:name s:value l:info
if xcvr isnull return
if "&" subs port then
  call doxcvrchn name value info ^{xcvr}.1
  call doxcvrchn name value info ^{xcvr}.2
else
  call doxcvrchn name value info xcvr
endif
return

procedure doxcvrchn s:name s:value l:info cs:xchan
if "." subs xchan then
elseif PORT ends "2" then
  sedit xchan xchan "APPEND" ".2"
else
  sedit xchan xchan "APPEND" ".1"
endif
if name eqs "XFREQ" then
  os/stderr=stderr/stdout=stdout ^ipmice freqN=^value ^xchan
elseif name eqs "XATTN" then
  os/stderr=stderr/stdout=stdout ^ipmice attnN=^value ^xchan
elseif name eqs "XOPTS" then
  os/stderr=stderr/stdout=stdout ^ipmice ref=^info ^xchan
else
  os/stderr=stderr/stdout=stdout ^ipmice status ^xchan
endif
!if "freq=" subs stdout then sedit stdout d:gc.XFREQ.v  "TRIM" "freq=" ","
!if "attn=" subs stdout then sedit stdout d:gc.XATTN.v  "TRIM" "attn=" ","
pause 0.1   ! for now
return

procedure setShows
set l:isit test(gc.port.v,eqss,"MOD")
set gc.SOURCE.show 1-isit
return

