!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  This algorithm is used to calibrate tuner timecode by reconstructing the 
!  original input from the tuner output and using cross spectral techniques
!  to calculate delays.  These are compared to the pic_tc() results to verify
!  the theoretical equations.
!
!  It can also be used to compare two files from presumably different paths 
!  to calculate TFDOA.  
!
!  If the second file is auto_nfloor, it is assumed to be a NFLOOR of the same sample
!  rate used to calibrate analog signals.
!
!  Selecting tune=fs/4 keeps freq error at minimum
!
!  Authors: Sid Moore, Joe Briggs, and Jeff Schoen
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/quiet/ltext=96 fn:infile1 fn:infile2 fn:outfile d:time d:length d:tune d:ratio

if "^infile1" eqs "auto_nfloor" then
  switch "TCGENRATE" rate get 100e6
  icewave infile1 nfloor form=ci elem=rate rate=rate gain=-3
  mergefile infile1 infile1
!  timex infile=infile2 floor=1 file=infile1	! copy to nearest second
  timex infile=infile2 ttt
  invoke ttt.floor(1)
  timex ttt file=infile1
endif

calc ilen file(infile1).size 
calc indelta file(infile1).xd
calc rate 1/indelta
calc nyquist .5*rate
set form1  file(infile1).format

calc outdelta file(infile2).xd
calc orate 1/outdelta
calc ddec outdelta/indelta
set format file(infile2).format

if file(infile1).time lt 10 then
  warn "No TC in ^infile1. Using 0-based start."
endif
if file(infile2).time lt 10 then
  warn "No TC in ^infile2. Using 0-based start."
endif

if tune eq -1 then
  if form1 eqss "C" 
    set d:tune 0
  else
    set d:tune rate/4
  endif
endif

if length gt 0 then
  calc ilen ilen length/indelta min round
endif


if ratio gt 0 then
  calc dec ddec ratio * round
else
  calc dec ddec round
  calc ratio dec/ddec
  if/tol=1e-9 ratio eqt 1.0 then
    set ratio 1.0
  endif
endif

calc nfft 2k*dec power2 64k min
calc frame 8k
calc navg 8 rate/10e6 * round

if dec gt 100
  calc nfft nfft*4
  calc navg navg/4 round
endif

calc predelta indelta dec *
calc outdelta indelta ddec *
if format eqss "C"
  calc upshift tune
  calc obw orate 0.5 *
  calc olen ilen/2 ddec / power2 2k max
else
  calc upshift tune orate 4 / - ! Adjust for output center freq
  calc obw orate 0.25 *
  calc olen ilen/2 ddec / power2 4k max
endif
if /debug then
  get format ilen olen rate tune dec ddec ratio
endif

if ratio gt 1 calc obw obw/ratio/ratio
switch "FBW" fbw get 0.8
calc obwf obw*fbw
if ratio lt 1 calc obwf obwf*fbw

if /icetc istrue then
  call xpack infile1
  call xpack infile2
endif

if /status then
  status infile1
  status infile2
endif

if ratio ne 1 then
  calc newrate 1/predelta 1e9 * round 1e9 /
  newrate infile2(0:olen) tcnb newrate
else
  thin infile2 tcnb 0 olen 1
endif

! the registered timecode difference between out and in
calc toffset file(tcnb).time.diff(file(infile1).time) file(tcnb).xs +
! the difference to the nearest input sample
calc outabsc toffset indelta / round indelta *
! the inner sample rest of the difference
calc intersample toffset outabsc -
! headermod the output to the nearest input sample
header tcnb xs=outabsc

if dec eq 1 and ratio eq 1 then

fft/psd tcnb specu nfft bh92 0 navg infile1 speci tccross 

elseif /nopipe then

waveform/tl=frame tf_mixer CF olen/ratio sin 1 upshift 0 outabsc predelta
fcalc/tl=frame tf_tunshift tcnb tf_mixer *
thin/tl=1k/ps=1m tf_tunshift tf_tunup ,,, -dec
fft/psd tf_tunup specu nfft bh92 0 navg infile1 speci tccross 
erase tf_mixer tf_tunshift tf_tunup

else

pipe on
waveform/tl=frame _mixer CF olen/ratio sin 1 upshift 0 outabsc predelta
fcalc/tl=frame _tunshift tcnb _mixer *
thin/tl=1k/ps=1m _tunshift _tunup ,,, -dec
fft/psd _tunup specu nfft bh92 0 navg infile1 speci tccross 
pipe off

endif

if file(tccross).size eq 0 error "Did not get a full frame"

thin tccross tccross1 ,,,, tune-obw tune+obw /absc
thin tccross tccross2 ,,,, tune-obwf tune+obwf /absc 
fcalc tphase tccross2 phasec unwrapc
header tphase xs=-obwf	! center for accurate coef(0)
polyfit tphase 1 slope tccoef err=terror
thin tccoef tcfdoa ,,,, 0 1
thin tccoef tctdoa ,,,, 1 2
header tcfdoa ty=1000
header tctdoa ty=1000
polyfit tcfdoa 1 slopef
polyfit tcfdoa 0 phasef
polyfit tctdoa 0 slopet

statis terror sdev=stdev
calc delay slopet(0) intersample +
calc l:delayns delay 1e9 * round 
calc f:delayisamp delay indelta /
calc f:delayosamp delay outdelta /
calc l:fdoa slopef(1) file(tccross).yd / 1e6 * round

calc f:stdev stdev
calc l:adelayns delayns abs
calc/type=d l:delays delay indelta * 
if dec gt 200 then
  calc l:tolr 25
else
  calc l:tolr 10
endif
switch "TOLR" l:tolr get tolr
switch "PORT" s:port get "FILE"

assert adelayns lt tolr and stdev lt .01 /text="TestTC Port=^port  Std=^stdev Samp=^delayisamp Tolr=^tolr  uHz=^fdoa nSec=^delayns " 

if /x then
  plot/all specu(0:1)|speci(0:1)|tccross(0:1) cm=10lo
  calc phasef 6.28 * push cos =crot sin =srot 
  ! get phasef crot srot
  fcalc tccross1 tccross1 (crot,srot) ~*
  fcalc tccross2 tccross2 (crot,srot) ~*
  plot/all tccross1(0:1)|tccross2(0:1) cm=ph y1=-180 y2=180
  plot/all tcfdoa y1=-1 y2=1
endif

endmacro

procedure xpack fn:xbfile
  keyword/scope=main xbfile get packet str
  if str neqss "ICE" then
    keyword/scope=main xbfile put packet "ICE/DET/FS=2048"
  endif
  icetc TOP ICE xbfile ,, tos
  timex tos file=xbfile
  keyword/scope=main xbfile del packet
return
