!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This macro serves up SNAPAPP applications on an ICE Appliance
!
startmacro/msgid=main/mlog l:port s:scfg s:scene s:smode

global hwalias
version ice
set addr env.hostaddr
set name env.hostname
set screen -1
set cron "10 @ 60"
set logint 0
set guptime 0
import ICEROOT iceroot
set gpsdfn "/var/log/gpsdump.txt"
import/warn=n DISPLAY screen
if screen rexists then sedit screen screen "TRIM" ":" 
say "Running ICESERVER Addr=^addr Port=^port Config=^scfg Scene=^scene Mode=^smode Screen=^screen"

! set default log file
switch "LOGFN" logfn get "iceserver" 
if logfn neqs "OFF" then report on logfn{CFL=1M}

! set default config file
switch "TBL" scfg get scfg
switch "OPT" opt get "ice"
switch "FAN" l:fan get 70
table nodei create {application="Scene=None",devices={},tasks={},tostr="App=? Devices=? Tasks=? NoS=?"}
table nodei setmode "KV"
table gps create {NoS=0,Stage=0}
call loadConfig

! establish PIC configuration
if /noinit isfalse
  call redoinit
else
  sendto "MAIN" "PICT" "RESET" 
endif

res npc hwalias.pics
res nnc hwalias.nics

set psf ""
if /iceos then set psf "os"
switch "PSF" psf get psf ""
invoke themes=nxm.sys.libg.Theme.nameList

pipe on

  panel/controls=gc/setup=^psf/logger

  gcontrol button "MODE"   "MainMode" "Apps,Tasks,System" /input /toff
  gcontrol label  "SERVL"  "Server"
  gcontrol tval   "TIME"   "Time" 0 1 -1 1 /edit=f
  gcontrol prompt "SADDR"  "Addr" "^addr" /edit=f
  gcontrol prompt "RPORT"  "Port" "^port" /edit=f

  gcontrol label  "SNAPL"  "Application"
  gcontrol file   "CFILE"  "Config File" scfg "*.tbl" "HOME"
  gcontrol choice "SCENE"  "Scene      " "NONE,^scenarios" scene 
  gcontrol choice "SPORT"  "Net Port   " "9000,9010,9020" /idef=1 
  gcontrol choice "SCREEN" "Screen     " "-1,0,1,2,3,4,5,6,7,8,9" ^screen
  gcontrol choice "THEME"  "Theme      " themes env.theme
  gcontrol choice "ACTION" "App Action " actions "Setup"
  gcontrol choice "CONN"   "App Status " "Open,Opened,Close,Closed" "Closed" /noedit
  gcontrol prompt "CRON"   "Schedule   " cron 

  gcontrol label  "SYS"    "System Status" 
  gcontrol tval   "UPTIME" "UpTime   " 0 1 -1 1 /edit=f
  gcontrol fval   "POWER"  "Power    " 0 1 -1 1 /edit=f /units=W
  gcontrol lval   "FAN"    "Fan Speed" fan 10 100 10 /units=%
  gcontrol lval   "TEMP"   "CPU Temp " 0 1 -1 1 /edit=f /units=C
  gcontrol choice "GPS"    "GPS Mode " "Time,Status,SetToGPS,SetToApp1,Track@60,Track@10,Track@2,Check,Dump@10,Dump@2,ReLoad,None,Done" "Done" 
  gcontrol button "STAT"   "Status" "IPM,GPS,PIC,NIO,IOS" /toff

  gcontrol label  "PICL"  "PIC Config" "Closed"
  gcontrol choice "PICT"  "PIC Action  " "Status,Speeds,Temps,Update,Detect,Driver,Dir,Dmac,DmacX,Done" "Done" 
  gcontrol lval   "PICS"  "PIC Devices " npc 0 npc 1 /edit=f
 do l:nn 1 npc
  set pic "PIC^{nn}AUTO"
  set alias "^hwalias.^pic"
  sedit alias alias sub "ICEPIC" "ACTIVE=0,TEMP=0,TYPE=0"
  gcontrol prompt "PIC_^nn"  "^pic"  alias 80 /edit=f
 enddo
  remove pic

  gcontrol label  "NICL"  "NIC Config" "Closed"
  gcontrol choice "NICT"  "NIC Action  " "Edit,Update,Done" "Done" 
  gcontrol lval   "NICS"  "NIC Devices " nnc 0 nnc 1 /edit=f
 do l:nn 0 nnc-1
  gcontrol prompt "NIC_^nn" "NIC^nn" "^hwalias.nic^{nn}auto" 80 /edit=t
 enddo

  gcontrol label  "DOCL"   "Documentation"
  gcontrol choice "VIEW"   "View" "Manual,TableFile,AutoConfig,NetworkConfig,DiskConfig" "Manual"
  gcontrol choice "MANS"   "Expl" "IceServer,Snapapp,Snapper,Packer,Sensor,SensorView,SensorFuse,SigGen,SigScan" "Snapapp"
  gcontrol choice "HLPS"   "Help" "Search,Concepts,Commands,Keys,Flags,Network,Tables,Scenes" "Search"

  icermif/id=rmif/http/title=homepageonly port "q:ack"
  iceconnector/id=hub port+1000 "225.1.2.3" nodei nodes

  view/id=hubv nodes

pipe run

set this.timers 2
set this.timer(0) 1
set this.timer(1) 10
set gc.THEME.show 0
set gc.SCREEN.show 0

call pingTemp
call pingIPM
call pingGPS "STAT"

if smode neqs "CLOSE" then sendto "MAIN" "MODE" smode
sendto "MAIN" "TIMER" info=1

pipe off

if logfn neqs "OFF" then report off

if poweroff rexists then
  info "Powering off mode=^poweroff"
  pause 5
  if /iceos then
    os touch /tmp/iceos.^poweroff
    os rm -f /tmp/iceos.loopserver
  elseif poweroff eqss "POWER" then
    os sudo /sbin/poweroff
  elseif poweroff eqs "REBOOT" then
    os sudo /sbin/reboot
  endif
endif

endmacro

procedure close
return

procedure processMessage

!say "Msg ^msg and ^msg.data"

if msg.name eqs "MODE" or msg.name eqs "APPS"  or msg.name eqs "TASKS"  or msg.name eqs "SYSTEM" then
  
  if msg.data eqs "APPS"
    gc/temp menu "APPS" "Apps" "Cancel,--------,OpenScene,CloseScene,----------,ScheduleScene,LaunchScene,----------,RunPacker,RunSensor,SensorView,SensorFuse,----------" "Cancel" /nc=1
  elseif msg.data eqs "TASKS"
    gc/temp menu "TASKS" "Tasks" "Cancel,----------,ReDoInit,RunInit,Test/Spec,Test/PFAT,Test/Eyes,Test/Pings,Test/IceFS,RunTracer" "Cancel" /nc=1
  elseif msg.data eqs "SYSTEM"
    gc/temp menu "SYSTEM" "System" "Cancel,----------,StatusNTP,StatusNVM,LogInt,ShowLog,ShowErrs,ShowNodes,ShowMore,----------,Console,Poll,NoPoll,QuitServer,----------,Reboot,PowerCyc,PowerOff" "Cancel" /nc=1

  elseif msg.data eqs "RUNPACKER"
    set gc.SCENE.v "runPACKER"
    call app_open "PACKER" "packers"
  elseif msg.data eqs "RUNSENSOR"
    set gc.SCENE.v "runSENSOR"
    call app_open "SENSOR" "sensors"
  elseif msg.data eqs "SENSORVIEW"
    run/bg sigview
  elseif msg.data eqs "SENSORFUSE"
    run/bg sensorfuse
  elseif msg.data eqss "OPEN"
    rem docron
    call app_open gc.SCENE.v scfg
  elseif msg.data eqss "CLOSE"
    rem docron
    call app_close
    if gc.SCENE.v eqss "run" then set gc.SCENE.v "None"
    set gc.CRON.title "Schedule   "
  elseif msg.data eqss "SCHEDULE" or msg.data eqss "CRON"
    if "@" subs gc.CRON.v then
      set l:docron -1
      set gc.CRON.title "Scheduling "
    else
      error "Schedule must have form   A @ B   to run for A sec every B sec" 
    endif
  elseif msg.data eqss "LAUNCH"
    gc/temp menu "LAUNCHAPP" "LaunchApp" "NONE,^scenarios" "NONE"

  elseif msg.data eqs "REDOINIT"
    call redoinit
  elseif msg.data eqs "RUNINIT"
   if "^aux.homepath/iceboxinit.mm" fexists
    info "Running local iceboxinit macro"
    %iceboxinit
    info "Finished local iceboxinit macro"
   else
    info "No %iceboxinit macro found"
   endif
   if cfg.server_defaults.gpsmode rexists then set gc.GPS.action ^cfg.server_defaults.gpsmode
  elseif msg.data eqs "TEST/SPEC"
    run/bg pic test/spec pic#auto
  elseif msg.data eqs "TEST/PFAT"
    run/bg pic pfat pic#auto
  elseif msg.data eqs "TEST/EYES"
    run/bg icetest/batch eyes pic1auto
  elseif msg.data eqs "TEST/PINGS"
    run/bg icetest pings pic1auto
  elseif msg.data eqs "TEST/ICEFS"
    run/bg icefs test
  elseif msg.data eqs "RUNTRACER"
    run/bg tracer

  elseif msg.data eqs "StatusNVM"
    call statNVM
  elseif msg.data eqs "StatusNTP"
    call statNTP
  elseif msg.data eqs "LOGINT" 
    gc/temp menu "LOGINT" "Log Interval" "0,10,60,300,600" "^logint" /input
  elseif msg.data eqs "SHOWLOG" 
    view/bg iceserver.mlog
  elseif msg.data eqs "SHOWERRS" 
    iceutil greplog iceserver.mlog iceserver_we.mlog "WARN|ERROR"
    view/bg iceserver_we.mlog
  elseif msg.data eqs "SHOWMORE" 
    set show 1-gc.THEME.show
    set gc.THEME.show show
    set gc.SCREEN.show show
  elseif msg.data eqs "SHOWNODES" 
    call updateNode
    sendto/sync "HUB" "UPDATE"
    view/bg nodes

  elseif msg.data eqs "CONSOLE" 
    os/bg xterm -geometry 90x22 -e su -c /etc/iceos/iceconsole
  elseif msg.data eqs "NOPOLL" 
    set nopoll 1
  elseif msg.data eqs "POLL" 
    rem nopoll

  elseif msg.data eqss "POWER" or msg.data eqs "REBOOT"
    if /nopoweroff and msg.data subs "PowerOff,PowerCyc" then
      warn "PowerOff and PowerCyc disabled by /nopoweroff switch"
    elseif /noreboot and msg.data subs "Reboot" then
      warn "Reboot disabled by /noreboot switch"
    else
      set poweroff msg.data
      call app_close
      pipe stop
    endif
  elseif msg.data eqs "EXITNOW" 
    call app_close
    os rm -f /tmp/iceos.loopserver
    pipe stop
  elseif msg.data eqss "EXIT" or msg.data eqss "QUIT"
    call app_close
    if msg.data eqss "QUIT" and "/tmp/iceos.loopserver" fexists then
      gc/temp menu "QUITLOOP" "Quit Loop ?" "Yes,No,Cancel" "No"
    else
      pipe stop
    endif
  endif

elseif msg.name eqs "QUITLOOP" then
    if msg.data eqss "C" then
      return
    elseif msg.data eqss "Y" then
      os rm -f /tmp/iceos.loopserver
    endif
    pipe stop

elseif msg.name eqs "LAUNCHAPP" then
  if msg.data neqs "NONE" then
    call app_launch msg.data
  endif

elseif msg.name eqs "LOGINT" then
  set l:logint msg.data

elseif msg.name eqs "CONN" then

elseif msg.name eqs "ACTION" then
  if gc.CONN.v eqs "OPENED"
    sendto "RAPP" "SET" {ACTION=^gc.ACTION.v}
  endif
  
elseif msg.name eqs "NICT" then
  if msg.data eqs "UPDATE" then
    set t:nt {} 
    do l:nn 0 nnc-1
      set nt.NIC^nn gc.NIC_^{nn}.v
    enddo
    fname afn home icenetcfg tbl aux
    table nt save afn
    info "Network configuration changes will be applied on REBOOT"
  endif
  if msg.data eqs "EDIT" then
    do l:nn 0 nnc-1
      set gc.NIC_^{nn}.flags "-NOEDIT"
    enddo
  else
    do l:nn 0 nnc-1
      set gc.NIC_^{nn}.flags "+NOEDIT"
    enddo
    set gc.NICT.v "Done"
  endif

elseif msg.name eqs "PICT" then
  if msg.data eqs "DIR" then
    pic dir
    return
  endif
  if msg.data eqs "DRIVER" then
    info "Showing /proc/driver/icepic ..."
    foreach line intf "/proc/driver/icepic"
      info line
    endfor
    return
  endif
  do l:nn 1 npc
    set pic "PIC^{nn}AUTO"
    picd get pic "ACTIVE" act
    if msg.data eqs "UPDATE" then
      set gc.PICT.v "Updating ^pic ..."
      if act ge 0 then
        picd get pic "TEMP" l:temp 
        picd get pic "TYPE" l:type 
      else
        set temp 0
        set type 0
      endif
      set alias "^hwalias.^pic"
      sedit alias alias sub "ICEPIC" "ACTIVE=^act,TEMP=^temp,TYPE=^type"
      set gc.PIC_^{nn}.v alias
    elseif msg.data eqs "RESET" then
      info "Resetting ^pic ..."
      if /noinit isfalse
        picd reset ^pic /flags=pcicap
      endif
      picd get ^pic "FPGASIG" sig /str
      picd get ^pic "FPGADSG" dsg /str
      picd get ^pic "CHNS" ntun 
      set nrx 0 ntx 0
      do ii 1 2 
        picd get ^pic "MTYPE^ii" mtype 
	if mtype gt 0 then set ntx ntx+1
	if mtype lt 0 then set nrx nrx+1
      enddo
      sedit dsg dsg "UPCASE"
      set nodei.devices.^pic "^dsg:^sig nRx=^nrx nTx=^ntx nTun=^ntun"
    elseif act lt 0 then
      info "Active ^pic status=^act not accessible"
    elseif msg.data eqs "STATUS" then
      info "Statusing ^pic ..."
      pic status ^pic
    elseif msg.data eqs "SPEEDS" then
      info "Speeds ^pic ..."
      picd get ^pic speeds /dmac=-1
    elseif msg.data eqs "DETECT" then
      info "Detecting pics ..."
      picd detect
    elseif msg.data eqs "TEMPS" then
      pic temps ^pic 
    elseif msg.data eqs "DMAC" then
      info "DMAC ^pic ..."
      picd dmac ^pic 
    elseif msg.data eqs "DMACX" then
      info "DMACX ^pic ..."
      pic dmacx ^pic /net /ntun=8
    elseif msg.data eqs "TEST" then
      info "Testing ^pic ..."
      pic test ^
    endif
  enddo
  remove pic
  info "Finished ^msg.data on ^npc DevICEs"
  set gc.PICT.v "Done"
  call updateNode

elseif msg.name eqs "STAT" then
  if msg.data eqs "IPM"
    call statusIPM
  elseif msg.data eqs "PIC"
    set gc.PICT.action "Status"
  elseif msg.data eqs "GPS" 
    call pingGPS "STAT"
    call checkPPS
  elseif msg.data eqs "NIO"
    picd get pic1auto "NIOS" 
  elseif msg.data eqs "IOS"
   sendto "MAIN" "PICT" "SPEEDS"
  endif

elseif msg.name eqs "GPS" then
  if msg.data eqss "NONE" or msg.data eqss "DONE" 
  elseif msg.data eqs "CHECK" then
    call statNTP
  elseif msg.data eqs "SETTOAPP1" then
    say "Not coded yet"
  else
    call pingGPS ^msg.data
  endif
  if msg.data eqss "DUMP" 
    info "Dumping GPS debug registers >> ^gpsdfn"
    return
  endif
  if msg.data eqss "TRACK" or msg.data eqss "DUMP" then return
  set gc.GPS.v "Done"

elseif msg.name eqs "TIMER" and msg.info eq 0 then  ! 1 sec
  set gc.time.v msg.data
  if reg.rapp rexists then
    sendto "RAPP" "GET" {ACTION=}
  endif
  if reg.rmif.remotes.rapp rexists then
    set gc.CONN.v reg.rmif.remotes.rapp.status
  endif
  timex gc.time.v soy=tt
  calc tt tt fix
  if docron rexists then
    sedit gc.CRON.v d:t1 "TRIM" "" "@"
    sedit gc.CRON.v d:t2 "TRIM" "@" ""
    if t1 lt 0 and gc.CONN.v neqs "OPENED" then set tt 0
    if calc(tt,2,/,fix,2,*,t2,mod) le 1 then
      if gc.CONN.v neqs "CLOSED"
        call app_close
      endif
      set docron 0
      call app_open gc.SCENE.v scfg
    elseif t1 gt 0 and docron ge t1 then
      set docron -1
      call app_close
    elseif docron ge 0 then
      set docron docron+1
    endif
  endif
  if logint gt 0 and calc(tt,logint,mod) eq 0 then	! status log at interval
    do l:nn 1 npc
      pic temps "PIC^{nn}AUTO" stdout
      info stdout
    enddo
    if /iceos then
      call statusIPM
    endif
    if cfg.server_defaults.gps eqss "IOM" then 
      call pingGPS "STAT"
    endif
    if noNTP nrexists then
      call statNTP
    endif
  endif
  if nopoll rexists return
  if cfg.server_defaults.gps eqss "IOM" then
    call pingGPS "CHECKUP"
  endif
!  set gc.lmsg.v reg.logger.last

elseif msg.name eqs "TIMER" and msg.info eq 1 then  ! 10 sec
  if nopoll rexists return
  call pingTemp
  call pingIPM
  call updateNode
  report flush

elseif msg.name eqs "FAN" then
  calc l:speed ^msg.data 100 min 0 max
  if /iceos then
    os/stderr=stderr/stdout=stdout ipmice fan=^speed 
  endif

elseif msg.name eqs "CFILE" then
  if gc.CONN.v eqs "CLOSED"
    set scfg msg.data
    call loadConfig
  else
    warning "The SNAPAPP must be CLOSED before loading a new configuration file"
  endif

elseif msg.name eqs "SCENE" then
  if gc.CONN.v eqs "OPENED"
    sendto "RAPP" "SET" {SCENE=^gc.SCENE.v}
  endif

elseif msg.name eqs "COMMAND" then
  run ^msg.data

elseif msg.name eqs "GETPSD" then
  icearchive "GETPSD" msg.data.arch msg.data.top msg.data.dur ,, msg.data.file

elseif msg.name eqs "GETCUT" then
  icearchive/id=arch "EXTRACT" "^msg.data.arch" ^msg.data.top ^msg.data.dur ,, "^msg.data.file" /cf=^msg.data.cf*1e6 /bw=^msg.data.bw*1e6 /card=pic2auto

elseif msg.name eqs "GETQSTAT"
  picd get pic1auto "QSTAT" qstat /dmac=^msg.info /str
  set msg.data qstat

elseif msg.name eqs "GET" then          ! server side
  set t:sets msg.data
  foreach key intable sets
    set sets.^key gc.^{key}.value
  endfor
  message send "REPLY" msg "RET" ,, sets

elseif msg.name eqs "RET" then          ! client side
  set t:sets msg.data
  foreach key intable sets
    if key eqs "ACTION" then
      set gc.ACTION.v "^sets.^key"
    endif
  endfor

elseif msg.name eqs "SET" then          ! server side
  set t:sets msg.data
  foreach key intable sets
    set gc.^{key}.action "^sets.^key"
  endfor
  message send "REPLY" msg "ACK" ,, sets

elseif msg.name eqs "ACK" then          ! client side
  set t:sets msg.data
  foreach key intable sets
!    set gc.^{key}.value "^sets.^key"
  endfor

elseif msg.name eqs "HLPS" then          ! documentation
  if msg.data eqs "SEARCH" then
    help/gui ,, ice
  elseif msg.data eqs "INDEX" then
    browse/bg "nxm.ice.docs.help.index.html"
  elseif msg.data eqs "CONCEPTS" then
    browse/bg "nxm.ice.docs.help.ice_hlp_all.html"
  elseif msg.data eqs "COMMANDS" then
    browse/bg "nxm.ice.docs.help.ice_exp_all.html"
  elseif msg.data eqs "NETWORK" then
    browse/bg "nxm.ice.docs.help.ice_hlp_network.html"
  elseif msg.data eqs "FLAGS" then
    browse/bg "nxm.ice.docs.help.ice_hlp_flags.html"
  elseif msg.data eqs "KEYS" then
    browse/bg "nxm.ice.docs.help.ice_hlp_keys.html"
  endif

elseif msg.name eqs "MANS" then          ! documentation
  sedit "nxm.ice.docs.help.ice_exp_^{msg.data}.html" fname "LOCASE"
  browse/bg "^fname"

elseif msg.name eqs "VIEW" then          ! documentation
  if msg.data eqs "MANUAL" then
    fname fn "HOME" "IceManual" "pdf" "AUX"
    os/bg xpdf ^fn
  elseif msg.data eqs "TABLEFILE" then
    fname fn "HOME" "^gc.CFILE.v" "tbl" "AUX"
    view/bg "^fn"
  elseif msg.data eqs "AUTOCONFIG" then
    fname fn "HOME" "iceauto" "tbl" "AUX"
    view/bg "^fn"
  elseif msg.data eqs "NETWORKCONFIG" then
    browse/bg "/var/etc/network.conf"
  endif

elseif msg.name eqs "EXIT"
  pipe stop

else
  ! the rest need no other action
endif
return

procedure app_launch s:stmp
  find nxm.ice.cfg.icebox_app.vnc appcsh
  run/bg "^appcsh 0 ^scfg ^stmp ^gc.SCREEN.v ^gc.THEME.v"
return

procedure app_open s:stmp s:xcfg
if gc.CONN.v eqs "OPENED"
  warn "App already opened"
else
  set l:sport gc.SPORT.v
  if "/TBL=" subs cfg.applist.^stmp then sedit cfg.applist.^stmp xcfg "TRIM" "/TBL=" ","
  find nxm.ice.cfg.icebox_app.vnc appcsh
  info "App opening scene=^stmp"
  run/bg "^appcsh ^sport ^xcfg ^stmp ^gc.SCREEN.v ^gc.THEME.v"
  sendto/sync "RMIF" "OPEN" {ID=RAPP,HP=localhost:^sport}
  do nn 1 100
    if reg.rmif.remotes.rapp.status eqs "OPENED" return
    pause 0.1
  enddo
  warn "Err opening app scene: ^stmp at ^appcsh"
endif
return

procedure app_close
if sport nrexists return
if gc.CONN.v eqs "CLOSED"
  warn "App already closed"
  sendto/sync "RMIF" "OPEN" {ID=RAPP,HP=localhost:^sport}
  sendto "RAPP" "SET" {ACTION=EXITNOW}
  sendto "RAPP" "CLOSE" 
else
  info "App closing scene=*"
  sendto "RAPP" "SET" {ACTION=EXITNOW}
  message/wait=5 getwn "RAPP" msg "ACK"
  sendto "RAPP" "CLOSE" 
  set gc.ACTION.v "Stop"
  do nn 1 100
    if reg.rmif.remotes.rapp.status eqs "CLOSED" return
    pause 0.1
  enddo
  warn "Err closing app scene: ^gc.SCENE.v at ^appcsh"
endif
return

procedure loadConfig
if ";" subs scfg then ! support /tbl=table;opt syntax
  sedit scfg opt trim ";"
  sedit scfg cfgn trim ,, ";"
  set cfgn "nxm.^{opt}.tbl.^{cfgn}.tbl"
else
  set cfgn scfg
  if ".tbl" nsubs cfgn then set cfgn "^{cfgn}.tbl"
  if cfgn nfexists then sedit "nxm.^{opt}.tbl.^{cfgn}" cfgn "LOCASE"
endif
if cfgn nfexists then 
  warn "Could not find config file: ^cfgn
  if cfg rexists return
  stop
endif
info "Config loading file=^cfgn"
set t:cfg cfgn
set actions "Monitor,Rec/PB,Stop,Cntrls,More,Exit"
if cfg.actions rexists set actions cfg.actions 
if gc.ACTION rexists then set gc.ACTION.items actions
! look for the APPLIST entry
set scenario "NONE"
if cfg.applist rexists then
  set scenarios "NONE,^cfg.applist.getlist"
else
  set scenarios "NULL"
endif
set scene "NONE"
if cfg.server_defaults rexists 
  if cfg.server_defaults.scene rexists then set scene cfg.server_defaults.scene
  if cfg.server_defaults.mode rexists then set smode cfg.server_defaults.mode
  if cfg.server_defaults.cron rexists then set cron cfg.server_defaults.cron
  if cfg.server_defaults.logint rexists then set logint cfg.server_defaults.logint
  if cfg.server_defaults.fan rexists then 
    set l:fan ^cfg.server_defaults.fan
    sendto "MAIN" "FAN" fan 
  endif
  if cfg.server_defaults.gps rexists then 
    sendto "MAIN" "GPS" "RELOAD" 
  endif
endif
if gc.SCENE rexists then 
  set gc.SCENE.items scenarios
  set gc.SCENE.value scene
endif
set gps2sys "GPS2SYS_WIN"
if "/var/etc/chrony.conf" fexists then
  iceutil "GREP" "manual" "/var/etc/chrony.conf" ans
  if "#" nsubs ans set gps2sys "GPS2CHRONY"
endif
return

procedure pingTemp 
if "/sys/class/thermal/thermal_zone0/temp" fexists
  file open/t tf "/sys/class/thermal/thermal_zone0/temp"
  file read tf l:temp
  file close tf 
  set gc.TEMP.v temp/1000
endif
return

procedure pingIPM
if /iceos then
  os/stderr=stderr/stdout=stdout ipmice status 
  if "Pwr=" subs stdout then sedit stdout f:gc.POWER.v  "TRIM" "Pwr=" " "
  if "Cnt=" subs stdout then sedit stdout l:gc.UPTIME.v "TRIM" "Cnt=" " "
endif
return

procedure statusIPM
do l:ii 0 4
  if "/dev/ttyACM^ii" aexists then
    os/stdout=stdout ipmice status ^ii
    info stdout
  endif
enddo
return

procedure pingGPS s:mode
if /iceos isfalse return
if mode eqs "STAT" then
  set tflg "NONE"
elseif gc.GPS.v eqss "TRACK" 
  set tflg "^{gps2sys}=10"
elseif gc.GPS.v eqss "DUMP" 
  set tflg "GPSDFN=^gpsdfn"
elseif mode eqs "SETTOGPS"
  set tflg "^{gps2sys}=0"
  set this.timer(0) 1
else
  set tflg "NONE"
endif
if mode eqs "CHECKUP" then
  set guptime guptime+1
  set l:gmod 15
  if gc.GPS.v eqss "TRACK" or gc.GPS.v eqss "DUMP" then sedit gc.GPS.v l:gmod "TRIM" "@" ""
  if calc(guptime,gmod,mod) neq 0 return
endif
if cfg.server_defaults.gps eqss "IOM" then
  if mode eqs "RELOAD" 
    call reloadGPS
  endif
  os/stderr=stderr/stdout=gstat ipmice gstatus - GPS=^cfg.server_defaults.gps,^tflg
  if gstat neqss "GPS NoS" then
    sedit gstat stmp "TRIM" "" "GPS NoS"
    if "GPS to" subs stmp sedit stmp stmp "TRIM" "GPS to" "" "PREPEND" "GPS to"
    info stmp
    sedit gstat gstat "TRIM" "GPS NoS" "" "PREPEND" "GPS NoS"
  endif
  if mode eqs "CHECKUP" then
    if "NoS=0" subs gstat or "Stage=0" subs gstat then
      if guptime gt 600 then
        pause 1 ! double check status
        os/stderr=stderr/stdout=gstat ipmice gstatus - GPS=^cfg.server_defaults.gps,^tflg
        if "NoS=0" subs gstat or "Stage=0" subs gstat then
          warn "Auto reload of GPS unit with bad status after 5 min" 
          call reloadGPS
          return
        endif
      else
	return
      endif
    elseif gc.GPS.v neqss "TRACK" and gc.GPS.v neqss "DUMP" then
      return	! just a checkup 
    endif
  endif
else
  timex now MJS=gtime
  warn "GPS not configured. Using CPU time MJS=^gtime"
  set gstat "NoGPS MJS=^gtime"
endif
sedit gstat d:time "TRIM" "MJS=" " "
if mode eqs "TIME"
  timex time
elseif gstat eqss "GPS " then
  info gstat
  sedit gstat gstat "SUB" "\n" "" 
  if "/var/log/icegps.log" fexists then
    file open/t/a glog "/var/log/icegps.log"
    file write glog gstat
    file close glog
  endif
  sedit gstat gstat "SUB" "GPS" "" "STRIM" "GSUB" " " "," 
  table gps create {^gstat}
  table gps save "/tmp/icegps.tbl"
  set nodei.gps gps
endif
return

procedure reloadGPS
  set params "GPS=^cfg.server_defaults.gps"
  if cfg.server_defaults.gpsopts rexists sedit params params "APPEND" ",GPSOPTS=^cfg.server_defaults.gpsopts"
  os/stderr=gstat ipmice uloadg - ^params
  pause 2 ! wait for it
  os touch /var/log/icegps.log
  set guptime 0
return

procedure statNVM
  os nvme list 
return

procedure statNTP
if /var/etc/chrony.conf nfexists and /etc/chrony.conf nfexists then
  warn "No chrony configuration file=/var/etc/chrony.conf or /etc/chrony.conf found"
  set noNTP "TRUE"
else
  os chronyc tracking
  rem/warn=n noNTP 
endif
call checkPPS
return

procedure checkPPS
do l:nn 1 npc
  set pic "PIC^{nn}AUTO"
  set port "MODULE1"
  picd get pic "NTPOFF" val /port=^port
  calc f:val val 1e3 *
  info "NTP offset=^val mSec on card=^pic port=^port"
enddo 
remove pic
return

procedure updateNode
set t:tasks {}
files/f=ramfiles * tmp env.ramaux
foreach name indf ramfiles
  sedit name task "ROOT" 
  if name nfexists continue
  keyword name "GET" "PORT" port "RFFREQ" rffreq "ARCHIVE" afn
  if port isnull continue
  if afn isnull then set afn "None"
  status name RATE=rate
  sedit rate*1e-6 rfbw "NFORM" (f5.3)
  if rffreq nisnull sedit rffreq rffreq "NFORM" (f6.1)
  if rffreq isnull set rffreq "?"
  set tasks.^task "Port=^port Freq=^rffreq BW=^rfbw AFN=^afn
endfor
erase ramfiles
set nodei.application "Scene=^gc.SCENE.v State=^gc.ACTION.v Port=^gc.SPORT.v"
set nodei.tasks tasks
set nodei.tostr "App=^gc.SCENE.v DevIces=^nodei.devices.getSize() Tasks=^nodei.tasks.getSize() NoS=^gps.nos"
sendto hubv "FILES" "REREAD"
return

procedure redoinit
  info "Checking for XCVR/IOC availability ..."
  call statusIPM
  info "Checking for PIC availability ..."
  remove/global hwalias
  pic get pic# active stat /flags=timeout=30
  info "Performing PIC autoconfig ..."
  set tflg ""
  if cfg.server_defaults.autoflags rexists then 
    set tflg cfg.server_defaults.autoflags
  endif
  if cfg.server_defaults.https rexists then 
    invoke nxm.ice.net.HServer.setHTTPS(^cfg.server_defaults.https)
  endif
  iceauto/aflags=tflg
  pic clean /batch
  files/e snap* mlog
  sendto "MAIN" "PICT" "RESET" 
  sendto "MAIN" "MODE" "RUNINIT" 
return
