!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  ICEMAKE - Utility MAKE macro for ICE-PIC DSP cards
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro u:func u:p2 u:p3 

global/readall 
fname icefat fat ,,, ice
import ICEROOT iceroot
import NMROOT  nmroot

if func eqs "" or func eqs "ALL" 
  buildopt/mfn=nxm.ice.mcr.buildopt.mm ice

elseif func eqs "RELEASE" 
  icemake "ALLCMP"
  icemake "ALLOBF"
  icemake "ALLCRC"
  if /ncore then
    buildopt/mfn=nxm.ice.mcr.buildopt.mm/ncore ice
  else
    buildopt/mfn=nxm.ice.mcr.buildopt.mm ice 
  endif
  os ^iceroot/test/build.lnx
  os ^iceroot/jre/icebld.sh all

elseif func eqs "SYS" 
  bld/keep/verbose NTerminal lib sys
  bld/keep/verbose Native lib sys
  bld/keep/verbose Fft libm sys

elseif func eqs "L" or func eqs "LIB"
  bld/keep DevIce lib ice
  bld/keep MDevIce lib ice
  bld/keep Archiver lib ice
  bld/keep NetIO lib ice
  bld/keep FileIO lib ice
  bld/keep Core lib ice
  bld/keep CoreNative lib ice

elseif func eqs "CORELINKS" 
  set option p2
  say "--> Building ICE Core links for option tree ^option <--"
  sedit option p2 "LOCASE"
  if env.ostype eqs "UNIX" then ! create links for CORE library linking
    set OPTROOT "^NMROOT/nxm/^p2"
    set suffix "^{reg.shell.getLibrarySuffix}^{reg.shell.getLibraryExt}"
    os ln -sfn ^ICEROOT/lib/DevIce^suffix ^OPTROOT/core/libAll$ICE^suffix
    os ln -sfn ^ICEROOT/inc ^OPTROOT/inc/cores
  else
    say "Core links only support under UNIX at this time"
  endif

elseif func eqs "FCSYM"
  res name p2
  status name sz=nn
  calc sample nn*2-1
  loop sample-nn ii
    res name(nn+ii) name(nn-ii)
  endloop
  status name

elseif func eqs "FILTER"
  fname bname dat ^p2 prm ice
  find zcode.imp name
  iceutil "FILT2M" name bname
  status/key bname
  plot bname
  fft bname filterfft 1 4k
  plot filterfft ,,, lo

elseif func eqs "TAPS"
  fname name taps ^p2 taps ice
  fname bname dat ^p2 prm ice
  convert name t2b bname "I8"
  headermod bname comment="Filter Coefficients"
  status/k bname

elseif func eqs "CXTAPS"
  fname name taps ^p2 taps ice
  fname bname dat ^p2 prm ice
  convert name t2b bname "F8|F8"
  headermod bname type=1000 form=CF comment="Filter Coefficients"
  statistics bname sum=fsum
  calc fsum fsum mag
  fcalc bname bname conj fsum /
  status/k bname
  fname bnamei dat ^{p2}I prm ice
  fcalc bnamei bname conj 

elseif func eqs "GAP"
  iceutil gerber gerber.usr default.gap

elseif func eqss "GTUN" or func eqss "GTBANK" then
  homepath icefat
  %testcard/nosig/noint/nolink/noxlink/noext/gtun ^p2 1
  fname bname dat ^func prm ice
  noop testout bname
  res nn 2
  if func eqs "GTUN3" res nn 256
  if func eqs "GTUN5" res nn 0
  if func eqs "GTUN6" res nn 0
  if func eqs "GTBANK" res nn 0
  key/scope=main bname set s:skip ^nn
  if func eqs "GTUN10" or func eqs "GTUN11" or func eqss "GTBANK1" key/scope=main bname put s:mask "0X000F000F"
  homepath restore

elseif func eqs "ALLCRC"
 file open/t/n hf nxm.ice.hlp.crcs.hlp
 file write hf "~Main CRCs - current CRCs for non-volatile EEProm memory on ICE cards
 call cardcrcs "PIC5" "SS,DD,HH,SH,DH,DS"
 call cardcrcs "PIC6" "SS,DD,HH,SH,DH,HHTQ,RRN"
 call cardcrcs "POD6" "DD,HH,RRN"
 call cardcrcs "PIC7" "HH,DD,SS,DH"
 call cardcrcs "PIC8" "HH,DD,SS,HHX,HHMT,HHWG"
 call cardcrcs "PAC8" "HHX,HHMT"
 call cardcrcs "NPAC8" "HHX,RRN,HHWG"
 call cardcrcs "SPAC8" "HHX,HHMT,HHWG"
 file close hf

elseif func eqs "ALLIOMCRC"
 call mkiomcrcs "a2dm20_hh,a2dm20x_hh,a2dm20x_hhpf" 
 call mkiomcrcs "sntr2,sntr4_192full,sntr4,sntr5p4,sntr5p5,sntr6lr,sntr6,sntr7di,sntr7lrm,sntr7lr,sntr7" 
 call mkiomcrcs "tgsdds,tgsddsr2,tgsddsr2lgpkt,tgsddsr3,tgsddsr3di,tgsddsr3lgpkt,tgvita"
 call mkiomcrcs "flzrxdr1,flzrxdr1_ext,flzrxdr1_osc800,flzrxdr1_osc1600"

elseif func eqs "CRCS"
  files/f nxm.ice.dat.ice^{p2}_*
  foreach file infile files
    key file get "CRC" crc
    say "File ^file CRC=^crc
  endfor 

elseif func eqs "ALLCMP"
  files/f nxm.ice.dat.ice*
  foreach file infile files
    key file get "COMMENT" comment
    if "FPGA Load" nsubs comment continue ! not an FPGA file
    key file get "ICSZ" icsz
    say "File ^file COM=^comment CMP=^icsz"
    if /inv istrue then
      if icsz eqs "NULL" continue ! already uncompressed
      iceutil "UNCOMPRESS" file testci
      info "UnCompressed ^file from ^file(file).datasize to ^file(testci).datasize"
    else
      if icsz neqs "NULL" continue ! already compressed
      iceutil "COMPRESS" file testci
      info "Compressed ^file from ^file(file).datasize to ^file(testci).datasize"
    endif
    erase file
    noop testci file
  endfor 

elseif func eqs "CHKDAT"
  files/f nxm.ice.dat.ice*
  foreach file infile files
    sedit file filen "TAIL"
    sedit p2 fileb "SUBS" "#" "^filen"
    if fileb nfexists then
    elseif file feq/d fileb then
      ! say "File ^file = SAME"
    else
      say "File ^file = DIFF"
    endif
  endfor 

elseif func eqs "SLRMAP"
  if p2 eqs "" then set p2 "fplan"
  if p3 eqs "" then set p3 "register_map.h"
  say "Saving to file=^p2 from file=^p3"
  file open/n out ^p2{form=sl}
  foreach line intf p3
    if line neqss "{" continue
    sedit line line trim "{" "}"
    sedit line l:addr parse 1
    sedit line l:regx parse 2 
    sedit line l:mask parse 3
    file write out (addr*64K)+(regx*256)+mask
  endfor
  file close out

elseif func eqs "PART"
  if "FF1738" subs p2 then
    set l:rows 42
  elseif "FF1136" subs p2 or  "FF1152" subs p2  or  "FF1156" subs p2 then
    set l:rows 34
  elseif  "FF901" subs p2 then
    set l:rows 30
  elseif  "FF784" subs p2 then
    set l:rows 28
  elseif  "FF665" subs p2 or "FF672" subs p2 or "FF668" subs p2 or "FG676" subs p2 or "FF676" subs p2 then
    set l:rows 26
  elseif  "FGG484" subs p2 then
    set l:rows 22
  elseif  "CSG324" subs p2 then
    set l:rows 18
  elseif  "CSG225" subs p2 then
    set l:rows 15
  elseif  "CPG196" subs p2 then
    set l:rows 14
  else
    error "Bad part name ^p2"
  endif
  if p2 eqss "XC2" then
    icemake "V2LST" /midas/opt/icexxx/code/cad/^p2
  elseif p2 eqss "XC4" then
    icemake "V4LST" /midas/opt/icexxx/code/cad/^p2
  elseif p2 eqss "XC5" then
    icemake "V5LST" /midas/opt/icexxx/code/cad/^p2
  elseif p2 eqss "XC6" then
    icemake "V6LST" /midas/opt/icexxx/code/cad/^p2
  elseif p2 eqss "XC7" then
    icemake "V7LST" /midas/opt/icexxx/code/cad/^p2
  else
    error "Bad part name ^p2"
  endif
  iceutil/rows=rows/pins=rows**2 "LST2CSP" /midas/opt/icexxx/code/cad/^p2 

elseif func eqs "V2LST"
  file open/t/n out ^{p2}.lst
  foreach line intf ^{p2}.pins
    sedit line pin parse 3
    sedit line text parse 2
    file write out "^pin=^text"
  endfor
  file close out

elseif func eqs "V4LST"
  file open/t/n out ^{p2}.lst
  calc l:lineno 0
  foreach line intf ^{p2}.txt
    calc l:lineno lineno+1
    if lineno lt 6 continue
    sedit line pin parse 4
    sedit line text parse 6
    file write out "^pin=^text"
  endfor
  file close out

elseif func eqs "V5LST" or func eqs "V6LST" or func eqs "V7LST"
  set l:col 3
  if "XC6S" subs p2 then set l:col 4
  if "XC7"  subs p2 then set l:col 2
  file open/t/n out ^{p2}.lst
  calc l:lineno 0
  foreach line intf ^{p2}.pkg
    if "PIN" eqss line continue
    if "DEVICE" eqss line continue
    if "NOPAD" subs line continue
    if "TOTAL" subs line continue
    sedit line pin parse 1
    sedit line text parse ^col
    file write out "^pin=^text"
  endfor
  file close out

elseif func eqs "UDIMM"
  file open/t/n out ^{p2}.lst
  foreach line intf ^{p2}.pins
    sedit line pin parse 1
    sedit line text parse 2
    file write out "^pin=^text"
  endfor
  file close out
  iceutil/rows=204/cols=1/reorder "LST2CSP" ^p2 

elseif func eqs "XDC" then
  iceutil ucf2xdc p2 p3

elseif "ICE" subs p2 and p2 neqss "/" then
  error "Loose the ICE prefix"

elseif "ICE" subs p3 then
  error "Loose the ICE prefix"

elseif func eqs "SHARC"
  fname name xfer xcode ,, ice
  fname bname dat ICE^p2 prm ice
  convert ^{name}.ldr t2b name "I6"
  headermod name form=6b xs=1 xd=1 xu=0 comm="SHARC Boot Loader Code Segments"
  noop name bname
  status/key bname

elseif func eqs "IOC" or func eqs "MOD" then
  fname bname dat ICE^p2 prm ice
  fname name xfer ycode ttf ice
  iceutil "TTF2M" name bname
  status/key bname

elseif func eqs "RBF" then
  fname name xfer ^p2 rbf ice
  fname bname dat ICE^p2 prm ice
  iceutil "RBF2M" name bname ^p3
  fname bname dat ICE^p2 ,, ice
  picd/stat=crc checkfile dummy ^bname
  calc/hex/str crc crc
  keyword/scope=main/warn=n bname set "CRC" crc
  status/key bname

elseif func eqs "ALLIOC" then
  ask s:card "Card name [PIC2]: "
  res bname "T1,T2,IIR,IIX,IOX,II,IO,OI,OO"
  if "4" subs card res bname "^bname,IIS,IOS,OIS"
  if card eqs "PIC4" res bname "^bname,IISN,IINS,IIXS,IINX,OOW"
  foreach name inlist bname
    res name ^{card}_^{name}
    ask answer "Process file ^name (Y/N) [Y]:"
    if answer eqss "Y" then
      pic make ioc ^name
      say "Finished ^name of ^bname"
    endif
  endfor

elseif func eqs "CHKIOC" then
  ask q:card "Card name [pic2]: "
  res bname "t1,t2,iir,iix,iox,ii,io,oi,oo"
  if "4" subs card set bname "^bname,iis"
  foreach name inlist bname
    res name1 nxm.ice.dat.ice^{card}_^{name}
    foreach name2 inlist bname
      res name2 nxm.ice.dat.ice^{card}_^{name2}
      if name1 feq/d name2 say "IOC File ^name1 == ^name2"
    endfor
  endfor

elseif func eqs "BITS" then
  sedit p2 p2 "LOCASE"
  if p3 eqs "" res p3 p2
  sedit p3 p3 "LOCASE"
  fname bname dat ice^p3 prm ice
  if "/" subs p2 then
   res name ^{p2}.bit
  else
   fname name code/soc/^p2 top bit ice
  endif 
  if p3 eqss "PIC5" then
    set flash 2M
  elseif p3 eqss "PIC6" or p3 eqss "POD6" then
    set flash 4M
  else
    set flash -1
  endif
  say "Bit file = ^name"
  iceutil "BIT2M" name bname /flash=flash
  status/key bname

elseif func eqs "ALLPPC" then
  foreach name inlist "pic5,pic6"
    icemake ppc ^name
  endfor
  foreach name inlist "def,usd,csd1,csd2,isd,tsd,gsd,dlt"
    icemake ppc dtdmppc_^name
  endfor

elseif func eqs "JVM" then
  set name p2
  sedit name loname "LOCASE"
  bld Ice^name lib ice
  icejvm nxm.ice.lib.Ice^name nxm.ice.dat.ice^loname

elseif func eqs "ALLJVM" then
  bld IceHW lib ice
  bld IceJVM lib ice
  bld IceJVMFat lib ice
  bld IcePM lib ice
  icejvm/boot nxm.ice.lib.IceJVMFat nxm.ice.dat.icejvmfat
  icejvm/boot nxm.ice.lib.IceIOM nxm.ice.dat.iceiomb
  if "^iceroot/code/soc/corez" dexists then
    fname file code/soc/lib jvmlut hx ice
    iceutil m2xbr nxm.ice.dat.jvmcodes file /banks=1 /prefix=inst /special
    fname file code/soc/lib jvmlut mif ice
    iceutil m2mif nxm.ice.dat.jvmcodes file /banks=1 /prefix=inst /special
  endif
  foreach name inlist "PIC9,PIC8,PIC7,K8M,K8P,V6M,S6M,S6MX,IOM,GPS,NIO,NVME"
    sedit name loname "LOCASE"
    bld Ice^name lib ice
    icejvm nxm.ice.lib.Ice^name nxm.ice.dat.ice^loname
  endfor

elseif func eqs "ALLOBF" then
  foreach name inlist "jvm,tfdd,qtfd,dds,cic,res,fir,fft,bot,gsd,r2c,ais,emt,pkt"
    set fname "^{name}engine.v"
    icejvco "nxm.ice.code.soc.corez.^fname" "nxm.ice.code.soc.cores.^fname" v
  endfor
  foreach name inlist "corecomps.sv"
    icejvco "nxm.ice.code.soc.corez.^name" "nxm.ice.code.soc.cores.^name" v
  endfor
  foreach name inlist "icekam.c,icekbfs.c"
    icejvco "nxm.ice.drv.lnx.^{name}" "nxm.ice.drv.lnx.^{name}x" c
  endfor

elseif func eqs "PPC" then
  sedit p3 p3 "LOCASE"
  fname easm code/ppc easm csh ice
  if p2 eqs "PIC5" then
    if p3 eqs "" then res p3 "alg_none"
    os ^easm ^p3 PIC5 MC
  elseif p2 eqs "PIC6" then
    if p3 eqs "" then res p3 "alg_none"
    os ^easm ^p3 PIC6 MC
  elseif "PPC" nsubs p2 then
    error "Where's the PPC ?"
    return
  elseif p2 eqs "PEPPC" then
    if p3 eqs "" then res p3 "alg_pe"
    os ^easm ^p3 PIC6 PE
  elseif p2 eqss "DTDMPPC" then
    sedit p2 suf "TRIM" "DTDMPPC_" "" "LOCASE"
    if p3 eqs "" then res p3 "alg_^suf"
    os ^easm ^p3 DTDM PM
  else
    error "Unsupport PPC code prefix in ^p2"
  endif
  if p2 eqss "ICE" sedit p2 p2 trim "ICE"
  fname bname dat ICE^p2 prm ice
  fname name code/ppc xcode elf ice
  iceutil "ELF2M" name bname
  say "File=^bname Size=^file(bname).size"

elseif func eqs "JVM" then
  sedit p2 p2 "LOCASE"
  sedit p3 p3 "LOCASE"
  if p3 eqs "" then res p3 "def"
  fname bname dat ice^{p2}_jvm_^p3 prm ice
  icejvm nxm.ice.lib.IcePM bname
  status/key bname

elseif func eqs "TWIDDLE" then
  res len 4096
  waveform sinlut form=sl elem=len freq=1/len amp=2147483648 phase=0  /dp
  fname file code/soc/lib twiddle hv ice
  iceutil m2vbr sinlut file
  fname file code/soc/lib twiddle hx ice
  iceutil m2xbr sinlut file /banks=2 /prefix=sinlut /enum

elseif func eqs "WINDOWS" then
  res len 4096
  window hann window{form=sl} len /scale=2147483648 
  fname file code/soc/lib window hv ice
  iceutil m2vbr window file
  fname file code/soc/lib window hx ice
  iceutil m2xbr window file /banks=2 /prefix=window /enum

elseif func eqs "SINLUT" then
  res len 4096
  waveform sinlut form=si elem=len freq=.25/len amp=32768 phase=.125/len /dp
  fname file code/soc/lib sinlut hv ice
  iceutil m2vbr sinlut file
  fname file code/soc/lib sinlut hx ice
  iceutil m2xbr sinlut file /banks=4 /enum2

  res len 1024
  waveform sinlut form=si elem=len freq=.25/len amp=32768 phase=.0/len /dp
  fname file code/soc/lib sinlutx hv ice
  iceutil m2vbr sinlut file /ram=ramx
  fname file code/soc/lib sinlutx hx ice
  iceutil m2xbr sinlut file /banks=1 /prefix=sinlutx /enum

  fcalc <sinlut(1:) <sinlut - >sinlutd{form=si}
  set file(sinlutd).data(1023) 0
  fname file code/soc/lib sinluty hv ice
  iceutil m2vbr sinlutd file /ram=ramy
  fname file code/soc/lib sinluty hx ice
  iceutil m2xbr sinlutd file /banks=1 /prefix=sinluty /enum

elseif func eqs "ALLLUT" then
  foreach name inlist "AM,PM,FM"
    iceutil lut ^name nxm.ice.dat.LUT_^{name}.prm
  endfor

elseif func eqs "FUNCLUT" then
  res vs ""
  res dx ""
  res dy ""
  res da ""
  switch "SIZE" l:size get 64 64
  if /trig then
    set scale 0.25/size
  elseif /inva then
    set scale 2/size
  elseif /invb then
    set scale (1/16)/size
  elseif /xy then
    calc l:size2d size sqrt
    set scale 1/size2d
  else
    set scale 1/size
  endif
  do ii 0 size-1
    if calc(ii,16,mod) eq 0 then
      sedit vs vs "APPEND" " "
      sedit dx dx "APPEND" " "
      sedit dy dy "APPEND" " "
      sedit da da "APPEND" " "
    endif
    if /inva or /invb then
      calc l:aa 1 ii*scale / 64k * round
      calc l:bb 1 (ii+1)*scale / 64k * round aa -
    elseif /xy then
      calc l:iix ii size2d mod
      calc l:iiy ii size2d / 
      calc l:aa iix*scale iiy*scale ^p2 64k * round
      calc l:bb (iix+1)*scale (iiy+0.0)*scale ^p2 (iix+0)*scale (iiy+0.0)*scale ^p2 - 64k * round
      calc l:cc (iix+0.0)*scale (iiy+1)*scale ^p2 (iix+0.0)*scale (iiy+0)*scale ^p2 - 64k * round
      sedit dy dy "APPEND" "^cc,"
      sedit da da "APPEND" "36'h"
      calc/hex das cc/4 round 4095 min
      sedit das das range 7 9
      sedit da da "APPEND" "^das"
      calc/hex das (16k+bb)/4 round 4095 min
      sedit das das range 7 9
      sedit da da "APPEND" "^das"
      calc/hex das aa/4 round 4095 min 
      sedit das das range 7 9
      sedit da da "APPEND" "^das,"
    else
      calc l:aa ii*scale ^p2 64k * round
      calc l:bb (ii+1)*scale ^p2 64k * round aa -
    endif
!    say "Ans ^ii ^aa ^bb
    sedit vs vs "APPEND" "^aa,"
    sedit dx dx "APPEND" "^bb,"
  enddo
  say "LUT for func=^p2"
  res vs
  res dx
  res dy
  res da

elseif func eqs "QTFIRS" then
  firkais nxm.ice.dat.qtfir_2.prm{form=sf} LOW .390 0 0 1 100 64 
  firkais nxm.ice.dat.qtfir_4.prm{form=sf} LOW .220 0 0 1 100 64 
  firkais nxm.ice.dat.qtfir_8.prm{form=sf} LOW .115 0 0 1 100 64 
  spectra nxm.ice.dat.qtfir_2 qtfir_2s 4k
  spectra nxm.ice.dat.qtfir_4 qtfir_4s 4k
  spectra nxm.ice.dat.qtfir_8 qtfir_8s 4k
  fcalc qtfir_2s qtfir_2s 64g *
  fcalc qtfir_4s qtfir_4s 64g *
  fcalc qtfir_8s qtfir_8s 64g *
  plot/db qtfir_2s|qtfir_4s|qtfir_8s

else
  warn "Unknown make option: ^func"
endif

endmacro

procedure cardcrcs s:card s:siglist
 file write hf ""
 file write hf "^card:"
 foreach sig inlist siglist
   picd checkfile dummy ice^{card}_^{sig}
   set crcs file(nxm.ice.dat.ice^{card}_^sig).getkeyword(CRC)
   file write hf "LoadFlash File=ICE^{card}_^sig CRC=^crcs"
   ! file write hf "LoadFlash Card=^card Sig=^sig CRC=^crcs"
 endfor
return

procedure mkiomcrcs s:modlist 
 foreach sig inlist modlist
   picd/stat=crc checkfile dummy ice^{sig}
   calc/hex/str crc crc
   keyword/scope=main/warn=n nxm.ice.dat.ice^sig set "CRC" crc
 endfor
return
