/* Rumel library routine defines */
#ifndef _RUMLIB_H
#define _RUMLIB_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

static int_4 pic_setup_a2dr9 (PICSTRUCT *p, int_4 mport, int_4 dir, int_4 bits, int_4 rate, int_4 gain, int_4 flags);
static int_4 pic_setup_a2dr9_gain(PICSTRUCT *p,int_4 mport, int_4 gain);
static int_4 pic_setup_a2dr10 (PICSTRUCT *p, int_4 mport, int_4 dir, int_4 bits, int_4 rate, int_4 gain, int_4 flags);
static int_4 pic_setup_a2dr11 (PICSTRUCT *p, int_4 mport, int_4 dir, int_4 bits, int_4 rate, int_4 gain, int_4 flags);
static int_4 pic_setup_a2dr13 (PICSTRUCT *p, int_4 mport, int_4 dir, int_4 bits, int_4 rate, int_4 gain, int_4 flags);
static int_4 pic_get_a2dr13_gain (PICSTRUCT *p, int_4 mport);
static int_4 pic_setup_a2dr13_gain(PICSTRUCT *p,int_4 mport, int_4 gain); 

static int_4 pic_setup_d2ar9 (PICSTRUCT *p, int_4 mport, int_4 dir, int_4 bits, int_4 rate, int_4 gain, int_4 flags);
static int_4 pic_setup_d2a   (PICSTRUCT *p, int_4 mport, int_4 dir, int_4 bits, int_4 rate, int_4 gain, int_4 flags);
static int_4 pic_setup_d2awg (PICSTRUCT *p, int_4 mport, int_4 dir, int_4 bits, int_4 rate, int_4 gain, int_4 flags);
static int_4 d2awg_get_rfpwr(PICSTRUCT *p, int_4 mport);
static int_4 d2awg_set_attn(PICSTRUCT *p, int_4 mport,int value);
static int_4 d2awg_get_attn (PICSTRUCT *p,int_4 mport);
static int_4 d2awg_set_tcxo(PICSTRUCT *p, int_4 mport,real_8 value);
static real_8 d2awg_get_freq (PICSTRUCT *p,int_4 mport);

static int_4 pic_setup_flzr (PICSTRUCT *p, int_4 mport, int_4 dir, int_4 rate, int_4 gain);
static int_4 pic_setup_fpqc(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain);
static int_4 pic_setup_fpdp(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate,int_4 gain); 
static int_4 pic_setup_udp(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate,int_4 gain);
static int_4 pic_setup_sdds(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate,int_4 bits);
static int_4 pic_setup_sonet(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate,int_4 gain);
static int_4 pic_init_tgsdds(PICSTRUCT *p);
static int_4 pic_setup_tgsdds(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 bits, int_4 ports);
static int_4 vita_join_leave_group (PICSTRUCT *p, int_4 mport, int_4 joinleave, int_u4 groupaddr, int_u2 running);
static int_4 pic_init_tgvita(PICSTRUCT *p);
static int_4 pic_setup_tgvita(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 bits, int_4 ports);
static int_4 pic_config_tgvita(PICSTRUCT *p, int_4 mport, int_u4 streamid,int_u4 streammask,
		int_u4 oui, int_u4 ouimask, int_u4 iccpcc,  int_u4 iccpccmask, int_u4 pktsz);
static int_4 pic_setup_d2pse(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain);
static int_4 pic_setup_sonetr2(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain);
static int_4 pic_setup_sonetr4 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain);
static int_4 pic_setup_sonetr5 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain);
static int_4 pic_setup_sonetr6 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain); 
static int_4 pic_setup_sonetr7 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain); 
static int_4 pic_setup_ngcfiber (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain);
static int_4 pic_setup_cdr2d (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain);
static int_4 pic_setup_esxdr1 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain, int_4 bits);
static int_4 pic_setup_uflz(PICSTRUCT *p, int_4 mport, int_4 dir,int_4 rate, int_4 gain) ;

static int_4 set_module_HW_IP_addr (PICSTRUCT *p, int_4 mport, int_u4 ipaddr, int_u2 vlan);
static int_4 pic_enable_module (PICSTRUCT *p, int_4 mport,int_4 dis_enable); 
static int_4 sdds_set_active_vlan(PICSTRUCT *p,int_4 mport, int_u2 vlan);
static int_4 sdds_join_leave_group (PICSTRUCT *p, int_4 mport, int_4 dir, int_u4 ipaddr, int_u2 running);
static int_4 sdds_enable (PICSTRUCT *p, int_4 mport, int_4 enable);
static int_4 pic_module_dump (PICSTRUCT *p, int_4 mport, int_4 flag);
static int_4 sdds_vlan (PICSTRUCT *p, int_4 mport);
static int_u4 calc_synthetic_clkbits (int_4 fref, int_u4 freq, int_u4 *actual);
static int_u4 convert_ip_addr2 (char *flgname, char *flgname2, char *config);
static int_u4 convert_ip_addr (char *flgname, char *config);
static int_u4 convert_ip_port (char *flgname, char *config);
static int_4 detect_rumel_mods (PICSTRUCT *p);
int_4 pic_set_sddstxtcoffset(PICSTRUCT *p, int_4 mport, int_8 tcoffset);
static int_4 pic_setkey_module(PICSTRUCT *p, int_4 mport, int_u4 addr, int_u4 value);
static int_4 pic_getkey_module(PICSTRUCT *p, int_4 mport, int_u4 addr);
static int_4 module_join_leave_group (PICSTRUCT *p, int_4 mport, int_4 joinleave, int_u4 groupaddr, int_u2 running);

#endif /* _RUMLIB_H */
