#define A2DR13_NUM_PRG_BITS 32
#define A2DR13_MAX_RATE     250000000
#define A2DR13_REF_OSC      10000000


#define A2DR13_MAX_FREQ       250000000.0             /* AD9230 Maximum Sample Rate                            */
#define A2DR13_MIN_FREQ        40000000.0             /* AD9230 Minimum Sample Rate                            */              
#define A2DR13_MAXPLL_FREQ    250000000.0             /* Synthetic Clock Maximum PLL Output Rate               */
#define A2DR13_MINPLL_FREQ     40000000.0             /* Synthetic Clock Minimum PLL Output Rate               */
#define A2DR13_MIN_CKSKEW              -88            /* Clock Skew Minimum * 250pS                            */
#define A2DR13_MAX_CKSKEW               88            /* Clock Skew Maximum * 250pS                            */

/* Synthetic Clock Commands */
#define A2DR13_SETADR         0x0000                  /* Set Address To Be Written                             */
#define A2DR13_WRDAT          0x0040                  /* Write Data                                            */  


/* A2DR13 Configuration Regs */ 
#define RESETCFG_INDEX     0x00000000
#define R13GAINCFG_INDEX   0x10000000
#define SYSCFG_INDEX       0x20000000
#define SYNCLKLO_INDEX     0x30000000
#define SYNCLKHI_INDEX     0x40000000
#define A2DLO_INDEX        0x50000000
#define A2DHI_INDEX        0x60000000

/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_enable_a2dr13 (PICSTRUCT *p, int_4 mport,int_u4 dis_enable)
{   
   if (dis_enable == 0)
     pic_wmodreg(p,mport,0,RESETCFG_INDEX,A2DR13_NUM_PRG_BITS);         /* Set System Cfg Reg = 0, ICE LVDS Interface In Reset  */
   else
     pic_wmodreg(p,mport,0,RESETCFG_INDEX|0x0001,A2DR13_NUM_PRG_BITS);  /* Set System Cfg Reg = 1, ICE LVDS Interface Active    */
   
   return 0;    
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_get_a2dr13_gain(PICSTRUCT *p,int_4 mport)
{      
   int_u4 mbval;
   int gain;
                        
   pic_rmodreg(p,mport,0x0,&mbval,A2DR13_NUM_PRG_BITS);
   udelay(1000);

  /* Lower 16 Bits Holds Requested Gain Value Plus Constant of 11 */
  /* Upper 16 Bits Holds Current   Gain Value Plus Constant of 11 */
  /* Subtract Constant 11 To Yield Gain Values In dB              */
  
  /* printf("Gain Return Value = %08x\n",mbval); */                      

   gain = (mbval >> 16) & 0x0000FFFF;
   gain = gain - 11;                   /* Subtract 11 as Constant */     
   return(gain);
}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_a2dr13_gain(PICSTRUCT *p,int_4 mport,int_4 gain)
{      
   int_4 igain=gain,ogain;
   gain = max(-4,min(20,gain));
   gain = gain + 11;                     /* Add 11 as Constant */
   
   pic_wmodreg(p,mport,0x0,R13GAINCFG_INDEX | gain,A2DR13_NUM_PRG_BITS);
   udelay(2000);  /* finished by 256*(gain-4)/rate max=150e-6 */
 
   ogain = pic_get_a2dr13_gain(p,mport);
   if (ogain != igain) printf("Problem setting gain desired=%d actual=%d\n",igain,ogain);
 
   return(0);
}
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 a2dr13_wmodreg_si5326 (PICSTRUCT *p, int_4 mport,int_u4 value)
{   
   udelay(100);
   pic_wmodreg(p,mport,0,SYNCLKLO_INDEX | (value & 0x0000FF00),A2DR13_NUM_PRG_BITS);         /* Set Low  Register Value*/
   pic_wmodreg(p,mport,0,SYNCLKHI_INDEX | A2DR13_SETADR,A2DR13_NUM_PRG_BITS);                /* Set High Register Value*/
   udelay(100);
   pic_wmodreg(p,mport,0,SYNCLKLO_INDEX | ((value << 8) & 0x0000FF00),A2DR13_NUM_PRG_BITS);  /* Set Low  Register Value*/ 
   pic_wmodreg(p,mport,0,SYNCLKHI_INDEX | A2DR13_WRDAT,A2DR13_NUM_PRG_BITS);                 /* Set High Register Value*/
   if (value == 0x00008840) udelay(53000); /* ICAL can last up to 53msec */ 
   udelay(100);
   return 0;    
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 a2dr13_a2d_cfg (PICSTRUCT *p, int_4 mport,int_u4 value)
{   
   pic_wmodreg(p,mport,0,A2DLO_INDEX | (value  & 0x0000FFFF),A2DR13_NUM_PRG_BITS);           /* Set Low Register Value*/
   pic_wmodreg(p,mport,0,A2DHI_INDEX | ((value >> 16) & 0x000000FF),A2DR13_NUM_PRG_BITS);    /* Set Low Register Value*/ 
   return 0;    
} 
/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
int_4 pic_setup_a2dr13 (PICSTRUCT *p, int_4 mport, int_4 dir,int_4 bits,int_4 rate, int_4 gain,int_4 flags) 
{  Si5326_Reg_Obj Si5326_Reg; 
   int i,ii; 
   int_u4 reffreq =  A2DR13_REF_OSC; 
   int clksrc = 3;  /* 0-Syn Clk From On-Board Crystal  */
                    /* 1-Syn Clk From Ext Ref           */                    
                    /* 3-Clk From Ext Input--Default    */
   int_u4 a2dr13_cfg_bits =  SYSCFG_INDEX;          
      
   int_u4 n32s,n2hs,n2ls,n1hs,nc2ls,holdn32s,holdn2hs,holdn2ls,holdn1hs,holdnc2ls,f3nbint;
   float n2hsflt,n2lsflt,n32sflt,f3nbflt,n1flt,freqdif,perf3nbflt,rateper;
   float lowdif        = 1000000.0;  
   int_u4 ref_freq      = 10000000;                    /* Reference Frequency                                   */    
   int    negdiff       = FALSE;  
   int    holdnegdiff   = FALSE;
   int_4  clatval       = 0;
   int_1  holdclat      = 0; 
   int_4  a2dckskew     = 0;
   int_u4 dload_val     = 0;


   pic_wmodreg(p,mport,0,RESETCFG_INDEX,A2DR13_NUM_PRG_BITS);         /* Set System Cfg Reg = 0, ICE LVDS Interface In Reset  */

   if (bits == -16)
     {
       if (rate > (((int_u4)A2DR13_MAX_FREQ)/2))
         {
           printf("\n\tErr:Max Clock Rate For Complex Data Mode = %d MHz\n\n",((int_u4)A2DR13_MAX_FREQ)/2000000);
           return(-1);
         }    

       rate = rate * 2;
     }

   if ((i=findflag("MUXCLK",p->config)) >= 0)
    {
      if (p->config[i+6]!='=') ;
      else if (p->config[i+7]=='P') 
        {          
          clksrc = 0;
          if (findflag("PREFX",p->config) >= 0)
            {
              clksrc = 1;                            /* Set Clock Source To PLL With Ext Ref Frequency */

             /* Determine User Ref Frequency For PLL Clk Use   */
         /*   ii = findintflag("PREFX",p->config);   
              if (ii <= 1)
                printf("\nWARN: Must Specify PREFX Flag As PREFX=<freq>, Assuming %d MHz\n",A2DR9_REF_OSC/1000000); 
              else
                reffreq = ii;                
         */ 
            }      
        } 
      else if ((p->config[i+7]=='A') &&  (mport == 1));
      else if ((p->config[i+7]=='B') &&  (mport == 2));
      else if (p->config[i+7]=='N');                
      else 
        {
          printf("Illegal MUXCLK=%c flag - ignored\n",p->config[i+7]);
          printf("Allowable Clock Choices: MUXCLK=");
          if (mport != 2)  
            printf("A,N,");
          if (mport != 1)
            printf("B,N,");
          printf("P,or P w/flag PREFX\n");
        }            
   }
            
  /* Setup Clock Synthesizer */
  if (clksrc == 3)  /* Bypass to External Clock */
     {
       a2dr13_wmodreg_si5326(p,mport,0x00008880);  /* Put Device In Reset     */
       a2dr13_wmodreg_si5326(p,mport,0x00008800);  /* Remove Reset            */
       a2dr13_wmodreg_si5326(p,mport,0x0000157C);  /* ClkSel[1..0] Reg Active */
       a2dr13_wmodreg_si5326(p,mport,0x00000305);  /* Set Clk1 Input Select   */
       a2dr13_wmodreg_si5326(p,mport,0x00000016);  /* Set Bypass Bit          */
     }
  else              /* Normal Clock selection */
     {
       if ((rate < A2DR13_MINPLL_FREQ) || (rate > A2DR13_MAXPLL_FREQ))
         {
           printf("\n\nERR: A2DR13 PLL Freq Out of Range!!!\n");
           printf(" Valid Range = %d Mhz To %d MHz\n",
             (int_u4)(A2DR13_MINPLL_FREQ/1e6),(int_u4)(A2DR13_MAXPLL_FREQ/1e6));
           return(-1);
         }
       Si5326_Reg.debuglevel = -1;
       Si5326_Reg.fref   =  10000000.0;
       Si5326_Reg.dclk1  = ((real_8) rate);
       Si5326_Reg.dclk2  = ((real_8) rate);
       Si5326_Reg.dwght1 = 1.0;
       Si5326_Reg.dwght2 = 1.0;   
       ii = si5326_regcfg_init(&Si5326_Reg,SI5326_REGCFG_MT_A2DR13);
       ii = si5326_regcfg_bwsel(&Si5326_Reg,7);
       if (clksrc == 1)  /* Ext Ref PLL  */
         ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_1);
       else              /* On-Board Ref PLL  */
         ii = si5326_regcfg_clkin(&Si5326_Reg,SI5326_REGCFG_CLKIN_2);
       ii = si5326_regcfg_dividers(&Si5326_Reg);
       if (ii != 0)
         printf("A2DR13 Warning: A/D sample rate not possible. Using %f\n",
           Si5326_Reg.fclk2);
       si5326_regcfg_debug(&Si5326_Reg);
       for(i=0; i<Si5326_Reg.numreg; i++) 
         a2dr13_wmodreg_si5326(p,mport,Si5326_Reg.regval[i]);
     }
     
  /* Set A/D Config */    
   dload_val = 0x0018;   /* Address Reg 0x00, Value 0x18-MSB First        */
   a2dr13_a2d_cfg (p,mport,dload_val);
                      
   dload_val = 0x1603;   /* Address Reg 0x16, Data Valid Pos Edge         */
   a2dr13_a2d_cfg (p,mport,dload_val);          

   dload_val = 0x1401;   /* Address Reg 0x14, Value 0x01-SDR On, 2's Comp */
   a2dr13_a2d_cfg (p,mport,dload_val);
         
   dload_val = 0x1811;   /* Address Reg 0x18, Value 0x11-1Vp-p            */
   a2dr13_a2d_cfg (p,mport,dload_val);
                 
  /* ***FOR DEBUG Address Reg 0x0D, Value 04,Output Checker Board Pattern */
   dload_val = 0x0D00;   /* Set Value 0x0D00 For Normal Operation         */  
   a2dr13_a2d_cfg (p,mport,dload_val);
                       
  /* LVDS Power */
   dload_val = 0x00150F; /* Address Reg 0x15, 2mA LVDS Output             */
   a2dr13_a2d_cfg (p,mport,dload_val);

   /* Clock Invert */
   dload_val = 0x001603; /* Do Not Invert Clock                           */
   a2dr13_a2d_cfg (p,mport,dload_val);

   dload_val = 0x00FF01; /* Address Reg 0xFF, Value 01, Trans To Slave Reg*/
   a2dr13_a2d_cfg (p,mport,dload_val);

   if (bits ==  8);                                                                /* Enable  8 Bit Data               */ 
   else if (bits == 16)                                                            /* Enable 16 Bit Data               */
     a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0040;                                   
   else if (bits == -16)                                                           /* Enalble Complex 16 Bit Data      */ 
     a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0080;
   else
     {
       printf("\n\tErr: Supported Data Data Types Are 8, 16 And Complex 16 Bit Samples (SB,SI,CI)\n");
       printf("\tErr: All Other Data Types Not Supported\n\n");
       return(-1); 
     }  
                  
   if (findflag("INVMSB",p->config) >= 0)                                          /* Turn Off MSB Inversion In Module */
     a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0008;             
   if (findflag("MODDEBUG",p->config) >= 0)                                        /* Turn Off A/D Send Ramp           */
     a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0010;
   if (findflag("LSBP",p->config) >= 0)
     a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0020;
   if (findflag("ADGAINFORCE",p->config) >= 0)
     {
       if (findflag("ADWARNOFF",p->config) < 0)
         { 
           printf("\n\tWARN: Gain Forcing Disables A2D Overdrive Tracking Attempting To Attenuate High Power Signals!!!\n");
           printf("\tWARN: Users Risk PERMANENT Hardware Damage If The A2D Is Severely Overdriven\n");
           printf("\tWARN: Use The Flag 'ADWARNOFF' To Suppress Output Of This Message\n\n");   
         }
       a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0100;                                 /* Force Gain To User Supplied Value    */     
     }  
   if (findflag("ADGAINTRACK",p->config) >= 0)                                     /* Allow Gain To Track Signal Up/Down   */  
     a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0200;

   if (findflag("ADDELAY",p->config) < 0)                                          /* Turn Off Start Up Delay              */  
     a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0400;
     
   if (findflag("MTGO",p->config) >= 0)                                             /* Turn On Triggered Go                 */  
     a2dr13_cfg_bits = a2dr13_cfg_bits | 0x0800;

   udelay(100);
   pic_wmodreg(p,mport,0,a2dr13_cfg_bits|0x01,A2DR13_NUM_PRG_BITS);                /* Remove Global Reset, Set Config Bits */

  /* Set gain as final action before return */
   udelay(25000); /* required to allow proper setting of initial gain */
   pic_setup_a2dr13_gain(p,mport,gain);                                            /* Set Initial Gain                     */
   return(0);    
}
