/*****************************************************************************/
/*                                                                           */
/* part_root.h                                                               */
/*     This is the root part to every module. It contains the module ID,     */
/*     HW version, SW(or FW) version, total number of parts, etc.            */
/*     The system register is always the first register in the space.        */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_ROOT_H
#define _PART_ROOT_H

#include "part_common.h"

/* ROOT unique part identifier  */
enum ROOT_PART_ID {
  PTID_ROOT = FPGA_PTID_ROOT 
};

/* ROOT Pin control Masks */
enum ROOT_PIN_MASK {
  ROOT_PIN_NULL   = 0x00000000,  /* No PINS active           */
  ROOT_PIN_RESET  = 0x00000001,  /* Module Reset             */
  ROOT_PIN_ENABLE = 0x00000002   /* Enable / Disable         */
};

/* ROOT Register ID's */
enum ROOT_RG_ID {
  ROOT_RG_SYSREG   = 0x00,  /* RG=ModuleID                     */
  ROOT_RG_NUMPARTS = 0x01,  /* Total number of parts in module */
  ROOT_RG_HWVER    = 0x02,  /* Hardware version of module      */
  ROOT_RG_SWVER    = 0x03   /* Software / Firmware version     */
};

/* Structure mirroring the root part layout */
typedef struct {
  int8_t   modid;
  int8_t   hw_ver;
  int8_t   sw_ver;
  int8_t   numparts;
  int32_t  modcrc;
  int32_t  cfgclk;
  int32_t  cmdkey;
  uint32_t initchk;
} PT_ROOT_Obj;

/* Maximum number of Part handles contained in a root part */
#define PT_CFG_OBJ_MAX    256

/* Part handle contents and structure (32 bits)                              */
typedef struct {
  int8_t  part_subID;
  int16_t part_ID;
  int8_t  part_addr;
} Part_Config_Obj;

/* ROOT Register Masks */
enum ROOT_RG_MASK {
  ROOT_RGM_00_MODID = ((int32_t)0xFFFFFFFF) /* Unique Module identifier   */
};


/* External function declarations */
EXTERN_CDEFINE int32_t pt_c3core_lookuppartaddr(Part_Config_Obj *part_cfg, 
                         int32_t numparts, int32_t part_ID, int32_t sub_ID);


#endif  /* _PART_ROOT_H */
