/****************************************************************************/
/*                                                                          */
/*  part_root.c                                                             */
/*                                                                          */
/****************************************************************************/

#include "part_root.h" 

/* Gets configuration handle to a part from the root part */
/*   - Optionally, get Root part configuration (part_lb2dm3, part_d2rf, etc) */

int32_t pt_c3core_lookuppartaddr(Part_Config_Obj *part_cfg, int32_t numparts,
                                int32_t part_ID, int32_t sub_ID)
{
  int32_t i=0;
  Part_Config_Obj *partptr = part_cfg;

  /* Check if Module ID is requested */
  if(part_ID==0) return(0);

  i=0;
  for(i=0; i<numparts; ++i){
    if(partptr->part_ID==part_ID && partptr->part_subID==sub_ID) {
      return(part_cfg[i].part_addr);
    }
    ++partptr;
  }
  return(-1);
}


