/*****************************************************************************/
/*                                                                           */
/* part_dbgmem.h                                                            */
/*                                                                           */
/*****************************************************************************/
#ifndef _PART_DBGMEM_H
#define _PART_DBGMEM_H

#include "part_common.h"

struct dbgVector {
  int_u4 datI:16;
  int_u4 datQ:16;
  int_u4 dummy:32;
};

struct dbgVector16 {
  int_u4 dat0:16;
  int_u4 dat1:16;
  int_u4 dat2:16;
  int_u4 dat3:16;
};

struct dbgVector0 {
  int_u8 dat0:33;
  int_u4 dat1:17;
  int_u4 dat2:7;
  int_u4 dat3:7;
};

struct dbgVector1 {
  int_u8 dat0:33;
  int_u4 dat1:15;
  int_u4 dat2:16;
};

union dbgMem {
  int_u4 dbgWord[2];
  struct dbgVector dbgSig;
  struct dbgVector16 dbgSig16;
  struct dbgVector0 dbgSig0;
  struct dbgVector1 dbgSig1;
};

/*---------------------------------------------------------------------------*/
/* Public function prototypes from part_dbgmem.c */


#endif  /* _PART_DBGMEM_H */
