/****************************************************************************/
/*                                                                          */
/*   iomlib_a2dm20.h: includes for A2DM20 library interfaces                */
/*                                                                          */
/****************************************************************************/
#ifndef _IOMLIB_A2DM20_H
#define _IOMLIB_A2DM20_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>   
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "icelib.h" 
#include "../part/part_ad6688.h"

#define JESD_SOFT_PCS 1
#define MOD_ID       0
#define JVM_ID       1
#define PE43704_0_ID 2
#define PE43704_1_ID 3
#define LMX2582_ID   4
#define LTC6957_ID   5
#define OSC_ID       6
#define DBG_ID       7
#define CMD_BUF_ID   8
#define MCP3421_0_ID 9
#define MCP3421_1_ID 10
#define MCP3421_2_ID 11
#define ROUTE_ID     12
#define AD6688_ID    13
#define JESD_AVS_ID  14
#define JESD_CFG_ID  15
#define JESD_RST_ID  16
#define MEM_4_ID     17
#define MEM_5_ID     18
#define LMH6401_0_ID 19
#define CMD_ID       20
#define ADCLM_0_ID   21
#define ADCLM_1_ID   22
#define MONITOR_ID   23
#define MEM_0_ID     24
#define MEM_1_ID     25
#define MEM_2_ID     26
#define MEM_3_ID     27
#define MTGO_ID      28
#define LMH6401_1_ID 29
#define JESD_SYS_ID  30

#define NIOS_ID      100
/* #define AD6688_ID    101 */

#define PFUNC_PWR 0
#define PFUNC_PRD 1
#define PFUNC_RWR 2
#define PFUNC_RRD 3
#define CFUNC_PWR 4
#define CFUNC_PRD 5
#define CFUNC_RWR 6
#define CFUNC_RRD 7

#define M20_DECTBL_SIZE 9
#define M20x_DECTBL_SIZE 14
#define M20_RATE_MIN 2000
#define M20_RATE_MAX 3100 
#define M20_RATE_MINSAFE 2400 
#define JESD_RATE_MIN 1687
#if JESD_SOFT_PCS
  #define JESD_RATE_MAX 12000 
#else
  #define JESD_RATE_MAX 7750 /* This should be as high as 8936, need to debug...*/
#endif
#define LMX_TBL_SIZE 43
#define LMX_VCO_CAPCTRL_OVR(x) (((x) & 0x01) << 10)
#define LMX_VCO_SEL_FORCE(x)   (((x) & 0x01) << 10)
#define LMX_VCO_SEL(x)         (((x) & 0x07) << 11)
#define LMX_VCO_CAPCTRL(x)     (((x) & 0xFF) << 0)
#define LMX_VCO_IDAC_OVR(x)    (((x) & 0x01) << 13)
#define LMX_VCO_IDAC(x)        (((x) & 0x1FF) << 3)
#define LMX_SEG1_EN(x)         (((x) & 0x01) << 1)
#define LMX_SEG2_EN(x)         (((x) & 0x01) << 7)
#define LMX_SEG3_EN(x)         (((x) & 0x01) << 8)
#define LMX_SEG1(x)            (((x) & 0x01) << 2)
#define LMX_SEG2(x)            (((x) & 0x0F) << 9)
#define LMX_SEG3(x)            (((x) & 0x0F) << 0)
#define LMX_SEL(x)             (((x) & 0x07) << 4)
#define LMX_MUX(x)             (((x) & 0x01) << 2)
#define LMX_LD(x)              (((x) & 0x01) << 13)
#define LMX_RDLOCK(x)          (((x) & 0x0600) >> 9)

#define JESD_STAT_RST(x)       (((x) & 0x0001) >> 0)
#define JESD_STAT_RXVAL(x)     (((x) & 0x0002) >> 1)
#define JESD_STAT_PLLCAL(x)    (((x) & 0x0008) >> 3)
#define JESD_STAT_PLLLOC(x)    (((x) & 0x0010) >> 4)
#define JESD_STAT_DIGRST(x)    (((x) & 0x0020) >> 5)
#define JESD_STAT_ALGRST(x)    (((x) & 0x0040) >> 6)
#define JESD_STAT_WTREQ(x)     (((x) & 0x0080) >> 7)
#define JESD_STAT_RXRDY(x)     (((x) & 0xFF00) >> 8)
#define JESD_STAT_CALBSY(x)    (((x) & 0x00FF) >> 0)
#define JESD_STAT_RXLOC(x)     (((x) & 0xFF00) >> 8)

#define AD6688_DDC_PINC 0x0316
#define AD6688_DDC_POFF 0x031D
#define AD6688_DDC_MAW  0x0390
#define AD6688_DDC_MBW  0x0398

#define M20_CFG_CMD 0x00
#define M20_CFG_RET 0x02
#define M20_CFG_BUF 0x04

struct DDC_obj {
  real_8 fc;
  int_4 dec;
  int_4 src;
};

struct AD6688_obj {
  int_u4 chksum;
  int_4 ddc_en;
  real_8 fs;
  struct DDC_obj DDC[4];
  int_4 gain;
  int_4 chip_dec;
  int_4 L;
  int_4 F;
  int_4 K;
  int_4 M;
  int_4 CS;
  int_4 N;
  int_4 SUBCLS;
  int_4 NP;
  int_4 S;
  int_4 HD;
  int_4 CF;
  int_4 rfopts;
  int_4 spinv;
  int_4 rfgain[2];
  int_4 rfattn[2];
  int_4 a2dports;
  int_4 pll_config;
};

typedef struct AD6688_obj A2DM20_State;

int_4 a2dm20_dec_table[M20_DECTBL_SIZE] = {48,24,16,12,8,6,4,3,2};
int_4 a2dm20x_dec_table[M20x_DECTBL_SIZE] = {48,40,30,24,20,16,15,12,10,8,6,4,3,2};

int_4 a2dm20x_pps_table[5][M20x_DECTBL_SIZE] = {
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {0,0,120,140,150,150,110,150,144,154,145,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,115,125,116,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,100,112},
  {220,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

#define XCVR_CFG_DPRIO_ADDR_WIDTH 10
#define XCVR_ARRAY_SIZE 116

int_u4 altera_xcvr_array [4][XCVR_ARRAY_SIZE] = {
 {0x00AFF01,0x00BFF03,0x00C0F02,0x00DFD00,0x00EFF80,0x00F8F00,0x010FF00,0x011FF00,
  0x012FF00,0x013FF00,0x0141F00,0x015F414,0x016FF00,0x017F700,0x018FF20,0x019FF17,
  0x01AFF00,0x01BFF00,0x01CFF00,0x01DFF00,0x01EFF00,0x01FFF00,0x024EF04,0x028F704,
  0x0290100,0x032FFF1,0x033FF2C,0x034FF00,0x035FF00,0x036FF0A,0x037FF0D,0x038FF7C,
  0x039FF03,0x03AFD0D,0x03BFF03,0x03CFF03,0x03DFF67,0x03EFF00,0x03FFF00,0x040FF00,
  0x041FF00,0x042FF00,0x043FF00,0x044FF40,0x0451F00,0x046FF01,0x047F901,0x048FC00,
  0x049FF00,0x04AFF12,0x04BFF00,0x04CFF80,0x04DFF00,0x04EFF00,0x04FFF04,0x050FF10,
  0x051FF1F,0x0523F00,0x053C040,0x054FF00,0x055FC00,0x0624F02,0x0633F06,0x064FF00,
  0x065FFF8,0x0660F00,0x0B80100,0x0C40101,0x0C70300,0x1190300,0x11B0200,0x11D0700,
  0x11F0100,0x1230F01,0x1242000,0x132F7B2,0x133E380,0x134F7C2,0x135FF4E,0x136FF0C,
  0x137FF0F,0x138FF82,0x139FF23,0x13AFF1A,0x13BFF28,0x13CFD71,0x13DFF00,0x13E7F00,
  0x13F7F03,0x140C700,0x1421F0F,0x1445800,0x1481F00,0x1490F08,0x14B8000,0x14D0704,
  0x14F8000,0x1528000,0x1538000,0x154C000,0x155C000,0x1564000,0x15B1505,0x15E0101,
  0x1600101,0x163E0E0,0x1660101,0x1670101,0x1680400,0x16FC000,0x170FF01,0x1710100,
  0x1721000,0x173FF31,0x1741F0C,0x175F090},
 {0x00AFF01,0x00BFF03,0x00C0F02,0x00DFD00,0x00EFF80,0x00F8F00,0x010FF00,0x011FF00,
  0x012FF00,0x013FF00,0x0141F00,0x015F414,0x016FF00,0x017F700,0x018FF20,0x019FF17,
  0x01AFF00,0x01BFF00,0x01CFF00,0x01DFF00,0x01EFF00,0x01FFF00,0x024EF04,0x028F704,
  0x0290100,0x032FFF1,0x033FF2C,0x034FF00,0x035FF00,0x036FF0A,0x037FF0D,0x038FF7C,
  0x039FF03,0x03AFD0D,0x03BFF03,0x03CFF03,0x03DFF67,0x03EFF00,0x03FFF00,0x040FF00,
  0x041FF00,0x042FF00,0x043FF00,0x044FF40,0x0451F00,0x046FF01,0x047F901,0x048FC00,
  0x049FF00,0x04AFF12,0x04BFF00,0x04CFF80,0x04DFF00,0x04EFF00,0x04FFF04,0x050FF10,
  0x051FF1F,0x0523F00,0x053C040,0x054FF00,0x055FC00,0x0624F02,0x0633F06,0x064FF00,
  0x065FFF8,0x0660F00,0x0B80100,0x0C40101,0x0C70300,0x1190300,0x11B0200,0x11D0700,
  0x11F0100,0x1230F01,0x1242000,0x132F7B2,0x133E380,0x134F7C2,0x135FF4F,0x136FF0C,
  0x137FF0F,0x138FF82,0x139FF22,0x13AFF22,0x13BFF50,0x13CFD71,0x13DFF00,0x13E7F00,
  0x13F7F03,0x140C700,0x1421F0F,0x1445800,0x1481F00,0x1490F08,0x14B8000,0x14D0704,
  0x14F8000,0x1528000,0x1538000,0x154C000,0x155C000,0x1564000,0x15B1505,0x15E0101,
  0x1600101,0x163E0E0,0x1660101,0x1670101,0x1680400,0x16FC000,0x170FF01,0x1710100,
  0x1721000,0x173FF31,0x1741F0C,0x175F090},
 {0x00AFF01,0x00BFF03,0x00C0F02,0x00DFD00,0x00EFF80,0x00F8F00,0x010FF00,0x011FF00,
  0x012FF00,0x013FF00,0x0141F00,0x015F414,0x016FF00,0x017F700,0x018FF20,0x019FF17,
  0x01AFF00,0x01BFF00,0x01CFF00,0x01DFF00,0x01EFF00,0x01FFF00,0x024EF04,0x028F704,
  0x0290100,0x032FFF1,0x033FF2C,0x034FF00,0x035FF00,0x036FF0A,0x037FF0D,0x038FF7C,
  0x039FF03,0x03AFD0D,0x03BFF03,0x03CFF03,0x03DFF67,0x03EFF00,0x03FFF00,0x040FF00,
  0x041FF00,0x042FF00,0x043FF00,0x044FF40,0x0451F00,0x046FF01,0x047F901,0x048FC00,
  0x049FF00,0x04AFF12,0x04BFF00,0x04CFF80,0x04DFF00,0x04EFF00,0x04FFF04,0x050FF10,
  0x051FF1F,0x0523F00,0x053C040,0x054FF00,0x055FC00,0x0624F02,0x0633F06,0x064FF00,
  0x065FFF8,0x0660F00,0x0B80100,0x0C40101,0x0C70300,0x1190300,0x11B0200,0x11D0700,
  0x11F0100,0x1230F01,0x1242000,0x132F7B6,0x133E380,0x134F7C2,0x135FF0E,0x136FF0A,
  0x137FF0B,0x138FF82,0x139FF24,0x13AFF23,0x13BFF28,0x13CFD71,0x13DFF00,0x13E7F00,
  0x13F7F03,0x140C700,0x1421F0F,0x1445800,0x1481F00,0x1490F08,0x14B8000,0x14D0704,
  0x14F8000,0x1528000,0x1538000,0x154C000,0x155C000,0x1564000,0x15B1505,0x15E0101,
  0x1600101,0x163E0E0,0x1660101,0x1670101,0x1680400,0x16FC000,0x170FF01,0x1710100,
  0x1721000,0x173FF31,0x1741F0C,0x175F090},
 {0x00AFF01,0x00BFF03,0x00C0F02,0x00DFD00,0x00EFF80,0x00F8F00,0x010FF00,0x011FF00,
  0x012FF00,0x013FF00,0x0141F00,0x015F414,0x016FF00,0x017F700,0x018FF20,0x019FF17,
  0x01AFF00,0x01BFF00,0x01CFF00,0x01DFF00,0x01EFF00,0x01FFF00,0x024EF04,0x028F704,
  0x0290100,0x032FFF1,0x033FF2C,0x034FF00,0x035FF00,0x036FF0A,0x037FF0D,0x038FF7C,
  0x039FF03,0x03AFD0D,0x03BFF03,0x03CFF03,0x03DFF67,0x03EFF00,0x03FFF00,0x040FF00,
  0x041FF00,0x042FF00,0x043FF00,0x044FF40,0x0451F00,0x046FF01,0x047F901,0x048FC00,
  0x049FF00,0x04AFF12,0x04BFF00,0x04CFF80,0x04DFF00,0x04EFF00,0x04FFF04,0x050FF10,
  0x051FF1F,0x0523F00,0x053C040,0x054FF00,0x055FC00,0x0624F02,0x0633F06,0x064FF00,
  0x065FFF8,0x0660F00,0x0B80100,0x0C40101,0x0C70300,0x1190300,0x11B0200,0x11D0700,
  0x11F0100,0x1230F01,0x1242000,0x132F7B6,0x133E380,0x134F7C2,0x135FF0E,0x136FF0A,
  0x137FF0B,0x138FF82,0x139FF22,0x13AFF1B,0x13BFF14,0x13CFD71,0x13DFF00,0x13E7F00,
  0x13F7F03,0x140C700,0x1421F0F,0x1445800,0x1481F00,0x1490F08,0x14B8000,0x14D0704,
  0x14F8000,0x1528000,0x1538000,0x154C000,0x155C000,0x1564000,0x15B1505,0x15E0101,
  0x1600101,0x163E0E0,0x1660101,0x1670101,0x1680400,0x16FC000,0x170FF01,0x1710100,
  0x1721000,0x173FF31,0x1741F0C,0x175F090} 
};

#endif /* _IOMLIB_A2DM20_H */
