package nxm.ice.lib;

import nxm.ice.lib.IceHW;

public class IceK8P extends IcePM {

  public static int ftt2;

  public static void initAlgorithm () {
    resetDMA();
    FTTStruct ftt = (FTTStruct)getObjectAt(FTT_LOC);
    ftt.stages = 0;
    ftt2 = 0;
    runMode = ALG_INIT;
  }

  public static void openAlgorithm (int port, int type, int route) {
    awBus(DMAC_ROUTE_SET,route);
    awBus(DMAC_ROUTE_FLG,ROUTF_HPFDP|ROUTF_HXFDP|ROUTF_CXFDP|ROUTF_TXFDP);
    if (type==IOPT_TBANK) initTBank(port);
    runMode = ALG_PROCESS;
  }

  public static void processAlgorithm () {
    FTTStruct ftt = (FTTStruct)getObjectAt(FTT_LOC);
    int stages = ftt.stages;
    if (stages<0) stages = -stages; // FTTM=0
    int cstage = ftt.cstage;
    if (stages>1) doTBank(cstage,true);
    if (stages>0) doTBank(stages-1,false);
    if (ftt2>0)   doTBank(4,false);
    if (dcfgA!=0) processDelay(dcfgA,delayA);
    if (dcfgB!=0) processDelay(dcfgB,delayB);
  }

  public static void closeAlgorithm (int port, int type, int route) {
    awBus(DMAC_ROUTE_CLR,route);
    if (type==IOPT_TBANK) {
      exitTBank(port);
      udelay(1000);
      runMode = ALG_DONE;
    }
    if (arBus(DMAC_CTL)==0) resetDMA();
  }

  public static void modifyAlgorithm (int data, int size) {
    
  }

  protected static void initTBank (int port) {

    int fttloc = FTT_LOC;
    FTTStruct ftt = (FTTStruct)getObjectAt(fttloc);
    TBStruct tb = null;
    if (port==2 && ftt.stages==1) {
      fttloc = FTT_LOC2;
      ftt = (FTTStruct)getObjectAt(fttloc);
      ftt2 = 1;
    }
    int oact = ftt.active;
    if (port==3) port=7;
    int act = oact|port;
    int top = (act==2)?1:0;
    int stages = ftt.stages;
    ftt.chantop = top;
    ftt.active  = act;
    for (int i=0; i<3; i++) {
      int tbi = fttloc + ((i>1)? FTT_TB2 : (i>0)? FTT_TB1 : FTT_TB0);
      tb = (TBStruct)getObjectAt(tbi);
      tb.chan = top; // needs to be before return if support A&B
      tb.pindx = 0;
      tb.tphase = 0;
      tb.tdphase = 0;
    }
    if (oact!=0) return;
    ftt.cstage = 0;
    ftt.lstage = -1;
    ftt.busy = -1;
    ftt.dca0 = null;
    ftt.dca1 = null;
    // set up the DMA channels
    tb = (TBStruct)getObjectAt(fttloc+FTT_TB0);
    int nchan = tb.nchan;
    int pcfg  = tb.pcfg;
    int pstrt = tb.pstrt;
    int psize = tb.psize;
    int inc   = (stages>1)? 2:1;
    for (int i=0,j=0,adr=pstrt|pcfg; i<nchan; i++,j+=inc,adr+=psize) {
      setupDMAt (j,adr+((ftt.stages<0)? (j&0xE)<<7 : 0));
    }
    ftt.tbctl = arBus(TUNC_CTL); // store BPASS tuner reg
    if (stages>1) ssBank(0);
  }

  protected static void doTBank (int stage, boolean bpass) {

    int fttloc = (stage==4)? FTT_LOC2 : FTT_LOC;
    FTTStruct ftt = (FTTStruct)getObjectAt(fttloc);
    TBStruct tb=null, tbn=null;
    if (stage==4) stage=0;
    int act = ftt.active;
    if (act==0) return;

    // check busy
    int dcaa = fttloc + (bpass? FTT_DCA1 : FTT_DCA0);
    int dci  = arMem(dcaa);
    // wait for last transfer
    if (dci!=0 && dmaSync(dci)!=0) return;

    // check config
    int tbi = fttloc + ((stage==0)? FTT_TB0 : (stage==1)? FTT_TB1 : FTT_TB2);
    tb = (TBStruct)getObjectAt(tbi);
    int tbni = tbi+TB_SIZEOF; // 20elem*4by
    tbn = (TBStruct)getObjectAt(tbni);
    int chan = tb.chan;
    int ctop = ftt.chantop;
    boolean odd = (chan&1)!=0 && (act!=7);
    int io = bpass? PM_TUNB : odd? ftt.omodb : ftt.omoda;

    // stop last tuner bank pass
    if (stage == ftt.busy) {
      awBus(DMAC_ROUTE_CLR,0x01000000<<io);
      ftt.busy = -1;
      // just finished with last bank, now update pointers
      if (chan==ctop) tbn.pindx = (tbn.pindx+tb.prod) & tbn.pmask;
      ssBank(0);
    }
    if (bpass && ftt.busy>=0) return;  // busy on another stage

    // get current address
    int addr;
    if (stage==0) {
      int chani = chan;
      if (bpass) chani<<=1;
      addr = arMem(DMA_TO+(chani<<2));
    } 
    else if (chan==ctop) addr = getBase(tb,chan);
    else addr = ftt.addr;

    // check availability
    int mask = tb.pmask;
    int indx = tb.index;
    int xfer = tb.xfer;
    int size = tb.psize;
    int diff = (addr&mask) - indx;
    if (diff<0) diff += size;
    if (diff<xfer) {
      if (bpass && chan==ctop && ftt.stages>2) ftt.cstage = 1-ftt.cstage;
      return;
    }

    // setup tuner bank pass
    if (bpass) {
      ssBank(0);
      if (chan==ctop) ftt.base = getBase (tbn,chan);
      int base = ftt.base;
      int incr   = tbn.psize;
      if (act!=7) incr <<= 1;
      int lstage = ftt.lstage;
      int phinc  = tbn.phinc;
      int dphinc = tbn.dphinc;
      int tphase = tbn.tphase;
      int tdphase= tbn.tdphase;
      int start  = tphase;
      int taddr  = TUNB_CTL;
      int tinc   = 0x10000;
      int cpb2   = tbn.mchan<<1;
      for (int i=1; i<cpb2; i+=2) {
        if (stage!=lstage) awBus(taddr+GCFPGA_FREQ,-phinc);
        if (chan==ctop) awBus(taddr+GCFPGA_POFF,-start);
        start += tdphase;
        setupDMAt(i,base);
        phinc += dphinc;
        base  += incr;
        taddr += tinc;
      }
      if (chan==ctop) {
       tbn.tphase = tphase + tbn.tphinc;
       tbn.tdphase = tdphase + tbn.tdphinc;
      }
      if (act==3) {
        if (odd) base =     base - tbn.psize;
        else     base = ftt.base + tbn.psize;
      }
      // force SI output on middle stage
      int cm = (stage==0 && ftt.stages>2)? -1 : 1;
      // start the tuner bank core
      ssBank(cm);
      ftt.lstage = stage;
      ftt.busy = stage;
      ftt.base = base;
    }

    // start the transfer
    int j = (ftt.stages<0)? chan : 0;
    int start = indx + ((j&0xE)<<7);
    int stop  = (start+xfer) & mask;
    int base  = addr & (~mask);
    dci = DMA_XI + (io<<3);
    awMem(dci+0,base+start);
    awMem(dci+4,base+stop);
    awBus(DMAC_ROUTE_SET,0x01000000<<io);

    // setup for next pass
    if ((act&3)!=3) chan++;
    if (++chan >= tb.nchan) {
      chan = ctop;
      indx = (indx+tb.cons) & mask;
      tb.index = indx;
    }
    if (stage>0) {
      addr += size;
      //if (act!=7) addr += size;
      if ((act&3)!=3) addr += size;
      ftt.addr = addr; 
    }
    tb.chan = chan;
    awMem(dcaa,dci);
  }

  protected static void exitTBank (int port) {
    FTTStruct ftt = (FTTStruct)getObjectAt(FTT_LOC);
    if (port>2) port=7;
    if (port==2) ftt2=0;
    int act = ftt.active & ~port;
    ftt.active = act;
    if (act!=0) return;
    if (ftt.stages>1) ssBank(0);
  }

  static int getBase (TBStruct tb, int chan) {
    return tb.pcfg | (tb.pstrt + tb.psize*chan + tb.pindx);
  }

  static void ssBank (int mode) {
    int ctl = arMem(FTT_LOC + FTT_TBCTL);	// only root FTT can handle multipass
    if (mode<0) ctl &= 0x7FFF;	// force REAL
    if (mode==0) ctl &= ~0x1;	// force DISABLE
    awBus(TUNC_CTL, ctl);
  }

}
