/*
  Definitions for the ICE-PIC handler / driver structures

*/
#ifndef _ICEIOCTL_H_

#define _ICEIOCTL_H_

#define ICEPIC_DEVICE_TYPE 0x8000

#define IOCTL_VERSION	0
#define IOCTL_READ	1
#define IOCTL_WRITE	2
#define IOCTL_ACMD	3
#define IOCTL_MAP	4
#define IOCTL_UNMAP	5
#define IOCTL_QMAP	6
#define IOCTL_LIOC	7
#define IOCTL_RALLOC	8
#define IOCTL_RDEALLOC	9
#define IOCTL_DMAMAP	10
#define IOCTL_QALLOC	11
#define IOCTL_LOG 	12
#define IOCTL_QLOG 	13
#define IOCTL_PMDUMP 	14
#define IOCTL_RCFG 	15
#define IOCTL_RCD 	16
#define IOCTL_REATTACH	99

#define IOCTL_MAXVALID 	16

#if defined(_WINxx) || defined(_VMS)
typedef long            int32_t;
typedef unsigned long   u_int32_t;
#endif

#if defined(_OSF) || defined(_SGI)

typedef struct pic_ioctl {
  int           function, offset;       /* Registers for IOCTL functions */
#ifdef _SGI
  __uint32_t    bufaddr;
#else
  void *        bufaddr;                /* Registers for IOCTL functions */
#endif
  int           bytes, status;          /* Registers for IOCTL functions */
} PICIOCTL;

#else

/* Structure used as a handle to the PIC device */
typedef struct pic_ioctl {
  int32_t	function, offset;	/* Registers for IOCTL functions */
  void *	bufaddr;		/* Registers for IOCTL functions */
  int32_t	bytes, status;		/* Registers for IOCTL functions */
} PICIOCTL;

/* Structure for SOLARIS 32/64 bit driver IF handlers */
#ifdef _MULTI_DATAMODEL
#include <sys/types32.h>
#include <unistd.h>
typedef uint32_t u_int32_t;
#endif

typedef struct pic_ioctl32 {
  int32_t	function, offset;	/* Registers for IOCTL functions */
  u_int32_t	bufaddr;		/* Registers for IOCTL functions */
  int32_t	bytes, status;		/* Registers for IOCTL functions */
} PICIOCTL32;

#endif

typedef struct {
  int32_t	func, len;
  int64_t 	bufaddr;
  int32_t	status;	
} ICEFSIOCTL;

#endif
