/* 
 * Description:  C include of blue header
 *
 * $Revision:   1.6  $
 * $Modtime:   01 May 1996 16:06:34  $
 *
 */

#ifndef _ICEHDR_H

#define L_outlets 8
#define L_keywords 92

typedef struct {
  real_8 xstart, xdelta;
  int_4 xunits, subsize;
  real_8 ystart, ydelta;
  int_4 yunits;
  int_4 bid;
} T2ADJ;

typedef struct {
  char            version[4];
  char            head_rep[4];
  char            data_rep[4];
  int_4           detached, protected_, pipe_;
  int_4           ext_start, ext_size;
  real_8          data_start, data_size;
  int_4           type;
  char            format[2];
  int_2           flagmask;
  real_8          timecode;
  int_2           inlet, outlets;
  int_4           outmask, pipeloc, pipesize;
  real_8          in_byte, out_byte, outbytes[L_outlets-1];
  int_8           vaddr;	/* to replace pipeloc for 64b virtual address */
  int_4           keylength;
  char            keywords[L_keywords];
 union {
  T2ADJ	          t2;
  char            c1[256];
  int_2           i2[128];
  int_4           i4[64];
  int_8           i8[32];
  real_8          r8[32];
 } adj;
} ICEHDR;

#define _ICEHDR_H
#endif
