/*

  Description :  Things C should have but doesn't
  Author:	   CLI  6/94

  $Revision:   1.7  $
  $Modtime:   02/22/96 10:21:12  $

  Automatic platform defining has been removed.  Make sure the 
  appropriate defines for OSTYPE, OSNAME, and OSREP are specified
  on the compile line.

*/

#ifndef _icedefs_h
#ifndef XM_CDEFS_H_

#define _NOROUND 0

#if vaxc
#define signed
#endif

/* Type definitions */

typedef signed char	int_1;
typedef	short		int_2;
typedef unsigned char	int_u1;
typedef unsigned short	int_u2;

#if _OSF|_SGI|__LP64__
typedef	int		int_4;
typedef unsigned int	int_u4;
typedef long		int_8;
typedef unsigned long	int_u8;
#define _LONG64

#elif _LINX
# include <stdlib.h>
typedef	int32_t		int_4;
typedef u_int32_t 	int_u4;
typedef int64_t		int_8;
typedef u_int64_t 	int_u8;
#if __WORDSIZE == 64
#  define _LONG64
#endif

#elif _WIN
typedef	long		int_4;
typedef unsigned long	int_u4;
/* some compilers want this 1st way - most dont */
#if MS_INT_8
typedef _int64		int_8; 
typedef _int64		int_u8; 
#define _LONG64
#else
#ifndef __int64
#define __int64 long long
#endif
typedef __int64		int_8; 
typedef __int64		int_u8; 
#endif

#else
typedef	long		int_4;
typedef unsigned long	int_u4;
typedef long long	int_8;
typedef unsigned long long int_u8;
#endif

typedef int_u1	bool_1;
typedef int_u2	bool_2;
typedef int_u4	bool_4;

typedef	float	real_4;
typedef	double	real_8;
typedef char *  pointer;

/* Unions */
typedef union {
  real_8 r8[1]; int_8 i8[1]; int_u8 u8[1];
  real_4 r4[2]; int_4 i4[2]; int_u4 u4[2];
  int_2 i2[4]; int_u2 u2[4];
  int_1 i1[8]; int_u1 u1[8];
} UnionBuf;

/*
 * We expect that the values for TRUE and FALSE below are portable.
 * That is, interpreted correctly by FORTRAN and C on all platforms.
 */
#ifndef TRUE
#  define	TRUE	1
#endif
#ifndef FALSE
#  define	FALSE	0
#endif

/* Return Status */
#if _VMS
#  include <ssdef.h>
#  define EXIT_NORMAL SS$_NORMAL
#  define EXIT_ERROR  SS$_ABORT
#else
#  define EXIT_NORMAL 0
#  define EXIT_ERROR  1
#endif

/* Macros */
#define streq(s, t)	(strcmp(s, t) == 0)
#define strneq(s, t, n)	(strncmp(s, t, n) == 0)

/* Fortran string handlers */
#if _VMS
#include <descrip.h>
#endif

typedef  struct {
  unsigned short length;
  char dtype,dclass;
  char *c;
} VAXstr;

#endif

/* Constants */
#ifdef _LONG64
typedef int_8	int_x;
#define B4G 0x100000000L
#define B4GM 0xFFFFFFFFL
#else
typedef int_4	int_x;
#define B4G 0x100000000LL
#define B4GM 0xFFFFFFFFLL
#endif

#if _NOROUND
#define round(A) floor((A)+0.5)
#define roundf(A) floorf((A)+0.5F)
#endif

#if _SHARC
typedef int_4  int32_t;
typedef int_u4 u_int32_t;
#endif

#define _icedefs_h
#endif
