/***********************************************************************
  Description:	Byte/Word/Frame/Page Conversions for ICE-PIC card drivers
  Author: 	Jeff Schoen - Innovative Computer Engineering
  Date:		3/2002

  word=4by addressing on cards can handle up to 16G

  phys addresses are packed into int_4s as:

  decode of bottom 2 bits

  00 word=4by   addressing can handle up to 4G   ( 1by logical element)
  x1 frame=64by addressing can handle up to 128G (32by logical element)
  10 page=4kby  addressing can handle up to 16T	 (1kby logical element)

************************************************************************/
int_4 long2phys (int_8 l) {
       if ((l>>37) != 0) l = ((l>>10)&0xFFFFFFFC) | 0x2;
  else if ((l>>32) != 0) l = ((l>>5)&0xFFFFFFFE) | 0x1;
  else l = (l&0xFFFFFFFC);
  return (int_4)l;
}
int_8 phys2long (int_4 i) {
  int_8 l=i; 
       if (i&1) l = (l&0xFFFFFFFE)<<5;
  else if (i&2) l = (l&0xFFFFFFFC)<<10;
  else          l = (l&0xFFFFFFFC)<<0;
  return l;
}
int_4 int2phys (int_4 i) {
  i = i&0xFFFFFFFC;
  return i;
}
int_4 phys2int (int_4 i) {
  if (i&0x1) i=-1;	/* error code */
  return i;
}
int_u4 phys2word (int_4 i) {
       if (i&1) i = (i<<3)&0xFFFFFFF0;
  else if (i&2) i = (i<<8)&0xFFFFFC00;
  else          i = (i>>2)&0x3FFFFFFF;
  return i;
}
int_4 word2phys (int_u4 i) {
  if (i&0xC0000000) i = ((i>>3)&0x1FFFFFFE) | 0x1;
  else i = i<<2;
  return i;
}
int_4 phys2page (int_4 i) {
       if (i&1) i = (i<<5)&0xFFFFFFC0;
  else if (i&2) i = (i<<0)&0xFFFFFFFC;
  else          i = (i>>10)&0x003FFFFC;
  return i;
}
int_4 page2phys (int_4 i) {
  if (i&0xFFC00000) i = (i&0xFFFFFFFC) | 0x2;
  else i = i<<10;
  return i;
}
int_u4 long2word (int_8 l) {
  l = (l>>2)&0xFFFFFFFF;
  return (int_4)l;
}
int_8 word2long (int_u4 i) {
  int_8 l=i; l = (l&0xFFFFFFFF)<<2;
  return l;
}
