c************
c   Description : FAST I/O pipe access routines
c
c   Author :    JGS   1/20/99
c
c   $Revision:   1.15  $
c   $Modtime:   01/17/96 10:14:44  $
c   
c************
	subroutine M$BUFIN (hcb, pbuf, ngot)

	implicit none
	include 'midas.inc'
	include 'pointer.inc'
	include 'headers.inc'
	record /HEADER/ hcb,hp
	record /M_PTR/ pbuf
	integer*4 ngot, nbytes, nget, ioff
	real*8 offset
	pointer (php,hp)

	nbytes = hcb.xfer_len*hcb.dbpe

	if (hcb.pipe.eq.0) goto 99			! not pipe
	if (hcb.type.ge.3000) goto 99			! record format
	if (hcb.buf_type .ne. hcb.format(2:2)) goto 99	! reformatting

	offset = hcb.offset*hcb.dbpe + hcb.first_byte
	ioff = dmod( offset, DBLE(hcb.pipesize) ) 
	if (hcb.pipesize-ioff .lt. nbytes) goto 99	! buffer wrap
	ngot = 0
	php = hcb.lph
	hp.out_bytes(hcb.outlet) = offset
	do while (hp.in_byte-offset .lt. nbytes)
	  if (Mc.break) return
	  call M$PAUSE (Mc.pause)
	enddo
	pbuf.ptr = Mu.sec_ptr(LS_pipe_buffers) + hp.pipeloc + ioff
	ngot = hcb.xfer_len
	return

  99	continue
	if (nbytes .gt. hcb.savebuf_len) then
          call M$STMFREE (hcb.savebuf_len, hcb.savebuf_loc)
          hcb.savebuf_len = nbytes
          call M$STMALLOC (hcb.savebuf_len, hcb.savebuf_loc)
	endif
	pbuf.ptr = hcb.savebuf_loc
	call M$GRABX(hcb, %val(pbuf.ptr), ngot)
	return
	end


	subroutine M$BUFDONE (hcb, pbuf, ngot)

	implicit none
	include 'midas.inc'
	include 'pointer.inc'
	include 'headers.inc'
	record /HEADER/ hcb,hp
	record /M_PTR/ pbuf
	integer*4 ngot
	real*8 offset
	pointer (php,hp)

	if (pbuf.ptr .eq. hcb.savebuf_loc) return
	hcb.offset = hcb.offset + ngot
	offset = hcb.offset*hcb.dbpe + hcb.first_byte
	php = hcb.lph
	hp.out_bytes(hcb.outlet) = offset

	end
