/**
  Common handles for processing COREs

  CORE_AREA is the java native package location
  CORE_NAME is the Library Function Name
  CORE_TYPE is the Processor Type Java,CPU,GPU,MLS,VHS,ICE

  @author Jeff Schoen
  @version $Id: CoreHandles.h,v 1.1 2011/04/27 13:09:47 jgs Exp $
*/

#ifdef CORE_AREA
#define CEXPORT static
#else
#define CEXPORT
#endif

#ifdef CORE_NAME

#define CCN CORE_NAME	/* C Core Name */
#define BGLOBAL(A,B) Core##B##_##A##_alloc
#define CGLOBAL(A,B) BGLOBAL(A,B)
#define STRNCPY_DEFINE(A,B,C) strncpy(A,"##B##",C)
#define ACTUAL_STRINGIFY(A) #A
#define STRINGIFY(B) ACTUAL_STRINGIFY(B)

CEXPORT int_4 CMETHOD(CCN,init_)    (void* halo) { return CMETHOD(CCN,init)((CCN*)halo); }
CEXPORT int_4 CMETHOD(CCN,set_)     (void* halo, void* key, void* value) { return CMETHOD(CCN,set)((CCN*)halo,(String*)key,(Value*)value); }
CEXPORT int_4 CMETHOD(CCN,get_)     (void* halo, void* key, void* value) { return CMETHOD(CCN,get)((CCN*)halo,(String*)key,(Value*)value); }
CEXPORT int_4 CMETHOD(CCN,open_)    (void* halo) { return CMETHOD(CCN,open)((CCN*)halo); };
#ifdef CORE_IS_HOC
#elif CORE_FLOW == CORE_FLOW_BUFFER
CEXPORT int_4 CMETHOD(CCN,process_) (void* halo, void* bi, void* bo) { return CMETHOD(CCN,process)((CCN*)halo,(Buffer*)bi,(Buffer*)bo); }
#elif CORE_FLOW == CORE_FLOW_STREAM
CEXPORT int_4 CMETHOD(CCN,process_) (void* halo, void* si, void* so) { return CMETHOD(CCN,process)((CCN*)halo,(Stream*)si,(Stream*)so); }
#elif CORE_FLOW == CORE_FLOW_BUFSTR
CEXPORT int_4 CMETHOD(CCN,process_) (void* halo, void* bi, void* so) { return CMETHOD(CCN,process)((CCN*)halo,(Buffer*)bi,(Stream*)so); }
#elif CORE_FLOW == CORE_FLOW_PACKET
CEXPORT int_4 CMETHOD(CCN,process4_) (void* halo, void* bi, void* sip, void* so, void* sop) { return CMETHOD(CCN,process)((CCN*)halo,(Buffer*)bi,(Stream*)sip,(Stream*)so,(Stream*)sop); }
#else
CEXPORT int_4 CMETHOD(CCN,process_) (void* halo) { return CMETHOD(CCN,process)((CCN*)halo); }
#endif
CEXPORT int_4 CMETHOD(CCN,close_)   (void* halo) { return CMETHOD(CCN,close)((CCN*)halo); }
CEXPORT int_4 CMETHOD(CCN,free_)    (void* halo) { return CMETHOD(CCN,free)((CCN*)halo); }
#ifndef CORE_IS_HOC
CEXPORT int_4 CMETHOD(CCN,upload_)  (void* halo, void* planp) { return CMETHOD(CCN,upload)((CCN*)halo,(void*)planp); }
CEXPORT int_4 CMETHOD(CCN,poll_)    (void* halo) { return CMETHOD(CCN,poll)((CCN*)halo); }
#endif

// allocates and initializes HALO
CEXPORT CCN* CMETHOD(CCN,plan) () {
  int_4 size = sizeof(CCN);
  HALO *pt = (HALO*)malloc(size);
  if (pt==NULL) return NULL;
  memset (pt,0,size);
  pt->init   = &CMETHOD(CCN,init_);
  pt->set    = &CMETHOD(CCN,set_);
  pt->get    = &CMETHOD(CCN,get_);
  pt->open   = &CMETHOD(CCN,open_);
#ifdef CORE_IS_HOC
#elif CORE_FLOW == CORE_FLOW_PACKET
  pt->process4 = &CMETHOD(CCN,process4_);
#else
  pt->process = &CMETHOD(CCN,process_);
#endif
  pt->close  = &CMETHOD(CCN,close_);
  pt->free   = &CMETHOD(CCN,free_);
#ifdef CORE_IS_VHS
  pt->work   = &VCore_process;
  pt->sysrd  = &VCore_sysrd;
  pt->syswr  = &VCore_syswr;
#elif CORE_IS_ICE
  pt->work   = &FPGA_process;
  pt->sysrd  = &FPGA_sysrd;
  pt->syswr  = &FPGA_syswr;
#endif
#ifndef CORE_IS_HOC
  pt->upload = &CMETHOD(CCN,upload_);
  pt->poll   = &CMETHOD(CCN,poll_);
#endif
  pt->psize  = size - sizeof(HALO);
  pt->impl   = CORE_TYPE;
  pt->flow   = CORE_FLOW;
  strncpy(pt->name,STRINGIFY(CCN),7);
  return (CCN*)pt;
}
void* CGLOBAL(CCN,CORE_SIG) (char* config) {
  return CMETHOD(CCN,alloc)(config);
}
#endif

#ifdef CORE_AREA
#define IGLOBAL(A,B,C) Java_##A##_##B##_00024##C##_alloc
#define JGLOBAL(A,B,C) IGLOBAL(A,B,C)
#ifndef NONEXTMIDAS
#include "native.h"
JNIEXPORT jlong JNICALL JGLOBAL(CORE_AREA,CCN,CORE_SIG) (JNIEnv *env, jobject obj) {
  jobject config =  GetStringObject(obj,"config");
  char *cconfig = (config==NULL)? 0 : (char *)GetString(config);
  jpointer handle = (jpointer) CMETHOD(CCN,alloc)((char *)cconfig);
  if (config!=NULL) ReleaseString(config,cconfig);
  return (jlong)handle;
}
#endif
#endif

