c************
c   Description : Copy a PIC RAMDISK file to a Midas file/pipe
c
c   Author :    JGS   9/10/96
c
c   $Revision:   1.15  $
c   $Modtime:   01/17/96 10:14:44  $
c   
c************
	program SOURCEPIC
c
	implicit none
	include 'sourcepic.inc'
	record /HEADER/ HWF
c
	character cnum*8,algstr*8
	byte      buf(1),out(1)
	pointer   (pbuf,buf),(pout,out)
	integer*4 tskip,lsf,ipktps,feed,pktmod,mlost,tccnt
	integer*4 tcstatuslast,swap,tinc,tcm,adone,nchan,nodma
	real*4    wait,pause,elapse,timeout,fstat
	logical*4 boot,sss,xts,stats,syncdata,flush,tuner,rtfile
	real*8    maxout, tcps, dval
c
	call M$CHECKIN
c
c find the PIC device
	devlab = M$UPICK(3)
	i  = M$HWF_OPEN (hwf) 
	ls = M$HWF_ALIAS (hwf, M$APICK(3), string) 
	i  = M$HWF_CLOSE (hwf) 
c
c open the PIC device
	flags = 0
	lsf = max(0,M$GET_USWITCH('FLAGS',flgstr))
	if (M$GET_USWITCH('PORT',tmpstr) .gt. 0) then
	  flgstr(lsf+1:) = ',PORT='//tmpstr
	  lsf = M$LENGTH(flgstr)
	endif
	i = M$GET_USWITCH('TC',tcmode)
	if (i.eq.0) then
	  tcmode = 'SDN4'
	  i = 4
	endif
	if (i.ge.0) then
	  flgstr = 'TC='//tcmode(1:i)//','//flgstr(1:lsf)
	  lsf = M$LENGTH(flgstr)
	  tcoff = M$GET_DSWITCH('TCOFF')
	  if (tcoff.eq.-1) then
	    call M$NOW (time1,time2)
	    i = M$TIMES2TOD (time1,time2,tmpstr)
	    tmpstr(5:) = ':01:01::00:00:00'
	    i = M$TOD2TIMES (tmpstr,tcoff,time2)
	    if (tcmode(1:3).eq.'CPU') tcoff = 0
	  endif
	  tctolr = M$GET_DSWITCH('TCTOLR')
	else
	  tcmode = 'OFF'
	endif
	i = M$GET_USWITCH('ALG',algstr)
	if (i.ge.0) then
	  flgstr = 'ALG='//algstr(1:i)//','//flgstr(1:lsf)
	  lsf = M$LENGTH(flgstr)
	endif
	i = M$GET_USWITCH('VERBOSE',cnum)
	if (i.ge.0) then
	  if (i.eq.0) flgstr = 'VERBOSE,'//flgstr(1:lsf)
	  if (i.ne.0) flgstr = 'VERBOSE='//cnum(1:i)//','//flgstr(1:lsf)
	  lsf = M$LENGTH(flgstr)
	endif
	rtfile = M$GET_SSWITCH('RTFILE') 
	info = .not. M$GET_SSWITCH('QUIET')
	string = flgstr(1:lsf)//','//string(1:ls)//','//CHAR(0)
	status = M$PIC_OPEN (p,string,Mc.break,flags)
	if (status .le. 0) call M$ERROR ('Opening port: '//string)
	boot = M$GET_SSWITCH('REBOOT')
	flags = 0
	if (boot) flags = flags .or. FLG_BOOT
	ratio = M$GET_DSWITCH('RATIO')
	if (ratio.gt.0) status = M$PIC_SETKEY (p, 0, KEY_RATIO, ratio, 8)
	status = M$PIC_RESET (p,flags) 
	if (status .le. 0) call M$ERROR ('Resetting port: '//string)
	status = M$PIC_GETKEY(p,0,KEY_PTYPE,type,4)
	status = M$PIC_GETKEY(p,0,KEY_PINDEX,port,4)
	tuner = type.eq.IOPT_TUNER .or. type.eq.IOPT_TBANK
c
c prep for algorithms
	feed=-1
	nargs=-1
	status = M$PIC_GETKEY(p,0,KEY_ALG,alg,4)
	if (alg.gt.0) then
	  nargs = M$GET_SWITCH_DEF('NARG',0)
	  do n = 1,nargs
	    write(cnum,'(3hARG,i1)') n
	    args(n) = M$GET_SWITCH_DEF(cnum(1:4),0)
	  enddo
	  feed = M$GET_SWITCH('FEED')
	endif
c
c open and check input file
	call M$INIT (HIN, M$APICK(1),'1000,2000',
     &			'SP,SB,SI,SL,CB,CI,CL',0)
	if (rtfile) then
	  call M$OPEN (HIN, HCBF_INPUT+HCBF_OUTPUT+HCBF_PRESERVE)
	else
	  call M$OPEN (HIN, HCBF_INPUT+HCBF_PRESERVE)
	endif
c
c get reduction 
	ired   = M$LPICK(4)	
	if (ired.eq.0) ired = 1
c
c check for TUNER options
	if (tuner) then
	  i = ired
	  ired = M$PIC_TUNER_DEC (p,ired,-1,0)
	  status = M$L2A (ired,cnum)
	  if (ired.ne.i) call M$WARNING ('Tuner dec changed to '//cnum)
	  host = M$GET_SSWITCH_DEF('HOST',0)
	  if (host) call M$ERROR ('Host TUNER mode not supported yet')
	elseif (type.eq.IOPT_CORE) then
	  host = M$GET_SSWITCH_DEF('HOST',0)
	else
	  host = M$GET_SSWITCH_DEF('HOST',1)
	endif
c
c fixup deltas
	idelta = iabs(ired)
c
c get tuner frequency / gain
	tfreq = M$DPICK(5)
	tgain = M$LPICK(6)
c
c get the transfer length switch
	tl = M$GET_SWITCH('TL')
	if (tl.le.0) tl = max(1, NINT(L_bbuf/HIN.dbpe))
	tskip = M$GET_SWITCH('SKIP')
	swap = M$GET_SWITCH('SWAP')
	wait = M$GET_DSWITCH('WAIT')
	if (wait.lt.0) wait = M$GET_DSWITCH('PAUSE')
	pause = M$GET_DSWITCH_DEF('POLL',0.025d0)
	maxout = M$GET_DSWITCH('MAXOUT')
	timeout = M$GET_DSWITCH_DEF('TIMEOUT',1.d0)
	dtfreq = M$GET_DSWITCH_DEF('DFREQ',0.0d0)
	stats = M$GET_PSWITCH('STATS')
	syncdata = M$GET_PSWITCH('SYNCDATA')
	flush = M$GET_PSWITCH('FLUSH')
c
c can we allow blocking this file
	noblock = HIN.ape.gt.1 .or. HIN.spa.gt.2
c
c enable autorestart feature ?
	autors = M$GET_SWITCH_DEF('AUTORS',0)
c
c enable multi-channel mode ?
	multi = M$GET_SWITCH_DEF('MULTI',1)
	autoss = M$GET_SSWITCH('AUTOSS')
	renum = M$GET_SWITCH('RENUM')
c
c fill out header and open output file
	call M$PROPAGATE (HIN,HOUT)
	HOUT.file_name = M$APICK(2)
	if (host) then
	  if (HIN.class .eq. 2) then
	    HOUT.ydelta = HIN.ydelta * idelta
	  else
	    HOUT.xdelta = HIN.xdelta * idelta
	  endif
	  HOUT.size  = DINT( (HIN.size-1.d0)/idelta ) + 1.d0
	  rate  = 1.d0 / max(1.d-10,HIN.xdelta) 
	elseif (type.eq.IOPT_CORE) then
	  rate  = ired / max(1.d-10,HIN.xdelta) 
	elseif (type.ne.IOPT_MODULE) then
	  ! input file matches output
	  rate  = HIN.spa * ired / max(1.d-10,HIN.xdelta) 
	else
	  rate  = 1.d0 / max(1.d-10,HIN.xdelta) 
	endif
	if (ratio .gt. 0.0) rate  = HIN.spa * ired / max(1.d-10,HIN.xdelta*ratio)
	call M$OPEN (HOUT, HCBF_OUTPUT+HCBF_OPTIONAL)
c
c get archive parameters 
	archid   = 0
	archdur  = -1
	archtime = 0
	archmode = ARCH_OFF
	i = M$GET_USWITCH('ARCH',archname)
	if (i.gt.0) archmode = ARCH_WAIT
	archtl = M$GET_SWITCH_DEF('ARCHTL',128*1024)
	archsf = M$GET_SWITCH('ARCHSF')
c
c tuner bank specific startup
	if (type .eq. IOPT_TBANK .or. type .eq. IOPT_CORE) then
	  nchan = M$PIC_GETKEY(p,port,KEY_CHNS,i,4)
	  if (type .eq. IOPT_CORE) nchan = 1
          nchan = M$GET_SWITCH_DEF('NCHN',nchan)
	  i = M$PIC_SETKEY(p,port,KEY_CHNS,nchan,4)
          i = M$GET_SWITCH_DEF('PKTLEN',tl*HIN.bpe)
	  i = M$PIC_SETKEY(p,port,KEY_PKTLEN,i,4)
	  i = M$PIC_SETKEY(p,port,KEY_DFREQ,2*dtfreq/rate,8)
	  if (renum.le.0) renum = 1
	else
	  nchan = 1
	endif
c
c get the timecode sampling rate
	tcpp = M$GET_SWITCH('TCPP')
	tcps = M$GET_DSWITCH('TCPS')
	if (tcps.gt.0 .and. tcpp.lt.0) then
	  tcpp = max(1.d0,1.d0/(tcps*HIN.xdelta*HIN.ape*tl*max(1,tskip))+.5)
	endif
c
c get the packet mode and initialize
	pktmod = M$GET_SWITCH('PKTMODE')
	packet = M$GET_USWITCH('PACKET',HPACK.file_name)
	apacket = M$GET_USWITCH('APACKET',afpext)
	if (packet.eq.0) then
	  ipkt = ICE_HDR_SZ / HOUT.dbpe
	  if (ipkt.le.0) call M$ERROR 
     &		('Int Packet Mode Format Incompatibility')
	  if (tl.le.0) call M$ERROR
     &		('Packet mode must specify transfer length /TL=n')
	endif
	if (apacket.eq.0) then
	  ipkt = ICE_HDR_SZ / HIN.bpa
	  if (ipkt.le.0) call M$ERROR 
     &		('Int Packet Mode Format Incompatibility')
	  if (archtl.le.0) call M$ERROR
     &		('Packet mode must specify transfer length /TL=n')
	endif
	if (packet.gt.0 .or. apacket.gt.0) then
	  call M$INIT (HPACK,HPACK.file_name,'3000','NH',0)
	  call M$ADDSUBR (HPACK,'KEYS','4B')
	  call M$ADDSUBR (HPACK,'CNT ','SL')
	  call M$ADDSUBR (HPACK,'ELEM','SL')
	  call M$ADDSUBR (HPACK,'USER','SI')
	  call M$ADDSUBR (HPACK,'CHAN','SI')
	  call M$ADDSUBR (HPACK,'SID ','2B')
	  call M$ADDSUBR (HPACK,'REP ','SB')
	  call M$ADDSUBR (HPACK,'BPA ','SB')
	  call M$ADDSUBR (HPACK,'MODE','SB')
	  call M$ADDSUBR (HPACK,'TYPE','SB')
	  call M$ADDSUBR (HPACK,'TCM ','SB')
	  call M$ADDSUBR (HPACK,'TCS ','SB')
	  call M$ADDSUBR (HPACK,'TCO ','SD')
	  call M$ADDSUBR (HPACK,'TCWS','SD')
	  call M$ADDSUBR (HPACK,'TCFS','SD')
	  if (pktmod.eq.1) then
	  call M$ADDSUBR (HPACK,'XDEL','SD')
	  call M$ADDSUBR (HPACK,'XSTA','SD')
	  elseif (pktmod.eq.2 .or. pktmod.eq.3) then
	  call M$ADDSUBR (HPACK,'RATE','SD')
	  call M$ADDSUBR (HPACK,'FREQ','SD')
	  else
	  call M$ADDSUBR (HPACK,'RBST','SL')
	  call M$ADDSUBR (HPACK,'RBSZ','SL')
	  call M$ADDSUBR (HPACK,'RBDO','SL')
	  call M$ADDSUBR (HPACK,'RBDS','SL')
	  endif
	  HAPACK = HPACK
	endif
	if (packet.gt.0) then
	  call M$OPEN (HPACK, HCBF_OUTPUT)
	endif
c
c get startup modes
	mpp = 0
	msync = 0
	msyncid = M$GET_SWITCH('MASTER')
	if (msyncid.gt.0) msync = 1
	i = M$GET_USWITCH('SLAVE',cnum)
	if (i.ge.0) msync = 2
	sss = (i.eq.2 .and. cnum.eq.'SS') ! same side slave
	xts = (i.eq.2 .and. cnum.eq.'XT') ! external trigger slave
	mgo = -1			! non-piped default
	if (Mc.mode.ne.0) mgo = 2	! piped default
	mgo = M$GET_SWITCH_DEF('REPLAY',mgo)
	if (msync.ge.2) mgo = 0		! slave wait
c
c get results labels
	if (M$GET_USWITCH ('SYNC', synclab).le.0) synclab = ' '
	if (M$GET_USWITCH ('LOST', lostlab).le.0) lostlab = ' '
	if (M$GET_USWITCH ('TCSTAT', tcslab).le.0) tcslab = ' '
	if (M$GET_USWITCH ('SEQERR', seqerr).le.0) seqerr = ' '
	if (M$GET_USWITCH ('SEQFILL', seqfill).le.0) seqfill = ' '
	if (M$GET_USWITCH ('PFULL', statlab).le.0) statlab = ' '
	if (M$GET_USWITCH ('NTPOFF', ntplab).le.0) ntplab = ' '
c
c init the PIC device parameters
	dir   = -1	! Read only primitive
	ape   = HOUT.ape 
	spa   = HOUT.spa
	epb   = HOUT.size / max(nchan,multi)
	bps   = HIN.bps
	dbpe  = HIN.dbpe
	bits  = HIN.dbpe / HIN.ape / HIN.spa * 8
	bits  = M$GET_SWITCH_DEF ('BITS',bits)
	if (spa .eq. 2) bits = -bits
	rate  = M$GET_DSWITCH_DEF ('SRATE',rate)
	if (tfreq.eq.-1) tfreq = rate * 0.25d0
	if (.not.host) idelta = 1
	delta = HOUT.xdelta
	tfreq = (rate/2) * M$PIC_TUNER_FREQ (p,2*tfreq/rate,0)
	nblock = max(0,tl) * HIN.dbpe 
	if (tskip.gt.1 .or. idelta.gt.1) nblock = -1
c
c set up real time controls
	idm = M$MWINIT('Replay Mode',mgo,'REPLAY;Play One,Continuous,'//
     &	'Stop Top,Stop Now,Spin,Archive,ReStart,Abort,NewDevice')
	ids = M$MWINIT('Sync Mode',msync,'Master,Slave Wait,Slave Run')
	idr = M$DWINIT('Sample Rate', rate, 1.d0, 100.d6, 1.d3)
	if (tuner) then
	  idd = M$LWINIT('Tuner Dec', ired, 1, 32768, 2)
	else
	  idd = M$LWINIT('Reduction', ired, 0, 2048, 1)
	endif
	idf = M$DWINIT('Tuner Freq', tfreq, 
     &		-rate*.5d0, rate*.5d0,rate*.005d0)
	idg = M$LWINIT('Tuner Gain', tgain, -100, 100, 1)
	idc = M$LWINIT('Curr Cycle', 0, 1, -1, 1)
	idlh = M$LWINIT('Lost HostBuf', 0, 1, -1, 1)
	idlc = M$LWINIT('Lost CardBuf', 0, 1, -1, 1)
	if (ratio.gt.0.d0) idrat = M$DWINIT('Resampler', 
     &	  ratio, .5d0, 2.0d0,.001d0)
	if (alg.gt.0) ida = M$MWINIT('Algorithm', 
     &	  alg, 'Noop,User,Swap,LUT,AM,FM,PM,PSK,QPSK')
	do n = 1,nargs
	  write(cnum,'(3hArg,i1)') n
	  i = M$LWINIT(cnum(1:4), args(n), 1, -1, 1)
	enddo
c
c realtime verbose mode
	idv = 0
	verbose = M$GET_SWITCH('VERBOSE')
	if (verbose.ge.0) idv = M$LWINIT('Verbose', verbose, 0, 5, 1)
c
c init the PIC device for IO
	fmode = M$GET_SWITCH_DEF('FMODE',1)
	status = M$PIC_SETKEY (p, 0, KEY_RATIO, ratio, 8)
 111	continue
	status = M$PIC_MAPFILE (p, map, HIN, fmode) 
	if (status.le.0) call M$ERROR ('Unacceptable DMA input file')  
	i = M$PIC_GETKEY(p,0,KEY_TINC,tinc,4)
	mnbytes = map.bytes/multi
	call M$MOVE(map,mapi,L_DMAMAP)
	mapi.bytes = mnbytes
	do n = 1, multi
	  if (n.eq.1 .and. msync.le.1) then
	    flags = 0
	  else if (n.eq.1 .and. msync.gt.1) then
	    flags = FLG_SGO
	    if (sss) flags = FLG_RGO
	    if (xts) flags = FLG_XTGO
	  else if (n.eq.2 .and. .not.autoss) then
	    flags = FLG_SGO
	  else
	    flags = FLG_RGO
	  endif
	  dmac = M$PIC_IOPORT (p, type, port, feed, dir, bits, 
     &	NINT(rate), 2*(tfreq+(n-1)*dtfreq)/rate, ired, tgain, flags)
          if (dmac.le.0) call M$ERROR ('Bad I/O Port parameters')
	  mapi.offset = (n-1)*mnbytes
	  status = M$PIC_DMASETUP (p, dmac, dir, mapi, nblock, 0)
	  if (status.le.0) call M$ERROR ('Unacceptable channel for DMA')  
	  if (swap.gt.0) i = M$PIC_SETKEY(p,dmac,KEY_SWAP,swap,4)
	  mdmac(n) = dmac
	  mport(n) = port
	  if (autoss) then
	    port = port + tinc
	  else if (mod(n,2).eq.1) then
	    port = port + 1
	  else
	    port = port - 1 + tinc
	  endif
	enddo
	dmac = mdmac(1)
	port = mport(1)
	do n = 1,nargs
	  i = M$PIC_SETKEY(p,dmac,KEY_ARGS+n-1,args(n),4)
	enddo
c
c report the DMA channel
	if (M$GET_USWITCH('DMAC',tmpstr).gt.0) call M$LRSLT(tmpstr,dmac)
	status = M$PIC_GETKEY(p,dmac,KEY_NODMA,nodma,4)
c
c setup framed decimation
	if (type.eq.IOPT_MODULE .and. HIN.class.eq.2 .and. .not.host) then
	  status = M$PIC_SETKEY (p, dmac, KEY_FRAME, HIN.subsize, 4)
	  status = M$PIC_SETKEY (p, dmac, KEY_DEC, ired, 4)
	endif
c
c setup tuner resampler
	if (ratio.gt.0.d0) then
	  status = M$PIC_SETKEY (p, dmac, KEY_RATIO, ratio, 8)
	  status = M$PIC_GETKEY (p, dmac, KEY_RATIO, ratio, 8)
	  call M$DWPUT(idrat,ratio)
	endif
c
c init the packet parameters
	status = M$PIC_GETKEY (p, dmac, KEY_TCMODE, tcm, 4)
	pkt.keys(1) = 101
	pkt.keys(2) = 102
	pkt.keys(3) = 103
	pkt.keys(4) = 0
	pkt.channel = port
	pkt.rep = ICHAR(HOUT.data_rep(1:1))
	pkt.bpa = HOUT.bpa
	pkt.mode = ICHAR(HOUT.format(1:1))
	pkt.type = ICHAR(HOUT.format(2:2))
	pkt.tcmode = tcm
	pkt.tcstatus = 0
	pkt.tcwsec = 0
	pkt.tcfsec = 0
	pkt.tcoff = 0
	pkt.elem = tl*HOUT.ape
	pkt.ramphys = map.paddr
	pkt.ramsize = map.bytes
	tcstatuslast = 0
c
c check packet size / buffer ratio
	if (apacket.ge.0) then
	  iper =  mnbytes / nchan / (archtl*HOUT.bpa)
	  if ( iper*nchan*(archtl*HOUT.bpa) .ne. mnbytes) call M$ERROR 
     &		('Host buffer must be multiple of archive packet size')
	  apkt = pkt
	else
	  archtl = 1
	endif
	if (packet.ge.0) then
	  iper =  mnbytes / nchan / (tl*HOUT.bpe)
	  if ( iper*nchan*(tl*HOUT.bpe) .ne. mnbytes) call M$ERROR 
     &		('Host buffer must be multiple of packet size')
	  if (tcpp.lt.0) tcpp = iper / max(1,tskip)
	endif
c
c initialize parameters
        nbuf = 0 	! dynamic memory size
	npass = 0
	ncycle = 1
	call RAMSYNC (P_SYNCINIT,status)
	if (mgo.ge.9 .and. mgo.le.11) then
	  mgo = 0 ! indicate ready
	  if (autors.eq.-3) mgo = 2
	  call M$MWPUT(idm,mgo)
	  if (msyncid.gt.0) call M$MWPUT(msyncid-1,mgo)	
	  goto 1
	else
	  outoff = 0
	  lastout = 0
	  nlost = 0
	  mlost = 0
	endif
c
c signal start of processing block
	call M$SYNC()
c
c release resources
	if (mgo.eq.0) then
	  do n = 1,multi
	    status = M$PIC_DMAFUNC (p,mdmac(n),DMA_RESET)
	  enddo
	endif
c
c initial slave sync up
	if (msyncid.gt.0) call M$MWPUT(msyncid-1,mgo)	
 101	if (wait.gt.0) call M$PAUSE(wait)
c
c top of throttle loop
  1	do while (mgo.eq.0 .or. mgo.eq.3 .or. mgo.eq.4
     &			   .or.	mgo.eq.7 .or. mgo.eq.99)
	  call UPDATE(status,0)
	  isok = M$MWGET(idm,mgo)
	  if (mgo.eq.7) then ! restart ?
	    if (autors.ge.2) goto 99
	    mgo = 2 ! already stopped - just start
	    call M$MWPUT(idm,mgo)
	  elseif (mgo.eq.3 .or. mgo.eq.4) then
	    mgo = 0
	    call M$MWPUT(idm,mgo)
	  endif
	  ! validate tuner decimation 
	  if (mgo.ne.0 .and. tuner .and. mgo.ne.99) then
	    ired = M$PIC_TUNER_DEC (p,ired,-1,0)
	    call M$LWPUT (idd, ired)
	  endif
	  if (msyncid.gt.0) call M$MWPUT(msyncid-1,mgo)	
	  if (mgo.ge.8 .and. mgo.le.11) goto 999
	  if (Mc.break) goto 999
	  call M$PAUSE(pause)
	enddo
c
c get stride
	! reduction widget was polled in UPDATE
	if (ired.eq.0) ired = 1
	if (.not.host) then
	  idelta = 1	! thinning is done in card 
	else
 	  if (ired.lt.-1 .and. noblock) then
	    call M$WARNING('Cannot perform blocking on input data type')
	    ired = 1
	  endif
	  idelta = iabs(ired)
	endif
c
c calculate copy and stride lengths in bytes
	iskip = 1
	icopy = max( 1.d0, HIN.dbpe)
	mdbpe = max( HIN.dbpe, HOUT.dbpe )
	if (.not.host .or. icopy*(ired-1).lt.512) then	! small stride
	  iper = tl
	  if (iper.le.0) iper = max(1, NINT(L_bbuf/mdbpe))
	  if (tskip .gt. 1) then
	    iper = 1
	    iskip = tskip
	  endif
	else					! large stride
	  iper = 1 
	  iskip = idelta
	  if (tskip.gt.1) iskip = iskip*tskip
	endif
	ibuf = iper*mdbpe
	if (ibuf.gt.nbuf) then
	  call M$MFREE (nbuf,pbuf)
	  nbuf = ibuf
	  call M$MALLOC (nbuf,pbuf)
	endif
	HOUT.buf_type = HIN.buf_type
!	if (2*iper*delta.gt.timeout) timeout = 2*iper*delta
	tcdelta = -1				! reset tctolr check
c
c make sure the slaved PIC device is running
	if (msyncid.gt.0) then	
	  isok = M$MWGET (msyncid,ssync)
	  do while (ssync.eq.2 .and. .not.Mc.break)	! wait for slave
	    call M$PAUSE (pause)
	    isok = M$MWGET (msyncid,ssync)
	  enddo
	endif
c
c make sure the PIC device is running
	if (mpp.ne.1) then
	  do n = multi,1,-1
	   if (nodma.gt.0) then
	    mgo = 5
	    call M$MWPUT(idm,mgo)
	    status = M$PIC_DMAFUNC (p,mdmac(n),DMA_ENABLE)
	   elseif ((mgo.eq.2 .or. mgo.eq.5 .or. mgo.lt.-1) .and. autors.ne.-2) then
	    status = M$PIC_DMAFUNC (p,mdmac(n),DMA_CIRCULAR)
	   else
	    status = M$PIC_DMAFUNC (p,mdmac(n),DMA_ONESHOT)
	   endif
	  enddo
	  if (status.lt.0) then
	    call M$WARNING('Problem starting port: '//devlab)
	    mgo = 99
	    call M$MWPUT(idm,mgo)
	    goto 1
	  endif
	  mpp = 1
	  call RAMSYNC (P_SYNCSET,status)
	  if (msync.gt.1) call M$MWPUT (ids,3)	! report slave running
	  pkt.count = 0
	  pkt_count = 0
	  tccnt = 0
	endif 
c
c spin
	do while (mgo.eq.5)
	  call M$PAUSE(pause)
	  call UPDATE(status,0)
	  isok = M$MWGET(idm,mgo)
	  if (Mc.break) goto 999
        enddo
c
c archive 
	if (mgo.eq.6) then
	  mpp = 2
	  status = M$PIC_DMAFUNC (p,dmac,DMA_STOP)
	  nstop = status/(HIN.dbpe*idelta)		! logical stop offset
	  if (nstop.gt.HIN.size) nstop=HIN.size
	  nstop = max(0,nstop)
	  if (msyncid.gt.0) call M$MWPUT (msyncid-1,mgo)	! trigger slave 
	  npass = ncycle-1-nlost
	endif
c
c update the pass through RAM buffer count
  2	npass = npass + 1
	call M$LWPUT (idc,npass)
c
c set xfer parameters
  3	dnext = 0
	adone = 0
	ntogo = HIN.size / multi
c
c debug statistics output
	if (stats .or. statlab.ne.' ') then
	  status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	  fstat = FLOAT(status)*100/mnbytes
	  if (stats) print *,'Sourcepic top ',npass,ncycle,iper*iskip*HIN.ape,fstat
	  if (statlab.ne.' ') call M$FRSLT (statlab,fstat)
	endif
c
c adjust start/stop pointers for split buffer archive mode
	if (mgo.eq.6) then
	  if (nstop.ge.0) then
	    dnext = nstop
	    ntogo = HIN.size/multi - nstop
	    nstop = -nstop
	  else
	    ntogo = -nstop
	    nstop = 0
	    npass = npass - 1
	  endif
c
c warn if we are falling way behind
	elseif (ncycle.gt.npass+nlost .and. mgo.ne.1) then
	  status = M$L2A (ncycle-(npass+nlost),cnum)
	  call M$WARNING ('Fell behind '//cnum//' RAM buffers')
	  nlost = (ncycle-npass)
	  call M$LRSLT (lostlab,nlost)
	endif
c
c wait for current data pointer
	elapse = 0
	do while (npass+nlost.gt.ncycle .and. mgo.lt.7)
          call RAMSYNC (P_SYNCSTAT,status)
	  call UPDATE(status,1)
	  call M$PAUSE (pause)
	  elapse = elapse + pause
	  if (autors.ge.2 .and. elapse.gt.timeout) goto 99
	  if (Mc.break) goto 999
	enddo
c
c loop through buffers of data  (data buffer loop)
c
	do while (ntogo.gt.0 .and. .not.Mc.break)
	  nget = min(iper,ntogo)
          call RAMSYNC (P_SYNCSTAT,status)
c
c get new real time controls
	  call UPDATE(status,1)
c
c check for falling behind
	  if (npass+nlost.eq.ncycle-1) then
	    status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	    nnext = dnext*HIN.dbpe
	    if (status .gt. nnext) then
	      call M$WARNING ('Falling behind one RAM buffer')
	      nlost = nlost + 1
	      call M$LRSLT (lostlab,nlost)
	    endif
	  endif
c
c add timecode to packet header (top of buffer or per packet)
	  if (tcmode.ne.'OFF') then
	    if (pkt_count.eq.0) then
	      ! wait for the input clock to be active
	      elapse = 0
	      do while (M$PIC_DMAFUNCX (p,dmac,DMA_STATUS) .eq. 0
     &		.and. (elapse.lt.timeout .or. autors.eq.0))
	        call UPDATE(status,1)
	        j = M$MWGET(idm,i)
	        if (i.eq.4 .or. i.ge.7 .or. Mc.break) goto 97
	        call M$PAUSE(pause)
		elapse = elapse+pause
	      enddo
	      if (HOUT.pipe.eq.0) then
	        status = M$PIC_TC (p, dmac, 0.d0, delta, 
     &			pkt.tcwsec, pkt.tcfsec, FLG_TCINTERP)
	        call M$PUT_EPOCH (HOUT, 
     &			tcoff+pkt.tcwsec, pkt.tcfsec, .false.)
	        call M$UPDATE_HEADER (HOUT)
	      endif
	    endif
	    tccnt = tccnt + 1
	    if ((pkt_count.eq.0) 
     &		.or. (tcpp.gt.0 .and. tccnt.ge.tcpp) ) then
	      tccnt = max(0,tccnt-tcpp)
	      pkt.tcstatus = M$PIC_TC (p, dmac, pkt.tcoff, delta, 
     &			pkt.tcwsec, pkt.tcfsec, 0)
	      if (pkt.tcstatus .gt. 0) then
		dtime = pkt.tcwsec - tcwlast
		if (pkt.tcwsec .lt. 100.d0) then	! 1st 100 sec of year
		  j = NINT(-dtime/86400)
		  if (j.eq.365 .or. j.eq.366) then	! assume ray day
		    tcoff = tcoff + j*86400
		    dtime = dtime + j*86400
		  endif
		endif
		dtime = dtime + pkt.tcfsec - tcflast
		dsamp = pkt.tcoff-tcofflast
		tcerr = dtime - dsamp*tcdelta
		if (pkt_count.gt.1 .and. tctolr.gt.0 .and. 
     &			tcdelta.gt.0 .and. abs(tcerr).gt.tctolr) then
		  if (info) print *, 'Time code slip > tolr ',
     &					tcerr,tctolr,pkt.count,dmac
		  if (autors.gt.0) then
		    call M$MWPUT (idm,7)
	            goto 97
		  endif
		endif
		if (pkt_count.gt.0 .and. dsamp.gt.1) then
		  tcdelta = dtime/dsamp
		  if (tcdelta.le.0) tcdelta = delta
		endif
		tcwlast = pkt.tcwsec
		tcflast = pkt.tcfsec
		tcofflast = pkt.tcoff
		! now adjust to be relative to the packet start
		pkt.tcwsec = pkt.tcwsec + tcoff  
		if (apacket .ge. 0) then
		  apkt.tcwsec = pkt.tcwsec
		  apkt.tcfsec = pkt.tcfsec
		  apkt.tcstatus = pkt.tcstatus
                  apkt.tcoff = pkt.tcoff - DBLE(nlost*epb*ape)
     &                       - apkt_count*DBLE(apkt.elem)
		endif
               pkt.tcoff = pkt.tcoff - DBLE(nlost*epb*ape)
     &                   - pkt_count*DBLE(pkt.elem*iskip)

	if (tcslab.ne.' ') call M$DRSLT (tcslab,pkt.tcwsec+pkt.tcfsec)
	      else
	if (tcslab.ne.' ') call M$DRSLT (tcslab,DBLE(pkt.tcstatus))
		if ((autors.le.0 .or. pkt.tcstatus.ne.tcstatuslast) .and.info)
     &	print *, '*** Bad TC status ',pkt.tcstatus,' see pic help tc'
	        if (autors.gt.0) then
		  call M$MWPUT (idm,7)
	          goto 97
		endif
	      endif
	      tcstatuslast = pkt.tcstatus
	    endif
	  endif
c
c check for max output branch
	  if (maxout.gt.0.d0 .and. HOUT.offset+nget.ge.maxout) then
	    nget = maxout - HOUT.offset
	    if (nget.le.0) then
	      call M$MWPUT(idm,8)
	      goto 97
	    endif
	  endif
c
c top of multi-channel data loop
	  do n = 1,max(nchan,multi)
c
c wait until data is available
	  if (npass+nlost.ge.ncycle) then
	    if (archmode.eq.ARCH_RT) then
	      nnext = (dnext+nget*iskip)*HIN.dbpe 
	    elseif (nchan.gt.1) then
	      nnext = (dnext+n*nget)*HIN.dbpe 
	    else
	      nnext = (dnext+nget)*HIN.dbpe 
	    endif
	    if (multi.gt.1) then
	      status = M$PIC_DMAFUNCX (p,mdmac(n),DMA_STATUS)
	    else
	      status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	    endif
	    elapse = 0
	    do while (status.lt.nnext .and. npass+nlost.ge.ncycle 
     &		.and. mgo.ne.7 .and. .not.Mc.break)
	      call UPDATE(status,1)
	      call M$PAUSE(pause)
              call RAMSYNC (P_SYNCSTAT,status)
	      elapse = elapse+pause
	      if (autors.gt.0 .and. elapse.gt.timeout) then
	        call M$MWPUT(idm,7)
		call M$WARNING('Detected DMA stall - auto restarting')
		if (n.eq.1) goto 97
	      endif
	      j = M$MWGET(idm,i)
	      if (n.eq.1 .and. (i.eq.4 .or. i.eq.7 .or. i.eq.8)) goto 97
	      if (multi.gt.1) then
	        status = M$PIC_DMAFUNCX (p,mdmac(n),DMA_STATUS)
	      else
	        status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	      endif
	    enddo
	  endif
c
c get the data
	  ! its already in memory - go for speed
	  pout = map.vaddr + (dnext*HIN.dbpe)
	  if (multi.gt.1) pout = pout + (n-1)*mnbytes
	  if (nchan.gt.1) pout = pout + (n-1)*nget*NINT(HIN.dbpe)
	  ngot = nget
c
c large or no skip
	  if (iper.eq.1 .or. idelta.eq.1) then	
	    npot = ngot
c
c regular thinning/blocking operation
	  else				
	    ! move is smart enough not to move onto itself
	    call M$MOVE (out,buf,ngot*HIN.bpe)
	    pout = pbuf	! FILAD now from buf
	    npot = (ngot+idelta-1)/idelta
	    if (ired.ge.0) then				! thinning
	      call M$VMOVN (buf,idelta,buf,1,npot,icopy)
	    else					! blocking
	      HOUT.buf_type = HOUT.format(2:2)
	      call M$REFORMAT (buf,HIN.format,
     &			buf,HOUT.buf_type, npot*idelta)
	      call M$VTYPE (HOUT.buf_type)
	      if (spa .eq. 2) then
		call M$CVBLK (buf,buf,idelta,ngot)
	      else
		call M$VBLK (buf,buf,idelta,ngot)
	      endif
	    endif
	  endif
c
c output packet headers and data to pipes/files
	  i = npot * HOUT.dbpe
	  if (packet.ge.0) then
	    if (multi.gt.1) pkt.channel = mport(n)
	    if (renum.gt.0) pkt.channel = renum-1+n
	    pkt.elem = npot * HOUT.ape
	    pkt.dataoffset = pout - map.vaddr
	    pkt.datasize = i
	    if (pktmod.eq.1) then
	      pkt.xdelta = delta
	      pkt.xstart = pkt.tcwsec+pkt.tcfsec-pkt.tcoff*delta
	      pkt.xstart = pkt.xstart - pkt_count*pkt.elem*delta
	    elseif (pktmod.eq.2) then
	      pkt.xdelta = rate
	      pkt.xstart = tfreq
	    elseif (pktmod.eq.3) then
	      i=M$PIC_GETKEY(p, dmac, KEY_RFFREQ, dval, 8)
	      pkt.xdelta = rate
	      pkt.xstart = dval
	    endif
	    if (packet.eq.0) call M$FILAD (HOUT,pkt,ipkt)
	    if (packet.gt.0) call M$FILAD (HPACK,pkt,1)
	  endif
	  if (HOUT.open) call M$FILAD (HOUT,out,npot)
	  lastout = HOUT.offset
c
c bottom of multi-channel data loop
	  enddo
c
c write out real time archive data
	  if (archmode.eq.ARCH_RT) then
	    nnext = min(HIN.size,dnext+nget*iskip) * HIN.ape
	    do while (nnext-adone .ge. archtl)
	     do n = 1,max(nchan,multi)
              pout = map.vaddr + adone*HIN.bpa
              if (multi.gt.1) pout = pout + (n-1)*mnbytes
              if (nchan.gt.1) pout = pout + (n-1)*ngot*HIN.bpa
	      i = nnext-adone
	      if (apacket.ge.0) then
	        i = min(archtl,i)
		apkt.elem = i
		if (multi.gt.1) apkt.channel = mport(n)
		if (renum.gt.0) apkt.channel = renum-1+n
		if (apacket.eq.0) call M$FILAD (HARCH,apkt,ipkt)
		if (apacket.gt.0) call M$FILAD (HAPACK,apkt,1)
	      endif
	      call M$FILAD (HARCH,out,i)
	     enddo
	     apkt.count = apkt.count+1
	     apkt_count = apkt_count+1
	     apkt.tcoff = apkt.tcoff - apkt.elem
	     adone = adone + i*nchan
	    enddo
	    if (archdur.ge.0 .and. HARCH.offset.ge.HARCH.size) then
	      call M$CLOSE(HARCH)
	      if (apacket.gt.0) call M$CLOSE(HAPACK)
	      archmode = ARCH_OFF
	      if (archid.ne.0) 
     &	      call M$SEND_MSGL ('ARCHDONE',0,archid,0,0,0,' ',0,0)
	    endif
	  endif
c
c update pointers
	  pkt.count = pkt.count + 1
	  pkt_count = pkt_count + 1
	  if (packet.ge.0) pkt.tcoff = pkt.tcoff - pkt.elem*iskip
	  i = nchan*ngot*iskip
	  ntogo = ntogo - i
	  dnext = dnext + i
c
c update realtime file fields
	  if (rtfile) then
	    HIN.in_byte = (dnext+(npass-1)*HIN.size)*HIN.dbpe
	    call M$UPDATE_HEADER (HIN)
	  endif
c
c check for large misalignment of slave
	  if (ntogo.eq.0 .and. autors.gt.0 .and. syncdata) then
	    j = M$MWGET (msyncid+5,i)
	    if ( abs(i-npass) .ge. 2) then
	call M$WARNING ('Large Master/Slave misalignment - restarting')
	      call M$MWPUT (idm,7)
	    endif
	  endif
c
c check throttle control widget
  97	  isok = M$MWGET (idm,mgo)
  	  if (msyncid.gt.0 .and. isok.gt.0) then
	    isok = M$MWGET (msyncid+5,i)
	    do while (syncdata .and. i.lt.npass .and. .not.Mc.break)
	      call M$PAUSE(pause)
	      isok = M$MWGET (msyncid+5,i)
	    enddo
	    call M$MWPUT (msyncid-1,mgo)	
	  endif
	  if (mgo.eq.4 .or. mgo.eq.5) ntogo = 0
	  if (mgo.eq.7 .or. mgo.eq.8) ntogo = 0

	enddo
c
c update the status widgets
  99	continue
	call M$LWPUT(idlh,nlost)
	i = M$PIC_DMAFUNC(p,dmac,DMA_LOST)
  	call M$LWPUT(idlc,i)
	if (i.gt.mlost) call M$WARNING('Lost one or more Card Buffers')
	mlost = i
	if (seqfill.ne.' ') then
	  i = M$PIC_GETKEY(p, dmac, KEY_SEQFILL, j, 4)
	  call M$LRSLT(seqfill,j)
	endif
	if (seqerr.ne.' ') then
	  i = M$PIC_GETKEY(p, dmac, KEY_SEQERR, j, 4)
	  call M$LRSLT(seqerr,j)
	endif
	if (ntplab.ne.' ') then
	  i = M$PIC_GETKEY(p, dmac, KEY_NTPOFF, dval, 8)
	  call M$DRSLT(ntplab,dval)
	endif
c
c flush packet header
	if (HPACK.open .and. HPACK.pipe.eq.0) then
	  call M$HCBFUNC(HPACK,HCBF_FLUSH,0)
	endif
	if (archmode.eq.ARCH_RT .and. flush) then
	  call M$HCBFUNC(HARCH,HCBF_FLUSH,0)
	  if (apacket.gt.0) call M$HCBFUNC(HAPACK,HCBF_FLUSH,0)
	endif
c
c stop PIC if necessary
	if (mgo.eq.1 .or. mgo.eq.-1 .or. mgo.eq.3 .or. mgo.eq.4 
     &			.or. mgo.ge.7 .or. autors.lt.0) then
	  if (mpp.eq.1 .and. msyncid.gt.0) then
	    isok = M$MWGET (msyncid+5,i)
	    if (syncdata .and. i.gt.npass) goto 2	! do one more
	    isok = M$MWGET (msyncid,ssync)
	    do while (ssync.eq.3 .and. .not.Mc.break)	! wait for stop
	      call M$PAUSE (pause)
	      isok = M$MWGET (msyncid,ssync)
	    enddo
	    isok = M$MWGET (msyncid+5,i)
	    if (syncdata .and. i.gt.npass) goto 2	! do one more
	  endif
	  if (mgo.eq.7 .and. autors.ge.2) then
	    call M$PAUSE(0.1)
	    ! make sure the other channels will at least DMA stall
	    status = M$PIC_DMAFUNC(p,dmac,DMA_KILL)
	  endif
	  do n = 1,multi
	    if (mpp.eq.1) status = M$PIC_DMAFUNC (p,mdmac(n),DMA_STOP)
	    if (mpp.eq.1) status = M$PIC_DMAFUNC (p,mdmac(n),DMA_RESET)
	  enddo
	  mpp = 0
	  npass = 0
	  nlost = 0
	  mlost = 0
	  ncycle = 1
	  outoff = lastout
	  pkt.count = 0
	  pkt_count = 0
	  tcstatuslast = 0
	  if (msync.gt.1) then
	    if (mgo.eq.7) then
	      mgo = 0 ! slave reports stopped
	      call M$MWPUT (idm,mgo)
	    endif
	    call M$MWPUT (ids,2)	! report slave wait
	  endif
	  if (autors.eq.-3) mgo = 11	! reopen
	  elapse = -1	! extra second to wait for other channels
	  do while (mgo.eq.7 .and. autors.ge.2 .and. elapse.lt.timeout 
     &		.and. M$PIC_DMAFUNC(p,dmac,DMA_ACTIVE).gt.0)
	    call M$PAUSE(0.1)
	    elapse = elapse + 0.1
	    if (elapse.ge.timeout) then
	      call M$WARNING ('All DMA channels on this input did not shut down')
	      if (autors.ge.3) then
		status = M$PIC_DMAFUNC(p,dmac,DMA_BURY)
		call M$WARNING ('Buried the non-responsive channels')
	      endif
	    endif
	  enddo
	  if (autors.ge.2) call M$PAUSE(0.5)
	elseif (mgo.eq.6) then
	  if (nstop.ne.0) goto 3
	  mgo = 5
	  call M$MWPUT (idm,mgo)
	endif
c
	if (archmode.eq.ARCH_RT .and. archsf.gt.0) then
	  call M$CLOSE(HARCH)
	  if (apacket.gt.0) call M$CLOSE(HAPACK)
	  archmode = ARCH_WAIT
	endif
c
c go back for replay
	if (mgo.ge.0) then
	  if (mgo.eq.1.or.mgo.eq.3.or.mgo.eq.4) then
	    mgo = 0
	    call M$MWPUT (idm,mgo)
	  endif
	  if (mgo.eq.2 .and. .not.Mc.break .and. autors.ne.-2) goto 2
	  if (mgo.eq.5 .and. .not.Mc.break) goto 1
	  if (mgo.eq.7) then
	    mgo = 2
	    if (autors.ge.4) mgo = autors
	    call M$MWPUT (idm,mgo)
	    if (msyncid.gt.0) call M$MWPUT(msyncid-1,mgo)	
	  endif
	  if (mgo.lt.8 .and. .not.Mc.break) goto 101
	else
	  mgo = mgo + 1 ! replicate mode
	  call M$MWPUT (idm,mgo)
	  if (mgo.lt.0 .and. .not.Mc.break) goto 1
	endif
c
c close PIC device
  999	continue
	do n = 1,multi
	  status = M$PIC_DMAFUNC (p,mdmac(n),DMA_CANCEL)
	enddo
	status = M$PIC_MAPFILE (p, map, HIN, -fmode) 
	if (mgo.ne.11) status = M$PIC_CLOSE (p)
c
c restart with new device ?
	if (mgo.ge.9 .and. mgo.le.11 .and. .not.Mc.break) then
	  if (mgo.eq.9 .and. M$RFIND(devlab,devstr,dummy).ne.'A') 
     &	    call M$ERROR ('Device argument not a proper result name: '
     &		//devlab)
	  if (mgo.ne.11) then
	    i  = M$HWF_OPEN (hwf) 
	    ls = M$HWF_ALIAS (hwf, devstr, string) 
	    i  = M$HWF_CLOSE (hwf) 
	    string = flgstr(1:lsf)//','//string(1:ls)//','//CHAR(0)
	    status = M$PIC_OPEN (p,string,Mc.break,flags)
	    if (status .le. 0) call M$ERROR ('ReOpening port: '//string)
	  endif
	  flags = 0
	  if (boot) flags = flags .or. FLG_BOOT
cJGS	  status = M$PIC_RESET (p, flags) 
	  if (p.ptype.ne.type) call M$ERROR
     &	    ('Not allowed to dynamically change port to different type')
	  if (tuner) then
	    ired = M$PIC_TUNER_DEC (p,ired,-1,0)
	    call M$LWPUT (idd, ired)
	  endif
	  port = p.pindex
	  dmac = -1
	  goto 111
	endif
c
c close input/output files
	call M$CLOSE (HIN)
	call M$CLOSE (HOUT)
	if (packet.gt.0) call M$CLOSE (HPACK) 
	if (archmode.ne.ARCH_OFF) then
	  call M$CLOSE (HARCH)
	  if (apacket.gt.0) call M$CLOSE(HAPACK)
	endif
c
	call M$RETURN
	end


	subroutine RAMSYNC (mode,status)
	implicit none
	include 'sourcepic.inc'
	integer*4 mode
	real*4 time

	if (mode.eq.P_SYNCINIT) then		! to initialize
	  statuslast = 0
	  return
	endif
	status = M$PIC_DMAFUNCX (p,dmac,DMA_STATUS)
	if (status.eq.-1) call M$ERROR ('ICE-PIC is down')
	status = max(0,min(mnbytes,status))
	if (status.lt.statuslast .or. mode.eq.P_SYNCSET) then 	! next buffer
	  time = SECNDS(0.0)
	  time = time - status/(rate*dbpe/ape)
	  call M$FRSLT (synclab, time)
  	  ncycle = M$PIC_DMAFUNC (p,dmac,DMA_CYCLE) + 1	! 0->1 based
	elseif (status.eq.0 .and. mgo.eq.1) then
	  ! check for small buffer fast completion case
  	  ncycle = M$PIC_DMAFUNC (p,dmac,DMA_CYCLE) + 1	! 0->1 based
	endif
	statuslast = status
	return
	end


	subroutine UPDATE (status,mode)
	implicit none
	include 'sourcepic.inc'
	include 'qmessages.inc'
	real*8	time, trigger, soy, fsoy, sample, timet, timed
	integer*4 mode, ratex, iredx, freqx, gainx, algx, argx, ratx
	integer*4 nelem, nm, lostoff, stat, cycle, index
	logical*4 stopping / .false. /
	real*8 ttfreq
	save
	integer*4 larch, parch

	mqh.info = 0	! set for multi-mode channel queue
	! look for messages
	if (Mu.id .le. 0) goto 100
	if (stopping) then
	  if (mgo.ne.0) goto 100
	  trigger = 0
	  mqh.info = 0
	  stopping = .false.
	  goto 1
	endif
	if (M$GET_MSG(mqh,mqd,L_mqd,0.0,0).le.0) goto 100
 1	if (mqh.name .eq. 'MGO') then
	  if (mqh.ndata.gt.0 .and. mqd.dbuf(1).gt.0) then
	    trigger = mqd.dbuf(1)
	  else
	    trigger = 0
	  endif
 2	  call M$NOW (time1,time2)
	  time = time1 + time2
	  if (mqh.info.eq.0 .and. mgo.ne.0) then
	    if (mgo.eq.2 .or. mgo.gt.4) call M$MWPUT (idm,4)
	    stopping = .true.	! now we are
	    goto 100
	  elseif (trigger.eq.0) then
	  elseif (trigger-time.le.0) then
	    ! take it now
	  elseif (trigger-time.gt.600.d0) then
	    call M$WARNING ('Huge trigger offset in message')
	  else
	    call M$PAUSE (Mc.pause)
	    goto 2
	  endif
	  call M$MWPUT (idm, mqh.info)
     	  call M$SEND_MSGL ('=MGO',0,mqh.sender,mqh.info,0,1,'D',time,0)
	elseif (mqh.name .eq. 'DEVICE') then
	  if (mgo.ne.0) call M$ERROR 
     &      ('DEVICE message can only be processed on a stopped port')
	  if (mqh.info .gt. 0) then
	    p.pindex = mqh.info
	    mgo = 11
	  else
	    i = M$LENGTH(mqd.sbuf(1:40))
	    devstr = mqd.sbuf(1:i)
	    mgo = 10
	  endif
	  call M$MWPUT (idm, mgo)
	elseif (mqh.name .eq. 'RFDG') then
	  call M$LWPUT (idr, NINT(mqd.dbuf(1)) )
	  call M$DWPUT (idf, mqd.dbuf(2) )
	  call M$LWPUT (idd, NINT(mqd.dbuf(3)) )
	  call M$LWPUT (idg, NINT(mqd.dbuf(4)) )
	  if (multi.gt.1 .or. mqh.info.eq.1) rate = -1
	  if (multi.gt.1 .or. mqh.info.eq.1) tfreq = -1
	  if (multi.gt.1 .or. mqh.info.eq.1) ired = -1
	  if (multi.gt.1 .or. mqh.info.eq.1) tgain = -1
	elseif (mqh.name .eq. 'RATE') then
	  call M$DWPUT (idr, mqd.dbuf(1) )
	  if (multi.gt.1 .or. mqh.info.eq.1) rate = -1
	elseif (mqh.name .eq. 'FREQ') then
	  call M$DWPUT (idf, mqd.dbuf(1) )
	  if (multi.gt.1 .or. mqh.info.eq.1) tfreq = -1
	  if (type.eq.IOPT_TBANK) then
	    i = M$PIC_SETKEY(p, dmac, KEY_CHAN, mqh.info, 4)
	  endif
	elseif (mqh.name .eq. 'DEC') then
	  call M$LWPUT (idd, NINT(mqd.dbuf(1)) )
	  if (multi.gt.1 .or. mqh.info.eq.1) ired = -1
	elseif (mqh.name .eq. 'GAIN') then
	  call M$LWPUT (idg, NINT(mqd.dbuf(1)) )
	  if (multi.gt.1 .or. mqh.info.eq.1) tgain = -1
	elseif (mqh.name .eq. 'RATIO') then
	  call M$DWPUT (idrat, mqd.dbuf(1) )
	elseif (mqh.name .eq. 'NFREQ') then
	  ttfreq = tfreq*2/rate
	  i = M$PIC_SETKEY(p, dmac, KEY_CHAN, mqh.info, 4)
	  i = M$PIC_GETKEY (p, dmac, KEY_NFREQ, ttfreq, 8)
	  mqd.dbuf(1) = ttfreq * (rate/2)
	  call M$SEND_MSGL ('=NFREQ',0,mqh.sender,mqh.info,
     &				0,1,'D',mqd.dbuf(1),0)
	elseif (mqh.name .eq. 'STATUS') then
	  mqd.dbuf(1) = mgo
	  mqd.dbuf(2) = msync
	  mqd.dbuf(3) = rate
	  mqd.dbuf(4) = ired
	  mqd.dbuf(5) = tfreq
	  mqd.dbuf(6) = tgain
	  mqd.dbuf(7) = ncycle
	  if (mqh.info.gt.0 .and. mqh.info.le.7) then
	    call M$SEND_MSGL ('=STATUS',0,mqh.sender,mqh.info,
     &				0,1,'D',mqd.dbuf(mqh.info),0)
	  else
	    call M$SEND_MSGL ('=STATUS',0,mqh.sender,mqh.info,
     &				0,7,'D',mqd,0)
	  endif
	elseif (mqh.name .eq. 'TC') then
	  trigger = mqd.dbuf(1)
	  if (trigger .eq. -3) then
	    status = M$PIC_TC (p, dmac, sample, delta, 
     &				soy, fsoy, 0)
	    soy = soy + tcoff
	  else if (trigger .eq. -2) then
	    trigger = outoff
	    fsoy = pkt.tcfsec + pkt.tcoff*delta
	    soy  = pkt.tcwsec + DINT(fsoy)
	    fsoy = fsoy - DINT(fsoy)
	    status = pkt.tcstatus
	  else
	    if (trigger.eq.-1) trigger = lastout
	    lostoff = nlost * epb 
	    sample = (trigger-outoff+lostoff) * ape
	    if (ired.gt.1 .and. type.eq.IOPT_MODULE) sample=sample*ired
	    status = M$PIC_TC (p,dmac,sample,delta, 
     &				soy, fsoy, FLG_TCINTERP)
	    soy = soy + tcoff
	  endif
	  mqd.dbuf(1) = trigger
	  mqd.dbuf(2) = soy
	  mqd.dbuf(3) = fsoy 
	  call M$SEND_MSGL ('=TC',0,mqh.sender,status,0,3,'D',mqd,0)
	elseif (mqh.name .eq. 'JOIN') then
	  if (mqh.info.gt.0) i = M$PIC_SETKEY (p,dmac,KEY_IPVLAN,mqh.info,4)
	  i = M$PIC_STR2IP (p,mqd.sbuf(1:16))
	  i = M$PIC_SETKEY (p,dmac,KEY_IPCONN,i,4)
	elseif (mqh.name .eq. 'LEAVE') then
	  if (mqh.info.gt.0) i = M$PIC_SETKEY (p,dmac,KEY_IPVLAN,mqh.info,4)
	  i = M$PIC_STR2IP (p,mqd.sbuf(1:16))
	  i = M$PIC_SETKEY (p,dmac,KEY_IPDISC,i,4)
	elseif (mqh.name .eq. 'ARCHIVE') then
	  if (archmode .ne. ARCH_OFF) then
	    call M$WARNING ('Previous ARCHIVE not completed yet')
	    call M$SEND_MSGL ('=ARCHIVE',0,archid,-1,0,0,' ',mqd,0)
	  else
	    archname = mqd.sbuf(1:80)
	    archtime = mqd.dbuf(11)
	    archdur  = mqd.dbuf(12)
	    archid   = mqh.sender
	    archmode = ARCH_WAIT
	    if (archsf.gt.1) archsf = 1
	  endif
	elseif (mqh.name .eq. 'ARCHDONE' 
     &	   .or. mqh.name .eq. 'ARCHSTOP') then
	  if (archmode.eq.ARCH_RT) then
	    call M$CLOSE(HARCH)
	    if (apacket.gt.0) call M$CLOSE(HAPACK)
	    archmode = ARCH_OFF
	    call M$SEND_MSGL ('ARCHDONE',0,archid,0,0,0,' ',mqd,0)
	  else
	    call M$WARNING ('No RT ARCHIVE active for ARCHDONE')
	  endif
        elseif (mqh.name .eq. 'RFFREQ') then
          i = M$PIC_SETKEY (p, dmac, KEY_RFFREQ, mqd.dbuf(1), 8)
        elseif (mqh.name .eq. 'RFGAIN') then
          i = M$PIC_SETKEY (p, dmac, KEY_RFGAIN, mqd.ibuf(1), 4)
        elseif (mqh.name .eq. 'REPLAY') then
          mgo = mqh.info
	elseif (mqh.name .eq. 'EXIT') then
	  call M$MWPUT (idm,8)
	else
	  call M$WARNING ('Unexpected message: '//mqh.name)
	endif

 100	continue	! look for widgets
	ratex = M$DWGET(idr,rate)
	iredx = M$LWGET(idd,ired)
	freqx = M$DWGET(idf,tfreq)
	gainx = M$LWGET(idg,tgain)
	algx  = 0
	argx  = 0
	ratx  = 0
	if (nargs.ge.0) then
	  algx = M$MWGET(ida,alg)
	  do j = 1,nargs
	    if (M$LWGET(ida+j,args(j)).gt.0) argx = JIBSET(argx,j)
	  enddo
	endif
	if (ratio .gt. 0.d0) ratx  = M$DWGET(idrat,ratio)
	nm = mqh.info
	if (nm.lt.1 .or. nm.gt.multi) nm = 0
	if (freqx.gt.0) then
	  tfreq = (rate/2) * M$PIC_TUNER_FREQ (p,2*tfreq/rate,0)
	  call M$DWPUT(idf,tfreq)
	endif
	if (ratex.gt.0 .or. iredx.gt.0) then
	  delta = (1/rate)
	  if (type.ne.IOPT_MODULE) delta = ired*delta*spa
	  tcdelta = -1
	  if (tcmode.ne.'OFF' .and. mgo.ne.0) then
	    if (autors.gt.0) call M$LWPUT (idm,7)
	    if (autors.eq.0 .and. ratex.gt.0) call M$WARNING 
     &	('Sample rate change while acquiring may invalidate timecode')
	  endif
	endif
	if  (iredx.gt.0) then
	  i = ired
	  if (type.eq.IOPT_TUNER .or. type.eq.IOPT_TBANK) then
	    ired = M$PIC_TUNER_DEC (p,ired,-1,0)
	  endif
	  if (ired.ne.i) then
	    call M$LWPUT (idd, ired)
	    if (info) print *, 'Tuner decimation limited to ',ired
	  endif
	  if (tcmode.ne.'OFF' .and. mgo.ne.0) then
	    if (autors.gt.0) call M$LWPUT (idm,7)
	    if (autors.eq.0) call M$WARNING 
     &	('Tuner decimation change while acquiring invalidates timecode')
	  endif
	endif
	do n = 1,multi	! loop through multi-channel structure
	 if (nm.eq.0 .or. n.eq.nm) then
	  if (ratex.gt.0) then
	    i = M$PIC_SETKEY (p, mdmac(n), KEY_RATE, NINT(rate), 4)
	  endif
	  if  (iredx.gt.0) then
	    i = M$PIC_SETKEY(p, mdmac(n), KEY_DEC, ired, 4)
	  endif
	  if (ratex.gt.0 .or. iredx.gt.0 .or. freqx.gt.0) then
	    ttfreq = tfreq
	    if (nm.eq.0) ttfreq = tfreq + (n-1)*dtfreq
	    i = M$PIC_SETKEY (p, mdmac(n), KEY_FREQ, 2*ttfreq/rate, 8)
	  endif
	  if  (gainx.gt.0) then
	    i = M$PIC_SETKEY(p, mdmac(n), KEY_GAIN, tgain, 4)
	  endif
	  if  (algx.gt.0) then
	    i = M$PIC_SETKEY(p, mdmac(n), KEY_ALG, alg, 4)
	  endif
	  if  (argx.ne.0) then
	   do j = 1,nargs
	    if (BTEST(argx,j)) i = 
     &		M$PIC_SETKEY(p, mdmac(n), KEY_ARGS+j-1, args(j), 4)
	   enddo
	  endif
	  if  (ratx.gt.0) then
	    i = M$PIC_SETKEY(p, mdmac(n), KEY_RATIO, ratio, 8)
	    i = M$PIC_GETKEY(p, mdmac(n), KEY_RATIO, ratio, 8)
	    call M$DWPUT(idrat,ratio)
	  endif
	 endif
	enddo

	if (archmode .eq. ARCH_WAIT) then
	  stat = M$PIC_DMASTAT (p,mdmac(1),index,cycle)
 	  call M$NOW (time1,time2)
	  time = time1 + time2  ! current time
	  timet = HIN.size * ape * delta
	  time1 = archtime
	  time2 = archdur
	  status = 1
	  if (archdur.le.0.0) time2 = timet
	  if (time1.le.0.0) time1 = time-time1-.001
	  if (archtime .eq. 0 .or. archdur .lt. 0) then
	    sample = ((npass-1)*HIN.size+dnext)*HIN.ape 
	    if (mpp.eq.1) archmode = ARCH_RT
	  elseif (timet .lt. time2) then
	    call M$WARNING ('ARCHIVE length longer than buffer')
	    archmode = ARCH_OFF
	    status = -2
	  elseif (time1 .lt. time-timet) then
	    call M$WARNING ('ARCHIVE length not in current buffer')
	    archmode = ARCH_OFF
	    status = -3
	  elseif (time1 .gt. time+timet) then
	    call M$WARNING ('ARCHIVE too far in future')
	    archmode = ARCH_OFF
	    status = -4
	  elseif (time1+time2.gt.time) then
	    ! wait for buffer to be available
	  else 
	    parchbuf = 0
	    larch = (time2/delta) * HIN.bpa
	    call M$MALLOC(larch,parchbuf)
	    index = index/HIN.bpa - NINT((time-time1)*rate)
	    sample = cycle*HIN.size*HIN.ape + index
	    archoff = index*HIN.bpa
	    ! capture buffer into temp memory
	    parch = map.vaddr
	    if (archoff .lt. 0) then	! from tail of last pass + some
	      nelem = min(-archoff,larch)
	      call M$MOVE (%val(parch+map.bytes+archoff),archbuf,nelem)
	      call M$MOVE (%val(parch),archbuf(nelem+1),larch-nelem)
	    else
	      call M$MOVE (%val(parch+archoff),archbuf,larch)
	    endif
	    archmode = ARCH_SNAP
	  endif
	  if (archmode.eq.ARCH_RT .or. archmode.eq.ARCH_SNAP) then
	    call M$PROPAGATE (HIN,HARCH)
	    if (archsf.gt.0) then
	      i = M$SEARCH(archname,'(')
	      j = M$LENGTH(archname)
	      if (i.le.0) write(HARCH.file_name,'(a,1h_,i5.5)') 
     &		archname(1:j),archsf
	      if (i.gt.0) write(HARCH.file_name,'(a,1h_,i5.5,a)') 
     &		archname(1:i-1),archsf,archname(i:j)
	      archsf = archsf+1
	    else
	      HARCH.file_name = archname
	    endif
	    if (HIN.class.eq.2) HARCH.type = 1000
	    HARCH.xdelta = delta
	    HARCH.size = NINT(time2/delta)
	    if (tcmode.ne.'OFF') then
	      stat = M$PIC_TC (p, dmac, 
     &		trigger, delta, time1, time2, 0)
	      mqd.dbuf(1) = trigger-sample
	      mqd.dbuf(2) = tcoff+time1
	      mqd.dbuf(3) = time2 
	      call M$PUT_EPOCH (HARCH, 
     &		tcoff+time1, time2+(sample-trigger)*delta, .false.)
	    endif
	    call M$OPEN(HARCH,HCBF_OUTPUT+HCBF_NOABORT)
	    if (.not. HARCH.open) then
	      archmode = ARCH_OFF
	      status = -4
	    endif
	    if (apacket.gt.0) then
	      i = M$SEARCHB(HARCH.file_name,'.')-1
	      if (i.le.0) i = M$LENGTH(HARCH.file_name)
	      HAPACK.file_name = HARCH.file_name(1:i)//afpext
	      call M$OPEN(HAPACK,HCBF_OUTPUT)
	      apkt.count = 0
	      apkt_count = 0
	    endif
	  endif
	  if (archmode .ne. ARCH_WAIT .and. archid.ne.0)
     &	  call M$SEND_MSGL ('=ARCHIVE',0,archid,status,0,3,'D',mqd,0)
	endif

	! write next archive buffer
	if (archmode .eq. ARCH_SNAP) then
	  larch = HARCH.offset * HARCH.dbpe
	  nelem = min( (NINT(HARCH.size-HARCH.offset)), archtl)
	  call M$FILAD (HARCH,archbuf(larch+1),nelem)
	  if (HARCH.offset .ge. HARCH.size) then
	    call M$CLOSE(HARCH)
	    call M$FREE(parchbuf)
	    archmode = ARCH_OFF
	    call M$SEND_MSGL ('ARCHDONE',0,archid,0,0,0,' ',mqd,0)
	  endif
	endif

	if (idv.gt.0 .and. M$LWGET(idv,verbose).gt.0) then
	  i = M$PIC_SETKEY(p, 0, KEY_VERBOSE, verbose, 4)
	endif

	return
	end

