//************
//  Description: Run an ICE NeXtMidas command from X-Midas
//
//  Author:	Jeff Schoen	2/2013
//
//  $Revision:	$
//  $Modtime:	$
//
//************
#include <primitive.h>
#include "midaslib_int.h"

void mainroutine ()
{
  string nmcmd,javahome,iceroot,nmroot,username,homedir,startup,auxes,jars,auxpath,oscmd;
  char line[128],saux[8],type; int_4 stat,attr;
  FILE *fd;

  int ljh = m_import("JAVAHOME",javahome); if (ljh<0) m_error("JAVAHOME must be defined");
  int lir = m_import("ICEROOT",iceroot); if (lir<0) m_error("ICEROOT must be defined");
  int lnr = m_import("NMROOT",nmroot);
  int lun = m_import("USER",username);
  int lhd = m_import("HOME",homedir);
  int raux, lra = m_get_result("RAMAUX",&raux,4, 0,type,attr); if (lra<=0) raux=9;

  m_qpick(nmcmd);

  startup = homedir+"/nmice.mm";
  fd = fopen(startup.c_str(),"w");
  if (fd==NULL) m_error("Unable to open nM startup file="+startup);

  fprintf(fd,"startmacro\n");
  fprintf(fd,"  debug off all\n");
  fprintf(fd,"  env set THEME gear2\n");
  fprintf(fd,"  env set GRAPHICS +contrast\n");
  fprintf(fd,"  opt ice %s\n",iceroot.c_str());
  fprintf(fd,"  path add ice\n");
  auxes = "";
  for (int i=0; i<Mc->read_auxs; i++) {
    int iaux = Mc->read_aux[i];
    int laux = m_form_path(iaux, username, auxpath);
    if (iaux==raux) fprintf(fd,"  set U:AUX.%d \"ramd:%s,RAM,AUTO\"\n",iaux,auxpath.c_str());
    else            fprintf(fd,"  set U:AUX.%d \"%s\"\n",iaux,auxpath.c_str());
    sprintf(saux,"%d|",iaux);
    auxes += saux;
  }
  auxes += "DAT";
  fprintf(fd,"  aux %d %s\n",Mc->write_aux,auxes.c_str());
  fprintf(fd,"  pic aux %d /quiet\n",raux);
  fprintf(fd,"endmacro\n");

  fclose(fd);

  oscmd = javahome+"/bin/java -DNMROOT="+iceroot+"/ -Djavahome="+javahome+" -classpath '"+ iceroot+":"+
		iceroot+"/jre/*' nxm.sys.lib.NeXtMidas -nonative=false -cmd=%nmice -cmd=\""+nmcmd+"\"";

  stat = system (oscmd.c_str());
  if (stat!=0) printf("nmice err: stat=%d oscmd=%s\n",stat,oscmd.c_str());

  m_sync();	// always run-to-completion

}
