startmacro/sid=0x123 l:bits[16] s:format[SI] 

if /all then
  %testvrt/nolist/noplot 16 si
  %testvrt/nolist/noplot 12 si
  %testvrt/nolist/noplot  8 si
  %testvrt/nolist/noplot  8 sb
  %testvrt/nolist/noplot  6 sb
  %testvrt/nolist/noplot  4 sb
  stop
endif

info "Testing VRT bits=^bits format=^format"
set amp 20e3
if "B" subs format then set amp 100
res rate 1e5

erase/nowarn testin testoutj testoutk testoutv testinj testinv

set l:size 64k
set l:siz size-8k
wave testin shape=sin form=format delta=1/rate freq=rate/100 amp=amp elem=size
timex now file=testin

sinkice/pt=vrt testin testoutj /bits=bits /rep=EEEI
sinkice/pt=vrt testin testoutk /bits=bits /rep=IEEE
sourceice/pt=vrt testoutj testinj /bits=bits
icevrt/core=v  testin testoutv /bits=bits /xmode=m2v
icevrt/core=v  testoutv testinv /bits=bits /mode=v2m

set p0 0
set p1 50*1440*8/bits

if /nolist isfalse

say "Data testoutj"
data/hex/p/nc=8 testoutj p0
data/hex/p/nc=8 testoutj p1

say "Data testoutk"
data/hex/p/nc=8 testoutk p0
data/hex/p/nc=8 testoutk p1

say "Data testoutv"
data/hex/p/nc=8 testoutv p0
data/hex/p/nc=8 testoutv p1

say "Data testin"
data/hex/p/nc=8 testin p0
data/hex/p/nc=8 testin p1

say "Data testinj"
data/hex/p/nc=8 testinj p0
data/hex/p/nc=8 testinj p1

say "Data testinv"
data/hex/p/nc=8 testinv p0
data/hex/p/nc=8 testinv p1

endif

assert testoutv(0:siz) feq testoutj(0:siz) and file(testoutv).size gt siz  /text="Forward files testoutj and testoutv are equal"
assert testinv(0:siz) feq testinj(0:siz) and file(testinv).size gt siz     /text="Inverse files testinj and testinv are equal"

if /noplot isfalse plot testin|testoutj|testoutk|testoutv|testinv x1=0 x2=.002

endmacro
