!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!  This algorithm is used to calibrate tuner timecode by reconstructing the 
!  original input from the tuner output and using cross spectral techniques
!  to calculate delays.  These are compared to the pic_tc() results to verify
!  the theoretical equations.
!
!  This also tests the wideband timecode by comparing with the embedded value
!
!  A wideband signal (with timecode) must be applied to the input module 1 
!
!  Selecting tune=fs/4 keeps freq error at minimum
!
!  Authors: Sid Moore, Joe Briggs, and Jeff Schoen
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/quiet/ltext=96 s:device[pic1] l:dec[64] s:format[SI] d:rate[10e6] d:tune[-1]

switch "AFLAGS" aflags get ""
switch "BFLAGS" bflags get ""
switch "WBFORM" wbform get "SI"

switch "TPORT" tport get "TUNER1"
switch "MPORT" mport get "MODULE1"
switch "RPORT" rport get "PM0TUNER1"
switch "NTB"  l:ntb  get 1
switch "ITB"  l:itb  get 0
switch "OVSR" l:ovsr get 0
switch "WOFF" l:woff get 0
switch "GAIN" l:gain get 0
switch "ALSO" l:also get -1
switch "RR"   d:ratio get 0
switch "TLEN" d:lenwb get 2
switch "NBTLEN" d:lennb get lenwb

if /side eq 2
  sedit tport tport subs "1" "2"
  sedit mport mport subs "1" "2"
  sedit rport rport subs "1" "2"
endif

set aflags "OVSR=^ovsr|^aflags"

erase tctestwb tctestwbr tctestnb1 tctestnb2 tctestnb4 tcnb tccross specu speci  /warn=n 

if rate lt 2000 set d:rate rate*1e6
pic create tctestwb ^wbform lenwb*rate rate /round=1m
picd get device "TYPE" ctype
picd get device "GCHIP" gchip

calc ilen lennb*rate
if /thrucore then calc ilen ilen/2
calc indelta file(tctestwb).xd
calc nyquist .5/indelta
calc nfft 64k
calc navg 8 rate/10e6 * round
calc frame 4k

if dec gt 100
  calc nfft nfft*4
  calc navg navg/4 round
endif

if ratio gt 0 then
  calc ddec dec ratio /
  if /pre gt 0 then
    set aflags "^aflags|PRESAMP|PREGAIN=-3|RATIO=^ratio"
  else
    set aflags "^aflags|RESAMP"
  endif
else
  set d:ddec dec
  set ratio 1
endif

if "FTTM=2" subs aflags then
  set aflags "^aflags|FTTG2=12"
endif

if tune lt 0 then calc tune rate*.25
!if dec eq 1  then calc tune rate/4
switch "CFREQ" d:tune get tune

if format eqss "C"
  calc olen ilen/2 ddec / 2 / power2 2k max
  calc orate rate ddec / 2 /
elseif format eqss "S"
  calc olen ilen/2 ddec / power2 4k max
  calc orate rate ddec /
else
  error "Illegal format type"
endif
switch "DFREQ" d:dfreq get orate*.25

if "POVSR" subs aflags 
  calc dec dec ovsr *
endif

if /SDDS and /SDN isfalse then
  set tcmode "SDDS"
elseif /IRB then
  set tcmode "IRBXP0"
  set aflags "^aflags|MUXCLK=PX"
  if wbform eqs "CI" set aflags "^aflags|MBITS=-16"
else
  set tcmode "SDN0"
endif

say "Test TC Mode=^tcmode on Port=^tport Dec=^dec Fmt=^format Rate=^rate Ratio=^ratio Flags=^aflags"

if /noreset isfalse
  picd/flags=^aflags reset ^device
endif

if also gt 0 then
  set dec2 dec
  set dec4 dec
  picd create tctestnb1 ^format olen*dec/dec2 orate*dec/dec2
  picd create tctestnb2 ^format olen*dec/dec2 orate*dec/dec2
  picd create tctestnb4 ^format olen*dec/dec4 orate*dec/dec4
else
  picd create tctestnb1 ^format olen*2*ntb orate
endif
if /wbr then
  pic create tctestwbr ^wbform 2.1*rate*ratio rate*ratio /round=1m
endif

set waitw 0
if /wblast then set waitw 0.5
set waitn  0.2
switch "NBWAIT" d:waitn get waitn
set waitn1 0.1
set waitn2 0.3

if ctype eq 3 or /wbsame istrue or /wbr istrue then
  set bflags "^bflags|RGO"
endif
if /nbsame istrue then
  set aflags "^aflags|RGO"
  set waitw 0.2
  set waitn 0.0
  set waitn1 0.0
  set waitn2 0.0
endif

pipe on 

if /wb neq 0 then
  picd/id=pwb/port=^mport/tc=^tcmode/tcoff=0/wait=waitw/flags=^bflags &
	acquire ^device tctestwb ,,, 1 tune
endif

if /wbr then
  picd/id=pwbr/port=^rport/tc=^tcmode/tcoff=0/wait=waitw/flags=^bflags|RESAMP|OVSR=2/ratio=ratio &
	acquire ^device tctestwbr ,,, 1 rate/4 -3
endif

  picd/id=pnb/port=^tport/tc=^tcmode/tcoff=0/wait=waitn/flags=^aflags/dfreq=dfreq/nchn=ntb/tl=frame/ratio=ratio &
	acquire ^device tctestnb1 ,,, dec tune gain /afreq=atune

if also eq 1 or also eq 3 then
  picd/id=pnb3/port=tuner3/tc=^tcmode/tcoff=0/wait=waitn1/flags=^aflags/dfreq=dfreq/nchn=ntb/tl=frame/ratio=ratio &
	acquire ^device tctestnb2 ,,, dec2 tune gain
endif

if also eq 2 or also eq 3 then
  picd/id=pnb5/port=tuner5/tc=^tcmode/tcoff=0/wait=waitn2/flags=^aflags/dfreq=dfreq/nchn=ntb/tl=frame/ratio=ratio &
	acquire ^device tctestnb4 ,,, dec4 tune gain
endif

pipe off

! thin out tuner bank frame
if ntb le 1 then 
elseif itb lt 0 
  set l:jtb -itb
  do itb 0 ntb-1 jtb
    thin tctestnb1{fs=frame} tctestnbi itb -0 ntb
    header tctestnbi fs=0
    icetfdoa tctestwb tctestnbi ,,,, ^atune(itb) ratio /port=^tport:^itb
  enddo
  stop
else
  set atune atune(itb)
  thin tctestnb1{fs=frame} tctestnb1 itb -0 ntb
  header tctestnb1 fs=0
endif

! test the narrow bands
if /wb eq 0 then
  icetfdoa tctestwbr tctestnb1 /resamp=1 /port=^rport
elseif /nb neq 0 then
  icetfdoa tctestwb tctestnb1 ,,,, ^atune ratio /port=^tport
endif
if also eq 1 or also eq 3 then
  icetfdoa tctestwb tctestnb2 ,,,, ^atune ratio /port=tuner3
endif
if also eq 2 or also eq 3 then
  icetfdoa tctestwb tctestnb4 ,,,, ^atune ratio /port=tuner5
endif

! test the presampler
if /wbr and /wb then
  icetfdoa tctestwb tctestwbr ,,,,, ratio /port=^rport
endif
if /wbr and /nb neq 0 then
  icetfdoa tctestwbr tctestnb1 ,,,,, 1 /port=^tport|X
endif

! test the wide band
if /wb then
  if /tcdc then
    icetc top SDN0YD tctestwb ,, toptime
  else
    icetc top SDN0Y tctestwb ,, toptime
  endif
  status tctestwb time=tctime
  calc f:diff toptime.diff(tctime) abs indelta /
  assert diff lt 0.1 /text="TestTC Port=^mport Top=^toptime.toString(9) Diff=^diff "
endif

endmacro
