startmacro/ps=2m/tc=sdds/tcps=10/replay=0/timeout=5 u:device[pic3iistv6] d:freq[-1] d:ovsr[8]

picd reset ^device

res dec   192
res ddec  192/ovsr
res irate 100e6/ovsr
res rrate 104e6/ovsr
res ratio rrate/irate
res nchan 4
res nfft  2k
res psz   32k
res crate rrate/ddec/2
res orate rrate/ddec

if freq lt 0 then calc/quiet freq irate/4

res mport "MODULE1"
res rport "PM0TUNER1"
res tport "TBANK1"
if /tuner gt 0 then
  res tport "TUNER1"
  res nchan 1
endif
if /core gt 0 then
  res tport "CORE11"
  res nchan 1
endif
if /side eq 2 then
  sedit mport mport subs "1" "2"
  sedit rport rport subs "1" "2"
  sedit tport tport subs "1" "2"
endif

res flgw "MUXCLK=N|TCLK=110e6"
res flgr "MUXCLK=N|OVSR=2|RESAMP"
res flgn "MUXCLK=N|OVSR=^ovsr|POVSR|FTTM=2|CPC=2|PRESAMP"

if /back gt 0 then
  res flgn "RGO|^flgn"
else
  res flgw "RGO|^flgw"
endif
if /nwb lt 0 or /back lt 0 then
  res flgr "RGO|^flgr"
endif

pic/round=psz create wbfile si irate irate
pic/round=psz create rbfile si rrate rrate
pic/round=psz/multi=nchan create nbfile ci crate crate

switch "AFLAGS" u:aflags get
res flgw "^aflags|^flgw"
res flgr "^aflags|^flgr"
res flgn "^aflags|^flgn"
picd/flags=^flgw reset ^device

pipe/panel on

! wideband data source
if /nwb le 0
sourcepic/id=sp1/port=^mport/flags=^flgw/packet="ICE/DET" wbfile(fs=nfft) _wb ^device 1 irate/4 
endif

! resampled data source
if /wbr gt 0 then
sourcepic/id=sp2/port=^rport/ratio=ratio/flags=^flgr/packet="ICE/DET" rbfile(fs=nfft) _rb ^device 1 irate/4 -3
endif

! narrowband data source
if /nnb le 0
sourcepic/id=sp3/port=^tport/ratio=ratio/nchn=nchan/tl=1/flags=^flgn/dfreq=1e4/packet="ICE/DET" nbfile(fs=nfft) _nb ^device dec freq 
endif

gcontrol menu act "ACTION" "Run,Stop,Exit"

pipe off

endmacro

procedure processMessage m:msg

if msg.name eqs "ACT" then
  if msg.data eqs "RUN" then
    if reg.sp1 rexists set reg.sp1.replay "CONT"
    pause 0.5
    if reg.sp2 rexists set reg.sp2.replay "CONT"
    pause 0.5
    if reg.sp3 rexists set reg.sp3.replay "CONT"
  elseif msg.data eqs "STOP" then
    if reg.sp1 rexists set reg.sp1.replay "STOPNOW"
    if reg.sp2 rexists set reg.sp2.replay "STOPNOW"
    if reg.sp3 rexists set reg.sp3.replay "STOPNOW"
  elseif msg.data eqs "EXIT" then
    pipe stop
  endif
endif
return

