startmacro t:tbl
  set flags "^tbl.flags|^tbl.aflags"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  call cleanFiles
  picd/flags=force|^flags reset ^tbl.card
  pic create fileo ^tbl.format ^tbl.fsize rate
  sourcepic/port=^tbl.port/flags=^flags/apacket=det/arch=march{^wstr} fileo fileo ^tbl.card
  call procResults march.pkt

  if /plotson or ( failure eq 1 ) then
    pipe on
      panel/setup
      plot/id=plot1 fileo
      list/id=plot2 march.pkt
    pipe off
  endif 
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n fileo march
return

procedure procResults hi f:thresh
  ! make sure file exist
  if (^hi fexists) isfalse then 
    assert/text="Time code" 0 eq 1
    return
  endif

  status ^hi size=sze
  ! just check if the last index has timecode
  file open/d tag ^hi
  set ind sze-1
  set tcs 0
  do ind 0 sze-1 1 
    res tcs tag.getDataTable(ind).tcs
    if tcs eq 1 then
      break
    endif
  enddo
  file close tag
  assert/text="Time code" tcs eq 1
  if tcs neq 1 then 
    set failure 1
  endif
return
