;///////////////////////////////////////////////////////////////
;//  Icepicmc.mc - event log message file
;//  Portions Copyright (c) 1997-2000, BlueWater Systems, Inc.
;///////////////////////////////////////////////////////////////
;//
;//  Status values are 32 bit values layed out as follows:
;//
;//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;//  +---+-+-------------------------+-------------------------------+
;//  |Sev|C|       Facility          |               Code            |
;//  +---+-+-------------------------+-------------------------------+
;//
;//  where
;//
;//      Sev - is the severity code
;//
;//          00 - Success
;//          01 - Informational
;//          10 - Warning
;//          11 - Error
;//
;//      C - is the Customer code flag
;//
;//      Facility - is the facility code
;//
;//      Code - is the facility's status code
;//
;
MessageIdTypedef=NTSTATUS

SeverityNames=(Success=0x0:STATUS_SEVERITY_SUCCESS
               Informational=0x1:STATUS_SEVERITY_INFORMATIONAL
               Warning=0x2:STATUS_SEVERITY_WARNING
               Error=0x3:STATUS_SEVERITY_ERROR
              )

FacilityNames=(System=0x0
               RpcRuntime=0x2:FACILITY_RPC_RUNTIME
               RpcStubs=0x3:FACILITY_RPC_STUBS
               Io=0x4:FACILITY_IO_ERROR_CODE
               IcepicDriver=0x7:FACILITY_ICEPIC_ERROR_CODE
              )


MessageId=0x0001 Facility=IcepicDriver Severity=Error SymbolicName=MISSING_REGISTRY_INFORMATION
Language=English
Information needed to start device %2 is missing from the registry.  The key missing is %3.
.

MessageId=0x0002 Facility=IcepicDriver Severity=Error SymbolicName=FAILED_TO_MAP_ADDRESS
Language=English
The device %2 failed to map the address %3 for a length of %4.  Another device may be using this address.
.

MessageId=0x0003 Facility=IcepicDriver Severity=Error SymbolicName=FAILED_TO_OBTAIN_INTERRUPT
Language=English
The device %2 failed to obtain the interrupt number %3.  The most likely cause is an ISA device conflict.
.

MessageId=0x0004 Facility=IcepicDriver Severity=Error SymbolicName=FAILED_TO_INITIALIZE_HARDWARE
Language=English
The hardware failed to initialize properly.  Please call technical support for assistance.
.

MessageId=0x0005 Facility=IcepicDriver Severity=Informational SymbolicName=CHECK_POINT
Language=English
Icepic checkPoint: %2.  
.

