#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <stropts.h>
#include "icedefs.h"
#include "iceioctl.h"
#include "iceflex.h"

#define K 1024
#define M (K*K)

main (int argc, char *argv[])
{
  int rc;
  PICIOCTL p;
  char *path = "/dev/icepic1";
  int fd;
  int i;

  if (argc > 1) {
    path = argv[1];
  }
  printf ("Opening ICE DEVICE: %s\n", path);
  fd = open (path, O_RDWR, 0666);

  if (fd == -1) {
    perror ("OPEN");
    exit (-1);
  }

 
  p.offset = 0;
  p.status = 9;
  p.bytes = 64 * M;
  p.bufaddr = (__uint32_t) valloc (p.bytes);
  if (!p.bufaddr) {
    perror ("MALLOC");
    exit (0);
  }
  printf ("bufaddr: %x\n", p.bufaddr);
  printf ("size = %d\n", sizeof (PICIOCTL));
  p.function = IOCTL_MAP;
  rc = ioctl (fd,  IOCTL_MAP, &p);
  if (rc == -1 ) {
    perror ("MAP");
  }
  printf ("Memory Mapped at: 0x%x\n", p.status);
  printf ("Press a key\n");
  getchar ();

  p.function = IOCTL_UNMAP;
  p.offset = p.status;
  rc = ioctl (fd, IOCTL_UNMAP, &p);
  if (rc == -1 ) {
    perror ("UNMAP");
  }

  p.function = IOCTL_READ;
  p.bytes = 4;
  p.offset = 0;
  rc = ioctl (fd, IOCTL_READ, &p);
  if (rc == -1 ) {
    perror ("IOCTL_READ");
  }
  for (i = 0; i < p.bytes; ++i) {
    printf ("0x%x ", * (int *) p.bufaddr);
  }
  close (fd);
}
