/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See WBR.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
import nxm.dsp.prim.firkais;
public class WBR extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, ONP = 1, NP = 2, BW = 32 * NP, IKR = 4 * NP, OTAP = 6, RTAP = 1 << OTAP, OFILT = 5, FILT = 1 << OFILT;
public static class CORE extends Core {
  float fwf;
  double p, dp, dpinc;
  int ntap, nrpt;
  float fscl;
  float lfp, mfp;
  float dpi;
  float[] dpia;
  boolean updn;
  boolean bypass;
  int gain;
  CxTapBuf vd;
  RomF2Di rft;
  CxFloat[] vi, vs, vo;
  public void setRatio (double ratio) {
    dp = 1.0 / ratio;
    ntap = RTAP - 2 * d2i (ceil (NP * dp));
    updn = (ratio > 1);
    bypass = (dp == 1);
    dpinc = updn ? dp : ratio;
    putVars ("dpinc");
  }
  public void setGain (double dgain) {
    double scale = pow (2.0, dgain / 6);
    fscl = d2f (scale);
    if (gain == dgain) return;
    gain = (byte) (dgain);
    putVars ("gain,fscl");
  }
  public void genFilt () {
    int i, j, k, nt = nrpt * ntap;
    int joff = RTAP - ntap;
    double fw = updn ? fwf : fwf / dp;
    float[] ctap = new float[nt*2];
    firkais.generate (1, fw / nrpt, 0.0, 0.05 / nrpt, 90.0, ctap, nt, false);
    for (i = j = 0; j < ntap; j ++) for (k = 0; k < nrpt; k ++, i += 2) rft.set (k, j + joff, ctap[i] * nrpt);
  }
  public int init () {
    fwf = 0.9F;
    dp = 1;
    fscl = 1;
    ntap = RTAP;
    nrpt = FILT;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "D:RATIO")) setRatio (value.toD ());
    else if (isMatch (key, "L:NTAP")) ntap = value.toL ();
    else if (isMatch (key, "F:FWF")) fwf = value.toF ();
    else if (isMatch (key, "D:GAIN")) setGain (value.toD ());
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:GAIN")) value.fromL (gain);
    else if (isMatch (key, "L:NTAP")) value.fromL (ntap);
    else if (isMatch (key, "D:RATIO")) value.fromD (1.0 / dp);
    else if (isMatch (key, "D:XDIO")) value.fromD (dp);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    int i;
    rft = new RomF2Di (OFILT, OTAP, RTAP);
    vd = new CxTapBuf (OTAP, 1, RTAP, -1);
    vi = new CxFloat[NP];
    for (i = 0; i < NP; i ++) vi[i] = new CxFloat ();
    vo = new CxFloat[NP];
    for (i = 0; i < NP; i ++) vo[i] = new CxFloat ();
    vs = new CxFloat[NP];
    for (i = 0; i < NP; i ++) vs[i] = new CxFloat ();
    if (ntap > RTAP) {
      System.out.printf ("Number taps=%d limited to max taps=%d for this buid\n", ntap, RTAP);
      ntap = RTAP;
    }
    genFilt ();
    dpi = d2f (dp);
    p = 0;
    lfp = 0;
    mfp = 1 - lfp;
    dpia = new float[NP];
    for (i = 0; i < NP; i ++) dpia[i] = dpi * i;
    dpi = d2f (dp * 0.999);
    System.out.printf ("WBR dp=%f ntap=%d nrpt=%d spc=%d byp=%d\n", dp, ntap, nrpt, NP, bypass ? 1 : 0);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    CxFloat fi=CxFloat.stk();
    boolean doin, doout;
    float pp, nfp;
    int i, j, k;
    CxFloat tf=CxFloat.stk();
    while (si.rok && so.wok) {
      nfp = d2f (p);
      if (updn) {
        doin = nfp < lfp;
        doout = true;
        pp = nfp;
      }
      else {
        doin = true;
        doout = (nfp <= lfp);
        pp = mfp * dpi;
      }
      lfp = nfp;
      mfp = 1.0F - nfp;
      p = frac (p + dpinc);
      if (doin) {
        si.rdCIFA (vi, NP);
        for (k = 0; k < NP; k ++) {
          mulfc (fscl, vi[k], vs[k]);
        }
        vd.loadA (vs, NP);
      }
      if (doout) {
        for (j = 0; j < NP; j ++) {
          float rp;
          rp = mulfp2 (pp, ONP) + dpia[j];
          CxFloat fr=CxFloat.stk();
          fr.x = 0;
          fr.y = 0;
          for (i = 0; i < RTAP; i ++) {
            float ft, ftx;
            CxFloat fdi=CxFloat.stk(), fdix=CxFloat.stk(), fdiy=CxFloat.stk();
            ftx = rft.getrN (rp, i);
            ft = ftx;
            vd.get (i, fdix);
            fdi = fdix;
            fr.x += ft * fdi.x;
            fr.y += ft * fdi.y;
          }
          vo[j] = fr;
        }
        so.wrCFIA (vo, NP);
      }
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
