/**
  Implements Real to Complex conversion

  @author Jeff Schoen
  @version $Id: PCIe.c,v 1.3 2005/03/29 14:56:00 jgs Exp $
*/

/* Signatures */
#define CORE_NAME PCIe
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 0
#define CORE_IS_HOC 1

#include "CoreDefs.h"

/* CORE Plan handle */
typedef struct {
  HALO halo;
  int_4 lanes;
  int_4 flags;
} PCIe;

#include "CoreProtos.h"

/* CORE Code */

void* PCIe_alloc (char *config) {
  PCIe *plan = PCIe_plan();
  HW_alloc(plan,config);
  return (void*)plan;
}

int_4 PCIe_init (PCIe *plan) {
  plan->flags = 0;
  plan->lanes = 8;
  return 0;
}

int_4 PCIe_set (PCIe *plan, String *key, Value *value) {
       if (keyMatch("L:FLAGS")) plan->flags=Value_toL(value);
  else if (keyMatch("L:LANES")) plan->lanes=Value_toL(value);
  else return Core_set(plan,key,value);
  return 0;
}

int_4 PCIe_get (PCIe *plan, String *key, Value *value) {
       if (keyMatch("L:FLAGS")) Value_fromL(value,plan->flags);
  else if (keyMatch("L:LANES")) Value_fromL(value,plan->lanes);
  else return Core_get(plan,key,value);
  return 0;
}

int_4 PCIe_open (PCIe *plan) {
  int_4 sysreg = 0x0001;
  if (plan->lanes==8) sysreg |= (0x3<<8);
  if (plan->lanes==4) sysreg |= (0x2<<8);
  if (plan->lanes==2) sysreg |= (0x1<<8);
  HW_write(COREG_FLAG,plan->flags);
  HW_write(COREG_SYS,sysreg);	// enable PCIe with specified lanes
  return 0;
}

int_4 PCIe_close (PCIe *plan) {
  return 0;
}

int_4 PCIe_free (PCIe *plan) {
  HW_free(plan);
  free(plan);
  return 0;
}

#include "CoreHandles.h"
