/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See MOD.jv for documentation.
*/
#include "Modefs.c"
#include "Modems.c"
#include "RFP.c"
#include "AWG.c"

/** Define Signatures */
#define CORE_NAME MOD
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { MOD_SSZ = 512 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  RFP* rfp;
  AWG* awg;
  Stream* sa;
  int_1 gen;
} MOD;

#include "cores/CoreProtos.h"

/** CORE Code */

void* MOD_alloc (char *config) {
  MOD* plan = MOD_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 MOD_upload (MOD* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,4);
  HW_loadSub  (planp,0xA3000001);
  HW_loadSub  (planp,0xA3000002);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,plan->gen);
  HW_push (planp,HW_OPEN);
  return 4;
}

int_4 MOD_init (MOD* plan) {
  plan->rfp = RFP_subCore (&plan->halo,1);
  plan->awg = AWG_subCore (&plan->halo,2);
  return 0;
}

int_4 MOD_set (MOD* plan, String* key, Value* value) {
  if (RFP_set (plan->rfp, key, value) >= 0);
  else if (AWG_set (plan->awg, key, value) >= 0);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 MOD_get (MOD* plan, String* key, Value* value) {
  if (RFP_get (plan->rfp, key, value) >= 0);
  else if (AWG_get (plan->awg, key, value) >= 0);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 MOD_open (MOD* plan) {
  RFP_open (plan->rfp);
  AWG_open (plan->awg);
  plan->sa = Stream_new (MOD_SSZ, BW, BW);
  plan->gen = RFP_isGen (plan->rfp);
  MOD_upload (plan,plan);
  return 0;
}

int_4 MOD_process (MOD* plan, Stream* si, Stream* so) {
  while ((plan->gen || si->rok) && so->wok) {
    RFP_process (plan->rfp, si, plan->sa);
    AWG_process (plan->awg, plan->sa, so);
  }
  return 0;
}

int_4 MOD_close (MOD* plan) {
  RFP_close (plan->rfp);
  AWG_close (plan->awg);
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 MOD_poll (MOD* plan) { return 0; }

int_4 MOD_free (MOD* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
