/**
  Implements Real to Complex conversion

  @author Jeff Schoen
  @version $Id: JVM.c,v 1.3 2005/03/29 14:56:00 jgs Exp $
*/

/* Signatures */
#define CORE_NAME JVM
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 0
#define CORE_IS_HOC 1

#include "CoreDefs.h"

/* CORE Plan handle */
typedef struct {
  HALO halo;
  int_4 flags;
} JVM;

#include "CoreProtos.h"

/* CORE Code */

int_4 loadCode (JVM *plan, int_2 *code, int_4 len) {
  int_4 i;
  HW_write(COREG_SYS,0x0);
  HW_write(COREG_SYS,0x2);
  HW_write(COREG_SYS,0x0);
  for (i=0; i<len; i++) {
    HW_write(COREG_DEC,code[i]); // load code
  }
  return len;
}

void* JVM_alloc (char *config) {
  JVM *plan = JVM_plan();
  HW_alloc(plan,config);
  return (void*)plan;
}

int_4 JVM_init (JVM *plan) {
  plan->flags = 0;
  return 0;
}

int_4 JVM_set (JVM *plan, String *key, Value *value) {
       if (keyMatch("L:FLAGS")) { plan->flags = Value_toL(value); }
//  else if (keyMatch("CODE")) { loadCode(plan,(int_2*)Value_toL(value),len/2);  }
  else if (keyMatch("L:OPCODE")) { HW_write(0x1000,Value_toL(value)); }
  else if (keyMatch("L:DATA1")) { HW_write(0x1004,Value_toL(value)); }
  else if (keyMatch("L:DATA2")) { HW_write(0x1008,Value_toL(value)); }
  else if (keyMatch("L:DATA3")) { HW_write(0x100C,Value_toL(value)); }
  else return Core_set(plan,key,value);
  return 0;
}

int_4 JVM_get (JVM *plan, String *key, Value *value) {
       if (keyMatch("L:FLAGS")) Value_fromL(value,plan->flags);
  else if (keyMatch("L:OPCODE")) Value_fromL(value,HW_read(0x1000));
  else if (keyMatch("L:DATA1")) Value_fromL(value,HW_read(0x1004));
  else if (keyMatch("L:DATA2")) Value_fromL(value,HW_read(0x1008));
  else if (keyMatch("L:DATA3")) Value_fromL(value,HW_read(0x100C));
  else return Core_get(plan,key,value);
  return 0;
}

int_4 JVM_open (JVM *plan) {
  HW_write(COREG_SYS,0x0);
  HW_write(COREG_FLAG,plan->flags);
  HW_write(COREG_SYS,0x3);	// reset with start
  HW_write(COREG_SYS,0x1);
  return 0;
}

int_4 JVM_close (JVM *plan) {
  return 0;
}

int_4 JVM_free (JVM *plan) {
  HW_free(plan);
  free(plan);
  return 0;
}

#include "CoreHandles.h"
