/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See FEC.jv for documentation.
*/

import CORE_types::*;
package FEC_types;
import CORE_types::*;
endpackage
import FEC_types::*;

module FEC_core #(PORT=1, IBW=32,OBW=32, IFLG=0,OFLG=0, IOCLKS=1, IKR=4,OKR=4, PBW=32,PKR=1) (
  input[2:0] s_clks, input s_rst, input s_cs, input[31:0] s_addr,
                     input s_wr, input[31:0] s_wrbus, input s_rd, output[31:0] s_rdbus, output s_ack,
  input[3:0] io_clk, output[1:0] i_rdy, input i_ena, input[7:0] i_sel, input[IBW-1:0] i_bus,
                     output[1:0] o_rdy, input o_ena, output[7:0] o_sel, output[OBW-1:0] o_bus,
  output [7:0] s_test);
  wire T=1,F=0; wire[7:0] T8=~0,F8=0;
  localparam SBW=32, ARRAY=0, STREAM=1, BUFFER=2, BUFSTR=3, PACKET=4;
  localparam BCIO=0, BCI=1, BCO=2, BCIIO=3, BCIOO=4, BCIIIOO=5;
  localparam FRAW=0, FCXI=1, FBIT=2, FAXI=3, FALL=4, FSWP=5;
  localparam TIGHT=8, BPAR=1024, BDMA=2048, BENA=16384, DBLBUF=32768, NEMPTY=131072, RAHEAD=262144;
  localparam FLOW=STREAM, BUFCFG=BCIO, SELFPACE=1, PIPE=-1, MC=0, CW=6, AW=16, MBW=256, NP=1, BW=32, SIBW=BW, SOBW=BW, BIBW=BW, BOBW=BW, PIBW=PBW, POBW=PBW, IFMT=FBIT, OFMT=FBIT, DBGBW=32, DBGBD=10, P2=FLOW, P3=NP, P4=BW, P5=0, P6=0, P7=0;
  localparam XIBW=SIBW, XOBW=SOBW;
  localparam BWP=BW/8, IBWP=IBW/8, OBWP=OBW/8, XIBWP=XIBW/8, XOBWP=XOBW/8;
  localparam XIBWO=(XIBW>64)? 4 : (XIBW>32)? 3 : (XIBW>16)? 2 : (XIBW>8)? 1 : 0;
  localparam XOBWO=(XOBW>64)? 4 : (XOBW>32)? 3 : (XOBW>16)? 2 : (XOBW>8)? 1 : 0;
  localparam NSUB=PORT/100, SUB=PORT%100;

  wire s_clk=s_clks[0],clk=s_clks[0],clk2=s_clks[1]; wire[1:0] clks=s_clks;
  logic rst,s_wrsys,s_wrscid; logic[31:0] s_sys; logic s_csm,s_csd,s_ena; logic[3:0] s_scid; 
  logic c_rd,c_wr,c_wok; logic[15:0] c_adr; logic[31:0] c_wbus,c_rbus; wire c_ok;
  always @(posedge s_clk) begin
    s_csd <= s_cs && s_addr[11:0]==12'hFFC;
    s_csm <= s_cs && !s_csd;
    s_wrsys <= s_cs && s_wr && s_addr[11:0]==0;
    if (s_rst) s_sys <= 0; else if (s_wrsys) s_sys <= s_wrbus;
    rst <= s_rst || s_sys[23];
    if (s_rst) c_wok <= 1; else if (!c_wr) c_wok <= !s_sys[22];
    s_ena <= (NSUB>0)? s_clks[2] : s_sys[0];
  end
  wire frst=!s_ena; wire s_opt=s_sys[4]; wire[3:0] s_ifmt=s_sys[11:8], s_ofmt=s_sys[15:12]; wire [1:0] s_vbpr=s_sys[21:20];
  wire i_frst = frst; wire o_frst = frst; wire p_frst = frst;

  wire [31:0] s_sub, s_rdbusm, s_rdbust; wire [63:0] s_val; wire [15:0] s_ind; wire[19:0] s_set;
  wire s_csr=s_csm && !s_sub[24] && !s_addr[0];
  setter #(20,1) s_bank (clk,rst,s_csm&s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);
  portstatusblk #(PORT,"FEC",P2,P3,P4,P5,P6,P7) s_sblk (s_clk,s_csr,s_addr,s_wr,s_wrbus,s_rd,s_rdbusm, clk,1'b1,c_adr,c_wok&c_wr,c_wbus,c_rd,c_rbus);
  assign s_rdbus = s_rdbusm;

  wire i_clk=io_clk[0], o_clk=(IOCLKS>1)?io_clk[1]:io_clk[0];
  logic si_ren,so_wen,si_rok_,so_wok_; logic[5:0] si_bits,so_bits; logic[XOBW-1:0] so_wbus; logic[XOBWP-1:0] so_wsel; logic[XIBW-1:0] si_rbus; logic[XIBWP-1:0] si_rsel; logic[7:0] so_swaps;
  wire c_rdy = (SELFPACE!=0) || (si_rok_ && so_wok_); wire si_rok = si_rok_ && c_ok; wire so_wok = so_wok_ && c_ok;
  generate if (NSUB>0 && SUB!=1) begin
    bitunpacker #(XIBW) bpi (s_clk,i_frst,si_bits, i_ena,i_rdy,i_bus, si_ren,si_rbus); assign si_rok_=i_ena;
  end else begin
    logic i_val; always @(posedge i_clk) i_val <= i_ena;
    fifoNxMbi #(IBW,XIBW,IKR/2,3,IFLG) f_i (i_clk,i_frst, i_rdy,i_val,i_bus, s_clk,i_frst, si_bits, si_rok_,si_ren,si_rbus);
    if (NSUB>0 && SUB==1) assign s_ack = si_rok_;
  end endgenerate
  generate if (NSUB>0 && SUB!=NSUB) begin
    bitpacker #(XOBW) bpo (s_clk,o_frst,so_bits, so_wen,so_wbus, o_rdy,o_bus); assign so_wok_=o_ena;
  end else begin
    fifoNxMbo #(OBW,XOBW,OKR/2,3,OFLG) f_o (o_clk,o_frst, o_rdy,o_ena,o_bus, s_clk,o_frst, so_bits, so_wok_,so_wen,so_wbus);
    if (NSUB>0 && SUB==NSUB) assign s_ack = so_wok_;
  end endgenerate

  logic c_start,c_prep,c_done,c_active; logic[15:0] c_cnt,c_stat;
  always @(posedge clk) begin
    if (frst) c_prep <= 0; else if (c_done) c_prep <= 0;
    if (frst) c_start <= 0; else c_start <= s_ena && (c_rdy||c_prep) && !c_start && !c_active;
    if (frst) c_active <= 0; else c_active <= c_start || (c_active && !c_done);
    if (c_start) c_cnt <= 0; else c_cnt <= c_cnt+1;
  end
  flowcontrol f_c (clk, frst, s_opt, c_cnt, c_ok);

  import CORE_funcs::*;

  localparam NL=54, MO=9, OLUT=12, NLUT=1<<OLUT, LRSPM=33554467;
  localparam CV_halo_sys=0, CV_halo_flag=28, CV_halo_func=64, CV_halo_fmts=68, CV_halo_flow=72, CV_halo_impl=76;
  localparam CV_polyA=256,CV_polyB=260,CV_shft=264,CV_mask=268,CV_mfr=272,CV_ifr=276,CV_punc=280,CV_ipunc=284,
    CV_mpunc=288,CV_errs=292,CV_elut=296,CV_ilen=300,CV_olen=304,CV_flgs=308,CV_scrc=312,CV_scrv=316,CV_gmask=320,CV_lrsc=324,
    CV_lrsp=328,CV_uv=332;

  uint16 polyA;
  uint16 polyB;
  uint16 shft;
  uint16 mask;
  uint12 mfr;
  uint12 ifr;
  uint3 punc;
  uint3 ipunc;
  uint3 ipunc_4; delayp #(4,3) dp_ipunc_4(clk,ipunc,ipunc_4);
  uint3 mpunc;
  uint24 errs;
  uint6 ilen;
  uint6 olen;
  uint8 flgs;
  uint5 scrc;
  uint24 scrv;
  uint4 gmask;
  uint32 lrsc;
  uint32 lrsp;
  uint2 uv;
  uint9 elut[NLUT];

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[54];  wire c_en[54];  wire c_xn[54];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",c_start,F);    // public int process ( StreamI si , StreamO so ) {
  uint9 olut;                                                // uint9 olut ;
  uint12 ilut;                                               // uint12 ilut ;
  uint12 imask;                                              // uint12 imask ;
  uint32 bi;                                                 // uint32 bi ;
  uint4 bix;                                                 // uint4 bix ;
  uint3 otcm3;                                               // uint3 otcm3 ;
  uint2 biy, otcm2;                                          // uint2 biy , otcm2 ;
  uint2 biy_3; delayp #(3,2) dp_biy_3(clk,biy,biy_3);
  uint1 qtcm, scrv0;                                         // uint1 qtcm , scrv0 ;
  boolean bypass, framed, reframe, scramb, gen, tcm;         // boolean bypass , framed , reframe , scramb , gen , tcm ;
  setLine #(1,0,1) f_11 (c_ln[11],"setVar",T,F);             // bypass = flgs [ 0 ] ;
  setLine #(1,0,1) f_12 (c_ln[12],"setVar",T,F);             // framed = flgs [ 1 ] ;
  setLine #(1,0,1) f_13 (c_ln[13],"setVar",T,F);             // scramb = flgs [ 2 ] ;
  setLine #(1,0,1) f_14 (c_ln[14],"setVar",T,F);             // gen = flgs [ 3 ] ;
  setLine #(1,0,1) f_15 (c_ln[15],"setVar",T,F);             // tcm = flgs [ 4 ] ;
  setLine #(1,1,0) f_16 (c_ln[16],"While",(gen || si_rok) && so_wok,c_xn[51]); // while ( ( gen || si.rok ) && so.wok ) {
  setLine #(16,0,0) f_17 (c_ln[17],"If",! gen,F);            // if ( ! gen ) {
  setLine #(17,0,3) f_18 (c_ln[18],"StreamI_rdBits",T,F);    // bi = si.rdBits ( ilen ) ;
  setLine #(17,0,0) f_19 (c_ln[19],"endIfE",c_xn[17],F);     // }
  setLine #(16,0,0) f_20 (c_ln[20],"ElseIf",T,c_xn[17]);     // else {
  setLine #(20,2,1) f_21 (c_ln[21],"setVar",T,F);            // bi = lrsc & gmask ;
  setLine #(20,2,1) f_22 (c_ln[22],"setVar",T,F);            // lrsc = iLRSP ( lrsc , lrsp ) ;
  setLine #(20,0,0) f_23 (c_ln[23],"endIf",c_xn[20],F|c_en[19]); // }
  setLine #(16,0,0) f_24 (c_ln[24],"If",bypass,F);           // if ( bypass ) {
  setLine #(24,3,1) f_25 (c_ln[25],"StreamO_wrBits",T,F);    // so.wrBits ( olen , bi ) ;
  setLine #(24,0,0) f_26 (c_ln[26],"endIfE",c_xn[24],F);     // }
  setLine #(16,0,0) f_27 (c_ln[27],"ElseIf",T,c_xn[24]);     // else {
  setLine #(27,2,1) f_28 (c_ln[28],"setVar",T,F);            // reframe = framed && ( ifr == 0 ) ;
  setLine #(27,2,1) f_29 (c_ln[29],"setVar",T,F);            // ifr = ( ifr == mfr ) ? 0 : ifr + 1 ;
  setLine #(27,3,1) f_30 (c_ln[30],"setVar",T,F);            // imask = reframe ? 0 : mask ;
  setLine #(27,3,0) f_31 (c_ln[31],"setVar",T,F);            // scrv0 = bi [ 0 : 0 ] ^ ( reframe ? 0 : scrv [ 3 : 3 ] ^ scrv [ 20 : 20 ] ^ ( ( scrc == 31 ) ? 1 : 0 ) ) ;
  setLine #(27,3,1) f_32 (c_ln[32],"setVar",T,F);            // scrc = reframe ? 0 : ( scrv [ 1 ] != scrv [ 9 ] ) ? 0 : scrc + 1 ;
  setLine #(27,3,1) f_33 (c_ln[33],"setVar",T,F);            // scrv = ( scrv0 << 1 ) | ( reframe ? 0 : ( scrv << 1 ) ) ;
  setLine #(27,3,1) f_34 (c_ln[34],"setVar",T,F);            // bix = tcm ? bi >> 1 : scramb ? scrv0 : bi ;
  setLine #(27,3,1) f_35 (c_ln[35],"setVar",T,F);            // biy = bi & 1 ;
  setLine #(27,4,1) f_36 (c_ln[36],"setVar",T,F);            // shft = ( ( shft << 1 ) & imask ) | bix ;
  setLine #(27,0,1) f_37 (c_ln[37],"setVar",T,F);            // ipunc = ( ipunc >= mpunc ) ? 0 : ipunc + 1 ;
  setLine #(27,5,1) f_38 (c_ln[38],"setVar",T,F);            // ilut = ( ipunc << MO ) | shft ;
  setLine #(27,6,1) f_39 (c_ln[39],"setVar",T,F);            // olut = elut [ ilut ] ;
  setLine #(27,0,0) f_40 (c_ln[40],"If",tcm,F);              // if ( tcm ) {
  setLine #(40,7,1) f_41 (c_ln[41],"setVar",T,F);            // uv = uv ^ ( biy << olut [ 1 : 1 ] ) ;
  setLine #(40,7,1) f_42 (c_ln[42],"setVar",T,F);            // otcm2 = olut [ 1 : 0 ] ;
  setLine #(40,7,1) f_43 (c_ln[43],"setVar",T,F);            // qtcm = olut [ 1 : 1 ] ;
  setLine #(40,8,1) f_44 (c_ln[44],"setVar",T,F);            // otcm3 = otcm2 | ( uv [ qtcm ] ? 4 : 0 ) ;
  setLine #(40,9,1) f_45 (c_ln[45],"StreamO_wrBits",T,F);    // so.wrBits ( 3 , otcm3 ) ;
  setLine #(40,0,0) f_46 (c_ln[46],"endIfE",c_xn[40],F);     // }
  setLine #(27,0,0) f_47 (c_ln[47],"ElseIf",T,c_xn[40]);     // else {
  setLine #(47,7,1) f_48 (c_ln[48],"StreamO_wrBits",T,F);    // so.wrBits ( olen - olut [ 8 : 8 ] , olut [ 7 : 0 ] ) ;
  setLine #(47,0,0) f_49 (c_ln[49],"endIf",c_xn[47],F|c_en[46]); // }
  setLine #(27,0,0) f_50 (c_ln[50],"endIf",c_xn[27],F|c_en[26]); // }
  setLine #(16,10,0) f_51 (c_ln[51],"endWhile",c_xn[16],F);  // }
  setLine #(51,0,0) f_52 (c_ln[52],"return",c_stat,F);       // return 0 ;
  setLine #(52,0,0) f_53 (c_ln[53],"endMethod",T,F);         // }

  assign scrv0 = bi[0:0] ^ (reframe ? 0 : scrv[3:3] ^ scrv[20:20] ^ ((scrc == 31) ? 1 : 0));
  always @(posedge clk) begin
    c_wr <= F; c_rd <= F; c_done <= F;
    if (MC==0) begin so_wen <= F; si_ren <= F; end
    if (s_set[0]) polyA <= s_val;
    if (s_set[1]) polyB <= s_val;
    if (s_set[2]) shft <= s_val;
    if (s_set[3]) mask <= s_val;
    if (s_set[4]) mfr <= s_val;
    if (s_set[5]) ifr <= s_val;
    if (s_set[6]) punc <= s_val;
    if (s_set[7]) ipunc <= s_val;
    if (s_set[8]) mpunc <= s_val;
    if (s_set[9]) errs <= s_val;
    if (s_set[10]) elut[s_ind] <= s_val;
    if (s_set[11]) ilen <= s_val;
    if (s_set[12]) olen <= s_val;
    if (s_set[13]) flgs <= s_val;
    if (s_set[14]) scrc <= s_val;
    if (s_set[15]) scrv <= s_val;
    if (s_set[16]) gmask <= s_val;
    if (s_set[17]) lrsc <= s_val;
    if (s_set[18]) lrsp <= s_val;
    if (s_set[19]) uv <= s_val;
    if (c_xn[11]) begin bypass <= flgs[0]; end
    if (c_xn[12]) begin framed <= flgs[1]; end
    if (c_xn[13]) begin scramb <= flgs[2]; end
    if (c_xn[14]) begin gen <= flgs[3]; end
    if (c_xn[15]) begin tcm <= flgs[4]; end
    if (c_en[18]) begin si_ren <= T; si_bits <= ilen; end 
    if (c_xn[18]) begin bi <= si_rbus; end
    if (c_xn[21]) begin bi <= lrsc & gmask; end
    if (c_xn[22]) begin lrsc <= iLRSP (lrsc, lrsp); end
    if (c_xn[25]) begin so_wen <= T; so_bits <= olen; so_wbus <= bi; end
    if (c_xn[28]) begin reframe <= framed && (ifr == 0); end
    if (c_xn[29]) begin ifr <= (ifr == mfr) ? 0 : ifr + 1; end
    if (c_xn[30]) begin imask <= reframe ? 0 : mask; end
    if (c_xn[32]) begin scrc <= reframe ? 0 : (scrv[1] != scrv[9]) ? 0 : scrc + 1; end
    if (c_xn[33]) begin scrv <= (scrv0 << 1) | (reframe ? 0 : (scrv << 1)); end
    if (c_xn[34]) begin bix <= tcm ? bi >>> 1 : scramb ? scrv0 : bi; end
    if (c_xn[35]) begin biy <= bi & 1; end
    if (c_xn[36]) begin shft <= ((shft << 1) & imask) | bix; end
    if (c_xn[37]) begin ipunc <= (ipunc >= mpunc) ? 0 : ipunc + 1; end
    if (c_xn[38]) begin ilut <= (ipunc_4 << MO) | shft; end
    if (c_xn[39]) begin olut <= elut[ilut]; end
    if (c_xn[41]) begin uv <= uv ^ (biy_3 << olut[1:1]); end
    if (c_xn[42]) begin otcm2 <= olut[1:0]; end
    if (c_xn[43]) begin qtcm <= olut[1:1]; end
    if (c_xn[44]) begin otcm3 <= otcm2 | (uv[qtcm] ? 4 : 0); end
    if (c_xn[45]) begin so_wen <= T; so_bits <= 3; so_wbus <= otcm3; end
    if (c_xn[48]) begin so_wen <= T; so_bits <= olen - olut[8:8]; so_wbus <= olut[7:0]; end
    if (c_xn[52]) begin c_stat <= 0; c_done <= T; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[54*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 41,1,1,1, 33,16,0,0, 10,17,0,2, 35,17,0,0, 34,16,0,0, 21,20,2,0, 21,20,2,0, 32,20,0,0, 33,16,0,0, 10,24,3,0, 35,24,0,0, 34,16,0,0, 21,27,2,0, 21,27,2,0, 21,27,3,0, 21,27,3,0, 21,27,3,0, 21,27,3,0, 21,27,3,0, 21,27,3,0, 21,27,4,0, 21,27,0,0, 21,27,5,0, 21,27,6,0, 33,27,0,0, 21,40,7,0, 21,40,7,0, 21,40,7,0, 21,40,8,0, 10,40,9,0, 35,40,0,0, 34,27,0,0, 10,47,7,0, 32,47,0,0, 32,27,0,0, 42,16,10,0, 14,51,0,0, 15,52,0,0};
  sequencer #(54,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
  assign s_test = {c_cnt[0],c_done,c_active,c_start,o_ena,i_ena,o_frst,i_frst};
endmodule

