/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See FEC.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.lib.*;
public class FEC extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, IFMT = FBIT, OFMT = FBIT, SELFPACE = 1, BW = 32, MO = 9, OLUT = 12, NLUT = 1 << OLUT;
public final static int LRSPM = 0x2000023;
public static class CORE extends Core implements Modefs {
  public int alg;
  public int len;
  public int scr;
  public int bpw;
  public int upp;
  int polyA, polyB;
  int shft, mask;
  int mfr, ifr;
  int punc, ipunc, mpunc;
  int errs;
  int[] elut;
  int ilen;
  int olen;
  int flgs;
  int scrc;
  int scrv;
  int gmask;
  int lrsc, lrsp;
  int uv;
  public void setLength (int length) {
    len = length;
  }
  public void optimize () {
    if (getBit(flgs, 0)) elut = new int[8];
  }
  public int init () {
    len = 0;
    mfr = 0;
    alg = FEC_NONE;
    upp = 0;
    scr = -1;
    bpw = -1;
    lrsp = 0;
    lrsc = 0;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "S:ALG")) alg = value.toItem (fecList);
    else if (isMatch (key, "S:FEC")) alg = value.toItem (fecList);
    else if (isMatch (key, "S:SCR")) scr = value.toItem (scrList);
    else if (isMatch (key, "L:LEN")) len = value.toL ();
    else if (isMatch (key, "L:BPW")) bpw = value.toL ();
    else if (isMatch (key, "L:LRSP")) lrsp = value.toL ();
    else if (isMatch (key, "L:LRSI")) lrsc = value.toL ();
    else if (isMatch (key, "L:VFLG"));
    else if (isMatch (key, "L:ERRS")) errs = value.toL ();
    else if (isMatch (key, "L:UPP")) upp = value.toL ();
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:ALG")) value.fromL (alg);
    else if (isMatch (key, "L:LEN")) value.fromL (len);
    else if (isMatch (key, "L:SCR")) value.fromL (scr);
    else if (isMatch (key, "L:ERRS")) value.fromL (errs);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    int iom;
    elut = new int[NLUT];
    iom = Modems.getFECLUT (alg, upp, elut, null);
    ilen = (iom >> 0) & 0xFF;
    olen = (iom >> 8) & 0xFF;
    mask = (iom >> 16) & 0xFFF;
    mpunc = (iom >> 28) & 0xF;
    gmask = (1 << ilen) - 1;
    ifr = 0;
    shft = 0;
    ipunc = mpunc;
    scrv = 0;
    flgs = 0;
    if (scr < 0) scr = (alg == FEC_NONE) ? SCR_LRS : SCR_NONE;
    if (scr > SCR_LRS) {
      flgs |= 0x4;
      if (alg == FEC_NONE) ilen = olen = 1;
    }
    if (alg == FEC_NONE && scr <= SCR_LRS) {
      flgs |= 0x1;
      ilen = olen = 32;
    }
    if (len > 0) {
      flgs |= 0x2;
      mfr = len - 1;
    }
    if (bpw == 0) flgs |= 0x8;
    if (alg >= FEC_TCM) flgs |= 0x10;
    if (lrsp == 0 || lrsp == - 1) lrsp = LRSPM;
    optimize ();
    if((this.halo.vbpr&1)!=0)System.out.printf ("FEC alg=%d scr=%x len=%d ilen=%d olen=%d flgs=%x punc=%d\n", alg, scr, len, ilen, olen, flgs, mpunc + 1);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    int olut;
    int ilut;
    int imask;
    int bi;
    int bix;
    int otcm3;
    int biy, otcm2;
    int qtcm, scrv0;
    boolean bypass, framed, reframe, scramb, gen, tcm;
    bypass = getBit(flgs, 0);
    framed = getBit(flgs, 1);
    scramb = getBit(flgs, 2);
    gen = getBit(flgs, 3);
    tcm = getBit(flgs, 4);
    while ((gen || si.rok) && so.wok) {
      if (! gen) {
        bi = si.rdBits (ilen);
      }
      else {
        bi = lrsc & gmask;
        lrsc = iLRSP (lrsc, lrsp);
      }
      if (bypass) {
        so.wrBits (olen, bi);
      }
      else {
        reframe = framed && (ifr == 0);
        ifr = (ifr == mfr) ? 0 : ifr + 1;
        imask = reframe ? 0 : mask;
        scrv0 = getBits(bi, 0, 0) ^ (reframe ? 0 : getBits(scrv, 3, 3) ^ getBits(scrv, 20, 20) ^ ((scrc == 31) ? 1 : 0));
        scrc = reframe ? 0 : (getBit(scrv, 1) != getBit(scrv, 9)) ? 0 : scrc + 1;
        scrv = (scrv0 << 1) | (reframe ? 0 : (scrv << 1));
        bix = tcm ? bi >> 1 : scramb ? scrv0 : bi;
        biy = bi & 1;
        shft = ((shft << 1) & imask) | bix;
        ipunc = (ipunc >= mpunc) ? 0 : ipunc + 1;
        ilut = (ipunc << MO) | shft;
        olut = elut[ilut];
        if (tcm) {
          uv = uv ^ (biy << getBits(olut, 1, 1));
          otcm2 = getBits(olut, 1, 0);
          qtcm = getBits(olut, 1, 1);
          otcm3 = otcm2 | (getBit(uv, qtcm) ? 4 : 0);
          so.wrBits (3, otcm3);
        }
        else {
          so.wrBits (olen - getBits(olut, 8, 8), getBits(olut, 7, 0));
        }
      }
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
