/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See DUC2.jv for documentation.
*/
#include "Filters.c"

/** Define Signatures */
#define CORE_NAME DUC2
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 2
#define AW 16
#define BW NP*32
#define CW 6

enum { DUC2_ONP = 1 };
enum { DUC2_OTAP = 4 };
enum { DUC2_NTAP = 16 };
enum { DUC2_SHF = 8 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  real_8 fbwf;
  real_8 fbwn;
  int_2 ntap;
  int_2 nrpt;
  int_u1 quad;
  int_u1 dquad;
  real_4* fta;
  real_4* ftb;
  real_4* ftc;
  CxTapBuf* vd;
  Value* vo;
} DUC2;

#include "cores/CoreProtos.h"

/** CORE Code */

void* DUC2_alloc (char *config) {
  DUC2* plan = DUC2_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 DUC2_upload (DUC2* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,9);
  HW_loadInt  (planp,plan->ntap);
  HW_loadInt  (planp,plan->nrpt);
  HW_loadInt  (planp,plan->quad);
  HW_loadInt  (planp,plan->dquad);
  HW_loadBuf  (planp,plan->fta,'f',1);
  HW_loadBuf  (planp,plan->ftb,'f',1);
  HW_loadBuf  (planp,plan->ftc,'f',1);
  HW_loadInt  (planp,0);
  HW_loadInt  (planp,0);
  HW_push (planp,HW_OPEN);
  return 9;
}

int_4 DUC2_init (DUC2* plan) {
  plan->fbwf = 1.0;
  plan->fbwn = 1.0;
  plan->ntap = -1;
  return 0;
}

int_4 DUC2_set (DUC2* plan, String* key, Value* value) {
  if (isMatch (key, "L:NTAP")) plan->ntap = Value_toL (value);
  else if (isMatch (key, "L:FCNY")) plan->dquad = Value_toL (value) % 4;
  else if (isMatch (key, "D:FBWF")) plan->fbwf = Value_toD (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 DUC2_get (DUC2* plan, String* key, Value* value) {
  if (isMatch (key, "D:XDIO")) Value_fromD (value, 0.5);
  else return Core_get (plan, key, value);
  return 0;
}

void DUC2_genFilt (DUC2* plan) {
  int_4 i, j, k, nt = plan->nrpt * plan->ntap;
  real_8 fw = plan->fbwn * plan->fbwf;
  real_4 scl = plan->nrpt * mulfp2 (1.0F, DUC2_SHF);
  real_4* ctap = zallocBuf(sizeof(real_4)*(nt * 2));
  Filters_genFirKais (1, fw / plan->nrpt, 0.0, 0.05 / plan->nrpt, 90.0, ctap, nt);
  for (i = j = 0; j < plan->ntap; j ++, i += 4) {
    plan->fta[j] = ctap[i+0] * scl;
    plan->ftb[j] = ctap[i+2] * scl;
  }
  for (i = 0; i < nt; i ++) {
    plan->ftc[i] = ctap[i+i] * scl;
  }
}

int_4 DUC2_open (DUC2* plan) {
  int_4 i;
  if (plan->ntap <= 0) plan->ntap = DUC2_NTAP;
  if (plan->ntap > DUC2_NTAP) {
    printf ("Warn ntap=%d limited to ntap=%d for this compile\n", plan->ntap, DUC2_NTAP);
    plan->ntap = DUC2_NTAP;
  }
  plan->vd = CxTapBuf_new (DUC2_OTAP, 1, DUC2_NTAP, -1);
  CxTapBuf_setLength (plan->vd, plan->ntap);
  plan->fta = zallocBuf(sizeof(real_4)*(DUC2_NTAP));
  plan->ftb = zallocBuf(sizeof(real_4)*(DUC2_NTAP));
  plan->ftc = zallocBuf(sizeof(real_4)*(DUC2_NTAP * 2));
  plan->vo = Value_new ("CI", NP);
  plan->nrpt = NP;
  DUC2_genFilt (plan);
  plan->quad = 0;
  if(plan->halo.vbpr&1)printf ("DUC2 fbwn=%f fbwf=%f ntap=%d NP=%d\n", plan->fbwn, plan->fbwf, plan->ntap, NP);
  DUC2_upload (plan,plan);
  return 0;
}

int_4 DUC2_process (DUC2* plan, Stream* si, Stream* so) {
  CxReal_4 cm_,*cm=&cm_, foa_,*foa=&foa_, fob_,*fob=&fob_, foaq_,*foaq=&foaq_, fobq_,*fobq=&fobq_;
  int_u1 i, j;
  while (si->rok && so->wok) {
    Stream_rdCIF (si, cm);
    CxTapBuf_load (plan->vd, cm);
    foa->x = 0;
    foa->y = 0;
    fob->x = 0;
    fob->y = 0;
    for (j = 0; j < plan->ntap; j ++) {
      CxReal_4 fdx_,*fdx=&fdx_, fdxa_,*fdxa=&fdxa_, fdxb_,*fdxb=&fdxb_;
      real_4 ftxa, ftxb;
      CxTapBuf_get (plan->vd, j, fdx);
      fdxa = fdx;
      fdxb = fdx;
      ftxa = plan->fta[j];
      ftxb = plan->ftb[j];
      foa->x += ftxa * fdxa->x;
      fob->x += ftxb * fdxb->x;
      foa->y += ftxa * fdxa->y;
      fob->y += ftxb * fdxb->y;
    }
    qrotcc (foa, plan->quad, foaq);
    qrotcc (fob, plan->quad + plan->dquad, fobq);
    plan->quad = (plan->quad + plan->dquad + plan->dquad) & 0x3;
    Value_setCFIS2 (plan->vo, - DUC2_SHF, foaq, fobq);
    Stream_wr (so, plan->vo);
  }
  return 0;
}

int_4 DUC2_close (DUC2* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 DUC2_poll (DUC2* plan) { return 0; }

int_4 DUC2_free (DUC2* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

DUC2* DUC2_subCore (HALO* halo, int_4 scid) {
  DUC2* plan = DUC2_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  DUC2_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
