/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See DDC.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.core.Filters;
import nxm.ice.core.Filters.CxCIC;
import nxm.ice.lib.*;
public class DDC extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(STREAM); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(STREAM); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(STREAM); } }

public final static int FLOW = STREAM, NP = 1, SIBW = 32 * NP, SOBW = 32, OCIC = 5, ODEC = 10, OTAP = 8, RTAP = 256, PTAP = 8, OAGC = 12, FPS = (RTAP / 8) - 1;
public final static int MAXCR = 250000000;
public static class CORE extends Core {
  public double fs;
  public double fbwf;
  public double dbwf;
  public float alpha;
  public int gain;
  double p, dp;
  float fscl;
  int ntap;
  int cdec, ndec, ups;
  int mdec, idec;
  int oagc;
  int pass;
  int maxpass;
  int count;
  int maxcount;
  float blkSum;
  float AMDes;
  boolean cntovr;
  CxCIC cic;
  CxTapBuf vd;
  RomF rft;
  public void setFreq (double freq) {
    dp = - freq / fs;
    putVars ("dp");
  }
  public void setFcny (double fcny) {
    dp = - fcny;
    putVars ("dp");
  }
  public void setBW (double bw) {
    ups = 1;
    cdec = 1;
    ndec = d2i (fs / (bw * dbwf));
    if (ndec < 1) {
      ups = 2;
      ndec = 1;
    }
    if (ndec > 3) {
      cdec = (ndec >> 1);
      ndec = 2;
    }
    fbwf = bw / (ups * fs / cdec);
    if((this.halo.vbpr&1)!=0)System.out.printf ("DDC.setBW fs=%f bw=%f bwf=%f ups=%d cdec=%d ndec=%d\n", fs, bw, dbwf, ups, cdec, ndec);
  }
  public double getRatio () {
    return (1.0 * ups) / (cdec * ndec);
  }
  public double getDelay () {
    double delay = oagc * maxcount * cdec * ndec;
    if (cdec == 1) delay -= (2.5 * cdec * ndec);
    else delay -= (3.5 + 2.5 * cdec * ndec);
    delay -= (ntap / 2 * cdec);
    return delay / fs;
  }
  public void setDec (int dec) {
    ups = 1;
    cdec = 1;
    ndec = dec;
    if (ndec > 3) {
      cdec = (ndec >> 1);
      ndec = 2;
    }
    fbwf = 0.8;
  }
  public void setGain (double gain) {
    int cicgain = d2i (gain / 6) * 6;
    cic.setGain (cicgain);
    gain -= cicgain;
    fscl = d2f (pow (2.0, gain / 6)) / i2f (FPS);
    putVars ("fscl");
  }
  public void genFilt () {
    int i, nt = ntap;
    double fw = fbwf;
    float scl = i2f (FPS);
    float falpha = (alpha > 0) ? alpha : (cdec == 2) ? 0.2F : (cdec == 3) ? 0.3F : 0.4F;
    float[] ctap = new float[nt*2];
    Filters.genFirKais (1, fw, 0.0, 0.01, 70.0, ctap, nt);
    for (i = 0; i < nt; i ++) ctap[i] = ctap[i+i];
    if (cdec > 1) Filters.applyCompensation (falpha, ctap, nt);
    for (i = 0; i < nt; i ++) rft.set (i, ctap[i] * scl);
  }
  public int init () {
    fs = -1.0;
    dbwf = 1.5;
    dp = 0;
    ntap = 128;
    gain = 0;
    alpha = -1;
    AMDes = 0.7071F;
    setDec (1);
    maxcount = (1 << OAGC);
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "D:FS")) fs = value.toD ();
    else if (isMatch (key, "D:FREQ")) setFreq (value.toD ());
    else if (isMatch (key, "D:FCNY")) setFcny (value.toD ());
    else if (isMatch (key, "D:BW")) setBW (value.toD ());
    else if (isMatch (key, "L:DEC")) setDec (value.toL ());
    else if (isMatch (key, "D:FBWF")) fbwf = value.toD ();
    else if (isMatch (key, "D:DBWF")) dbwf = value.toD ();
    else if (isMatch (key, "L:NTAP")) ntap = value.toL ();
    else if (isMatch (key, "L:GAIN")) gain = value.toL ();
    else if (isMatch (key, "L:AGC")) oagc = value.toL ();
    else if (isMatch (key, "F:AMDES")) AMDes = value.toF ();
    else if (isMatch (key, "F:ALPHA")) alpha = value.toF ();
    else if (isMatch (key, "L:MAXPASS")) maxpass = value.toL ();
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "D:FS")) value.fromD (fs);
    else if (isMatch (key, "D:FREQ")) value.fromD (dp * fs);
    else if (isMatch (key, "D:RATIO")) value.fromD (getRatio ());
    else if (isMatch (key, "D:XDIO")) value.fromD (1.0 / getRatio ());
    else if (isMatch (key, "D:XSIO")) value.fromD (getDelay ());
    else if (isMatch (key, "L:NTAP")) value.fromL (ntap);
    else if (isMatch (key, "L:GAIN")) value.fromL (gain);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    cic = new CxCIC (OCIC, ODEC);
    cic.setDecimation (cdec);
    vd = new CxTapBuf (OTAP, 1, PTAP, 0);
    vd.setLength (ntap);
    rft = new RomF (OTAP, PTAP);
    genFilt ();
    setGain (gain);
    if (oagc > 0) AMDes *= d2f (pow (2.0, gain / 6));
    p = 0;
    mdec = ndec - 1;
    idec = mdec;
    System.out.printf ("DDC Fs=%f Fc=%f cdec=%d ndec=%d fbwf=%f ntap=%d mc=%d NP=%d\n", fs, - fs * dp, cdec, ndec, fbwf, ntap, maxcount, NP);
    this.halo.state=1;
    return 0;
  }
  public int process (Stream si, Stream so) {
    CxFloat sc=CxFloat.stk(), cn=CxFloat.stk(), cm=CxFloat.stk(), cc=CxFloat.stk(), fo=CxFloat.stk(), fos=CxFloat.stk(), fc=CxFloat.stk();
    float fp, msq, mag, blkAvg, blkAvgInv;
    boolean cgo, fout, okOut;
    int ia;
    if (cntovr) {
      pass = (pass >= 0x1000) ? 0x1000 : pass + 1;
      if (pass <= oagc) {
        blkAvg = divfp2 (blkSum, OAGC);
        blkAvgInv = invf (blkAvg);
        fscl = fscl * AMDes * blkAvgInv;
        blkSum = 0;
      }
      count = 0;
      cntovr = false;
    }
    okOut = (pass >= oagc);
    while (si.rok && so.wok && ! cntovr) {
      if (ups == 2 && getBit(count, 0)) {
        cn.x = 0;
        cn.y = 0;
      }
      else {
        si.rdCIF (cn);
      }
      fp = d2f (p);
      p = frac (p + dp);
      sincoscf (fp, sc);
      mulcc (cn, sc, cm);
      cgo = cic.process (cm, cc);
      if (cgo) {
        vd.load (cc);
        fout = (idec == 0);
        idec = (idec == 0) ? mdec : idec - 1;
        if (fout) {
          fo.x = 0;
          fo.y = 0;
          for (ia = 0; ia < ntap; ia ++) {
            float ft;
            CxFloat fdi=CxFloat.stk();
            ft = rft.get (ia);
            vd.get (ia, fdi);
            fo.x += ft * fdi.x;
            fo.y += ft * fdi.y;
          }
          mulcf (fo, fscl, fos);
          if (okOut) {
            so.wrCFI (fos);
          }
          if (pass < oagc) {
            fc.x = fos.x * fos.x;
            fc.y = fos.y * fos.y;
            msq = fc.x + fc.y;
            mag = sqrtf (msq);
            blkSum = blkSum + mag;
          }
          count = count + 1;
          cntovr = (count >= maxcount);
        }
      }
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
