/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See AU2C.jv for documentation.
*/

import CORE_types::*;
package AU2C_types;
import CORE_types::*;
typedef struct packed {
  uint4 smd;
  uint6 cnt;
  uint10 ptr;
  uint4 irow;
  uint4 orow;
  uint15 ilen;
  uint15 olen;
  uint19 iram;
  uint19 oram;
} ChannelState;
endpackage
import AU2C_types::*;

module AU2C_core #(PORT=1, IBW=64,OBW=64, IFLG=0,OFLG=0, IOCLKS=1, IKR=4,OKR=4, PBW=32,PKR=1) (
  input[2:0] s_clks, input s_rst, input s_cs, input[31:0] s_addr,
                     input s_wr, input[31:0] s_wrbus, input s_rd, output[31:0] s_rdbus, output s_ack,
  input[3:0] io_clk, output[1:0] i_rdy, input i_ena, input[7:0] i_sel, input[IBW-1:0] i_bus,
                     output[1:0] o_rdy, input o_ena, output[7:0] o_sel, output[OBW-1:0] o_bus,
  output [7:0] s_test);
  wire T=1,F=0; wire[7:0] T8=~0,F8=0;
  localparam SBW=32, ARRAY=0, STREAM=1, BUFFER=2, BUFSTR=3, PACKET=4;
  localparam BCIO=0, BCI=1, BCO=2, BCIIO=3, BCIOO=4, BCIIIOO=5;
  localparam FRAW=0, FCXI=1, FBIT=2, FAXI=3, FALL=4, FSWP=5;
  localparam TIGHT=8, BPAR=1024, BDMA=2048, BENA=16384, DBLBUF=32768, NEMPTY=131072, RAHEAD=262144;
  localparam FLOW=BUFFER, BUFCFG=BCIO, SELFPACE=0, PIPE=-1, MC=0, CW=6, AW=16, MBW=256, NP=1, BW=64, SIBW=BW, SOBW=BW, BIBW=BW, BOBW=BW, PIBW=PBW, POBW=PBW, IFMT=FRAW, OFMT=FRAW, DBGBW=32, DBGBD=10, P2=FLOW, P3=NP, P4=BW, P5=0, P6=0, P7=0;
  localparam XIBW=BIBW, XOBW=BOBW;
  localparam BWP=BW/8, IBWP=IBW/8, OBWP=OBW/8, XIBWP=XIBW/8, XOBWP=XOBW/8;
  localparam XIBWO=(XIBW>64)? 4 : (XIBW>32)? 3 : (XIBW>16)? 2 : (XIBW>8)? 1 : 0;
  localparam XOBWO=(XOBW>64)? 4 : (XOBW>32)? 3 : (XOBW>16)? 2 : (XOBW>8)? 1 : 0;
  localparam NSUB=PORT/100, SUB=PORT%100;

  wire s_clk=s_clks[0],clk=s_clks[0],clk2=s_clks[1]; wire[1:0] clks=s_clks;
  logic rst,s_wrsys,s_wrscid; logic[31:0] s_sys; logic s_csm,s_csd,s_ena; logic[3:0] s_scid; 
  logic c_rd,c_wr,c_wok; logic[15:0] c_adr; logic[31:0] c_wbus,c_rbus; wire c_ok;
  always @(posedge s_clk) begin
    s_csd <= s_cs && s_addr[11:0]==12'hFFC;
    s_csm <= s_cs && !s_csd;
    s_wrsys <= s_cs && s_wr && s_addr[11:0]==0;
    if (s_rst) s_sys <= 0; else if (s_wrsys) s_sys <= s_wrbus;
    rst <= s_rst || s_sys[23];
    if (s_rst) c_wok <= 1; else if (!c_wr) c_wok <= !s_sys[22];
    s_ena <= (NSUB>0)? s_clks[2] : s_sys[0];
  end
  wire frst=!s_ena; wire s_opt=s_sys[4]; wire[3:0] s_ifmt=s_sys[11:8], s_ofmt=s_sys[15:12]; wire [1:0] s_vbpr=s_sys[21:20];
  wire i_frst = frst; wire o_frst = frst; wire p_frst = frst;

  wire [31:0] s_sub, s_rdbusm, s_rdbust; wire [63:0] s_val; wire [15:0] s_ind; wire[5:0] s_set;
  wire s_csr=s_csm && !s_sub[24] && !s_addr[0];
  setter #(6,1) s_bank (clk,rst,s_csm&s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);
  portstatusblk #(PORT,"AU2C",P2,P3,P4,P5,P6,P7) s_sblk (s_clk,s_csr,s_addr,s_wr,s_wrbus,s_rd,s_rdbusm, clk,1'b1,c_adr,c_wok&c_wr,c_wbus,c_rd,c_rbus);
  assign s_rdbus = s_rdbusm;

  wire i_clk=io_clk[0], o_clk=(IOCLKS>1)?io_clk[1]:io_clk[0];
  logic bi_rd,bo_wr,bi_nxt,bo_nxt,bi_rok,bo_wok;
  logic[AW-1:0] bi_adr,bo_adr,bi_len,bo_len; logic[31:0] bi_dma,bo_dma;
  logic[XIBW-1:0] bi_bus; logic[XIBWP-1:0] bi_sel; logic[XOBW-1:0] bo_bus; logic[XOBWP-1:0] bo_sel;
  logic[XIBWO-1:0] bi_adrb;  always @(posedge s_clk) bi_adrb <= bi_adr;
  logic[7:0] bi_busb; assign bi_busb = bi_bus >> {bi_adrb,3'h0};
  logic i_val; always @(posedge i_clk) i_val <= i_ena;
  wire c_rdy = (SELFPACE!=0) || (bi_rok && bo_wok);

  fiaoNxM #(IBW+IBWP,XIBW+XIBWP,IKR,8,IFLG^BPAR,BPAR|BDMA|BENA) f_i (i_clk,i_frst, i_rdy,i_val,{i_sel,i_bus}, s_clk,i_frst, bi_rok,bi_rd,bi_dma,bi_nxt,bi_adr,bi_len,{bi_sel,bi_bus});
  aifoNxM #(XOBW+XOBWP,OBW+OBWP,OKR,8,BPAR|BDMA|BENA,OFLG^BPAR) f_o (s_clk,o_frst, bo_wok,bo_wr,bo_dma,bo_nxt,bo_adr,bo_len,{bo_sel,bo_bus}, o_clk,o_frst, o_rdy,o_ena,{o_sel,o_bus});

  logic c_start,c_prep,c_done,c_active; logic[15:0] c_cnt,c_stat;
  always @(posedge clk) begin
    if (frst) c_prep <= 0; else if (c_done) c_prep <= 0;
    if (frst) c_start <= 0; else c_start <= s_ena && (c_rdy||c_prep) && !c_start && !c_active;
    if (frst) c_active <= 0; else c_active <= c_start || (c_active && !c_done);
    if (c_start) c_cnt <= 0; else c_cnt <= c_cnt+1;
  end
  flowcontrol f_c (clk, frst, s_opt, c_cnt, c_ok);

  import CORE_funcs::*;

  localparam NL=246, RW=12, NHDR=64, NPKT=2432, NPKTI=2432, NCFG=64, NOVR=4000, NRAM=4096, MRAM=(NRAM-1), NCRP=270,
     NCRV=260, NROW=9, NVRC=(87*9), NOUT=2340, NTOT=(NHDR+NPKT), NTOTI=(NHDR+NPKTI), SFIL=(NHDR+NOUT-4), SOVH=(NHDR+NOUT+12),
     MAXDMAI=272, MAXDMAO=264;
  localparam CV_halo_sys=0, CV_halo_flag=28, CV_halo_func=64, CV_halo_fmts=68, CV_halo_flow=72, CV_halo_impl=76;
  localparam CV_csa=256,CV_ram=260,CV_rov=264,CV_rop=268,CV_dmar=272,CV_dmaw=276;


  uint15 NCRPS[3:0]; assign NCRPS[0]=NCRP*1, NCRPS[1]=NCRP*4, NCRPS[2]=NCRP*16, NCRPS[3]=NCRP*64;
  uint15 NCRVS[3:0]; assign NCRVS[0]=NCRV*1, NCRVS[1]=NCRV*4, NCRVS[2]=NCRV*16, NCRVS[3]=NCRV*64;
  uint19 DMINS[3:0]; assign DMINS[0]=10*1*12, DMINS[1]=10*4*3, DMINS[2]=10*16*1, DMINS[3]=10*64*1;
  ChannelState csa[NCFG];
  logic ram_wr; logic[32-1:0] ram_wdma; logic[CW-1:0] ram_wchn; logic[RW-1:0] ram_wadr; logic[BW-1:0] ram_wbus; 
  logic ram_rd; logic[32-1:0] ram_rdma; logic[CW-1:0] ram_rchn; logic[RW-1:0] ram_radr; logic[BW-1:0] ram_rbus; logic[8-1:0] ram_rbusb; 
  RamRWC #( RW , BW , BW , CW ) ram (clks,rst,ram_wr,ram_wdma,ram_wchn,ram_wadr,ram_wbus,ram_rd,ram_rdma,ram_rchn,ram_radr,ram_rbus,ram_rbusb);
  logic rov_wr; logic[32-1:0] rov_wdma; logic[CW-1:0] rov_wchn; logic[4-1:0] rov_wadr; logic[BW-1:0] rov_wbus; 
  logic rov_rd; logic[32-1:0] rov_rdma; logic[CW-1:0] rov_rchn; logic[4-1:0] rov_radr; logic[8-1:0] rov_rbus; logic[8-1:0] rov_rbusb; 
  RamRWC #( 4 , BW , 8 , CW ) rov (clks,rst,rov_wr,rov_wdma,rov_wchn,rov_wadr,rov_wbus,rov_rd,rov_rdma,rov_rchn,rov_radr,rov_rbus,rov_rbusb);
  logic rop_wr; logic[32-1:0] rop_wdma; logic[1-1:0] rop_wchn; logic[RW-1:0] rop_wadr; logic[BW-1:0] rop_wbus; 
  logic rop_rd; logic[32-1:0] rop_rdma; logic[1-1:0] rop_rchn; logic[RW-1:0] rop_radr; logic[BW-1:0] rop_rbus; logic[8-1:0] rop_rbusb; 
  RamRWC #( RW , BW , BW , 1 ) rop (clks,rst,rop_wr,rop_wdma,rop_wchn,rop_wadr,rop_wbus,rop_rd,rop_rdma,rop_rchn,rop_radr,rop_rbus,rop_rbusb);
  logic dmar_start; logic[RW-1:0] dmar_cnt; logic[8-1:0] dmar_flags; logic dmar_shrd; logic dmar_busy; 
  logic dmar_rok; logic[RW-1:0] dmar_radr; logic[BW-1:0] dmar_rbus; logic[32-1:0] dmar_rdma; 
  logic dmar_wok; logic[RW-1:0] dmar_wadr; logic[BW-1:0] dmar_wbus; logic[32-1:0] dmar_wdma; 
  Dma #( RW , BW ) dmar (clks,rst,dmar_start,dmar_cnt,dmar_flags,dmar_shrd,dmar_busy,dmar_rok,dmar_radr,dmar_rbus,dmar_rdma,dmar_wok,dmar_wadr,dmar_wbus,dmar_wdma);
  logic dmaw_start; logic[RW-1:0] dmaw_cnt; logic[8-1:0] dmaw_flags; logic dmaw_shrd; logic dmaw_busy; 
  logic dmaw_rok; logic[RW-1:0] dmaw_radr; logic[BW-1:0] dmaw_rbus; logic[32-1:0] dmaw_rdma; 
  logic dmaw_wok; logic[RW-1:0] dmaw_wadr; logic[BW-1:0] dmaw_wbus; logic[32-1:0] dmaw_wdma; 
  Dma #( RW , BW ) dmaw (clks,rst,dmaw_start,dmaw_cnt,dmaw_flags,dmaw_shrd,dmaw_busy,dmaw_rok,dmaw_radr,dmaw_rbus,dmaw_rdma,dmaw_wok,dmaw_wadr,dmaw_wbus,dmaw_wdma);

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[246];  wire c_en[246];  wire c_xn[246];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",c_start,F);    // public int process ( BufferI bi , BufferO bo ) {
  int_4 flag;                                                // int_4 flag ;
  int_8 bx, bx1;                                             // int_8 bx , bx1 ;
  int_1 bb, br;                                              // int_1 bb , br ;
  uint2 omc;                                                 // uint2 omc ;
  uint3 nds;                                                 // uint3 nds ;
  uint4 omd, typ, smd, pmode, noc;                           // uint4 omd , typ , smd , pmode , noc ;
  uint6 chn, seq, cnt;                                       // uint6 chn , seq , cnt ;
  uint8 chx, ndx, ndy;                                       // uint8 chx , ndx , ndy ;
  uint9 bpct;                                                // uint9 bpct ;
  uint9 ncol;                                                // uint9 ncol ;
  uint10 ptr, xptr, nptr;                                    // uint10 ptr , xptr , nptr ;
  uint12 i, iadr, jadr, oadr;                                // uint12 i , iadr , jadr , oadr ;
  uint12 i_3; delayp #(3,12) dp_i_3(clk,i,i_3);
  uint12 iper, oper, iend, oend;                             // uint12 iper , oper , iend , oend ;
  uint19 iram, oram, dram, tram, dmin;                       // uint19 iram , oram , dram , tram , dmin ;
  uint3 xpebc, xpobc;                                        // uint3 xpebc , xpobc ;
  uint4 irow, orow;                                          // uint4 irow , orow ;
  uint15 ilen, olen;                                         // uint15 ilen , olen ;
  uint15 inpr, onpr;                                         // uint15 inpr , onpr ;
  boolean iok, ook, restart, doin, doout, doovh, byp;        // boolean iok , ook , restart , doin , doout , doovh , byp ;
  ChannelState cs;                                           // ChannelState cs ;
  setLine #(1,0,1) f_22 (c_ln[22],"setVar",T,F);             // nptr = 0 ;
  setLine #(1,0,1) f_23 (c_ln[23],"setVar",T,F);             // i = 0 ;
  setLine #(1,0,3) f_24 (c_ln[24],"Ram_rd",CV_halo_flag,F);  // flag = this.halo.flag ;
  setLine #(1,1,3) f_25 (c_ln[25],"BufferI_getX",T,F);       // bx = bi.getX ( i ) ;
  setLine #(1,4,1) f_26 (c_ln[26],"setVar",T,F);             // ipkt = bx [ 63 : 32 ] ;
  setLine #(1,4,1) f_27 (c_ln[27],"setVar",T,F);             // bx [ 63 : 32 ] = opkt ;
  setLine #(1,5,1) f_28 (c_ln[28],"BufferO_setX",T,F);       // bo.setX ( i , bx ) ;
  setLine #(1,5,1) f_29 (c_ln[29],"setVar",T,F);             // i += 8 ;
  setLine #(1,6,3) f_30 (c_ln[30],"BufferI_getX",T,F);       // bx = bi.getX ( i ) ;
  setLine #(1,9,1) f_31 (c_ln[31],"BufferO_setX",T,F);       // bo.setX ( i , bx ) ;
  setLine #(1,9,1) f_32 (c_ln[32],"setVar",T,F);             // bx1 = bx ;
  setLine #(1,9,1) f_33 (c_ln[33],"setVar",T,F);             // i += 8 ;
  setLine #(1,9,1) f_34 (c_ln[34],"setVar",T,F);             // chx = bx [ 39 : 32 ] ;
  setLine #(1,9,1) f_35 (c_ln[35],"setVar",T,F);             // chn = bx [ 53 : 48 ] ;
  setLine #(1,9,1) f_36 (c_ln[36],"setVar",T,F);             // omd = bx [ 59 : 56 ] ;
  setLine #(1,9,1) f_37 (c_ln[37],"setVar",T,F);             // typ = bx [ 63 : 60 ] ;
  setLine #(1,10,1) f_38 (c_ln[38],"setVar",T,F);            // omc = omd - 1 ;
  setLine #(1,10,1) f_39 (c_ln[39],"setVar",T,F);            // byp = ( typ == 0 ) || ( typ == 2 ) || ( flag [ 4 : 4 ] != 0 ) ;
  setLine #(1,0,1) f_40 (c_ln[40],"setVar",T,F);             // doovh = ( novh >= NOUT ) ;
  setLine #(1,11,0) f_41 (c_ln[41],"While",i < NHDR,c_xn[45]); // while ( i < NHDR ) {
  setLine #(41,0,3) f_42 (c_ln[42],"BufferI_getX",T,F);      // bx = bi.getX ( i ) ;
  setLine #(41,3,1) f_43 (c_ln[43],"BufferO_setX",T,F);      // bo.setX ( i , bx ) ;
  setLine #(41,0,1) f_44 (c_ln[44],"setVar",T,F);            // i += 8 ;
  setLine #(41,4,0) f_45 (c_ln[45],"endWhile",c_xn[41],F);   // }
  setLine #(45,0,1) f_46 (c_ln[46],"setVar",T,F);            // doin = T ;
  setLine #(45,0,1) f_47 (c_ln[47],"setVar",T,F);            // doout = F ;
  setLine #(45,1,0) f_48 (c_ln[48],"If",byp,F);              // if ( byp ) {
  setLine #(48,0,0) f_49 (c_ln[49],"While",i < NTOT,c_xn[53]); // while ( i < NTOT ) {
  setLine #(49,0,3) f_50 (c_ln[50],"BufferI_getX",T,F);      // bx = bi.getX ( i ) ;
  setLine #(49,3,1) f_51 (c_ln[51],"BufferO_setX",T,F);      // bo.setX ( i , bx ) ;
  setLine #(49,0,1) f_52 (c_ln[52],"setVar",T,F);            // i += 8 ;
  setLine #(49,4,0) f_53 (c_ln[53],"endWhile",c_xn[49],F);   // }
  setLine #(53,0,1) f_54 (c_ln[54],"setVar",T,F);            // doout = T ;
  setLine #(53,1,0) f_55 (c_ln[55],"endIfE",c_xn[48],F);     // }
  setLine #(55,1,0) f_56 (c_ln[56],"ElseIf",doovh,c_xn[48]); // else if ( doovh ) {
  setLine #(56,0,1) f_57 (c_ln[57],"setVar",T,F);            // bx1 [ 63 : 32 ] = 0x90000000 ;
  setLine #(56,1,1) f_58 (c_ln[58],"BufferO_setX",T,F);      // bo.setX ( 8 , bx1 ) ;
  setLine #(56,2,1) f_59 (c_ln[59],"Dma_r2b",dmaw_busy,F);   // dmaw.r2b ( rop , 0 , bo , NHDR , NPKT ) ;
  setLine #(56,0,1) f_60 (c_ln[60],"setVar",T,F);            // novh = 0 ;
  setLine #(56,0,1) f_61 (c_ln[61],"setVar",T,F);            // doin = F ;
  setLine #(56,0,1) f_62 (c_ln[62],"setVar",T,F);            // doout = T ;
  setLine #(56,3,0) f_63 (c_ln[63],"endIfE",c_xn[56],F);     // }
  setLine #(63,1,0) f_64 (c_ln[64],"ElseIf",typ == 1,c_xn[56]); // else if ( typ == 1 ) {
  setLine #(64,0,0) f_65 (c_ln[65],"endIfE",c_xn[64],F);     // }
  setLine #(65,1,0) f_66 (c_ln[66],"ElseIf",T,c_xn[64]);     // else {
  setLine #(66,0,1) f_67 (c_ln[67],"RamRWC_setC",T,F);       // ram.setC ( chn ) ;
  setLine #(66,0,1) f_68 (c_ln[68],"RamRWC_setC",T,F);       // rov.setC ( chn ) ;
  setLine #(66,0,1) f_69 (c_ln[69],"setVar",T,F);            // nds = omc << 1 ;
  setLine #(66,1,1) f_70 (c_ln[70],"setVar",T,F);            // ndx = 1 << nds ;
  setLine #(66,2,1) f_71 (c_ln[71],"setVar",T,F);            // ndy = ndx - 1 ;
  setLine #(66,3,1) f_72 (c_ln[72],"setVar",T,F);            // seq = chx & ndy ;
  setLine #(66,1,1) f_73 (c_ln[73],"setVar",T,F);            // bpct = 3 << nds ;
  setLine #(66,0,1) f_74 (c_ln[74],"setVar",T,F);            // cs = csa [ chn ] ;
  setLine #(66,1,1) f_75 (c_ln[75],"setVar",T,F);            // packed ( oram , iram , olen , ilen , orow , irow , ptr , cnt , smd ) = cs ;
  setLine #(66,0,0) f_76 (c_ln[76],"Dma_addReader",T,F);     // dmar.addReader ( bi ) ;
  setLine #(66,1,0) f_77 (c_ln[77],"Dma_addReader",T,F);     // dmaw.addReader ( ram ) ;
  setLine #(66,0,1) f_78 (c_ln[78],"setVar",T,F);            // inpr = NCRPS [ omc ] ;
  setLine #(66,0,1) f_79 (c_ln[79],"setVar",T,F);            // onpr = NCRVS [ omc ] ;
  setLine #(66,0,1) f_80 (c_ln[80],"setVar",T,F);            // dmin = DMINS [ omc ] + MAXDMAO ;
  setLine #(66,0,1) f_81 (c_ln[81],"setVar",T,F);            // dram = iram - oram ;
  setLine #(66,1,1) f_82 (c_ln[82],"setVar",T,F);            // doout = dram > dmin && dram < NRAM ;
  setLine #(66,0,1) f_83 (c_ln[83],"setVar",T,F);            // iper = 192 ;
  setLine #(66,0,1) f_84 (c_ln[84],"setVar",T,F);            // iadr = NHDR ;
  setLine #(66,0,1) f_85 (c_ln[85],"setVar",T,F);            // iend = NHDR + NPKT ;
  setLine #(66,4,0) f_86 (c_ln[86],"If",seq == 0,F);         // if ( seq == 0 ) {
  setLine #(86,0,1) f_87 (c_ln[87],"setVar",T,F);            // irow = 0 ;
  setLine #(86,0,1) f_88 (c_ln[88],"setVar",T,F);            // ilen = 0 ;
  setLine #(86,1,0) f_89 (c_ln[89],"endIf",c_xn[86],F);      // }
  setLine #(89,0,0) f_90 (c_ln[90],"If",seq == 57 && omc == 3,F); // if ( seq == 57 && omc == 3 ) {
  setLine #(90,0,1) f_91 (c_ln[91],"setVar",T,F);            // iadr += iper ;
  setLine #(90,1,0) f_92 (c_ln[92],"endIf",c_xn[90],F);      // }
  setLine #(92,0,0) f_93 (c_ln[93],"If",seq == ndy,F);       // if ( seq == ndy ) {
  setLine #(93,0,1) f_94 (c_ln[94],"setVar",T,F);            // iend -= ( 2 << nds ) ;
  setLine #(93,1,0) f_95 (c_ln[95],"endIf",c_xn[93],F);      // }
  setLine #(95,0,1) f_96 (c_ln[96],"setVar",T,F);            // oadr = NHDR ;
  setLine #(95,0,1) f_97 (c_ln[97],"setVar",T,F);            // oend = NHDR + NOUT ;
  setLine #(95,0,1) f_98 (c_ln[98],"setVar",T,F);            // bx = 0 ;
  setLine #(95,0,1) f_99 (c_ln[99],"setVar",T,F);            // i = SFIL ;
  setLine #(95,1,0) f_100 (c_ln[100],"While",i < NTOT,c_xn[103]); // while ( i < NTOT ) {
  setLine #(100,0,1) f_101 (c_ln[101],"BufferO_setX",T,F);   // bo.setX ( i , bx ) ;
  setLine #(100,0,1) f_102 (c_ln[102],"setVar",T,F);         // i += 8 ;
  setLine #(100,1,0) f_103 (c_ln[103],"endWhile",c_xn[100],F); // }
  setLine #(103,0,0) f_104 (c_ln[104],"DoWhile",c_xn[217],F); // do {
  setLine #(104,0,1) f_105 (c_ln[105],"setVar",T,F);         // iok = iadr < iend ;
  setLine #(104,1,0) f_106 (c_ln[106],"If",ilen > 0 && iok,F); // if ( ilen > 0 && iok ) {
  setLine #(106,0,1) f_107 (c_ln[107],"setVar",T,F);         // iper = iend - iadr ;
  setLine #(106,1,0) f_108 (c_ln[108],"If",ilen < iper,F);   // if ( ilen < iper ) {
  setLine #(108,0,1) f_109 (c_ln[109],"setVar",T,F);         // iper = ilen ;
  setLine #(108,1,0) f_110 (c_ln[110],"endIf",c_xn[108],F);  // }
  setLine #(110,0,0) f_111 (c_ln[111],"If",iper > MAXDMAI,F); // if ( iper > MAXDMAI ) {
  setLine #(111,0,1) f_112 (c_ln[112],"setVar",T,F);         // iper = MAXDMAI ;
  setLine #(111,1,0) f_113 (c_ln[113],"endIf",c_xn[111],F);  // }
  setLine #(113,0,0) f_114 (c_ln[114],"print",s_vbpr[0],F);  // vprint ( "DMAi chn=%d row=%d adr=%x ram=%x xfer=%d smd=%d\n" , chn , irow , iadr , iram , iper , smd ) ;
  setLine #(113,0,0) f_115 (c_ln[115],"If",smd > 1,F);       // if ( smd > 1 ) {
  setLine #(115,0,0) f_116 (c_ln[116],"Dma_sync",dmar_busy,F); // dmar.sync ( ) ;
  setLine #(116,0,1) f_117 (c_ln[117],"Dma_b2r",dmar_busy,F); // dmar.b2r ( bi , iadr , ram , iram , iper ) ;
  setLine #(116,0,1) f_118 (c_ln[118],"setVar",T,F);         // iram = ( iram + iper ) ;
  setLine #(116,1,0) f_119 (c_ln[119],"endIf",c_xn[115],F);  // }
  setLine #(119,0,1) f_120 (c_ln[120],"setVar",T,F);         // iadr += iper ;
  setLine #(119,0,1) f_121 (c_ln[121],"setVar",T,F);         // ilen -= iper ;
  setLine #(119,1,0) f_122 (c_ln[122],"endIf",c_xn[106],F);  // }
  setLine #(122,0,1) f_123 (c_ln[123],"setVar",T,F);         // iok = iadr < iend ;
  setLine #(122,0,1) f_124 (c_ln[124],"setVar",T,F);         // oper = oend - oadr ;
  setLine #(122,1,0) f_125 (c_ln[125],"If",olen > 0 && oper > 0 && doout,F); // if ( olen > 0 && oper > 0 && doout ) {
  setLine #(125,0,0) f_126 (c_ln[126],"If",olen < oper,F);   // if ( olen < oper ) {
  setLine #(126,0,1) f_127 (c_ln[127],"setVar",T,F);         // oper = olen ;
  setLine #(126,1,0) f_128 (c_ln[128],"endIf",c_xn[126],F);  // }
  setLine #(128,0,0) f_129 (c_ln[129],"If",oper > MAXDMAO,F); // if ( oper > MAXDMAO ) {
  setLine #(129,0,1) f_130 (c_ln[130],"setVar",T,F);         // oper = MAXDMAO ;
  setLine #(129,1,0) f_131 (c_ln[131],"endIf",c_xn[129],F);  // }
  setLine #(131,0,0) f_132 (c_ln[132],"print",s_vbpr[0],F);  // vprint ( "DMAo chn=%d row=%d adr=%x ram=%x olen=%d xfer=%d\n" , chn , orow , oadr , oram , olen , oper ) ;
  setLine #(131,0,0) f_133 (c_ln[133],"Dma_sync",dmaw_busy,F); // dmaw.sync ( ) ;
  setLine #(133,0,1) f_134 (c_ln[134],"Dma_r2b",dmaw_busy,F); // dmaw.r2b ( ram , oram , bo , oadr , oper ) ;
  setLine #(133,0,1) f_135 (c_ln[135],"setVar",T,F);         // oram = ( oram + oper ) ;
  setLine #(133,0,1) f_136 (c_ln[136],"setVar",T,F);         // oadr += oper ;
  setLine #(133,0,1) f_137 (c_ln[137],"setVar",T,F);         // olen -= oper ;
  setLine #(133,1,0) f_138 (c_ln[138],"endIf",c_xn[125],F);  // }
  setLine #(138,0,0) f_139 (c_ln[139],"If",ilen == 0 && iok,F); // if ( ilen == 0 && iok ) {
  setLine #(139,0,1) f_140 (c_ln[140],"setVar",T,F);         // noc = 9 ;
  setLine #(139,1,0) f_141 (c_ln[141],"If",irow == 3,F);     // if ( irow == 3 ) {
  setLine #(141,0,1) f_142 (c_ln[142],"setVar",T,F);         // restart = F ;
  setLine #(141,0,1) f_143 (c_ln[143],"setVar",T,F);         // jadr = iadr + bpct ;
  setLine #(141,0,3) f_144 (c_ln[144],"BufferI_getB",T,F);   // bb = bi.getB ( iadr ) ;
  setLine #(141,3,1) f_145 (c_ln[145],"setVar",T,F);         // nptr [ 9 : 8 ] = bb ;
  setLine #(141,3,1) f_146 (c_ln[146],"setVar",T,F);         // pmode = bb [ 7 : 4 ] ;
  setLine #(141,1,3) f_147 (c_ln[147],"BufferI_getB",T,F);   // bb = bi.getB ( jadr ) ;
  setLine #(141,4,1) f_148 (c_ln[148],"setVar",T,F);         // nptr [ 7 : 0 ] = bb ;
  setLine #(141,5,1) f_149 (c_ln[149],"setVar",T,F);         // xptr = nptr ^ ptr ;
  setLine #(141,6,1) f_150 (c_ln[150],"setVar",T,F);         // xpebc = xptr [ 0 : 0 ] + xptr [ 2 : 2 ] + xptr [ 4 : 4 ] + xptr [ 6 : 6 ] + xptr [ 8 : 8 ] ;
  setLine #(141,6,1) f_151 (c_ln[151],"setVar",T,F);         // xpobc = xptr [ 1 : 1 ] + xptr [ 3 : 3 ] + xptr [ 5 : 5 ] + xptr [ 7 : 7 ] + xptr [ 9 : 9 ] ;
  setLine #(141,7,0) f_152 (c_ln[152],"If",xptr == 0,F);     // if ( xptr == 0 ) {
  setLine #(152,0,0) f_153 (c_ln[153],"If",smd < 5,F);       // if ( smd < 5 ) {
  setLine #(153,0,1) f_154 (c_ln[154],"setVar",T,F);         // smd ++ ;
  setLine #(153,1,0) f_155 (c_ln[155],"endIf",c_xn[153],F);  // }
  setLine #(155,0,1) f_156 (c_ln[156],"setVar",T,F);         // restart = ( smd == 2 ) ;
  setLine #(155,1,0) f_157 (c_ln[157],"endIfE",c_xn[152],F); // }
  setLine #(157,7,0) f_158 (c_ln[158],"ElseIf",pmode == 9,c_xn[152]); // else if ( pmode == 9 ) {
  setLine #(158,0,0) f_159 (c_ln[159],"If",smd > 2,F);       // if ( smd > 2 ) {
  setLine #(159,0,1) f_160 (c_ln[160],"setVar",T,F);         // smd = 2 ;
  setLine #(159,1,0) f_161 (c_ln[161],"endIf",c_xn[159],F);  // }
  setLine #(161,0,1) f_162 (c_ln[162],"setVar",T,F);         // ptr = nptr ;
  setLine #(161,0,1) f_163 (c_ln[163],"setVar",T,F);         // restart = T ;
  setLine #(161,1,0) f_164 (c_ln[164],"endIfE",c_xn[158],F); // }
  setLine #(164,7,0) f_165 (c_ln[165],"ElseIf",smd < 2,c_xn[158]); // else if ( smd < 2 ) {
  setLine #(165,0,1) f_166 (c_ln[166],"setVar",T,F);         // ptr = nptr ;
  setLine #(165,1,0) f_167 (c_ln[167],"endIfE",c_xn[165],F); // }
  setLine #(167,7,0) f_168 (c_ln[168],"ElseIf",xpobc > 2,c_xn[165]); // else if ( xpobc > 2 ) {
  setLine #(168,0,1) f_169 (c_ln[169],"setVar",T,F);         // noc = 12 ;
  setLine #(168,0,1) f_170 (c_ln[170],"setVar",T,F);         // ptr ++ ;
  setLine #(168,1,0) f_171 (c_ln[171],"If",ptr == NVRC,F);   // if ( ptr == NVRC ) {
  setLine #(171,0,1) f_172 (c_ln[172],"setVar",T,F);         // ptr = 0 ;
  setLine #(171,1,0) f_173 (c_ln[173],"endIf",c_xn[171],F);  // }
  setLine #(173,0,0) f_174 (c_ln[174],"endIfE",c_xn[168],F); // }
  setLine #(174,7,0) f_175 (c_ln[175],"ElseIf",xpebc > 2,c_xn[168]); // else if ( xpebc > 2 ) {
  setLine #(175,0,1) f_176 (c_ln[176],"setVar",T,F);         // noc = 6 ;
  setLine #(175,1,0) f_177 (c_ln[177],"If",ptr == 0,F);      // if ( ptr == 0 ) {
  setLine #(177,0,1) f_178 (c_ln[178],"setVar",T,F);         // ptr = NVRC - 1 ;
  setLine #(177,1,0) f_179 (c_ln[179],"endIfE",c_xn[177],F); // }
  setLine #(179,1,0) f_180 (c_ln[180],"ElseIf",T,c_xn[177]); // else {
  setLine #(180,0,1) f_181 (c_ln[181],"setVar",T,F);         // ptr -- ;
  setLine #(180,1,0) f_182 (c_ln[182],"endIf",c_xn[180],F|c_en[179]); // }
  setLine #(182,0,0) f_183 (c_ln[183],"endIfE",c_xn[175],F); // }
  setLine #(183,7,0) f_184 (c_ln[184],"ElseIf",smd > 0,c_xn[175]); // else if ( smd > 0 ) {
  setLine #(184,0,1) f_185 (c_ln[185],"setVar",T,F);         // smd -- ;
  setLine #(184,1,0) f_186 (c_ln[186],"If",smd == 2,F);      // if ( smd == 2 ) {
  setLine #(186,0,1) f_187 (c_ln[187],"setVar",T,F);         // smd = 0 ;
  setLine #(186,1,0) f_188 (c_ln[188],"endIf",c_xn[186],F);  // }
  setLine #(188,0,0) f_189 (c_ln[189],"If",smd == 0,F);      // if ( smd == 0 ) {
  setLine #(189,0,1) f_190 (c_ln[190],"setVar",T,F);         // restart = T ;
  setLine #(189,1,0) f_191 (c_ln[191],"endIf",c_xn[189],F);  // }
  setLine #(191,0,0) f_192 (c_ln[192],"endIf",c_xn[184],F|c_en[183]|c_en[174]|c_en[167]|c_en[164]|c_en[157]); // }
  setLine #(192,0,1) f_193 (c_ln[193],"setVar",T,F);         // tram = ptr * bpct ;
  setLine #(192,0,0) f_194 (c_ln[194],"print",s_vbpr[0],F);  // vprint ( "pMode=%x nPtr=%x Ptr=%x chn=%d typ=%d smd=%d iadr=%x\n" , pmode , nptr , ptr , chn , typ , smd , iadr ) ;
  setLine #(192,1,0) f_195 (c_ln[195],"If",restart,F);       // if ( restart ) {
  setLine #(195,0,1) f_196 (c_ln[196],"setVar",T,F);         // doout = F ;
  setLine #(195,0,1) f_197 (c_ln[197],"setVar",T,F);         // iram = 0 ;
  setLine #(195,0,1) f_198 (c_ln[198],"setVar",T,F);         // oram = tram ;
  setLine #(195,0,1) f_199 (c_ln[199],"setVar",T,F);         // orow = 0 ;
  setLine #(195,0,1) f_200 (c_ln[200],"setVar",T,F);         // cnt = 0 ;
  setLine #(195,0,1) f_201 (c_ln[201],"setVar",T,F);         // olen = 0 ;
  setLine #(195,1,0) f_202 (c_ln[202],"endIf",c_xn[195],F);  // }
  setLine #(202,0,0) f_203 (c_ln[203],"endIf",c_xn[141],F);  // }
  setLine #(203,0,1) f_204 (c_ln[204],"setVar",T,F);         // ncol = NCRP - noc ;
  setLine #(203,0,1) f_205 (c_ln[205],"setVar",T,F);         // iadr = iadr + ( noc << nds ) ;
  setLine #(203,0,1) f_206 (c_ln[206],"setVar",T,F);         // irow = irow + 1 ;
  setLine #(203,1,1) f_207 (c_ln[207],"setVar",T,F);         // ilen = ncol << nds ;
  setLine #(203,2,0) f_208 (c_ln[208],"endIf",c_xn[139],F);  // }
  setLine #(208,0,1) f_209 (c_ln[209],"setVar",T,F);         // ook = oadr < oend && doout ;
  setLine #(208,1,0) f_210 (c_ln[210],"If",olen == 0 && ook,F); // if ( olen == 0 && ook ) {
  setLine #(210,0,3) f_211 (c_ln[211],"RamRWC_rdB",T,F);     // br = ram.rdB ( oram ) ;
  setLine #(210,0,1) f_212 (c_ln[212],"setVar",T,F);         // oram += ndx ;
  setLine #(210,0,1) f_213 (c_ln[213],"setVar",T,F);         // olen = onpr ;
  setLine #(210,0,1) f_214 (c_ln[214],"setVar",T,F);         // orow = orow + 1 ;
  setLine #(210,3,1) f_215 (c_ln[215],"RamRWC_wrB",T,F);     // rov.wrB ( orow , br ) ;
  setLine #(210,4,0) f_216 (c_ln[216],"endIf",c_xn[210],F);  // }
  setLine #(216,0,0) f_217 (c_ln[217],"endDoWhile",iok || ook,F); // } while ( iok || ook ) ;
  setLine #(217,0,0) f_218 (c_ln[218],"If",doout,F);         // if ( doout ) {
  setLine #(218,0,0) f_219 (c_ln[219],"Dma_sync",dmaw_busy,F); // dmaw.sync ( ) ;
  setLine #(219,0,1) f_220 (c_ln[220],"setVar",T,F);         // bx1 [ 47 : 32 ] = cnt ;
  setLine #(219,1,1) f_221 (c_ln[221],"BufferO_setX",T,F);   // bo.setX ( 8 , bx1 ) ;
  setLine #(219,0,1) f_222 (c_ln[222],"setVar",T,F);         // cnt = ( cnt + 1 ) & ndy ;
  setLine #(219,2,0) f_223 (c_ln[223],"If",cnt == 0,F);      // if ( cnt == 0 ) {
  setLine #(223,0,1) f_224 (c_ln[224],"RamRWC_wrB",T,F);     // rov.wrB ( 0 , chn ) ;
  setLine #(223,1,1) f_225 (c_ln[225],"Dma_r2b",dmaw_busy,F); // dmaw.r2b ( rov , 1 , bo , SOVH , 9 ) ;
  setLine #(223,2,0) f_226 (c_ln[226],"Dma_sync",dmaw_busy,F); // dmaw.sync ( ) ;
  setLine #(226,0,1) f_227 (c_ln[227],"Dma_r2r",dmaw_busy,F); // dmaw.r2r ( rov , 0 , rop , novh , 10 ) ;
  setLine #(226,0,1) f_228 (c_ln[228],"setVar",T,F);         // novh += 10 ;
  setLine #(226,0,1) f_229 (c_ln[229],"setVar",T,F);         // orow = 0 ;
  setLine #(226,1,0) f_230 (c_ln[230],"endIf",c_xn[223],F);  // }
  setLine #(230,0,0) f_231 (c_ln[231],"endIf",c_xn[218],F);  // }
  setLine #(231,0,1) f_232 (c_ln[232],"setVar",T,F);         // cs = packed ( oram , iram , olen , ilen , orow , irow , ptr , cnt , smd ) ;
  setLine #(231,1,1) f_233 (c_ln[233],"setVarI",T,F);        // csa [ chn ] = cs ;
  setLine #(231,2,0) f_234 (c_ln[234],"endIf",c_xn[66],F|c_en[65]|c_en[63]|c_en[55]); // }
  setLine #(234,0,0) f_235 (c_ln[235],"Dma_sync",dmar_busy,F); // dmar.sync ( ) ;
  setLine #(235,0,0) f_236 (c_ln[236],"If",doin,F);          // if ( doin ) {
  setLine #(236,0,0) f_237 (c_ln[237],"BufferI_rnxt",T,F);   // bi.rnxt ( NTOTI ) ;
  setLine #(236,0,0) f_238 (c_ln[238],"endIf",c_xn[236],F);  // }
  setLine #(238,0,0) f_239 (c_ln[239],"Dma_sync",dmaw_busy,F); // dmaw.sync ( ) ;
  setLine #(239,0,0) f_240 (c_ln[240],"If",doout,F);         // if ( doout ) {
  setLine #(240,0,0) f_241 (c_ln[241],"BufferO_wnxt",T,F);   // bo.wnxt ( NTOT ) ;
  setLine #(240,0,1) f_242 (c_ln[242],"setVar",T,F);         // opkt ++ ;
  setLine #(240,0,0) f_243 (c_ln[243],"endIf",c_xn[240],F);  // }
  setLine #(243,0,0) f_244 (c_ln[244],"return",c_stat,F);    // return 0 ;
  setLine #(244,0,0) f_245 (c_ln[245],"endMethod",T,F);      // }

  assign rop_rdma = dmaw_rdma;
  assign dmar_shrd = bi_rd;
  assign dmaw_shrd = ram_rd;
  assign bi_dma = dmar_rdma;
  assign ram_rdma = dmaw_rdma;
  assign rov_rdma = dmaw_rdma;
  always @(posedge clk) begin
    if (rst) cs <= 0;
    if (rst) chn <= chn+1;
    c_wr <= F; c_rd <= F; c_done <= F;
    bi_rd <= F; bi_nxt <= F;
    bo_wr <= F; bo_nxt <= F; bo_dma <= F;
    ram_wr <= F; ram_wdma <= F; if (rst) ram_wchn <= 0; if (rst) ram_wadr <= 0; if (rst) ram_wbus <= 0; ram_rd <= F; if (rst) ram_rchn <= 0; if (rst) ram_radr <= 0; 
    rov_wr <= F; rov_wdma <= F; if (rst) rov_wchn <= 0; if (rst) rov_wadr <= 0; if (rst) rov_wbus <= 0; rov_rd <= F; if (rst) rov_rchn <= 0; if (rst) rov_radr <= 0; 
    rop_wr <= F; rop_wdma <= F; rop_wchn <= F; if (rst) rop_wadr <= 0; if (rst) rop_wbus <= 0; rop_rd <= F; rop_rchn <= F; if (rst) rop_radr <= 0; 
    dmar_start <= F; if (rst) dmar_cnt <= 0; if (rst) dmar_flags <= F; dmar_rok <= F; if (rst) dmar_radr <= 0; if (rst) dmar_rbus <= 0; dmar_wok <= F; if (rst) dmar_wadr <= 0; 
    dmaw_start <= F; if (rst) dmaw_cnt <= 0; if (rst) dmaw_flags <= F; dmaw_rok <= F; if (rst) dmaw_radr <= 0; if (rst) dmaw_rbus <= 0; dmaw_wok <= F; if (rst) dmaw_wadr <= 0; 
    if (c_xn[22]) begin nptr <= 0; end
    if (c_xn[23]) begin i <= 0; end
    if (c_en[24]) begin c_rd <= T; c_adr <= CV_halo_flag; end 
    if (c_xn[24]) begin flag <= c_rbus; end
    if (c_en[25]) begin bi_rd <= T; bi_adr <= i; end 
    if (c_xn[25]) begin bx <= bi_bus; end
    if (c_xn[26]) begin ipkt <= bx[63:32]; end
    if (c_xn[27]) begin bx[63:32] <= opkt; end
    if (c_xn[28]) begin bo_wr <= T; bo_adr <= i; bo_bus <= bx; end
    if (c_xn[29]) begin i <= i + 8; end
    if (c_en[30]) begin bi_rd <= T; bi_adr <= i; end 
    if (c_xn[30]) begin bx <= bi_bus; end
    if (c_xn[31]) begin bo_wr <= T; bo_adr <= i; bo_bus <= bx; end
    if (c_xn[32]) begin bx1 <= bx; end
    if (c_xn[33]) begin i <= i + 8; end
    if (c_xn[34]) begin chx <= bx[39:32]; end
    if (c_xn[35]) begin chn <= bx[53:48]; end
    if (c_xn[36]) begin omd <= bx[59:56]; end
    if (c_xn[37]) begin typ <= bx[63:60]; end
    if (c_xn[38]) begin omc <= omd - 1; end
    if (c_xn[39]) begin byp <= (typ == 0) || (typ == 2) || (flag[4:4] != 0); end
    if (c_xn[40]) begin doovh <= (novh >= NOUT); end
    if (c_en[42]) begin bi_rd <= T; bi_adr <= i; end 
    if (c_xn[42]) begin bx <= bi_bus; end
    if (c_xn[43]) begin bo_wr <= T; bo_adr <= i_3; bo_bus <= bx; end
    if (c_xn[44]) begin i <= i + 8; end
    if (c_xn[46]) begin doin <= T; end
    if (c_xn[47]) begin doout <= F; end
    if (c_en[50]) begin bi_rd <= T; bi_adr <= i; end 
    if (c_xn[50]) begin bx <= bi_bus; end
    if (c_xn[51]) begin bo_wr <= T; bo_adr <= i_3; bo_bus <= bx; end
    if (c_xn[52]) begin i <= i + 8; end
    if (c_xn[54]) begin doout <= T; end
    if (c_xn[57]) begin bx1[63:32] <= 32'h90000000; end
    if (c_xn[58]) begin bo_wr <= T; bo_adr <= 8; bo_bus <= bx1; end
    if (c_en[59]) begin dmaw_start <= T; dmaw_radr <= 0; dmaw_wadr <= NHDR; dmaw_cnt <= NPKT; end 
    if (c_xn[59]) begin dmaw_rok <= rop_rok; dmaw_rbus <= rop_rbus; dmaw_wok <= bo_wok; bo_dma <= dmaw_wdma; bo_bus <= dmaw_wbus; end
    if (c_xn[60]) begin novh <= 0; end
    if (c_xn[61]) begin doin <= F; end
    if (c_xn[62]) begin doout <= T; end
    if (c_xn[67]) begin ram_rchn <= chn; ram_wchn <= chn; end
    if (c_xn[68]) begin rov_rchn <= chn; rov_wchn <= chn; end
    if (c_xn[69]) begin nds <= omc << 1; end
    if (c_xn[70]) begin ndx <= 1 << nds; end
    if (c_xn[71]) begin ndy <= ndx - 1; end
    if (c_xn[72]) begin seq <= chx & ndy; end
    if (c_xn[73]) begin bpct <= 3 << nds; end
    if (c_xn[74]) begin cs <= csa[chn]; end
    if (c_xn[75]) begin { oram, iram, olen, ilen, orow, irow, ptr, cnt, smd } <= cs; end
    if (c_xn[78]) begin inpr <= NCRPS[omc]; end
    if (c_xn[79]) begin onpr <= NCRVS[omc]; end
    if (c_xn[80]) begin dmin <= DMINS[omc] + MAXDMAO; end
    if (c_xn[81]) begin dram <= iram - oram; end
    if (c_xn[82]) begin doout <= dram > dmin && dram < NRAM; end
    if (c_xn[83]) begin iper <= 192; end
    if (c_xn[84]) begin iadr <= NHDR; end
    if (c_xn[85]) begin iend <= NHDR + NPKT; end
    if (c_xn[87]) begin irow <= 0; end
    if (c_xn[88]) begin ilen <= 0; end
    if (c_xn[91]) begin iadr <= iadr + iper; end
    if (c_xn[94]) begin iend <= iend - (2 << nds); end
    if (c_xn[96]) begin oadr <= NHDR; end
    if (c_xn[97]) begin oend <= NHDR + NOUT; end
    if (c_xn[98]) begin bx <= 0; end
    if (c_xn[99]) begin i <= SFIL; end
    if (c_xn[101]) begin bo_wr <= T; bo_adr <= i; bo_bus <= bx; end
    if (c_xn[102]) begin i <= i + 8; end
    if (c_xn[105]) begin iok <= iadr < iend; end
    if (c_xn[107]) begin iper <= iend - iadr; end
    if (c_xn[109]) begin iper <= ilen; end
    if (c_xn[112]) begin iper <= MAXDMAI; end
    if (c_xn[114]) begin $write ("DMAi chn=%d row=%d adr=%x ram=%x xfer=%d smd=%d\n", chn, irow, iadr, iram, iper, smd); end
    if (c_en[117]) begin dmar_start <= T; dmar_radr <= iadr; dmar_wadr <= iram; dmar_cnt <= iper; end 
    if (c_xn[117]) begin dmar_rok <= bi_rok; dmar_rbus <= bi_bus; dmar_wok <= ram_wok; ram_wdma <= dmar_wdma; ram_wbus <= dmar_wbus; end
    if (c_xn[118]) begin iram <= (iram + iper); end
    if (c_xn[120]) begin iadr <= iadr + iper; end
    if (c_xn[121]) begin ilen <= ilen - iper; end
    if (c_xn[123]) begin iok <= iadr < iend; end
    if (c_xn[124]) begin oper <= oend - oadr; end
    if (c_xn[127]) begin oper <= olen; end
    if (c_xn[130]) begin oper <= MAXDMAO; end
    if (c_xn[132]) begin $write ("DMAo chn=%d row=%d adr=%x ram=%x olen=%d xfer=%d\n", chn, orow, oadr, oram, olen, oper); end
    if (c_en[134]) begin dmaw_start <= T; dmaw_radr <= oram; dmaw_wadr <= oadr; dmaw_cnt <= oper; end 
    if (c_xn[134]) begin dmaw_rok <= ram_rok; dmaw_rbus <= ram_rbus; dmaw_wok <= bo_wok; bo_dma <= dmaw_wdma; bo_bus <= dmaw_wbus; end
    if (c_xn[135]) begin oram <= (oram + oper); end
    if (c_xn[136]) begin oadr <= oadr + oper; end
    if (c_xn[137]) begin olen <= olen - oper; end
    if (c_xn[140]) begin noc <= 9; end
    if (c_xn[142]) begin restart <= F; end
    if (c_xn[143]) begin jadr <= iadr + bpct; end
    if (c_en[144]) begin bi_rd <= T; bi_adr <= iadr; end 
    if (c_xn[144]) begin bb <= bi_busb; end
    if (c_xn[145]) begin nptr[9:8] <= bb; end
    if (c_xn[146]) begin pmode <= bb[7:4]; end
    if (c_en[147]) begin bi_rd <= T; bi_adr <= jadr; end 
    if (c_xn[147]) begin bb <= bi_busb; end
    if (c_xn[148]) begin nptr[7:0] <= bb; end
    if (c_xn[149]) begin xptr <= nptr ^ ptr; end
    if (c_xn[150]) begin xpebc <= xptr[0:0] + xptr[2:2] + xptr[4:4] + xptr[6:6] + xptr[8:8]; end
    if (c_xn[151]) begin xpobc <= xptr[1:1] + xptr[3:3] + xptr[5:5] + xptr[7:7] + xptr[9:9]; end
    if (c_xn[154]) begin smd <= smd + 1; end
    if (c_xn[156]) begin restart <= (smd == 2); end
    if (c_xn[160]) begin smd <= 2; end
    if (c_xn[162]) begin ptr <= nptr; end
    if (c_xn[163]) begin restart <= T; end
    if (c_xn[166]) begin ptr <= nptr; end
    if (c_xn[169]) begin noc <= 12; end
    if (c_xn[170]) begin ptr <= ptr + 1; end
    if (c_xn[172]) begin ptr <= 0; end
    if (c_xn[176]) begin noc <= 6; end
    if (c_xn[178]) begin ptr <= NVRC - 1; end
    if (c_xn[181]) begin ptr <= ptr - 1; end
    if (c_xn[185]) begin smd <= smd - 1; end
    if (c_xn[187]) begin smd <= 0; end
    if (c_xn[190]) begin restart <= T; end
    if (c_xn[193]) begin tram <= ptr * bpct; end
    if (c_xn[194]) begin $write ("pMode=%x nPtr=%x Ptr=%x chn=%d typ=%d smd=%d iadr=%x\n", pmode, nptr, ptr, chn, typ, smd, iadr); end
    if (c_xn[196]) begin doout <= F; end
    if (c_xn[197]) begin iram <= 0; end
    if (c_xn[198]) begin oram <= tram; end
    if (c_xn[199]) begin orow <= 0; end
    if (c_xn[200]) begin cnt <= 0; end
    if (c_xn[201]) begin olen <= 0; end
    if (c_xn[204]) begin ncol <= NCRP - noc; end
    if (c_xn[205]) begin iadr <= iadr + (noc << nds); end
    if (c_xn[206]) begin irow <= irow + 1; end
    if (c_xn[207]) begin ilen <= ncol << nds; end
    if (c_xn[209]) begin ook <= oadr < oend && doout; end
    if (c_en[211]) begin ram_rd <= T; ram_radr <= oram; end 
    if (c_xn[211]) begin br <= ram_rbusb; end
    if (c_xn[212]) begin oram <= oram + ndx; end
    if (c_xn[213]) begin olen <= onpr; end
    if (c_xn[214]) begin orow <= orow + 1; end
    if (c_xn[215]) begin rov_wr <= T; rov_wadr <= orow; rov_wbus <= br; end
    if (c_xn[220]) begin bx1[47:32] <= cnt; end
    if (c_xn[221]) begin bo_wr <= T; bo_adr <= 8; bo_bus <= bx1; end
    if (c_xn[222]) begin cnt <= (cnt + 1) & ndy; end
    if (c_xn[224]) begin rov_wr <= T; rov_wadr <= 0; rov_wbus <= chn; end
    if (c_en[225]) begin dmaw_start <= T; dmaw_radr <= 1; dmaw_wadr <= SOVH; dmaw_cnt <= 9; end 
    if (c_xn[225]) begin dmaw_rok <= rov_rok; dmaw_rbus <= rov_rbus; dmaw_wok <= bo_wok; bo_dma <= dmaw_wdma; bo_bus <= dmaw_wbus; end
    if (c_en[227]) begin dmaw_start <= T; dmaw_radr <= 0; dmaw_wadr <= novh; dmaw_cnt <= 10; end 
    if (c_xn[227]) begin dmaw_rok <= rov_rok; dmaw_rbus <= rov_rbus; dmaw_wok <= rop_wok; rop_wdma <= dmaw_wdma; rop_wbus <= dmaw_wbus; end
    if (c_xn[228]) begin novh <= novh + 10; end
    if (c_xn[229]) begin orow <= 0; end
    if (c_xn[232]) begin cs <= { oram, iram, olen, ilen, orow, irow, ptr, cnt, smd }; end
    if (c_xn[233]) begin csa[chn] <= cs; end
    if (c_en[237]) begin bi_nxt <= T; bi_adr <= NTOTI; end
    if (c_en[241]) begin bo_nxt <= T; bo_adr <= NTOT; end
    if (c_xn[242]) begin opkt <= opkt + 1; end
    if (c_xn[244]) begin c_stat <= 0; c_done <= T; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[246*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 10,1,0,2, 10,1,1,2, 21,1,4,0, 21,1,4,0, 10,1,5,0, 21,1,5,0, 10,1,6,2, 10,1,9,0, 21,1,9,0, 21,1,9,0, 21,1,9,0, 21,1,9,0, 21,1,9,0, 21,1,9,0, 21,1,10,0, 21,1,10,0, 21,1,0,0, 41,1,11,1, 10,41,0,2, 10,41,3,0, 21,41,0,0, 42,41,4,0, 21,45,0,0, 21,45,0,0, 33,45,1,0, 41,48,0,1, 10,49,0,2, 10,49,3,0, 21,49,0,0, 42,49,4,0, 21,53,0,0, 35,53,1,0, 34,55,1,0, 21,56,0,0, 10,56,1,0, 53,56,2,0, 21,56,0,0, 21,56,0,0, 21,56,0,0, 35,56,3,0, 34,63,1,0, 35,64,0,0, 34,65,1,0, 10,66,0,0, 10,66,0,0, 21,66,0,0, 21,66,1,0, 21,66,2,0, 21,66,3,0, 21,66,1,0, 21,66,0,0, 21,66,1,0, 10,66,0,0, 10,66,1,0, 21,66,0,0, 21,66,0,0, 21,66,0,0, 21,66,0,0, 21,66,1,0, 21,66,0,0, 21,66,0,0, 21,66,0,0, 31,66,4,0, 21,86,0,0, 21,86,0,0, 32,86,1,0, 31,89,0,0, 21,90,0,0, 32,90,1,0, 31,92,0,0, 21,93,0,0, 32,93,1,0, 21,95,0,0, 21,95,0,0, 21,95,0,0, 21,95,0,0, 41,95,1,1, 10,100,0,0, 21,100,0,0, 42,100,1,0, 43,103,0,0, 21,104,0,0, 31,104,1,0, 21,106,0,0, 31,106,1,0, 21,108,0,0, 32,108,1,0, 31,110,0,0, 21,111,0,0, 32,111,1,0, 24,113,0,0, 31,113,0,0, 55,115,0,0, 52,116,0,0, 21,116,0,0, 32,116,1,0, 21,119,0,0, 21,119,0,0, 32,119,1,0, 21,122,0,0, 21,122,0,0, 31,122,1,0, 31,125,0,0, 21,126,0,0, 32,126,1,0, 31,128,0,0, 21,129,0,0, 32,129,1,0, 24,131,0,0, 55,131,0,0, 53,133,0,0, 21,133,0,0, 21,133,0,0, 21,133,0,0, 32,133,1,0, 31,138,0,0, 21,139,0,0, 31,139,1,0, 21,141,0,0, 21,141,0,0, 10,141,0,2, 21,141,3,0, 21,141,3,0, 10,141,1,2, 21,141,4,0, 21,141,5,0, 21,141,6,0, 21,141,6,0, 33,141,7,0, 31,152,0,0, 21,153,0,0, 32,153,1,0, 21,155,0,0, 35,155,1,0, 34,157,7,0, 31,158,0,0, 21,159,0,0, 32,159,1,0, 21,161,0,0, 21,161,0,0, 35,161,1,0, 34,164,7,0, 21,165,0,0, 35,165,1,0, 34,167,7,0, 21,168,0,0, 21,168,0,0, 31,168,1,0, 21,171,0,0, 32,171,1,0, 35,173,0,0, 34,174,7,0, 21,175,0,0, 33,175,1,0, 21,177,0,0, 35,177,1,0, 34,179,1,0, 21,180,0,0, 32,180,1,0, 35,182,0,0, 34,183,7,0, 21,184,0,0, 31,184,1,0, 21,186,0,0, 32,186,1,0, 31,188,0,0, 21,189,0,0, 32,189,1,0, 32,191,0,0, 21,192,0,0, 24,192,0,0, 31,192,1,0, 21,195,0,0, 21,195,0,0, 21,195,0,0, 21,195,0,0, 21,195,0,0, 21,195,0,0, 32,195,1,0, 32,202,0,0, 21,203,0,0, 21,203,0,0, 21,203,0,0, 21,203,1,0, 32,203,2,0, 21,208,0,0, 31,208,1,0, 10,210,0,2, 21,210,0,0, 21,210,0,0, 21,210,0,0, 10,210,3,0, 32,210,4,0, 44,216,0,0, 31,217,0,0, 55,218,0,0, 21,219,0,0, 10,219,1,0, 21,219,0,0, 31,219,2,0, 10,223,0,0, 53,223,1,0, 55,223,2,0, 54,226,0,0, 21,226,0,0, 21,226,0,0, 32,226,1,0, 32,230,0,0, 21,231,0,0, 22,231,1,0, 32,231,2,0, 55,234,0,0, 31,235,0,0, 10,236,0,0, 32,236,0,0, 55,238,0,0, 31,239,0,0, 10,240,0,0, 21,240,0,0, 32,240,0,0, 14,243,0,0, 15,244,0,0};
  sequencer #(246,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
  assign s_test = {c_cnt[0],c_done,c_active,c_start,o_ena,i_ena,o_frst,i_frst};
endmodule

