/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See AU2C.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
import nxm.sys.lib.Convert;
public class AU2C extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(BUFFER); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(BUFFER); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(BUFFER); } }

public static class ChannelState extends TypeDef {
  int smd;
  int cnt;
  int ptr;
  int irow;
  int orow;
  int ilen;
  int olen;
  int iram;
  int oram;
}
public static class CORE extends Core {
  public final static int FLOW = BUFFER;
  public final static int BW = 64, RW = 12, CW = 6;
  public final static int NHDR = 64, NPKT = 2432, NPKTI = 2432, NCFG = 64, NOVR = 4000, NRAM = 4096, MRAM = (NRAM - 1), NCRP = 270, NCRV = 260, NROW = 9, NVRC = (87 * 9), NOUT = 2340, NTOT = (NHDR + NPKT), NTOTI = (NHDR + NPKTI), SFIL = (NHDR + NOUT - 4), SOVH = (NHDR + NOUT + 12), MAXDMAI = 272, MAXDMAO = 264;
  public int func, dec, chn, imd;
  public byte pkt, tag, ntag, mtag;
  public int nfpp, itag, ncfg;
  public int itl, otl, ofs, dfs;
  public int ipkt, opkt;
  public int novh;
  public int init () {
    itl = NTOTI;
    otl = NTOT * 2;
    ofs = NTOT;
    dec = 1;
    return 0;
  }
  public void setFunction (Value value) {
  }
  public void setConfigFile (Value value) {
  }
  public int set (String key, Value value) {
    if (isMatch (key, "S:FUNCTION")) setFunction (value);
    else if (isMatch (key, "L:CONFIG")) setConfigFile (value);
    else if (isMatch (key, "L:CHN")) chn = value.toL ();
    else if (isMatch (key, "L:FLAGS")) halo.flag = value.toL ();
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:NCFG")) value.fromL (ncfg);
    else if (isMatch (key, "L:ITL")) value.fromL (itl);
    else if (isMatch (key, "L:OTL")) value.fromL (otl);
    else if (isMatch (key, "L:OFS")) value.fromL (ofs);
    else if (isMatch (key, "L:DEC")) value.fromL (dec);
    else return super.get (key, value);
    return 0;
  }
  final static int[] NCRPS = { NCRP * 1, NCRP * 4, NCRP * 16, NCRP * 64 };
  final static int[] NCRVS = { NCRV * 1, NCRV * 4, NCRV * 16, NCRV * 64 };
  final static int[] DMINS = { 10 * 1 * 12, 10 * 4 * 3, 10 * 16 * 1, 10 * 64 * 1 };
  ChannelState[] csa;
  RamRWC ram, rov, rop;
  Dma dmar, dmaw;
  public int open () {
    int i;
    csa = new ChannelState[NCFG];
    for (i = 0; i < NCFG; i ++) csa[i] = new ChannelState ();
    ram = new RamRWC (RW, BW, BW, CW);
    rov = new RamRWC (4, BW, 8, CW);
    rop = new RamRWC (RW, BW, BW, 1);
    dmar = new Dma (RW, BW);
    dmaw = new Dma (RW, BW);
    this.halo.state=1;
    return 0;
  }
  public int process (Buffer bi, Buffer bo) {
    int flag;
    long bx, bx1;
    int bb, br;
    int omc;
    int nds;
    int omd, typ, smd, pmode, noc;
    int chn, seq, cnt;
    int chx, ndx, ndy;
    int bpct;
    int ncol;
    int ptr, xptr, nptr;
    int i, iadr, jadr, oadr;
    int iper, oper, iend, oend;
    int iram, oram, dram, tram, dmin;
    int xpebc, xpobc;
    int irow, orow;
    int ilen, olen;
    int inpr, onpr;
    boolean iok, ook, restart, doin, doout, doovh, byp;
    ChannelState cs;
    nptr = 0;
    i = 0;
    flag = this.halo.flag;
    bx = bi.getX (i);
    ipkt = getBits(bx, 63, 32);
    bx=setBits(bx, 63, 32, opkt);
    bo.setX (i, bx);
    i += 8;
    bx = bi.getX (i);
    bo.setX (i, bx);
    bx1 = bx;
    i += 8;
    chx = getBits(bx, 39, 32);
    chn = getBits(bx, 53, 48);
    omd = getBits(bx, 59, 56);
    typ = getBits(bx, 63, 60);
    omc = omd - 1;
    byp = (typ == 0) || (typ == 2) || (getBits(flag, 4, 4) != 0);
    doovh = (novh >= NOUT);
    while (i < NHDR) {
      bx = bi.getX (i);
      bo.setX (i, bx);
      i += 8;
    }
    doin = true;
    doout = false;
    if (byp) {
      while (i < NTOT) {
        bx = bi.getX (i);
        bo.setX (i, bx);
        i += 8;
      }
      doout = true;
    }
    else if (doovh) {
      bx1=setBits(bx1, 63, 32, 0x90000000);
      bo.setX (8, bx1);
      dmaw.r2b (rop, 0, bo, NHDR, NPKT);
      novh = 0;
      doin = false;
      doout = true;
    }
    else if (typ == 1) {
    }
    else {
      ram.setC (chn);
      rov.setC (chn);
      nds = omc << 1;
      ndx = 1 << nds;
      ndy = ndx - 1;
      seq = chx & ndy;
      bpct = 3 << nds;
      cs = csa[chn];
      oram=cs.oram; iram=cs.iram; olen=cs.olen; ilen=cs.ilen; orow=cs.orow; irow=cs.irow; ptr=cs.ptr; cnt=cs.cnt; smd=cs.smd;
      dmar.addReader (bi);
      dmaw.addReader (ram);
      inpr = NCRPS[omc];
      onpr = NCRVS[omc];
      dmin = DMINS[omc] + MAXDMAO;
      dram = iram - oram;
      doout = dram > dmin && dram < NRAM;
      iper = 192;
      iadr = NHDR;
      iend = NHDR + NPKT;
      if (seq == 0) {
        irow = 0;
        ilen = 0;
      }
      if (seq == 57 && omc == 3) {
        iadr += iper;
      }
      if (seq == ndy) {
        iend -= (2 << nds);
      }
      oadr = NHDR;
      oend = NHDR + NOUT;
      bx = 0;
      i = SFIL;
      while (i < NTOT) {
        bo.setX (i, bx);
        i += 8;
      }
      do {
        iok = iadr < iend;
        if (ilen > 0 && iok) {
          iper = iend - iadr;
          if (ilen < iper) {
            iper = ilen;
          }
          if (iper > MAXDMAI) {
            iper = MAXDMAI;
          }
          if((this.halo.vbpr&1)!=0)System.out.printf ("DMAi chn=%d row=%d adr=%x ram=%x xfer=%d smd=%d\n", chn, irow, iadr, iram, iper, smd);
          if (smd > 1) {
            dmar.sync ();
            dmar.b2r (bi, iadr, ram, iram, iper);
            iram = (iram + iper);
          }
          iadr += iper;
          ilen -= iper;
        }
        iok = iadr < iend;
        oper = oend - oadr;
        if (olen > 0 && oper > 0 && doout) {
          if (olen < oper) {
            oper = olen;
          }
          if (oper > MAXDMAO) {
            oper = MAXDMAO;
          }
          if((this.halo.vbpr&1)!=0)System.out.printf ("DMAo chn=%d row=%d adr=%x ram=%x olen=%d xfer=%d\n", chn, orow, oadr, oram, olen, oper);
          dmaw.sync ();
          dmaw.r2b (ram, oram, bo, oadr, oper);
          oram = (oram + oper);
          oadr += oper;
          olen -= oper;
        }
        if (ilen == 0 && iok) {
          noc = 9;
          if (irow == 3) {
            restart = false;
            jadr = iadr + bpct;
            bb = bi.getB (iadr);
            nptr=setBits(nptr, 9, 8, bb);
            pmode = getBits(bb, 7, 4);
            bb = bi.getB (jadr);
            nptr=setBits(nptr, 7, 0, bb);
            xptr = nptr ^ ptr;
            xpebc = getBits(xptr, 0, 0) + getBits(xptr, 2, 2) + getBits(xptr, 4, 4) + getBits(xptr, 6, 6) + getBits(xptr, 8, 8);
            xpobc = getBits(xptr, 1, 1) + getBits(xptr, 3, 3) + getBits(xptr, 5, 5) + getBits(xptr, 7, 7) + getBits(xptr, 9, 9);
            if (xptr == 0) {
              if (smd < 5) {
                smd ++;
              }
              restart = (smd == 2);
            }
            else if (pmode == 9) {
              if (smd > 2) {
                smd = 2;
              }
              ptr = nptr;
              restart = true;
            }
            else if (smd < 2) {
              ptr = nptr;
            }
            else if (xpobc > 2) {
              noc = 12;
              ptr ++;
              if (ptr == NVRC) {
                ptr = 0;
              }
            }
            else if (xpebc > 2) {
              noc = 6;
              if (ptr == 0) {
                ptr = NVRC - 1;
              }
              else {
                ptr --;
              }
            }
            else if (smd > 0) {
              smd --;
              if (smd == 2) {
                smd = 0;
              }
              if (smd == 0) {
                restart = true;
              }
            }
            tram = ptr * bpct;
            if((this.halo.vbpr&1)!=0)System.out.printf ("pMode=%x nPtr=%x Ptr=%x chn=%d typ=%d smd=%d iadr=%x\n", pmode, nptr, ptr, chn, typ, smd, iadr);
            if (restart) {
              doout = false;
              iram = 0;
              oram = tram;
              orow = 0;
              cnt = 0;
              olen = 0;
            }
          }
          ncol = NCRP - noc;
          iadr = iadr + (noc << nds);
          irow = irow + 1;
          ilen = ncol << nds;
        }
        ook = oadr < oend && doout;
        if (olen == 0 && ook) {
          br = ram.rdB (oram);
          oram += ndx;
          olen = onpr;
          orow = orow + 1;
          rov.wrB (orow, br);
        }
      } while (iok || ook);
      if (doout) {
        dmaw.sync ();
        bx1=setBits(bx1, 47, 32, cnt);
        bo.setX (8, bx1);
        cnt = (cnt + 1) & ndy;
        if (cnt == 0) {
          rov.wrB (0, chn);
          dmaw.r2b (rov, 1, bo, SOVH, 9);
          dmaw.sync ();
          dmaw.r2r (rov, 0, rop, novh, 10);
          novh += 10;
          orow = 0;
        }
      }
      cs.oram=oram; cs.iram=iram; cs.olen=olen; cs.ilen=ilen; cs.orow=orow; cs.irow=irow; cs.ptr=ptr; cs.cnt=cnt; cs.smd=smd;
      csa[chn] = cs;
    }
    dmar.sync ();
    if (doin) {
      bi.rnxt (NTOTI);
    }
    dmaw.sync ();
    if (doout) {
      bo.wnxt (NTOT);
      opkt ++;
    }
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
