/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE V6M Module System Clock Generators, etc.

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
`ifndef SYS_CLKF
`define SYS_CLKF 133
`endif
`ifndef SYS_CLKF2
`define SYS_CLKF2 266
`endif
`ifndef SYS_CLKM
`define SYS_CLKM 166
`endif
`ifndef SYS_CLKX
`define SYS_CLKX 166
`endif
`ifndef SYS_CLKV
`define SYS_CLKV 400
`endif

module sysclocks (x2p,x2n,vipc,vinc,vopc,vonc,mclk,jclk,
	crst,addr, srst,swrbus, srdbus1,srdbus2, rdmac,
	rscs,rprc,rmem,rtun,rio,rmod, speed,trsp,
	gclkc,gclkt,gclks,gclkx,gclkms,gclkvi,gclkvis,gclkvo,gclkvos,gclkf, test);

  localparam CLKM=`SYS_CLKM;
  localparam CLKV=`SYS_CLKV;

  localparam CLKF_MUL = 10;
  localparam CLKF_DIV = 1000.0/`SYS_CLKF;
 
  input x2p,x2n,jclk;
  input vipc,vinc;
  output vopc,vonc;
  input crst,srst,rdmac;
  input [7:0] addr;
  input [31:0] swrbus;
  output [31:0] srdbus1,srdbus2;
  output reg [7:0] speed;
  output reg rscs,rprc,rmem,rtun,rio,rmod;
  input [2:0] trsp;
  output gclkc,gclkt,gclks,gclkx,gclkvi,gclkvo,gclkf,mclk;
  output [3:0] gclkvis,gclkvos;
  output [10:0] gclkms;
  output [7:0] test;

  wire lclkr,lclkw,lclkf,lclks,lclkx,lclkvh,lclkvs,lclkn,lclkt,lclksc,lclkm;
  wire lock,lock1,lock2,gclksc,shifted,nclk,gclkvs,gclkr,gclkw;
  wire H=1, L=0; 
  wire [2:0] trsv;

  // System resets
  always @(posedge gclkc)  rscs <= (crst && addr[0]);
  always @(posedge gclkt)  rtun <= (crst && addr[5]);
  always @(posedge gclkf)  rmod <= rprc;
  reg booted;
  always @(posedge gclkx) begin
    booted <= crst || booted;
    rprc   <= !booted || rscs || (crst && addr[2] && !addr[7])
              || (rprc && !(crst && addr[2] && addr[7]));
    rio    <= (crst && addr[6]) || rdmac;
  end

  // Clock recovery
  reg [7:0] tune; reg trspe; wire trspa,trspu;
  timing_recovery trp (mclk,rmem, tune,trsp, gclks,trspe,trspa,trspu, srdbus1);
  reg trsve; wire trsva,trsvu;
  timing_recovery trv (nclk,rmem, 8'hC9,trsv, gclks,trsve,trsva,trsvu, srdbus2);

  // Clock adjusts
  reg rscv,ascv,dscv,rscp,ascp,dscp,rmems;
  always @(posedge gclks) begin
    rscv  <= (srst && !swrbus[9] && swrbus[0]);
    ascv  <= (srst && !swrbus[9] && swrbus[1]) || (trsve && trsva);
    dscv  <= (srst && !swrbus[9] && swrbus[8]) || (trsve && trsva && trsvu);
    trsve <= (srst && !swrbus[9] && swrbus[5]) || (trsve && !rscv);
    rscp  <= (srst && !swrbus[9] && swrbus[2]);
    ascp  <= (srst && !swrbus[9] && swrbus[3]) || (trspe && trspa);
    dscp  <= (srst && !swrbus[9] && swrbus[8]) || (trspe && trspa && trspu);
    trspe <= (srst && !swrbus[9] && swrbus[6]) || (trspe && !rscp);
    rmems <= (srst && !swrbus[9] && swrbus[4]);
    if (srst&&swrbus[9]) speed <= swrbus[7:0];
    if (srst && swrbus[6]) tune <= swrbus[23:16];
  end

  assign vadj = {dscv,ascv,rscv,gclks};

  always @(posedge gclkx) rmem <= rprc || rmems;

  // Global Clocks
  assign gclkc = jclk;

  IBUFGDS _clksc (gclksc,x2p,x2n);	// 100MHz Diff Crystal

  BUFG    _clks  (gclks,lclks);		// 100MHz for DDR and PPC 
  BUFG    _clkx  (gclkx,lclkx);		// 166MHz for DDR and PPC (~ to help duty cycle)
  BUFG    _clkr  (gclkr,lclkr);		// 166MHz for DDR phase=~90 for read + 2.5ns out pad delay
  BUFG    _clkw  (gclkw,lclkw);		// 166MHz for DDR phase=270 for write
  BUFG    _clkvi (gclkvi,lclkvh);	// 105|266MHz for HyperTransport in
  BUFG    _clkvo (gclkvo,lclkvh);	// 105|266MHz for HyperTransport out
  BUFG    _clkvs (gclkvs,lclkvs);	// 105|266MHz for HyperTransport out
  BUFG    _clkm  (mclk,lclkm);          // 166MHz DDR read strobe + 270 for timing recovery
  BUFG    _clkn  (nclk,lclkn);          // 266MHz for HyperTransport in + 270 for timing recovery

  BUFG    _clkf  (gclkf,lclkf);		// 133+ MHz for FFT/Demod/Cores
  assign gclkt = gclkf;			// for back end tuner cores

  // the 166MHz System clock for the PPC, DRAM, and DMA engine 
  wire x_rst,x_pwr,x_lock; mmcm_phase_calibration xmpc (x_lock,rscs,L,x_rst,lock,x_pwr);
  MMCM_ADV x_dcm (.PSCLK(L),.PSEN(L),.PSINCDEC(L),.RST(x_rst),.PWRDWN(x_pwr),.LOCKED(x_lock),
  	.CLKIN1(gclksc),.CLKFBIN(gclks),.CLKFBOUT(lclks),.CLKOUT1(lclkx),.CLKOUT2(lclkw));
  defparam x_dcm.BANDWIDTH = "LOW";  
  defparam x_dcm.CLKIN1_PERIOD = 10;  
  defparam x_dcm.CLKFBOUT_MULT_F = 10;
  defparam x_dcm.CLKFBOUT_PHASE  = 0;
  defparam x_dcm.CLKOUT1_DIVIDE = (CLKM==200)? 5 : 6;
  defparam x_dcm.CLKOUT2_DIVIDE = (CLKM==200)? 5 : 6;
  defparam x_dcm.CLKOUT1_PHASE  = 0;
  defparam x_dcm.CLKOUT2_PHASE  = 270;

  assign gclkms = {gclkx, !dscp,ascp,rscp,gclks, L,L,L, gclkw,gclkr,gclkx}; 

  // the 166MHz clock for the DRAM read strobe
  wire p_rst,p_pwr,p_lock,p_fb; mmcm_phase_calibration pmpc (p_lock,rscp,L,p_rst,lock1,p_pwr);
  wire p_fbi,p_fbo; BUFG p_fbb (p_fbi,p_fbo);
  MMCM_ADV p_dcm (.PSCLK(gclks),.PSEN(ascp),.PSINCDEC(!dscp),.RST(p_rst),.PWRDWN(p_pwr),.LOCKED(p_lock),
  	.CLKIN1(gclkx),.CLKFBIN(p_fbi),.CLKFBOUT(p_fbo),.CLKOUT1(lclkr),.CLKOUT2(lclkm));
  defparam p_dcm.CLKIN1_PERIOD = 6;  
  defparam p_dcm.CLKFBOUT_MULT_F = 5;
  defparam p_dcm.CLKFBOUT_PHASE = 0;	// reset phase problems if this is not zero
  defparam p_dcm.CLKFBOUT_USE_FINE_PS = "TRUE";
  defparam p_dcm.CLKOUT1_DIVIDE = 5;
  defparam p_dcm.CLKOUT1_PHASE  = 270;
  defparam p_dcm.CLKOUT2_DIVIDE = 5;
  defparam p_dcm.CLKOUT2_PHASE  = 180;
  defparam p_dcm.COMPENSATION = "EXTERNAL";

  // the CLKF  MHz System clock
  wire f_fb;
  MMCM_ADV f_dcm (.PSCLK(L),.PSEN(L),.PSINCDEC(L),.RST(rscs),.PWRDWN(L),
        .CLKIN1(gclksc),.CLKFBIN(f_fb),.CLKFBOUT(f_fb),.CLKOUT0(lclkf));
  defparam f_dcm.CLKIN1_PERIOD = 10;
  defparam f_dcm.DIVCLK_DIVIDE = 1;
  defparam f_dcm.CLKFBOUT_MULT_F = CLKF_MUL;
  defparam f_dcm.CLKOUT0_DIVIDE_F = CLKF_DIV;

  // the HyperTransport clocks
  wire v_rst,v_pwr,v_lock,v_fb; mmcm_phase_calibration vmpc (v_lock,rscv,L,v_rst,lock2,v_pwr);
  MMCM_ADV v_dcm (.PSCLK(gclks),.PSEN(ascv),.PSINCDEC(!dscv),.RST(v_rst),.PWRDWN(v_pwr),.LOCKED(v_lock),
  	.CLKIN1(vclk),.CLKFBIN(v_fb),.CLKFBOUT(v_fb),.CLKOUT2(lclkn),.CLKOUT3(lclkvs),.CLKOUT4(lclkvh));
  defparam v_dcm.CLKIN1_PERIOD =  (CLKV==625)? 1.6 : 2.5;  
  defparam v_dcm.DIVCLK_DIVIDE =  (CLKV==625)? 5   : 2;
  defparam v_dcm.CLKFBOUT_MULT_F= (CLKV==625)? 10  : 6;
  defparam v_dcm.CLKFBOUT_PHASE = 0;
  defparam v_dcm.CLKFBOUT_USE_FINE_PS = "TRUE";
  defparam v_dcm.CLKOUT2_DIVIDE = (CLKV==625)? 2 : 3;
  defparam v_dcm.CLKOUT2_PHASE  = 90;
  defparam v_dcm.CLKOUT3_DIVIDE = (CLKV==625)? 2 : 3;
  defparam v_dcm.CLKOUT3_PHASE  = 0;
  defparam v_dcm.CLKOUT4_DIVIDE = (CLKV==625)? 4 : 6;
  defparam v_dcm.CLKOUT4_PHASE  = 0;
  defparam v_dcm.COMPENSATION = "INTERNAL";

  wire vclkp,vclkn,vclkr,vrst;
  delaypipe #(64,1) vdp (gclkvi,(rio|v_rst),vrst);
  reg vrsti,vrsto;
  always @(posedge gclkvi) vrsti <= vrst;
  always @(posedge gclkvo) vrsto <= vrst;
  diddrc _bufvi (vipc,vinc,vclk, nclk,vclkp,vclkn);
  IDELAYCTRL dlyc (.REFCLK(gclkx),.RST(rio) );
`ifdef EXPERIMENTAL
  IDELAY dly (.C(gclks),.CE(ascv),.INC(dscv),.RST(rscv), .I(vclk),.O(vclkd) );
  defparam i_dly.IOBDELAY_TYPE = "VARIABLE";
  defparam i_dly.IOBDELAY_VALUE = 0;
  BUFG vibg (.I(vclkd),.O(gclkvs));	// 400-650 MHz IO clk
  BUFR vibr (.I(vclk),.O(vclkr),.CE(H),.CLR(rio));
  defparam vibr.BUFR_DIVIDE = 2;
  BUFG vibi (.I(vclkr),.O(gclkvi));	// 200-325 MHz IO clk
  BUFG vibo (.I(vclkr),.O(gclkvo));	// 200-325 MHz IO clk
`endif
  doqdr  _bufvo (vopc,vonc, gclkvo,gclkvs,vrsto,L,L, H,L,H,L);
  assign trsv = {vclkn,vclkp,1'b1};
  assign gclkvis = {L,L,vrsti,gclkvs};
  assign gclkvos = {L,L,vrsto,gclkvs};
  reg vvv; always @(posedge gclkvi) vvv <= !vvv;

assign test = {lock,rscv,ascv,dscv,gclks,gclkx,vvv,gclkf};
//assign test = {v_lock,vvv,mclk,gclkr,gclkx,gclks};

//assign test = 0;

endmodule
