////////////////////////////////////////////////////////////////////////////////
// Company: Xilinx
// Engineer: Xilinx Appplications Team
//
// Create Date: Jan 12, 2010
// Design Name: mmcm_phase_calibration
// Module Name: mmcm_phase_calibration
// Target Device: Virtex-6
// Tool versions: 11.4
// Description:
//    MMCM Phase Calibration Macro
// Dependencies:
//    Must be used in conjunction with an MMCM
// Revision:
//    1.0
// Additional Comments:
//    None
////////////////////////////////////////////////////////////////////////////////
`timescale 1ns/1ps

module mmcm_phase_calibration (
  input mmcm_lock,
  input user_reset, user_pwrdwn,
  output mmcm_reset, user_lock, mmcm_pwrdwn
);

  wire clrflops, la_pwrup, clkflops;
  reg  F1, F2, F3;

  always@(posedge clkflops, posedge mmcm_pwrdwn)
    if (mmcm_pwrdwn) begin
      F1 <= 1'b0;
      F3 <= 1'b0;
    end else begin
      F1 <= 1'b1;
      F3 <= F2;
    end

  always@(negedge mmcm_reset, posedge mmcm_pwrdwn)
    if (mmcm_pwrdwn)
	   F2 <= 1'b0;
    else
	   F2 <= F1;

   // LDCE:  Transparent latch with Asynchronous Reset and Gate Enable.
   //        Virtex-6
   // Xilinx HDL Language Template, version 11.4
   
   LDCE #(
      .INIT(1'b0) // Initial value of latch (1'b0 or 1'b1)
   ) ld_pwrup (
      .Q(la_pwrup),  // Data output
      .CLR(1'b0),    // Asynchronous clear/reset input
      .D(1'b1),      // Data input
      .G(mmcm_lock), // Gate input
      .GE(1'b1)      // Gate enable input
   );
  
   // End of ld_pwrup instantiation

	assign clkflops = mmcm_lock & la_pwrup;
	assign mmcm_reset = mmcm_lock & F1 & ~F2;  

	assign user_lock = F3 & clkflops;
	assign mmcm_pwrdwn = user_reset | user_pwrdwn;
	
endmodule
