/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Core Engine Simulator Interface

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
`define IO_CPP
`define PE_CPP
`undef ENGINE1
`include "mdefs.h"
`include "../lib/ramdefs.h"

//`define SIM_DBG 1
//`define RAM_DBG 1

`define MCF_CTBE 1
`define DMA_PKT_4X 1

module core (sclk,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
	     ioclk, istat,iena,isel,ibus, ostat,oena,osel,obus, 
		   istatp,ienap,ibusp, ostatp,oenap,obusp, test);

  parameter PORT=1;	// engine index
  parameter IBW=`SIM_IBW;  // 32b/64b in processor modules, 128b in PCIe sim
  parameter SBW=32;	// System bus width - always 32

  input sclk;		// system clock
  input srst;		// system reset
  input scs;		// system select
  input swr;		// register write
  input srd;		// register read
  input [31:0] saddr;	// register address
  input [31:0] swrbus;	// register data
  output [31:0] srdbus;	// register data
  output sack;

  input ioclk;		// I/O data bus clock
  output istat;		// istat - ready to accept 64 byte burst
  input iena;		// input enable  (one cycle early) (continuous 64 byte burst)
  input [7:0] isel;
  input [127:0] ibus;	// input data bus
  output ostat;		// ostat - ready to provide 64 byte burst
  input oena;		// output enable (one cycle early) (continuous 64 byte burst)
  output [7:0] osel;
  output [127:0] obus;	// output data bus

  output istatp,ostatp;
  input  ienap,oenap; 
  input [31:0] ibusp;
  output [31:0] obusp;

  output [7:0] test;	// 8 test signals for scope probes

  wire L=0, H=1;
  wire F=0, T=1;

  // buffer the input as verilator has trouble with direct operations on this bus interface to C
  reg jena; reg [7:0] jsel; reg [IBW-1:0] jbus; 
  always @(posedge ioclk) begin jena <= iena; jsel <= isel; jbus <= ibus; end
  reg jenap; reg [31:0] jbusp; 
  always @(posedge ioclk) begin jenap <= ienap; jbusp <= ibusp; end

  wire [1:0] sclks = {ioclk,sclk};
  wire [2:0] ioclks = {srst,ioclk,ioclk};

`ifdef CORE_PKT
  `ENGINE #(1,IBW,IBW) inst (sclks,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
      ioclks, istat,jena,jsel,jbus, ostat,oena,osel,obus, istatp,jenap,jbusp, ostatp,oenap,obusp, test);

  wire ostaty,ostatx,oenax,tenap,tenap2; reg ovalx; wire [31:0] obusx,tbusp;
  fifoNxM #(IBW,IBW,8,5,0,`DBLBUF) mf (ioclk,srst, ostaty,ovalx,obus, ioclk,srst, ostatx,oenax,obusx);
  pkt2pkt #(IBW) pp (ioclk,srst, ostatx,oenax,obusx, H,tenap,tenap2,tbusp);
  always @(posedge ioclk) begin
    ovalx <= oena;
    if (oenax|tenap) $write("Here %x %x  :  %x %x\n",oenax,obusx,tenap,tbusp);
  end

`elsif RAM_DBG

`define ALTERA 1
`define AGILEX 1
  wire clk=ioclk;
  wire pgo,wramc,cload;
  wire [9:0] pcn,astkc;
  wire [7:0] cdata,bc2;
  wire [31:0] istkc,ostkc;

  dpram #(2,8,32,`COMCLK) code (clk,pgo, pcn,cload, cdata,bc2,  clk,H, astkc,wramc, istkc,ostkc);

`elsif CORE_DUO
  reg mduo,opha,msel,mena,oval,oenax,ovalx; reg [3:0] ofmt;
  wire [7:0] osel1,osel2; wire [IBW-1:0] obus1,obus2,obusx; 
  wire istat1,istat2,ostat1,ostat2,ostatx; wire [7:0] test1,test2;
  always @(posedge sclk) begin
    if (scs&&swr&&saddr==0) begin 
      ofmt <= swrbus[15:12];
      mduo <= swrbus[3];
      mena <= swrbus[0];
    end
  end
  always @(posedge ioclk) begin
    if (!mena) opha <= !mduo; else if (mduo&oenax) opha <= !opha;
    msel <= mduo && opha;
    oenax <= (mduo? ostat1 && ostat2 : ostat1) && ostatx;
    ovalx <= oenax;
    oval <= oena;
  end
  `ENGINE #(1,IBW,IBW) inst1 (sclk,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
                        ioclks, istat1,jena&&(mduo?H:H),jsel,jbus, ostat1,oenax&&(mduo?opha:H),osel1,obus1, test1);
  `ENGINE #(2,IBW,IBW) inst2 (sclk,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
                        ioclks, istat2,jena&&(mduo?H:L),jsel,jbus, ostat2,oenax&&(mduo?opha:L),osel2,obus2, test2);
  wire [1:0] mfmt=(ofmt==8)?2:(ofmt==9)?1:(ofmt==0)?1:0;	// CI,CB,SI,SB - always CI
  mix2xNci #(IBW) mx (obusx, obus1,obus2, msel,mduo);		// every other 32b from alternate sides
  // buffer the output as verilator has trouble with direct operations on this bus interface to C
  fifoNxM #(IBW,IBW) mf (ioclk,!mena, ostatx,ovalx,obusx, ioclk,!mena, ostat,oena,obus);
  assign istat = mduo? istat1 && istat2 : istat1;
  assign osel  = osel1;

`else
  `ENGINE #(1,IBW,IBW) inst (sclks,srst, scs,saddr, swr,swrbus, srd,srdbus, sack,
                        ioclks, istat,jena,jsel,jbus, ostat,oena,osel,obus, test);
`endif

`ifdef PE_IOM
  defparam inst.IOTYPE = `IOTYPE;
`endif




`ifdef SIM_DBG
  reg [31:0] bbb;
  reg [31:3] aaa;
  wire [31:3] aa = {aaa[5:3],aaa[14],aaa[19:15],aaa[13:6]};
  wire [7:0] isel_ = {aaa[5:3],aaa[14]};
  wire [7:0] osel_;
  wire irdy_,ordy_;
  reg ival_,oval_;
  wire [255:0] ibus_ = {aa,3'h7,aa,3'h6,aa,3'h5,aa,3'h4,aa,3'h3,aa,3'h2,aa,3'h1,aa,3'h0};
  wire [127:0] obus_;
  wire oena_ = ordy_;
  always @(posedge ioclk) begin
    oval_ <= oena_;
    ival_ <= iena;
    if (srst) bbb <= 0; else if (oval_) bbb <= bbb+1;
    if (srst) aaa <= 0; else if (ival_) aaa <= aaa+1;
    if (ival_) $write("inp %x   %x %x %d\n",bbb,isel_,ibus_,oval_);
    if (oval_) $write("out %x                                                                              out %x %x\n",bbb,osel_,obus_);
  end
  mcfifoNxM #(256+32,128+16,128,5,`BPAR,`BPAR) dpr (ioclk,srst, irdy_,ival_,{{4{isel_}},ibus_}, ioclk,srst, ordy_,oena_,{osel_,obus_}, 8'hFF);
`endif


`ifdef PKT_DBG
  wire trdy;
  reg ocycle,coff,cok;
  reg [15:0] ccc,csize,cout;
  wire [31:0] ddd = pobus;
  assign poena_ = (ccc==1) || (ccc==2) || (ccc>=16 && ccc<16+csize);
  wire [3:0] tcbus; wire [31:0] tdbus;
  wire tvalx = (ccc>=18) && (ccc<18+cout);
  wire tvaly = coff && (ccc==18+cout);
  pkt2eth tpkte  (ioclk,srst, trdy,tvalx,tvaly,ddd, tcbus,tdbus);
  always @(posedge ioclk) begin
    if (srst) cok <= 0; else cok <= cok || jena;
    if (srst) csize <= 0; else if (ccc==2) csize <= pobus[15:2];
    if (srst) coff  <= 0; else if (ccc==2) coff <= (pobus[19:16]==3)? 1 : 0;
    if (srst) cout  <= 0; else if (ccc==2) cout <= (pobus[19:16]==3)? 15 : 0;
    if (!cok) ocycle <= 0; else ocycle <= ocycle? ccc<csize+16+8 : postat_;
    if (!ocycle) ccc <= 0; else ccc <= ccc+1;
    if (ccc>0) $write("OK c=%x s=%x e=%d sz=%x co=%d o=%d d=%x    tx=%d:%d tc=%x td=%x\n",
	ccc,postat_,poena_,csize,cout,coff,ddd,tvalx,tvaly,tcbus,tdbus);
  end
`endif

endmodule

