// $Id: sim_main.cpp 712 2006-06-29 16:11:21Z wsnyder $
// DESCRIPTION: Verilator Example: Top level main for invoking model
//
// Copyright 2003-2006 by Wilson Snyder. This program is free software; you can
// redistribute it and/or modify it under the terms of either the GNU
// General Public License or the Perl Artistic License.

#include <verilated.h>		// Defines common routines
#include <verilated_vcd_c.h>	// Defines common routines
#include "Vcore.h"		// From Verilating "core.v"

#include "VCoreDefs.h"

extern "C" int FPGA_open(void *halo, void *config);
extern "C" int FPGA_close(void *halo);

Vcore *core;			// Instantiation of module	
int flg=0;
int ttime;
VerilatedVcdC *tfp;

void timeclk (int sc, int ic) {
  core->sclk=sc; core->ioclk=ic; core->eval();
  if (tfp!=NULL) tfp->dump(ttime++);
}

void timestep () {
  timeclk(1,1);
  timeclk(1,0);
  timeclk(0,1);
  timeclk(0,0);
}


extern "C" void VCore_open (HALO *halo, void *config) {
  int i;
  char *tfn = getenv("VERILATOR_TFN");
  tfp=NULL;
  ttime=0;
  core = new Vcore;		// Create instance of module
  Verilated::debug(0);
  Verilated::traceEverOn(true);
  core->srst = 1;
  core->scs = 1;		// leave chip select always on
  core->swr = 0;
  core->srd = 0;
  for (i=0; i<32; i++) {	// some clocks with reset
    if (i==16) core->srst = 0;
    timestep();
  }
  if (tfn!=NULL) {
    tfp = new VerilatedVcdC;
    core->trace (tfp,99);
    printf("Trace File Name=%s\n",tfn);
    tfp->open(tfn);
  } 
  FPGA_open(halo,config);
}

extern "C" void VCore_syswr (HALO *halo, int addr, int value) {
  int i;
  core->saddr = addr&0xFFFF;
  core->swrbus = value;
//  printf("syswr addr=%08x value=%08x\n",addr,value);
  for (i=0; i<8; i++) {	// some clocks 
    core->swr = (i==2)?1:0;
    timestep();
  }
}

extern "C" void VCore_syswrblk (HALO *halo, int addr, int *value, int size) {
  int i; for (i=0; i<size; i++) VCore_syswr(halo,addr,value[i]);
}

extern "C" void VCore_syswrn (HALO *halo, int addr, int value, int n) {
  int i;
  core->saddr = addr;
  core->swrbus = value;
  for (i=0; i<n; i++) {	// some clocks 
    core->swr = (i==0)?1:0;
    timestep();
  }
}

extern "C" int VCore_sysrd (HALO *halo, int addr) {
  int i,value;
  core->saddr = addr;
  for (i=0; i<8; i++) {	// some clocks 
    core->srd = (i==4)?1:0;
    timestep();
    if (i==4) value = core->srdbus; 
  }
  return value;
}

extern "C" int VCore_process (HALO *halo, Stream *si, Stream *sip, Stream *so, Stream *sop, int nbw) {
  int i, j, k=nbw/32, iin=0, iout=0, pin=0, pout=0, ic=0;
  int extra = (si->bib<=0)? 1024 : 64; // to flush pipelines
  core->iena = core->oena = core->ienap = core->oenap = 0;
  timeclk(0,0);
  for (i=0; i<extra; i++, ic=1-ic) {	// some clocks 
    if (si!=NULL) core->iena = (core->istat!=0 && si->bib >= k*4)?1:0;			// iena is one clock before valid ibus
    if (so!=NULL) core->oena = (core->ostat!=0 && so->bib < so->len-k*4)?1:0;		// oena is one clock before valid obus
    if (sip!=NULL) core->ienap = (core->istatp!=0 && sip->bib >= 4 && pin==0)?1:0;		// ipena is one clock before valid ibus
    if (sop!=NULL) core->oenap = (core->ostatp!=0 && sop->bib < sop->len-4 && pout==0)?1:0;	// opena is one clock before valid obus
    timeclk(ic,1);
    timeclk(ic,0);
    if (pin>0) pin--;
    if (pout>0) pout--;
//if (core->iena) printf("OK in  k=%d data=%08x:%08x\n",k,*(int*)(si->b+si->roff-8),*(int*)(si->b+si->roff-4));
    if (core->iena) for (j=0; j<k; j++) { iin++;  core->ibus[j] = *(int*)(si->b+si->roff); 
					si->roff+=4; si->bib-=4; if (si->roff>=si->len) si->roff-=si->len; }
    if (core->oena) for (j=0; j<k; j++) { iout++; *(int*)(so->b+so->woff) = core->obus[j]; 
					so->woff+=4; so->bib+=4; if (so->woff>=so->len) so->woff-=so->len; }
    if (core->ienap)                    { pin=0;  core->ibusp = *(int*)(sip->b+sip->roff); 
					sip->roff+=4; sip->bib-=4; if (sip->roff>=sip->len) sip->roff-=sip->len; }
    if (core->oenap)                    { pout=2; *(int*)(sop->b+sop->woff) = core->obusp;  
					sop->woff+=4; sop->bib+=4; if (sop->woff>=sop->len) sop->woff-=sop->len; }
//if (core->oena) printf("OK out k=%d data=%08x:%08x\n",k,*(int*)(so->b+so->woff-8),*(int*)(so->b+so->woff-4));
    if (core->iena || core->oena) i=0;	// keep going
  }
  //printf("Out to nbw=%d iin=%d iout=%d i=%d\n",nbw,iin,iout,i);
  core->iena = core->oena = core->ienap = core->oenap = 0;
  for (i=0; i<2; i++) timestep();
  return iout*4;
}


extern "C" void VCore_close (HALO *halo) {
  if (tfp!=NULL) tfp->close();
  FPGA_close((void*)halo);
  core->final();
}

extern "C" void _ZN12VlThreadPoolC1EP16VerilatedContextj() {}
